/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.sleepycat;

import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.IsolationLevel;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.repo.sleepycat.BDBCursor;
import com.amazon.carbonado.repo.sleepycat.DB_Storage;
import com.amazon.carbonado.txn.TransactionScope;
import com.sleepycat.db.Cursor;
import com.sleepycat.db.CursorConfig;
import com.sleepycat.db.Database;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.LockMode;
import com.sleepycat.db.OperationStatus;
import com.sleepycat.db.Transaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DB_Cursor<S extends Storable>
extends BDBCursor<Transaction, S> {
    protected final Database mDatabase;
    private final LockMode mLockMode;
    private final DatabaseEntry mSearchKey;
    private final DatabaseEntry mData;
    protected Cursor mCursor;

    DB_Cursor(TransactionScope<Transaction> scope, byte[] startBound, boolean inclusiveStart, byte[] endBound, boolean inclusiveEnd, int maxPrefix, boolean reverse, DB_Storage<S> storage, Database database) throws DatabaseException, FetchException {
        super(scope, startBound, inclusiveStart, endBound, inclusiveEnd, maxPrefix, reverse, storage);
        this.mDatabase = database;
        this.mLockMode = scope.isForUpdate() ? LockMode.RMW : LockMode.DEFAULT;
        this.mSearchKey = new DatabaseEntry();
        this.mData = new DatabaseEntry();
    }

    protected byte[] searchKey_getData() {
        return DB_Cursor.getData((byte[])this.mSearchKey.getData(), (int)this.mSearchKey.getSize());
    }

    protected byte[] searchKey_getDataCopy() {
        return DB_Cursor.getDataCopy((byte[])this.mSearchKey.getData(), (int)this.mSearchKey.getSize());
    }

    protected void searchKey_setData(byte[] data) {
        this.mSearchKey.setData(data);
    }

    protected void searchKey_setPartial(boolean partial) {
        this.mSearchKey.setPartial(0, 0, partial);
    }

    protected boolean searchKey_getPartial() {
        return this.mSearchKey.getPartial();
    }

    protected byte[] data_getData() {
        return DB_Cursor.getData((byte[])this.mData.getData(), (int)this.mData.getSize());
    }

    protected byte[] data_getDataCopy() {
        return DB_Cursor.getDataCopy((byte[])this.mData.getData(), (int)this.mData.getSize());
    }

    protected void data_setPartial(boolean partial) {
        this.mData.setPartial(0, 0, partial);
    }

    protected boolean data_getPartial() {
        return this.mData.getPartial();
    }

    protected byte[] primaryKey_getData() {
        return DB_Cursor.getData((byte[])this.mSearchKey.getData(), (int)this.mSearchKey.getSize());
    }

    protected void cursor_open(Transaction txn, IsolationLevel level) throws Exception {
        CursorConfig config = level == IsolationLevel.READ_COMMITTED ? CursorConfig.READ_COMMITTED : (level == IsolationLevel.READ_UNCOMMITTED ? CursorConfig.READ_UNCOMMITTED : CursorConfig.DEFAULT);
        this.mCursor = this.mDatabase.openCursor(txn, config);
    }

    protected void cursor_close() throws Exception {
        Cursor cursor = this.mCursor;
        if (cursor != null) {
            this.mCursor = null;
            cursor.close();
        }
    }

    protected boolean cursor_getCurrent() throws Exception {
        return this.cursor().getCurrent(this.mSearchKey, this.mData, this.mLockMode) == OperationStatus.SUCCESS;
    }

    protected boolean cursor_getFirst() throws Exception {
        return this.cursor().getFirst(this.mSearchKey, this.mData, this.mLockMode) == OperationStatus.SUCCESS;
    }

    protected boolean cursor_getLast() throws Exception {
        return this.cursor().getLast(this.mSearchKey, this.mData, this.mLockMode) == OperationStatus.SUCCESS;
    }

    protected boolean cursor_getSearchKeyRange() throws Exception {
        return this.cursor().getSearchKeyRange(this.mSearchKey, this.mData, this.mLockMode) == OperationStatus.SUCCESS;
    }

    protected boolean cursor_getNext() throws Exception {
        return this.cursor().getNext(this.mSearchKey, this.mData, this.mLockMode) == OperationStatus.SUCCESS;
    }

    protected boolean cursor_getNextDup() throws Exception {
        return this.cursor().getNextDup(this.mSearchKey, this.mData, this.mLockMode) == OperationStatus.SUCCESS;
    }

    protected boolean cursor_getPrev() throws Exception {
        return this.cursor().getPrev(this.mSearchKey, this.mData, this.mLockMode) == OperationStatus.SUCCESS;
    }

    protected boolean cursor_getPrevNoDup() throws Exception {
        return this.cursor().getPrevNoDup(this.mSearchKey, this.mData, this.mLockMode) == OperationStatus.SUCCESS;
    }

    private Cursor cursor() throws FetchException {
        Cursor cursor = this.mCursor;
        if (cursor == null) {
            throw new FetchException("Cursor is not open");
        }
        return cursor;
    }
}

