/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SoftValuedCache<K, V> {
    static final Evictor cEvictor;

    public static <K, V> SoftValuedCache<K, V> newCache(int capacity) {
        return new Impl(capacity);
    }

    public abstract int size();

    public abstract boolean isEmpty();

    public abstract V get(K var1);

    public abstract V put(K var1, V var2);

    public abstract V putIfAbsent(K var1, V var2);

    public abstract V remove(K var1);

    public abstract boolean remove(K var1, V var2);

    public abstract boolean replace(K var1, V var2, V var3);

    public abstract V replace(K var1, V var2);

    public abstract void clear();

    public abstract String toString();

    static {
        Evictor evictor = new Evictor();
        evictor.setName("SoftValuedCache Evictor");
        evictor.setDaemon(true);
        evictor.setPriority(10);
        evictor.start();
        cEvictor = evictor;
    }

    private static class Evictor
    extends Thread {
        final ReferenceQueue<Object> mQueue = new ReferenceQueue();

        Evictor() {
        }

        public void run() {
            try {
                while (true) {
                    ((Ref)this.mQueue.remove()).remove();
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class Ref<T>
    extends SoftReference<T> {
        Ref(T referent) {
            super(referent, SoftValuedCache.cEvictor.mQueue);
        }

        abstract void remove();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry<K, V>
    extends Ref<V> {
        final Impl<K, V> mCache;
        final int mHash;
        final K mKey;
        Entry mNext;

        Entry(Impl<K, V> cache, int hash, K key, V value, Entry next) {
            super(value);
            this.mCache = cache;
            this.mHash = hash;
            this.mKey = key;
            this.mNext = next;
        }

        @Override
        void remove() {
            this.mCache.removeCleared(this);
        }

        boolean matches(K key, int hash) {
            return hash == this.mHash && (key == null ? this.mKey == null : key.equals(this.mKey));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Impl<K, V>
    extends SoftValuedCache<K, V> {
        private static final float LOAD_FACTOR = 0.75f;
        private Entry<K, V>[] mEntries;
        private int mSize;
        private int mThreshold;

        Impl(int capacity) {
            this.mEntries = new Entry[capacity];
            this.mThreshold = (int)((float)capacity * 0.75f);
        }

        @Override
        public synchronized int size() {
            return this.mSize;
        }

        @Override
        public synchronized boolean isEmpty() {
            return this.mSize == 0;
        }

        @Override
        public synchronized V get(K key) {
            int hash = key == null ? 0 : key.hashCode();
            Entry<K, V>[] entries = this.mEntries;
            int index = (hash & Integer.MAX_VALUE) % entries.length;
            Entry e = entries[index];
            while (e != null) {
                if (e.matches(key, hash)) {
                    return (V)e.get();
                }
                e = e.mNext;
            }
            return null;
        }

        @Override
        public synchronized V put(K key, V value) {
            int hash = key == null ? 0 : key.hashCode();
            Entry<K, V>[] entries = this.mEntries;
            int index = (hash & Integer.MAX_VALUE) % entries.length;
            Entry e = entries[index];
            Entry prev = null;
            while (e != null) {
                if (e.matches(key, hash)) {
                    Entry<K, V> newEntry;
                    Object old = e.get();
                    e.clear();
                    if (prev == null) {
                        newEntry = new Entry<K, V>(this, hash, key, value, e.mNext);
                    } else {
                        prev.mNext = e.mNext;
                        newEntry = new Entry<K, V>(this, hash, key, value, entries[index]);
                    }
                    entries[index] = newEntry;
                    return (V)old;
                }
                prev = e;
                e = e.mNext;
            }
            if (this.mSize >= this.mThreshold) {
                this.cleanup();
                if (this.mSize >= this.mThreshold) {
                    this.rehash();
                    entries = this.mEntries;
                    index = (hash & Integer.MAX_VALUE) % entries.length;
                }
            }
            entries[index] = new Entry<K, V>(this, hash, key, value, entries[index]);
            ++this.mSize;
            return null;
        }

        @Override
        public synchronized V putIfAbsent(K key, V value) {
            V existing = this.get(key);
            return existing == null ? this.put(key, value) : existing;
        }

        @Override
        public synchronized V remove(K key) {
            int hash = key == null ? 0 : key.hashCode();
            Entry<K, V>[] entries = this.mEntries;
            int index = (hash & Integer.MAX_VALUE) % entries.length;
            Entry e = entries[index];
            Entry prev = null;
            while (e != null) {
                if (e.matches(key, hash)) {
                    Object old = e.get();
                    e.clear();
                    if (prev == null) {
                        entries[index] = e.mNext;
                    } else {
                        prev.mNext = e.mNext;
                    }
                    --this.mSize;
                    return (V)old;
                }
                prev = e;
                e = e.mNext;
            }
            return null;
        }

        @Override
        public synchronized boolean remove(K key, V value) {
            V existing = this.get(key);
            if (existing != null && existing.equals(value)) {
                this.remove(key);
                return true;
            }
            return false;
        }

        @Override
        public synchronized boolean replace(K key, V oldValue, V newValue) {
            V existing = this.get(key);
            if (existing != null && existing.equals(oldValue)) {
                this.put(key, newValue);
                return true;
            }
            return false;
        }

        @Override
        public synchronized V replace(K key, V value) {
            return this.get(key) == null ? null : (V)this.put(key, value);
        }

        @Override
        public synchronized void clear() {
            Entry<K, V>[] entries = this.mEntries;
            int i = entries.length;
            while (--i >= 0) {
                Entry<K, V> e = entries[i];
                if (e == null) continue;
                e.clear();
                entries[i] = null;
            }
            this.mSize = 0;
        }

        @Override
        public synchronized String toString() {
            if (this.isEmpty()) {
                return "{}";
            }
            StringBuilder b = new StringBuilder();
            b.append('{');
            Entry<K, V>[] entries = this.mEntries;
            int removed = 0;
            boolean any = false;
            int i = entries.length;
            while (--i >= 0) {
                Entry e = entries[i];
                Entry prev = null;
                while (e != null) {
                    Object value = e.get();
                    if (value == null) {
                        if (prev == null) {
                            entries[i] = e.mNext;
                        } else {
                            prev.mNext = e.mNext;
                        }
                        ++removed;
                    } else {
                        prev = e;
                        if (any) {
                            b.append(',').append(' ');
                        }
                        Object key = e.mKey;
                        b.append(key).append('=').append(value);
                        any = true;
                    }
                    e = e.mNext;
                }
            }
            this.mSize -= removed;
            b.append('}');
            return b.toString();
        }

        synchronized void removeCleared(Entry<K, V> cleared) {
            Entry<K, V>[] entries = this.mEntries;
            int index = (cleared.mHash & Integer.MAX_VALUE) % entries.length;
            Entry e = entries[index];
            Entry prev = null;
            while (e != null) {
                if (e == cleared) {
                    if (prev == null) {
                        entries[index] = e.mNext;
                    } else {
                        prev.mNext = e.mNext;
                    }
                    --this.mSize;
                    return;
                }
                prev = e;
                e = e.mNext;
            }
        }

        private synchronized void cleanup() {
            Entry<K, V>[] entries = this.mEntries;
            int removed = 0;
            int i = entries.length;
            while (--i >= 0) {
                Entry e = entries[i];
                Entry prev = null;
                while (e != null) {
                    if (e.get() == null) {
                        if (prev == null) {
                            entries[i] = e.mNext;
                        } else {
                            prev.mNext = e.mNext;
                        }
                        ++removed;
                    } else {
                        prev = e;
                    }
                    e = e.mNext;
                }
            }
            this.mSize -= removed;
        }

        private synchronized void rehash() {
            Entry<K, V>[] oldEntries = this.mEntries;
            int newCapacity = oldEntries.length * 2 + 1;
            Entry[] newEntries = new Entry[newCapacity];
            int removed = 0;
            int i = oldEntries.length;
            while (--i >= 0) {
                Entry old = oldEntries[i];
                while (old != null) {
                    Entry e = old;
                    old = old.mNext;
                    if (e.get() == null) {
                        ++removed;
                        continue;
                    }
                    int index = (e.mHash & Integer.MAX_VALUE) % newCapacity;
                    e.mNext = newEntries[index];
                    newEntries[index] = e;
                }
            }
            this.mEntries = newEntries;
            this.mSize -= removed;
            this.mThreshold = (int)((float)newCapacity * 0.75f);
        }
    }
}

