/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.util;

import com.amazon.carbonado.util.WeakReentrantLockPool;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import org.cojen.util.ThrowUnchecked;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPool<K, V, E extends Exception> {
    private final ConcurrentMap<K, V> mValues = new ConcurrentHashMap();
    private final WeakReentrantLockPool<K> mLockPool = new WeakReentrantLockPool();

    protected AbstractPool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key) throws E {
        Object value = this.mValues.get(key);
        if (value != null) {
            return value;
        }
        Lock lock = (Lock)this.mLockPool.get(key);
        lock.lock();
        try {
            value = this.mValues.get(key);
            if (value == null) {
                try {
                    value = this.create(key);
                    this.mValues.put(key, value);
                }
                catch (Exception e) {
                    ThrowUnchecked.fire((Throwable)e);
                }
            }
        }
        finally {
            lock.unlock();
        }
        return value;
    }

    public V remove(Object key) {
        return this.mValues.remove(key);
    }

    public Collection<V> values() {
        return this.mValues.values();
    }

    protected abstract V create(K var1) throws E;
}

