/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.txn;

import com.amazon.carbonado.IsolationLevel;
import com.amazon.carbonado.PersistException;
import com.amazon.carbonado.Transaction;
import java.util.concurrent.TimeUnit;

public class TransactionPair
implements Transaction {
    private final Transaction mPrimaryTransaction;
    private final Transaction mSecondaryTransaction;

    public TransactionPair(Transaction primaryTransaction, Transaction secondaryTransaction) {
        this.mPrimaryTransaction = primaryTransaction;
        this.mSecondaryTransaction = secondaryTransaction;
    }

    public void commit() throws PersistException {
        this.mPrimaryTransaction.commit();
        try {
            this.mSecondaryTransaction.commit();
        }
        catch (Exception e) {
            throw new PersistException("Failure to commit secondary transaction has likely caused an inconsistency", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit() throws PersistException {
        try {
            this.mSecondaryTransaction.exit();
        }
        finally {
            this.mPrimaryTransaction.exit();
        }
    }

    public void setForUpdate(boolean forUpdate) {
        this.mPrimaryTransaction.setForUpdate(forUpdate);
        this.mSecondaryTransaction.setForUpdate(forUpdate);
    }

    public boolean isForUpdate() {
        return this.mPrimaryTransaction.isForUpdate() && this.mSecondaryTransaction.isForUpdate();
    }

    public void setDesiredLockTimeout(int timeout, TimeUnit unit) {
        this.mPrimaryTransaction.setDesiredLockTimeout(timeout, unit);
        this.mSecondaryTransaction.setDesiredLockTimeout(timeout, unit);
    }

    public IsolationLevel getIsolationLevel() {
        return this.mPrimaryTransaction.getIsolationLevel().lowestCommon(this.mSecondaryTransaction.getIsolationLevel());
    }

    public void detach() {
        this.mPrimaryTransaction.detach();
        try {
            this.mSecondaryTransaction.detach();
        }
        catch (IllegalStateException e) {
            this.mPrimaryTransaction.attach();
            throw e;
        }
    }

    public void attach() {
        this.mPrimaryTransaction.attach();
        try {
            this.mSecondaryTransaction.attach();
        }
        catch (IllegalStateException e) {
            this.mPrimaryTransaction.detach();
            throw e;
        }
    }
}

