/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.txn;

import com.amazon.carbonado.IsolationLevel;
import com.amazon.carbonado.PersistException;
import com.amazon.carbonado.RepositoryException;
import com.amazon.carbonado.Transaction;
import com.amazon.carbonado.txn.TransactionScope;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.cojen.util.WeakIdentityMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TransactionManager<Txn> {
    private static final int OPEN = 0;
    private static final int CLOSED = 1;
    private static final int SUSPENDED = 2;
    private final ThreadLocal<TransactionScope<Txn>> mLocalScope = new ThreadLocal();
    private final Map<TransactionScope<Txn>, ?> mAllScopes = new WeakIdentityMap();
    private int mState;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionScope<Txn> localScope() {
        TransactionScope<Txn> scope = this.mLocalScope.get();
        if (scope == null) {
            int state;
            TransactionManager transactionManager = this;
            synchronized (transactionManager) {
                state = this.mState;
                scope = new TransactionScope(this, state != 0);
                this.mAllScopes.put(scope, null);
            }
            this.mLocalScope.set(scope);
            if (state == 2) {
                scope.getLock().lock();
            }
        }
        return scope;
    }

    public TransactionScope<Txn> detachLocalScope() {
        TransactionScope<Txn> scope = this.mLocalScope.get();
        if (scope != null) {
            scope.markDetached();
            this.detachNotification(scope.getActiveTxn());
            this.mLocalScope.remove();
        }
        return scope;
    }

    boolean removeLocalScope(TransactionScope<Txn> scope) {
        TransactionScope<Txn> existing = this.mLocalScope.get();
        if (existing == scope) {
            this.detachNotification(scope.getActiveTxn());
            this.mLocalScope.remove();
            return true;
        }
        return false;
    }

    boolean setLocalScope(TransactionScope<Txn> scope, boolean detached) {
        TransactionScope<Txn> existing = this.mLocalScope.get();
        if ((existing == null || existing.isInactive()) && detached || existing == scope) {
            this.attachNotification(scope.getActiveTxn());
            this.mLocalScope.set(scope);
            return true;
        }
        return false;
    }

    public synchronized void close(boolean suspend) throws RepositoryException {
        if (this.mState == 2) {
            return;
        }
        if (suspend) {
            for (TransactionScope<Txn> scope : this.mAllScopes.keySet()) {
                scope.getLock().lock();
            }
        }
        this.mState = suspend ? 2 : 1;
        for (TransactionScope<Txn> scope : this.mAllScopes.keySet()) {
            scope.close();
        }
    }

    public synchronized boolean isClosed() {
        return this.mState != 0;
    }

    protected abstract IsolationLevel selectIsolationLevel(Transaction var1, IsolationLevel var2);

    protected abstract boolean supportsForUpdate();

    protected abstract Txn createTxn(Txn var1, IsolationLevel var2) throws Exception;

    protected Txn createTxn(Txn parent, IsolationLevel level, int timeout, TimeUnit unit) throws Exception {
        return this.createTxn(parent, level);
    }

    protected void reuseTxn(Txn txn) throws Exception {
    }

    protected void setForUpdate(Txn txn, boolean forUpdate) {
    }

    protected void attachNotification(Txn txn) {
    }

    protected void detachNotification(Txn txn) {
    }

    protected abstract boolean commitTxn(Txn var1) throws PersistException;

    protected abstract void abortTxn(Txn var1) throws PersistException;
}

