/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.synthetic;

import com.amazon.carbonado.AlternateKeys;
import com.amazon.carbonado.Index;
import com.amazon.carbonado.Indexes;
import com.amazon.carbonado.Key;
import com.amazon.carbonado.Name;
import com.amazon.carbonado.Nullable;
import com.amazon.carbonado.PrimaryKey;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.SupportException;
import com.amazon.carbonado.Version;
import com.amazon.carbonado.info.StorablePropertyAdapter;
import com.amazon.carbonado.layout.Unevolvable;
import com.amazon.carbonado.synthetic.ClassFileBuilder;
import com.amazon.carbonado.synthetic.SyntheticBuilder;
import com.amazon.carbonado.synthetic.SyntheticIndex;
import com.amazon.carbonado.synthetic.SyntheticKey;
import com.amazon.carbonado.synthetic.SyntheticProperty;
import com.amazon.carbonado.synthetic.SyntheticPropertyList;
import com.amazon.carbonado.util.AnnotationBuilder;
import com.amazon.carbonado.util.AnnotationDescParser;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.cojen.classfile.ClassFile;
import org.cojen.classfile.MethodInfo;
import org.cojen.classfile.Modifiers;
import org.cojen.classfile.TypeDesc;
import org.cojen.classfile.attribute.Annotation;
import org.cojen.util.ClassInjector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyntheticStorableBuilder
implements SyntheticBuilder {
    private String mName;
    private List<SyntheticProperty> mPropertyList;
    private SyntheticKey mPrimaryKey;
    private List<SyntheticKey> mAlternateKeys;
    private List<SyntheticIndex> mExtraIndexes;
    private StorableClassFileBuilder mClassFileGenerator;
    private Class<? extends Storable> mStorableClass;
    private SyntheticBuilder.ClassNameProvider mClassNameProvider;
    private ClassLoader mLoader;
    private boolean mEvolvable = false;

    public SyntheticStorableBuilder(String name, ClassLoader loader) {
        this.mName = name;
        this.mLoader = loader;
        this.mPropertyList = new ArrayList<SyntheticProperty>();
        this.mAlternateKeys = new ArrayList<SyntheticKey>();
        this.mExtraIndexes = new ArrayList<SyntheticIndex>();
        this.mClassNameProvider = new DefaultProvider();
    }

    @Override
    public ClassFileBuilder prepare() throws SupportException {
        if (this.mPrimaryKey == null) {
            throw new IllegalStateException("Primary key not defined");
        }
        this.mStorableClass = null;
        this.mClassFileGenerator = new StorableClassFileBuilder(this.mClassNameProvider, this.mLoader, SyntheticStorableBuilder.class, this.mEvolvable);
        ClassFile cf = this.mClassFileGenerator.getClassFile();
        for (SyntheticProperty prop : this.mPropertyList) {
            this.definePropertyBeanMethods(cf, prop);
        }
        this.definePrimaryKey(cf);
        this.defineAlternateKeys(cf);
        this.defineIndexes(cf);
        return this.mClassFileGenerator;
    }

    @Override
    public Class<? extends Storable> getStorableClass() {
        if (null == this.mStorableClass) {
            this.mStorableClass = this.mClassFileGenerator.build();
        }
        return this.mStorableClass;
    }

    @Override
    public Class<? extends Storable> build() throws SupportException {
        this.prepare();
        return this.getStorableClass();
    }

    @Override
    public SyntheticProperty addProperty(String name, Class type) {
        SyntheticProperty prop = new SyntheticProperty(name, type);
        this.mPropertyList.add(prop);
        return prop;
    }

    @Override
    public SyntheticProperty addProperty(SyntheticProperty prop) {
        this.mPropertyList.add(prop);
        return prop;
    }

    @Override
    public boolean hasProperty(String name) {
        for (SyntheticProperty prop : this.mPropertyList) {
            if (!prop.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public SyntheticKey addPrimaryKey() {
        if (this.mPrimaryKey == null) {
            this.mPrimaryKey = new SyntheticKey();
        }
        return this.mPrimaryKey;
    }

    @Override
    public SyntheticKey addAlternateKey() {
        SyntheticKey alternateKey = new SyntheticKey();
        this.mAlternateKeys.add(alternateKey);
        return alternateKey;
    }

    @Override
    public SyntheticIndex addIndex() {
        SyntheticIndex index = new SyntheticIndex();
        this.mExtraIndexes.add(index);
        return index;
    }

    @Override
    public boolean isVersioned() {
        for (SyntheticProperty prop : this.mPropertyList) {
            if (!prop.isVersion()) continue;
            return true;
        }
        return false;
    }

    public SyntheticBuilder.ClassNameProvider getClassNameProvider() {
        return this.mClassNameProvider;
    }

    public void setClassNameProvider(SyntheticBuilder.ClassNameProvider classNameProvider) {
        this.mClassNameProvider = classNameProvider;
    }

    public void setEvolvable(boolean evolvable) {
        this.mEvolvable = evolvable;
    }

    private void definePrimaryKey(ClassFile cf) {
        if (this.mPrimaryKey == null) {
            return;
        }
        Annotation pk = cf.addRuntimeVisibleAnnotation(TypeDesc.forClass(PrimaryKey.class));
        Annotation.MemberValue[] props = new Annotation.MemberValue[this.mPrimaryKey.getPropertyCount()];
        pk.putMemberValue("value", props);
        int propPos = 0;
        Iterator<String> propNames = this.mPrimaryKey.getProperties();
        while (propNames.hasNext()) {
            String propName = propNames.next();
            props[propPos] = pk.makeMemberValue(propName);
            ++propPos;
        }
    }

    private void defineAlternateKeys(ClassFile cf) {
        this.defineIndexes(cf, this.mAlternateKeys, AlternateKeys.class, Key.class);
    }

    private void defineIndexes(ClassFile cf) {
        this.defineIndexes(cf, this.mExtraIndexes, Indexes.class, Index.class);
    }

    private void defineIndexes(ClassFile cf, List<? extends SyntheticPropertyList> definedIndexes, Class annotationGroupClass, Class annotationClass) {
        if (definedIndexes.size() == 0) {
            return;
        }
        Annotation indexSet = cf.addRuntimeVisibleAnnotation(TypeDesc.forClass((Class)annotationGroupClass));
        Annotation.MemberValue[] indexes = new Annotation.MemberValue[definedIndexes.size()];
        indexSet.putMemberValue("value", indexes);
        int position = 0;
        for (SyntheticPropertyList syntheticPropertyList : definedIndexes) {
            Annotation index = this.addIndex(indexSet, indexes, position++, annotationClass);
            Annotation.MemberValue[] indexProps = new Annotation.MemberValue[syntheticPropertyList.getPropertyCount()];
            index.putMemberValue("value", indexProps);
            int propPos = 0;
            Iterator<String> propNames = syntheticPropertyList.getProperties();
            while (propNames.hasNext()) {
                String propName = propNames.next();
                indexProps[propPos] = index.makeMemberValue(propName);
                ++propPos;
            }
        }
    }

    private Annotation addIndex(Annotation annotator, Annotation.MemberValue[] indexes, int position, Class annotationClass) {
        assert (indexes.length > position);
        Annotation index = annotator.makeAnnotation();
        index.setType(TypeDesc.forClass((Class)annotationClass));
        indexes[position] = annotator.makeMemberValue(index);
        return index;
    }

    protected boolean definePropertyBeanMethods(ClassFile cf, SyntheticProperty property) {
        List<String> annotationDescs;
        TypeDesc propertyType = TypeDesc.forClass((Class)property.getType());
        final MethodInfo mi = cf.addMethod(Modifiers.PUBLIC_ABSTRACT, property.getReadMethodName(), propertyType, null);
        if (property.getName() != null) {
            Annotation ann = mi.addRuntimeVisibleAnnotation(TypeDesc.forClass(Name.class));
            ann.putMemberValue("value", property.getName());
        }
        if (property.isNullable()) {
            mi.addRuntimeVisibleAnnotation(TypeDesc.forClass(Nullable.class));
        }
        boolean versioned = false;
        if (property.isVersion()) {
            mi.addRuntimeVisibleAnnotation(TypeDesc.forClass(Version.class));
            versioned = true;
        }
        if (property.getAdapter() != null) {
            StorablePropertyAdapter adapter = property.getAdapter();
            Annotation ann = mi.addRuntimeVisibleAnnotation(TypeDesc.forClass(adapter.getAnnotation().getAnnotationType()));
            java.lang.annotation.Annotation jann = adapter.getAnnotation().getAnnotation();
            if (jann != null) {
                new AnnotationBuilder().visit(jann, ann);
            }
        }
        if ((annotationDescs = property.getAccessorAnnotationDescriptors()) != null && annotationDescs.size() > 0) {
            for (String desc : annotationDescs) {
                new AnnotationDescParser(desc){

                    protected Annotation buildRootAnnotation(TypeDesc rootAnnotationType) {
                        return mi.addRuntimeVisibleAnnotation(rootAnnotationType);
                    }
                }.parse(null);
            }
        }
        cf.addMethod(Modifiers.PUBLIC_ABSTRACT, property.getWriteMethodName(), null, new TypeDesc[]{propertyType});
        return versioned;
    }

    protected String getName() {
        return this.mName;
    }

    protected List<SyntheticProperty> getPropertyList() {
        return this.mPropertyList;
    }

    public String toString() {
        return this.mName + this.mPropertyList.toString();
    }

    static class StorableClassFileBuilder
    extends ClassFileBuilder {
        StorableClassFileBuilder(SyntheticBuilder.ClassNameProvider nameProvider, ClassLoader loader, Class sourceClass, boolean evolvable) {
            String className = nameProvider.getName();
            this.mInjector = nameProvider.isExplicit() ? ClassInjector.createExplicit((String)className, (ClassLoader)loader) : ClassInjector.create((String)className, (ClassLoader)loader);
            this.mClassFile = new ClassFile(this.mInjector.getClassName());
            Modifiers modifiers = this.mClassFile.getModifiers().toAbstract(true);
            this.mClassFile.setModifiers(modifiers);
            this.mClassFile.addInterface(Storable.class);
            if (!evolvable) {
                this.mClassFile.addInterface(Unevolvable.class);
            }
            this.mClassFile.markSynthetic();
            this.mClassFile.setSourceFile(sourceClass.getName());
            this.mClassFile.setTarget("1.5");
            this.mClassFile.addDefaultConstructor();
        }
    }

    private class DefaultProvider
    implements SyntheticBuilder.ClassNameProvider {
        DefaultProvider() {
        }

        public String getName() {
            StringBuilder b = new StringBuilder();
            if (null == SyntheticStorableBuilder.this.getName()) {
                b.append("synth");
            } else {
                b.append(SyntheticStorableBuilder.this.getName());
            }
            Iterator<String> props = SyntheticStorableBuilder.this.mPrimaryKey.getProperties();
            HashSet<String> propSet = new HashSet<String>();
            while (props.hasNext()) {
                String prop = props.next();
                if (prop.charAt(0) != '+' && prop.charAt(0) != '-') {
                    propSet.add(prop);
                    b.append('~');
                } else {
                    propSet.add(prop.substring(1));
                }
                b.append(prop);
            }
            List<SyntheticProperty> list = SyntheticStorableBuilder.this.getPropertyList();
            for (SyntheticProperty prop : list) {
                if (propSet.contains(prop.getName())) continue;
                b.append('~');
                b.append(prop.getName());
            }
            return b.toString();
        }

        public boolean isExplicit() {
            return true;
        }
    }
}

