/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.spi;

import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.PersistException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.Trigger;
import com.amazon.carbonado.lob.Lob;
import com.amazon.carbonado.spi.LobEngine;
import com.amazon.carbonado.spi.LobProperty;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LobEngineTrigger<S extends Storable>
extends Trigger<S> {
    final LobEngine mEngine;
    private final int mBlockSize;
    private final LobProperty<Lob>[] mLobProperties;

    LobEngineTrigger(LobEngine engine, Class<S> type, int blockSize, List<LobProperty<?>> lobProperties) {
        this.mEngine = engine;
        this.mBlockSize = blockSize;
        this.mLobProperties = new LobProperty[lobProperties.size()];
        lobProperties.toArray(this.mLobProperties);
    }

    @Override
    public Object beforeInsert(S storable) throws PersistException {
        int length = this.mLobProperties.length;
        Object[] userLobs = new Object[length];
        for (int i = 0; i < length; ++i) {
            Object userLob;
            LobProperty<Lob> prop = this.mLobProperties[i];
            userLobs[i] = userLob = storable.getPropertyValue(prop.mName);
            if (userLob == null) continue;
            Lob lob = prop.createNewLob(this.mBlockSize);
            storable.setPropertyValue(prop.mName, lob);
        }
        return userLobs;
    }

    @Override
    public void afterInsert(S storable, Object state) throws PersistException {
        Object[] userLobs = (Object[])state;
        int length = this.mLobProperties.length;
        for (int i = 0; i < length; ++i) {
            Object userLob = userLobs[i];
            if (userLob == null) continue;
            LobProperty<Lob> prop = this.mLobProperties[i];
            Lob lob = (Lob)storable.getPropertyValue(prop.mName);
            prop.setLobValue(this.mEngine.getLocator(lob), (Lob)userLob);
        }
    }

    @Override
    public void failedInsert(S storable, Object state) {
        this.unreplaceLobs(storable, state);
    }

    @Override
    public Object beforeUpdate(S storable) throws PersistException {
        int length = this.mLobProperties.length;
        Object[] userLobs = new Object[length];
        Storable existing = null;
        for (int i = 0; i < length; ++i) {
            Object userLob;
            LobProperty<Lob> prop = this.mLobProperties[i];
            if (!storable.isPropertyDirty(prop.mName)) continue;
            try {
                if (existing == null) {
                    S s = this.loadExisting(storable);
                    existing = (Storable)s;
                    if (s == null) {
                        return null;
                    }
                }
            }
            catch (FetchException e) {
                throw e.toPersistException();
            }
            userLobs[i] = userLob = storable.getPropertyValue(prop.mName);
            Lob existingLob = (Lob)existing.getPropertyValue(prop.mName);
            if (userLob == null) {
                if (existingLob == null) continue;
                this.mEngine.deleteLob(existingLob);
                continue;
            }
            if (existingLob == null) {
                existingLob = prop.createNewLob(this.mBlockSize);
            }
            prop.setLobValue(this.mEngine.getLocator(existingLob), (Lob)userLob);
            storable.setPropertyValue(prop.mName, existingLob);
        }
        return userLobs;
    }

    @Override
    public void failedUpdate(S storable, Object state) {
        this.unreplaceLobs(storable, state);
    }

    @Override
    public Object beforeDelete(S storable) throws PersistException {
        Object existing = storable.copy();
        try {
            if (!existing.tryLoad()) {
                existing = null;
            }
            return existing;
        }
        catch (FetchException e) {
            throw e.toPersistException();
        }
    }

    @Override
    public void afterDelete(S storable, Object existing) throws PersistException {
        if (existing != null) {
            for (LobProperty<Lob> prop : this.mLobProperties) {
                Lob lob = (Lob)((Storable)existing).getPropertyValue(prop.mName);
                this.mEngine.deleteLob(lob);
            }
        }
    }

    private S loadExisting(S storable) throws FetchException {
        Object existing = storable.copy();
        if (!existing.tryLoad()) {
            return null;
        }
        return existing;
    }

    private void unreplaceLobs(S storable, Object state) {
        if (state != null) {
            Object[] userLobs = (Object[])state;
            int length = this.mLobProperties.length;
            for (int i = 0; i < length; ++i) {
                Object userLob = userLobs[i];
                if (userLob == null) continue;
                storable.setPropertyValue(this.mLobProperties[i].mName, userLob);
            }
        }
    }
}

