/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.sequence;

import com.amazon.carbonado.PersistException;
import com.amazon.carbonado.sequence.SequenceValueProducer;
import java.math.BigInteger;

public abstract class AbstractSequenceValueProducer
implements SequenceValueProducer {
    protected AbstractSequenceValueProducer() {
    }

    public int nextIntValue() throws PersistException {
        return (int)this.nextLongValue();
    }

    public String nextDecimalValue() throws PersistException {
        return this.nextNumericalValue(10, 0);
    }

    public String nextNumericalValue(int radix, int minLength) throws PersistException {
        String str;
        long next = this.nextLongValue();
        if (next >= 0L) {
            str = Long.toString(next, radix);
        } else {
            byte[] bytes = new byte[9];
            bytes[8] = (byte)(next & 0xFFL);
            bytes[7] = (byte)((next >>= 8) & 0xFFL);
            bytes[6] = (byte)((next >>= 8) & 0xFFL);
            bytes[5] = (byte)((next >>= 8) & 0xFFL);
            bytes[4] = (byte)((next >>= 8) & 0xFFL);
            bytes[3] = (byte)((next >>= 8) & 0xFFL);
            bytes[2] = (byte)((next >>= 8) & 0xFFL);
            bytes[1] = (byte)((next >>= 8) & 0xFFL);
            str = new BigInteger(bytes).toString(radix);
        }
        int pad = minLength - str.length();
        if (pad > 0) {
            StringBuilder b = new StringBuilder(minLength);
            while (--pad >= 0) {
                b.append('0');
            }
            b.append(str);
            str = b.toString();
        }
        return str;
    }
}

