/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.sleepycat;

import com.amazon.carbonado.IsolationLevel;
import com.amazon.carbonado.PersistException;
import com.amazon.carbonado.Transaction;
import com.amazon.carbonado.repo.sleepycat.BDBRepository;
import com.amazon.carbonado.spi.ExceptionTransformer;
import com.amazon.carbonado.txn.TransactionManager;
import java.lang.ref.WeakReference;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BDBTransactionManager<Txn>
extends TransactionManager<Txn> {
    private final ExceptionTransformer mExTransformer;
    private final WeakReference<BDBRepository<Txn>> mRepositoryRef;

    BDBTransactionManager(ExceptionTransformer exTransformer, BDBRepository<Txn> repository) {
        this.mExTransformer = exTransformer;
        this.mRepositoryRef = new WeakReference<BDBRepository<Txn>>(repository);
    }

    @Override
    protected IsolationLevel selectIsolationLevel(Transaction parent, IsolationLevel level) {
        return this.repository().selectIsolationLevel(parent, level);
    }

    @Override
    protected boolean supportsForUpdate() {
        return true;
    }

    @Override
    protected Txn createTxn(Txn parent, IsolationLevel level) throws Exception {
        if (level == IsolationLevel.NONE) {
            return null;
        }
        return this.repository().txn_begin(parent, level);
    }

    @Override
    protected Txn createTxn(Txn parent, IsolationLevel level, int timeout, TimeUnit unit) throws Exception {
        if (level == IsolationLevel.NONE) {
            return null;
        }
        if (timeout == 0) {
            return this.repository().txn_begin_nowait(parent, level);
        }
        return this.repository().txn_begin(parent, level, timeout, unit);
    }

    @Override
    protected boolean commitTxn(Txn txn) throws PersistException {
        try {
            this.repository().txn_commit(txn);
            return false;
        }
        catch (Throwable e) {
            throw this.mExTransformer.toPersistException(e);
        }
    }

    @Override
    protected void abortTxn(Txn txn) throws PersistException {
        try {
            this.repository().txn_abort(txn);
        }
        catch (Throwable e) {
            throw this.mExTransformer.toPersistException(e);
        }
    }

    private BDBRepository<Txn> repository() {
        BDBRepository repo = (BDBRepository)this.mRepositoryRef.get();
        if (repo == null) {
            throw new IllegalStateException("Repository closed");
        }
        return repo;
    }
}

