/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.sleepycat;

import com.amazon.carbonado.ConfigurationException;
import com.amazon.carbonado.Cursor;
import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.IsolationLevel;
import com.amazon.carbonado.MalformedArgumentException;
import com.amazon.carbonado.PersistException;
import com.amazon.carbonado.Repository;
import com.amazon.carbonado.RepositoryException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.Storage;
import com.amazon.carbonado.Transaction;
import com.amazon.carbonado.TriggerFactory;
import com.amazon.carbonado.capability.IndexInfo;
import com.amazon.carbonado.capability.IndexInfoCapability;
import com.amazon.carbonado.capability.ShutdownCapability;
import com.amazon.carbonado.capability.StorableInfoCapability;
import com.amazon.carbonado.info.StorableIntrospector;
import com.amazon.carbonado.layout.Layout;
import com.amazon.carbonado.layout.LayoutCapability;
import com.amazon.carbonado.layout.LayoutFactory;
import com.amazon.carbonado.qe.RepositoryAccess;
import com.amazon.carbonado.qe.StorageAccess;
import com.amazon.carbonado.raw.StorableCodecFactory;
import com.amazon.carbonado.repo.sleepycat.BDBRepositoryBuilder;
import com.amazon.carbonado.repo.sleepycat.BDBStorage;
import com.amazon.carbonado.repo.sleepycat.BDBTransactionManager;
import com.amazon.carbonado.repo.sleepycat.CheckpointCapability;
import com.amazon.carbonado.repo.sleepycat.EnvironmentCapability;
import com.amazon.carbonado.repo.sleepycat.HotBackupCapability;
import com.amazon.carbonado.repo.sleepycat.StoredDatabaseInfo;
import com.amazon.carbonado.sequence.SequenceCapability;
import com.amazon.carbonado.sequence.SequenceValueGenerator;
import com.amazon.carbonado.sequence.SequenceValueProducer;
import com.amazon.carbonado.spi.AbstractRepository;
import com.amazon.carbonado.spi.ExceptionTransformer;
import com.amazon.carbonado.spi.LobEngine;
import com.amazon.carbonado.txn.TransactionManager;
import com.amazon.carbonado.txn.TransactionScope;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BDBRepository<Txn>
extends AbstractRepository<Txn>
implements Repository,
RepositoryAccess,
IndexInfoCapability,
HotBackupCapability,
CheckpointCapability,
EnvironmentCapability,
ShutdownCapability,
StorableInfoCapability,
SequenceCapability,
LayoutCapability {
    private final Log mLog = LogFactory.getLog(this.getClass());
    private final boolean mIsMaster;
    final Iterable<TriggerFactory> mTriggerFactories;
    private final AtomicReference<Repository> mRootRef;
    private final StorableCodecFactory mStorableCodecFactory;
    private final ExceptionTransformer mExTransformer;
    private final BDBTransactionManager<Txn> mTxnMgr;
    Checkpointer mCheckpointer;
    DeadlockDetector mDeadlockDetector;
    private final Runnable mPreShutdownHook;
    private final Runnable mPostShutdownHook;
    private final Object mInitialDBConfig;
    private final BDBRepositoryBuilder.DatabaseHook mDatabaseHook;
    private final Map<Class<?>, Integer> mDatabasePageSizes;
    final boolean mRunCheckpointer;
    final boolean mKeepOldLogFiles;
    final boolean mLogInMemory;
    final boolean mRunDeadlockDetector;
    final File mDataHome;
    final File mEnvHome;
    final String mSingleFileName;
    final Map<String, String> mFileNameMap;
    final Object mBackupLock = new Object();
    int mBackupCount = 0;
    int mIncrementalBackupCount = 0;
    private LayoutFactory mLayoutFactory;
    private LobEngine mLobEngine;

    BDBRepository(AtomicReference<Repository> rootRef, BDBRepositoryBuilder builder, ExceptionTransformer exTransformer) throws ConfigurationException {
        super(builder.getName());
        builder.assertReady();
        if (exTransformer == null) {
            throw new IllegalArgumentException("Exception transformer must not be null");
        }
        this.mIsMaster = builder.isMaster();
        this.mTriggerFactories = builder.getTriggerFactories();
        this.mRootRef = rootRef;
        this.mExTransformer = exTransformer;
        this.mTxnMgr = new BDBTransactionManager(this.mExTransformer, this);
        this.mRunCheckpointer = !builder.getReadOnly() && builder.getRunCheckpointer();
        this.mKeepOldLogFiles = builder.getKeepOldLogFiles();
        this.mLogInMemory = builder.getLogInMemory();
        this.mRunDeadlockDetector = builder.getRunDeadlockDetector();
        this.mStorableCodecFactory = builder.getStorableCodecFactory();
        this.mPreShutdownHook = builder.getPreShutdownHook();
        this.mPostShutdownHook = builder.getShutdownHook();
        this.mInitialDBConfig = builder.getInitialDatabaseConfig();
        this.mDatabaseHook = builder.getDatabaseHook();
        this.mDatabasePageSizes = builder.getDatabasePagesMap();
        this.mDataHome = builder.getDataHomeFile();
        this.mEnvHome = builder.getEnvironmentHomeFile();
        this.mSingleFileName = builder.getSingleFileName();
        this.mFileNameMap = builder.getFileNameMap();
        this.getLog().info((Object)("Opening repository \"" + this.getName() + '\"'));
    }

    @Override
    public <S extends Storable> IndexInfo[] getIndexInfo(Class<S> storableType) throws RepositoryException {
        return ((BDBStorage)this.storageFor(storableType)).getIndexInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getUserStorableTypeNames() throws RepositoryException {
        Repository metaRepo = this.getRootRepository();
        Cursor<StoredDatabaseInfo> cursor = metaRepo.storageFor(StoredDatabaseInfo.class).query().orderBy("databaseName").fetch();
        try {
            ArrayList<String> names = new ArrayList<String>();
            while (cursor.hasNext()) {
                StoredDatabaseInfo info = cursor.next();
                if (info.getEvolutionStrategy() == 0) continue;
                names.add(info.getDatabaseName());
            }
            String[] stringArray = names.toArray(new String[names.size()]);
            return stringArray;
        }
        finally {
            cursor.close();
        }
    }

    @Override
    public boolean isSupported(Class<Storable> type) {
        if (type == null) {
            return false;
        }
        StorableIntrospector.examine(type);
        return true;
    }

    @Override
    public boolean isPropertySupported(Class<Storable> type, String name) {
        if (type == null || name == null) {
            return false;
        }
        return StorableIntrospector.examine(type).getAllProperties().get(name) != null;
    }

    @Override
    public HotBackupCapability.Backup startBackup() throws RepositoryException {
        return this.startBackup(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HotBackupCapability.Backup startBackup(boolean deleteOldLogFiles) throws RepositoryException {
        if (this.mLogInMemory) {
            throw new IllegalStateException("Log files are only kept in memory and backups cannot be performed");
        }
        Object object = this.mBackupLock;
        synchronized (object) {
            int count = this.mBackupCount;
            if (count == 0) {
                try {
                    if (deleteOldLogFiles) {
                        this.enterBackupMode(true);
                    } else {
                        this.enterBackupMode();
                    }
                }
                catch (Exception e) {
                    throw this.mExTransformer.toRepositoryException(e);
                }
            }
            this.mBackupCount = count + 1;
            return new FullBackup();
        }
    }

    @Override
    public HotBackupCapability.Backup startIncrementalBackup(long lastLogNumber) throws RepositoryException {
        return this.startIncrementalBackup(lastLogNumber, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HotBackupCapability.Backup startIncrementalBackup(long lastLogNumber, boolean deleteOldLogFiles) throws RepositoryException {
        if (this.mLogInMemory) {
            throw new IllegalStateException("Log files are only kept in memory and incremental backup cannot be performed");
        }
        if (lastLogNumber < 0L) {
            throw new IllegalArgumentException("The number of the last backup cannot be negative: " + lastLogNumber);
        }
        Object object = this.mBackupLock;
        synchronized (object) {
            try {
                this.enterIncrementalBackupMode(lastLogNumber, deleteOldLogFiles);
                ++this.mIncrementalBackupCount;
            }
            catch (Exception e) {
                throw this.mExTransformer.toRepositoryException(e);
            }
        }
        return new IncrementalBackup(lastLogNumber);
    }

    @Override
    public void suspendCheckpointer(long suspensionTime) {
        if (this.mCheckpointer != null) {
            this.mCheckpointer.suspendCheckpointer(suspensionTime);
        }
    }

    @Override
    public void resumeCheckpointer() {
        if (this.mCheckpointer != null) {
            this.mCheckpointer.resumeCheckpointer();
        }
    }

    @Override
    public void forceCheckpoint() throws PersistException {
        if (this.mCheckpointer != null) {
            this.mCheckpointer.forceCheckpoint();
        } else {
            try {
                this.env_checkpoint();
            }
            catch (Exception e) {
                throw this.toPersistException(e);
            }
        }
    }

    @Override
    public void sync() throws PersistException {
        try {
            this.env_sync();
        }
        catch (Exception e) {
            throw this.toPersistException(e);
        }
    }

    @Override
    public Repository getRootRepository() {
        return this.mRootRef.get();
    }

    @Override
    public <S extends Storable> StorageAccess<S> storageAccessFor(Class<S> type) throws RepositoryException {
        return (BDBStorage)this.storageFor(type);
    }

    @Override
    public Layout layoutFor(Class<? extends Storable> type) throws FetchException, PersistException {
        try {
            return ((BDBStorage)this.storageFor(type)).getLayout(true, this.mStorableCodecFactory);
        }
        catch (PersistException e) {
            throw e;
        }
        catch (RepositoryException e) {
            throw e.toFetchException();
        }
    }

    @Override
    public Layout layoutFor(Class<? extends Storable> type, int generation) throws FetchException {
        return this.mLayoutFactory.layoutFor(type, generation);
    }

    protected void finalize() {
        this.close();
    }

    @Override
    protected void shutdownHook() {
        if (this.mPreShutdownHook != null) {
            this.mPreShutdownHook.run();
        }
        for (Storage storage : this.allStorage()) {
            try {
                if (!(storage instanceof BDBStorage)) continue;
                ((BDBStorage)storage).close();
            }
            catch (Throwable e) {
                this.getLog().error(null, e);
            }
        }
        if (this.mCheckpointer != null) {
            this.mCheckpointer.interrupt();
            try {
                this.mCheckpointer.join();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (this.mDeadlockDetector != null) {
            this.mDeadlockDetector.interrupt();
            try {
                this.mDeadlockDetector.join();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        try {
            this.env_close();
        }
        catch (Throwable e) {
            this.getLog().error(null, e);
        }
        if (this.mPostShutdownHook != null) {
            this.mPostShutdownHook.run();
        }
    }

    @Override
    protected Log getLog() {
        return this.mLog;
    }

    @Override
    protected <S extends Storable> Storage createStorage(Class<S> type) throws RepositoryException {
        try {
            return this.createBDBStorage(type);
        }
        catch (MalformedArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.toRepositoryException(e);
        }
    }

    @Override
    protected SequenceValueProducer createSequenceValueProducer(String name) throws RepositoryException {
        return new SequenceValueGenerator(this, name);
    }

    boolean isMaster() {
        return this.mIsMaster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] getAllDatabaseNames() throws RepositoryException {
        Repository metaRepo = this.getRootRepository();
        Cursor<StoredDatabaseInfo> cursor = metaRepo.storageFor(StoredDatabaseInfo.class).query().orderBy("databaseName").fetch();
        ArrayList<String> names = new ArrayList<String>();
        names.add(StoredDatabaseInfo.class.getName());
        try {
            while (cursor.hasNext()) {
                names.add(cursor.next().getDatabaseName());
            }
        }
        finally {
            cursor.close();
        }
        return names.toArray(new String[names.size()]);
    }

    String getDatabaseFileName(String dbName) {
        String singleFileName = this.mSingleFileName;
        if (singleFileName == null && this.mFileNameMap != null && (singleFileName = this.mFileNameMap.get(dbName)) == null && dbName != null) {
            singleFileName = this.mFileNameMap.get(null);
        }
        String dbFileName = dbName;
        if (singleFileName == null) {
            if (this.mDatabaseHook != null) {
                dbFileName = this.mDatabaseHook.databaseName(dbName);
            }
        } else {
            dbFileName = singleFileName;
        }
        if (this.mDataHome != null && !this.mDataHome.equals(this.mEnvHome)) {
            dbFileName = new File(this.mDataHome, dbFileName).getPath();
        }
        return dbFileName;
    }

    String getDatabaseName(String dbName) {
        if (this.mFileNameMap == null) {
            return null;
        }
        String name = this.mFileNameMap.get(dbName);
        if (name == null && dbName != null) {
            name = this.mFileNameMap.get(null);
        }
        if (name == null) {
            return null;
        }
        if (this.mDatabaseHook != null) {
            try {
                dbName = this.mDatabaseHook.databaseName(dbName);
            }
            catch (IncompatibleClassChangeError incompatibleClassChangeError) {
                // empty catch block
            }
        }
        return dbName;
    }

    StorableCodecFactory getStorableCodecFactory() {
        return this.mStorableCodecFactory;
    }

    LayoutFactory getLayoutFactory() throws RepositoryException {
        if (this.mLayoutFactory == null) {
            this.mLayoutFactory = new LayoutFactory(this.getRootRepository());
        }
        return this.mLayoutFactory;
    }

    LobEngine getLobEngine() throws RepositoryException {
        if (this.mLobEngine == null) {
            this.mLobEngine = new LobEngine((Repository)this, this.getRootRepository());
        }
        return this.mLobEngine;
    }

    public Object getInitialDatabaseConfig() {
        return this.mInitialDBConfig;
    }

    Integer getDatabasePageSize(Class<? extends Storable> type) {
        if (this.mDatabasePageSizes == null) {
            return null;
        }
        Integer size = this.mDatabasePageSizes.get(type);
        if (size == null && type != null) {
            size = this.mDatabasePageSizes.get(null);
        }
        return size;
    }

    void runDatabasePrepareForOpeningHook(Object database) throws RepositoryException {
        if (this.mDatabaseHook != null) {
            this.mDatabaseHook.prepareForOpening(database);
        }
    }

    void start(long checkpointInterval, long deadlockDetectorInterval) {
        this.getLog().info((Object)("Opened repository \"" + this.getName() + '\"'));
        if (this.mRunCheckpointer && checkpointInterval > 0L) {
            this.mCheckpointer = new Checkpointer(this, checkpointInterval, 1024, 5);
            this.mCheckpointer.start();
        } else {
            this.mCheckpointer = null;
        }
        if (this.mRunDeadlockDetector && deadlockDetectorInterval > 0L) {
            this.mDeadlockDetector = new DeadlockDetector(this, deadlockDetectorInterval);
            this.mDeadlockDetector.start();
        } else {
            this.mDeadlockDetector = null;
        }
        this.setAutoShutdownEnabled(true);
    }

    void start(long checkpointInterval, long deadlockDetectorInterval, BDBRepositoryBuilder builder) {
        this.getLog().info((Object)("Opened repository \"" + this.getName() + '\"'));
        if (this.mRunCheckpointer && checkpointInterval > 0L) {
            this.mCheckpointer = new Checkpointer(this, checkpointInterval, builder.getCheckpointThresholdKB(), builder.getCheckpointThresholdMinutes());
            this.mCheckpointer.start();
        } else {
            this.mCheckpointer = null;
        }
        if (this.mRunDeadlockDetector && deadlockDetectorInterval > 0L) {
            this.mDeadlockDetector = new DeadlockDetector(this, deadlockDetectorInterval);
            this.mDeadlockDetector.start();
        } else {
            this.mDeadlockDetector = null;
        }
        this.setAutoShutdownEnabled(true);
    }

    abstract IsolationLevel selectIsolationLevel(Transaction var1, IsolationLevel var2);

    abstract Txn txn_begin(Txn var1, IsolationLevel var2) throws Exception;

    Txn txn_begin(Txn parent, IsolationLevel level, int timeout, TimeUnit unit) throws Exception {
        return this.txn_begin(parent, level);
    }

    abstract Txn txn_begin_nowait(Txn var1, IsolationLevel var2) throws Exception;

    abstract void txn_commit(Txn var1) throws Exception;

    abstract void txn_abort(Txn var1) throws Exception;

    abstract void env_checkpoint() throws Exception;

    abstract void env_sync() throws Exception;

    abstract void env_checkpoint(int var1, int var2) throws Exception;

    abstract void env_detectDeadlocks() throws Exception;

    abstract void env_close() throws Exception;

    abstract <S extends Storable> BDBStorage<Txn, S> createBDBStorage(Class<S> var1) throws Exception;

    void enterBackupMode() throws Exception {
        this.enterBackupMode(false);
    }

    abstract void enterBackupMode(boolean var1) throws Exception;

    abstract void exitBackupMode() throws Exception;

    abstract void enterIncrementalBackupMode(long var1, boolean var3) throws Exception;

    abstract void exitIncrementalBackupMode() throws Exception;

    @Deprecated
    File[] backupFiles() throws Exception {
        return this.backupFiles(new long[1]);
    }

    @Deprecated
    File[] backupFiles(long[] newLastLogNum) throws Exception {
        throw new UnsupportedOperationException();
    }

    abstract File[] backupDataFiles() throws Exception;

    abstract File[] backupLogFiles(long[] var1) throws Exception;

    abstract File[] incrementalBackup(long var1, long[] var3) throws Exception;

    FetchException toFetchException(Throwable e) {
        return this.mExTransformer.toFetchException(e);
    }

    PersistException toPersistException(Throwable e) {
        return this.mExTransformer.toPersistException(e);
    }

    RepositoryException toRepositoryException(Throwable e) {
        return this.mExTransformer.toRepositoryException(e);
    }

    @Override
    protected final TransactionManager<Txn> transactionManager() {
        return this.mTxnMgr;
    }

    @Override
    protected final TransactionScope<Txn> localTransactionScope() {
        return this.mTxnMgr.localScope();
    }

    class FullBackup
    extends AbstractBackup {
        FullBackup() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void finishBackup() throws RepositoryException {
            block5: {
                int count = BDBRepository.this.mBackupCount - 1;
                try {
                    if (count != 0) break block5;
                    try {
                        BDBRepository.this.exitBackupMode();
                    }
                    catch (Exception e) {
                        throw BDBRepository.this.mExTransformer.toRepositoryException(e);
                    }
                }
                finally {
                    BDBRepository.this.mBackupCount = count;
                }
            }
        }

        File[] getDataBackupFiles() throws Exception {
            try {
                return BDBRepository.this.backupDataFiles();
            }
            catch (AbstractMethodError e) {
                return new File[0];
            }
        }

        File[] getLogBackupFiles(long[] newLastLogNum) throws Exception {
            try {
                return BDBRepository.this.backupLogFiles(newLastLogNum);
            }
            catch (AbstractMethodError e) {
                try {
                    return BDBRepository.this.backupFiles(newLastLogNum);
                }
                catch (AbstractMethodError e2) {
                    return BDBRepository.this.backupFiles();
                }
            }
        }
    }

    class IncrementalBackup
    extends AbstractBackup {
        private final long mLastLogNumber;

        IncrementalBackup(long lastLogNumber) {
            this.mLastLogNumber = lastLogNumber;
        }

        void finishBackup() throws RepositoryException {
            --BDBRepository.this.mIncrementalBackupCount;
            try {
                BDBRepository.this.exitIncrementalBackupMode();
            }
            catch (Exception e) {
                throw BDBRepository.this.mExTransformer.toRepositoryException(e);
            }
        }

        File[] getDataBackupFiles() throws Exception {
            return new File[0];
        }

        File[] getLogBackupFiles(long[] newLastLogNum) throws Exception {
            return BDBRepository.this.incrementalBackup(this.mLastLogNumber, newLastLogNum);
        }
    }

    abstract class AbstractBackup
    implements HotBackupCapability.Backup {
        boolean mDone;
        long mFinalLogNumber = -1L;

        AbstractBackup() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void endBackup() throws RepositoryException {
            Object object = BDBRepository.this.mBackupLock;
            synchronized (object) {
                if (this.mDone) {
                    return;
                }
                this.mDone = true;
                this.finishBackup();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Deprecated
        public File[] getFiles() throws RepositoryException {
            Object object = BDBRepository.this.mBackupLock;
            synchronized (object) {
                File[] data = this.getDataFiles();
                File[] logs = this.getLogFiles();
                File[] all = new File[data.length + logs.length];
                System.arraycopy(data, 0, all, 0, data.length);
                System.arraycopy(logs, 0, all, data.length, logs.length);
                return all;
            }
        }

        public File[] getDataFiles() throws RepositoryException {
            Object object = BDBRepository.this.mBackupLock;
            synchronized (object) {
                if (this.mDone) {
                    throw new IllegalStateException("Backup has ended");
                }
                try {
                    return this.getDataBackupFiles();
                }
                catch (Exception e) {
                    throw BDBRepository.this.mExTransformer.toRepositoryException(e);
                }
            }
        }

        public File[] getLogFiles() throws RepositoryException {
            Object object = BDBRepository.this.mBackupLock;
            synchronized (object) {
                if (this.mDone) {
                    throw new IllegalStateException("Backup has ended");
                }
                try {
                    long[] newLastLogNum = new long[]{-1L};
                    File[] toReturn = this.getLogBackupFiles(newLastLogNum);
                    this.mFinalLogNumber = newLastLogNum[0];
                    return toReturn;
                }
                catch (Exception e) {
                    throw BDBRepository.this.mExTransformer.toRepositoryException(e);
                }
            }
        }

        public long getLastLogNumber() throws RepositoryException {
            if (this.mFinalLogNumber < 0L) {
                throw new IllegalStateException("Must get files prior to retrieving the last log number");
            }
            return this.mFinalLogNumber;
        }

        abstract void finishBackup() throws RepositoryException;

        abstract File[] getDataBackupFiles() throws Exception;

        abstract File[] getLogBackupFiles(long[] var1) throws Exception;
    }

    private static class DeadlockDetector
    extends Thread {
        private final WeakReference<BDBRepository> mRepository;
        private final long mSleepInterval;

        DeadlockDetector(BDBRepository repository, long sleepInterval) {
            super(repository.getClass().getSimpleName() + " deadlock detector (" + repository.getName() + ')');
            this.setDaemon(true);
            this.mRepository = new WeakReference<BDBRepository>(repository);
            this.mSleepInterval = sleepInterval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    Thread.sleep(this.mSleepInterval);
                }
                catch (InterruptedException e) {
                    break;
                }
                BDBRepository repository = (BDBRepository)this.mRepository.get();
                if (repository == null) break;
                try {
                    repository.env_detectDeadlocks();
                    continue;
                }
                catch (ThreadDeath e) {
                }
                catch (Throwable e) {
                    repository.getLog().error((Object)"Deadlock detection failed", e);
                    continue;
                }
                finally {
                    repository = null;
                    continue;
                }
                break;
            }
        }
    }

    private static class Checkpointer
    extends Thread {
        private final WeakReference<BDBRepository> mRepository;
        private final long mSleepInterval;
        private final int mKBytes;
        private final int mMinutes;
        private boolean mInProgress;
        private long mSuspendUntil = Long.MIN_VALUE;

        Checkpointer(BDBRepository repository, long sleepInterval, int kBytes, int minutes) {
            super(repository.getClass().getSimpleName() + " checkpointer (" + repository.getName() + ')');
            this.setDaemon(true);
            this.mRepository = new WeakReference<BDBRepository>(repository);
            this.mSleepInterval = sleepInterval;
            this.mKBytes = kBytes;
            this.mMinutes = minutes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            try {
                Checkpointer checkpointer;
                block32: {
                    Checkpointer checkpointer2;
                    while (true) {
                        checkpointer = this;
                        // MONITORENTER : checkpointer
                        if (!this.mInProgress) {
                            try {
                                this.wait(this.mSleepInterval);
                            }
                            catch (InterruptedException e) {
                                // MONITOREXIT : checkpointer
                                break block32;
                            }
                        }
                        // MONITOREXIT : checkpointer
                        BDBRepository repository = (BDBRepository)this.mRepository.get();
                        if (repository == null) break block32;
                        Checkpointer checkpointer3 = this;
                        // MONITORENTER : checkpointer3
                        long suspendUntil = this.mSuspendUntil;
                        // MONITOREXIT : checkpointer3
                        if (suspendUntil != Long.MIN_VALUE && System.currentTimeMillis() < suspendUntil) continue;
                        Log log = repository.getLog();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Running checkpoint on repository \"" + repository.getName() + '\"'));
                        }
                        try {
                            checkpointer2 = this;
                            // MONITORENTER : checkpointer2
                            this.mInProgress = true;
                            // MONITOREXIT : checkpointer2
                            repository.env_checkpoint(this.mKBytes, this.mMinutes);
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("Finished running checkpoint on repository \"" + repository.getName() + '\"'));
                            continue;
                        }
                        catch (ThreadDeath e) {
                            break block32;
                        }
                        catch (Throwable e) {
                            log.error((Object)"Checkpoint failed", e);
                            continue;
                        }
                        break;
                    }
                    finally {
                        checkpointer2 = this;
                    }
                }
                checkpointer = this;
            }
            catch (Throwable throwable) {
                Checkpointer checkpointer = this;
                // MONITORENTER : checkpointer
                this.mInProgress = false;
                this.notify();
                // MONITOREXIT : checkpointer
                throw throwable;
            }
            this.mInProgress = false;
            this.notify();
            // MONITOREXIT : checkpointer
        }

        synchronized void suspendCheckpointer(long suspensionTime) {
            while (this.mInProgress) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {}
            }
            if (suspensionTime <= 0L) {
                return;
            }
            long now = System.currentTimeMillis();
            long suspendUntil = now + suspensionTime;
            if (now >= 0L && suspendUntil < 0L) {
                suspendUntil = Long.MAX_VALUE;
            }
            this.mSuspendUntil = suspendUntil;
        }

        synchronized void resumeCheckpointer() {
            this.mSuspendUntil = Long.MIN_VALUE;
        }

        synchronized void forceCheckpoint() throws PersistException {
            while (this.mInProgress) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            BDBRepository repository = (BDBRepository)this.mRepository.get();
            if (repository != null) {
                try {
                    repository.env_checkpoint();
                }
                catch (Exception e) {
                    throw repository.toPersistException(e);
                }
            }
        }
    }
}

