/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.replicated;

import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.PersistException;
import com.amazon.carbonado.Query;
import com.amazon.carbonado.Repository;
import com.amazon.carbonado.RepositoryException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.Storage;
import com.amazon.carbonado.SupportException;
import com.amazon.carbonado.Trigger;
import com.amazon.carbonado.UnsupportedTypeException;
import com.amazon.carbonado.filter.Filter;
import com.amazon.carbonado.repo.replicated.ReplicatedRepository;
import com.amazon.carbonado.repo.replicated.ReplicationTrigger;
import com.amazon.carbonado.spi.BelatedStorageCreator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReplicatedStorage<S extends Storable>
implements Storage<S> {
    final Storage<S> mReplicaStorage;
    final Storage<S> mMasterStorage;
    final ReplicationTrigger<S> mReplicationTrigger;

    public ReplicatedStorage(ReplicatedRepository aRepository, Storage<S> replicaStorage) throws SupportException, RepositoryException, UnsupportedTypeException {
        this.mReplicaStorage = replicaStorage;
        Log log = LogFactory.getLog(this.getClass());
        BelatedStorageCreator<S> creator = new BelatedStorageCreator<S>(log, aRepository.getMasterRepository(), replicaStorage.getStorableType(), 30000);
        this.mMasterStorage = (Storage)creator.get(15000);
        this.mReplicationTrigger = new ReplicationTrigger<S>(aRepository, this.mReplicaStorage, this.mMasterStorage);
    }

    ReplicatedStorage(Repository aRepository, Storage<S> replicaStorage, Storage<S> masterStorage) {
        this.mReplicaStorage = replicaStorage;
        this.mMasterStorage = masterStorage;
        this.mReplicationTrigger = new ReplicationTrigger<S>(aRepository, this.mReplicaStorage, masterStorage);
    }

    @Override
    public Class<S> getStorableType() {
        return this.mReplicaStorage.getStorableType();
    }

    @Override
    public S prepare() {
        return this.mReplicaStorage.prepare();
    }

    @Override
    public Query<S> query() throws FetchException {
        return this.mReplicaStorage.query();
    }

    @Override
    public Query<S> query(String filter) throws FetchException {
        return this.mReplicaStorage.query(filter);
    }

    @Override
    public Query<S> query(Filter<S> filter) throws FetchException {
        return this.mReplicaStorage.query(filter);
    }

    @Override
    public void truncate() throws PersistException {
        this.mMasterStorage.truncate();
        this.mReplicaStorage.truncate();
    }

    @Override
    public boolean addTrigger(Trigger<? super S> trigger) {
        return this.mReplicationTrigger.addTrigger(trigger);
    }

    @Override
    public boolean removeTrigger(Trigger<? super S> trigger) {
        return this.mReplicationTrigger.removeTrigger(trigger);
    }

    ReplicationTrigger<S> getReplicationTrigger() {
        return this.mReplicationTrigger;
    }
}

