/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.replicated;

import com.amazon.carbonado.CorruptEncodingException;
import com.amazon.carbonado.Cursor;
import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.FetchInterruptedException;
import com.amazon.carbonado.IsolationLevel;
import com.amazon.carbonado.MalformedTypeException;
import com.amazon.carbonado.PersistException;
import com.amazon.carbonado.Query;
import com.amazon.carbonado.Repository;
import com.amazon.carbonado.RepositoryException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.Storage;
import com.amazon.carbonado.SupportException;
import com.amazon.carbonado.Transaction;
import com.amazon.carbonado.UnsupportedTypeException;
import com.amazon.carbonado.capability.Capability;
import com.amazon.carbonado.capability.IndexInfo;
import com.amazon.carbonado.capability.IndexInfoCapability;
import com.amazon.carbonado.capability.ResyncCapability;
import com.amazon.carbonado.capability.ShutdownCapability;
import com.amazon.carbonado.capability.StorableInfoCapability;
import com.amazon.carbonado.cursor.SortedCursor;
import com.amazon.carbonado.info.Direction;
import com.amazon.carbonado.info.StorableInfo;
import com.amazon.carbonado.info.StorableIntrospector;
import com.amazon.carbonado.repo.indexed.IndexEntryAccessCapability;
import com.amazon.carbonado.repo.replicated.ReplicatedStorage;
import com.amazon.carbonado.repo.replicated.ReplicationTrigger;
import com.amazon.carbonado.spi.StoragePool;
import com.amazon.carbonado.txn.TransactionPair;
import com.amazon.carbonado.util.Throttle;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReplicatedRepository
implements Repository,
ResyncCapability,
ShutdownCapability,
StorableInfoCapability {
    private static final int RESYNC_BATCH_SIZE = 10;
    private static final int RESYNC_WATERMARK = 100;
    private String mName;
    private Repository mReplicaRepository;
    private Repository mMasterRepository;
    private final StoragePool mStoragePool;

    private static String[] selectNaturalOrder(Repository repo, Class<? extends Storable> type) throws RepositoryException {
        String[] propNames;
        IndexInfoCapability capability = repo.getCapability(IndexInfoCapability.class);
        if (capability == null) {
            return null;
        }
        IndexInfo info = null;
        for (IndexInfo candidate : capability.getIndexInfo(type)) {
            if (!candidate.isClustered()) continue;
            info = candidate;
            break;
        }
        if (info == null) {
            return null;
        }
        Set<String> pkSet = StorableIntrospector.examine(type).getPrimaryKeyProperties().keySet();
        for (String prop : propNames = info.getPropertyNames()) {
            if (pkSet.contains(prop)) continue;
            return null;
        }
        String[] orderBy = new String[pkSet.size()];
        Direction[] directions = info.getPropertyDirections();
        pkSet = new LinkedHashSet<String>(pkSet);
        for (int i = 0; i < propNames.length; ++i) {
            orderBy[i] = (directions[i] == Direction.DESCENDING ? "-" : "+") + propNames[i];
            pkSet.remove(propNames[i]);
        }
        if (pkSet.size() > 0) {
            for (String prop : pkSet) {
                orderBy[i++] = prop;
            }
        }
        return orderBy;
    }

    ReplicatedRepository(String aName, Repository aReplicaRepository, Repository aMasterRepository) {
        this.mName = aName;
        this.mReplicaRepository = aReplicaRepository;
        this.mMasterRepository = aMasterRepository;
        this.mStoragePool = new StoragePool(){

            @Override
            protected <S extends Storable> Storage<S> createStorage(Class<S> type) throws SupportException, RepositoryException {
                StorableInfo<S> info = StorableIntrospector.examine(type);
                if (info.isAuthoritative()) {
                    try {
                        return ReplicatedRepository.this.mMasterRepository.storageFor(type);
                    }
                    catch (UnsupportedTypeException e) {
                        if (info.isIndependent()) {
                            return ReplicatedRepository.this.mReplicaRepository.storageFor(type);
                        }
                        throw e;
                    }
                }
                Storage<S> replicaStorage = ReplicatedRepository.this.mReplicaRepository.storageFor(type);
                try {
                    return new ReplicatedStorage<S>(ReplicatedRepository.this, replicaStorage);
                }
                catch (UnsupportedTypeException e) {
                    if (info.isIndependent()) {
                        return replicaStorage;
                    }
                    throw e;
                }
            }
        };
    }

    @Override
    public String getName() {
        return this.mName;
    }

    Repository getReplicaRepository() {
        return this.mReplicaRepository;
    }

    @Override
    public Repository getMasterRepository() {
        return this.mMasterRepository;
    }

    @Override
    public <S extends Storable> Storage<S> storageFor(Class<S> type) throws MalformedTypeException, SupportException, RepositoryException {
        return (Storage)this.mStoragePool.get(type);
    }

    @Override
    public Transaction enterTransaction() {
        return new TransactionPair(this.mMasterRepository.enterTransaction(), this.mReplicaRepository.enterTransaction());
    }

    @Override
    public Transaction enterTransaction(IsolationLevel level) {
        return new TransactionPair(this.mMasterRepository.enterTransaction(level), this.mReplicaRepository.enterTransaction(level));
    }

    @Override
    public Transaction enterTopTransaction(IsolationLevel level) {
        return new TransactionPair(this.mMasterRepository.enterTopTransaction(level), this.mReplicaRepository.enterTopTransaction(level));
    }

    @Override
    public IsolationLevel getTransactionIsolationLevel() {
        IsolationLevel replicaLevel = this.mReplicaRepository.getTransactionIsolationLevel();
        if (replicaLevel == null) {
            return null;
        }
        IsolationLevel masterLevel = this.mMasterRepository.getTransactionIsolationLevel();
        if (masterLevel == null) {
            return null;
        }
        return replicaLevel.lowestCommon(masterLevel);
    }

    @Override
    public <C extends Capability> C getCapability(Class<C> capabilityType) {
        if (capabilityType.isInstance(this)) {
            if (ShutdownCapability.class.isAssignableFrom(capabilityType) && this.mReplicaRepository.getCapability(capabilityType) == null && this.mMasterRepository.getCapability(capabilityType) == null) {
                return null;
            }
            return (C)this;
        }
        boolean favorReplica = IndexInfoCapability.class.isAssignableFrom(capabilityType) || IndexEntryAccessCapability.class.isAssignableFrom(capabilityType);
        C masterCap = this.mMasterRepository.getCapability(capabilityType);
        C replicaCap = this.mReplicaRepository.getCapability(capabilityType);
        if (favorReplica) {
            return replicaCap != null ? replicaCap : masterCap;
        }
        return masterCap != null ? masterCap : replicaCap;
    }

    @Override
    public void close() {
        this.mReplicaRepository.close();
        this.mMasterRepository.close();
    }

    @Override
    public String[] getUserStorableTypeNames() throws RepositoryException {
        StorableInfoCapability replicaCap = this.mReplicaRepository.getCapability(StorableInfoCapability.class);
        StorableInfoCapability masterCap = this.mMasterRepository.getCapability(StorableInfoCapability.class);
        if (replicaCap == null) {
            if (masterCap == null) {
                return new String[0];
            }
            return masterCap.getUserStorableTypeNames();
        }
        if (masterCap == null) {
            return replicaCap.getUserStorableTypeNames();
        }
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        for (String name : replicaCap.getUserStorableTypeNames()) {
            names.add(name);
        }
        for (String name : masterCap.getUserStorableTypeNames()) {
            names.add(name);
        }
        return names.toArray(new String[names.size()]);
    }

    @Override
    public boolean isSupported(Class<Storable> type) {
        StorableInfoCapability replicaCap = this.mReplicaRepository.getCapability(StorableInfoCapability.class);
        StorableInfoCapability masterCap = this.mMasterRepository.getCapability(StorableInfoCapability.class);
        return !(masterCap != null && !masterCap.isSupported(type) || replicaCap != null && !replicaCap.isSupported(type));
    }

    @Override
    public boolean isPropertySupported(Class<Storable> type, String name) {
        StorableInfoCapability replicaCap = this.mReplicaRepository.getCapability(StorableInfoCapability.class);
        StorableInfoCapability masterCap = this.mMasterRepository.getCapability(StorableInfoCapability.class);
        return !(masterCap != null && !masterCap.isPropertySupported(type, name) || replicaCap != null && !replicaCap.isPropertySupported(type, name));
    }

    @Override
    public boolean isAutoShutdownEnabled() {
        ShutdownCapability cap = this.mReplicaRepository.getCapability(ShutdownCapability.class);
        if (cap != null && cap.isAutoShutdownEnabled()) {
            return true;
        }
        cap = this.mMasterRepository.getCapability(ShutdownCapability.class);
        return cap != null && cap.isAutoShutdownEnabled();
    }

    @Override
    public void setAutoShutdownEnabled(boolean enabled) {
        ShutdownCapability cap = this.mReplicaRepository.getCapability(ShutdownCapability.class);
        if (cap != null) {
            cap.setAutoShutdownEnabled(enabled);
        }
        if ((cap = this.mMasterRepository.getCapability(ShutdownCapability.class)) != null) {
            cap.setAutoShutdownEnabled(enabled);
        }
    }

    @Override
    public void shutdown() {
        ShutdownCapability cap = this.mReplicaRepository.getCapability(ShutdownCapability.class);
        if (cap != null) {
            cap.shutdown();
        } else {
            this.mReplicaRepository.close();
        }
        cap = this.mMasterRepository.getCapability(ShutdownCapability.class);
        if (cap != null) {
            cap.shutdown();
        } else {
            this.mMasterRepository.close();
        }
    }

    @Override
    public <S extends Storable> void resync(Class<S> type, double desiredSpeed, String filter, Object ... filterValues) throws RepositoryException {
        this.resync(type, null, desiredSpeed, filter, filterValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S extends Storable> void resync(Class<S> type, ResyncCapability.Listener<? super S> listener, double desiredSpeed, String filter, Object ... filterValues) throws RepositoryException {
        Throttle throttle;
        Query<S> masterQuery;
        Query<S> replicaQuery;
        if (!(this.storageFor(type) instanceof ReplicatedStorage)) {
            throw new UnsupportedTypeException("Storable type is not replicated", type);
        }
        ReplicationTrigger replicationTrigger = ((ReplicatedStorage)this.storageFor(type)).getReplicationTrigger();
        Storage<S> replicaStorage = this.mReplicaRepository.storageFor(type);
        Storage<S> masterStorage = this.mMasterRepository.storageFor(type);
        if (filter == null) {
            replicaQuery = replicaStorage.query();
            masterQuery = masterStorage.query();
        } else {
            replicaQuery = replicaStorage.query(filter).withValues(filterValues);
            masterQuery = masterStorage.query(filter).withValues(filterValues);
        }
        String[] orderBy = ReplicatedRepository.selectNaturalOrder(this.mReplicaRepository, type);
        if (orderBy == null && (orderBy = ReplicatedRepository.selectNaturalOrder(this.mMasterRepository, type)) == null) {
            Set<String> pkSet = StorableIntrospector.examine(type).getPrimaryKeyProperties().keySet();
            orderBy = pkSet.toArray(new String[pkSet.size()]);
        }
        Comparator<S> comparator = SortedCursor.createComparator(type, orderBy);
        replicaQuery = replicaQuery.orderBy(orderBy);
        masterQuery = masterQuery.orderBy(orderBy);
        if (desiredSpeed >= 1.0) {
            throttle = null;
        } else {
            if (desiredSpeed < 0.0) {
                desiredSpeed = 0.0;
            }
            throttle = new Throttle(50);
        }
        Transaction replicaTxn = this.mReplicaRepository.enterTransaction();
        try {
            replicaTxn.setForUpdate(true);
            this.resync(replicationTrigger, replicaStorage, replicaQuery, masterStorage, masterQuery, listener, throttle, desiredSpeed, comparator, replicaTxn);
            replicaTxn.commit();
        }
        finally {
            replicaTxn.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <S extends Storable> void resync(ReplicationTrigger<S> replicationTrigger, Storage<S> replicaStorage, Query<S> replicaQuery, Storage<S> masterStorage, Query<S> masterQuery, ResyncCapability.Listener<? super S> listener, Throttle throttle, double desiredSpeed, Comparator comparator, Transaction replicaTxn) throws RepositoryException {
        Log log = LogFactory.getLog(ReplicatedRepository.class);
        Cursor<S> replicaCursor = null;
        Cursor<S> masterCursor = null;
        try {
            while (replicaCursor == null) {
                try {
                    replicaCursor = replicaQuery.fetch();
                }
                catch (CorruptEncodingException e) {
                    S replicaWithKeyOnly = this.recoverReplicaKey(replicaStorage, e);
                    if (this.deleteCorruptEntry(replicationTrigger, replicaWithKeyOnly, e)) continue;
                    throw e;
                }
            }
            masterCursor = masterQuery.fetch();
            Storable lastReplicaEntry = null;
            Storable replicaEntry = null;
            Storable masterEntry = null;
            int count = 0;
            int txnCount = 0;
            while (true) {
                if (throttle != null) {
                    try {
                        throttle.throttle(desiredSpeed, 100L);
                    }
                    catch (InterruptedException e) {
                        throw new FetchInterruptedException(e);
                    }
                }
                if (replicaEntry == null && replicaCursor != null) {
                    int skippedCount = 0;
                    while (replicaCursor.hasNext()) {
                        try {
                            replicaEntry = (Storable)replicaCursor.next();
                            if (listener != null) {
                                listener.afterLoad(replicaEntry);
                            }
                            if (skippedCount <= 0) break;
                            if (skippedCount == 1) {
                                log.warn((Object)("Skipped corrupt replica entry before this one: " + replicaEntry));
                                break;
                            }
                            log.warn((Object)("Skipped " + skippedCount + " corrupt replica entries before this one: " + replicaEntry));
                            break;
                        }
                        catch (CorruptEncodingException e) {
                            replicaCursor.close();
                            replicaCursor = null;
                            S replicaWithKeyOnly = this.recoverReplicaKey(replicaStorage, e);
                            boolean deleted = this.deleteCorruptEntry(replicationTrigger, replicaWithKeyOnly, e);
                            if (lastReplicaEntry == null) break;
                            replicaCursor = replicaQuery.fetchAfter(lastReplicaEntry);
                            if (!deleted) continue;
                            try {
                                ++skippedCount;
                                skippedCount = replicaCursor.skipNext(skippedCount);
                                log.info((Object)"Skipped corrupt replica entry", (Throwable)e);
                                if (replicaWithKeyOnly == null) continue;
                                replicaEntry = replicaWithKeyOnly;
                                if (listener == null) break;
                                listener.afterLoad(replicaEntry);
                                break;
                            }
                            catch (FetchException e2) {
                                log.error((Object)"Unable to skip past corrupt replica entry", (Throwable)e2);
                                throw e;
                            }
                        }
                    }
                }
                if (count++ >= 100 || txnCount >= 10) {
                    replicaTxn.commit();
                    if (replicaCursor != null) {
                        replicaCursor.close();
                        replicaCursor = null;
                    }
                    count = 0;
                    txnCount = 0;
                }
                if (masterEntry == null && masterCursor.hasNext()) {
                    masterEntry = (Storable)masterCursor.next();
                }
                Runnable resyncTask = null;
                int compare = comparator.compare(replicaEntry, masterEntry);
                if (compare < 0) {
                    resyncTask = this.prepareResyncTask(replicationTrigger, listener, replicaEntry, null);
                    if (replicaCursor == null) {
                        replicaCursor = replicaQuery.fetchAfter(replicaEntry);
                    }
                    lastReplicaEntry = replicaEntry;
                    replicaEntry = null;
                } else if (compare > 0) {
                    resyncTask = this.prepareResyncTask(replicationTrigger, listener, null, masterEntry);
                    masterEntry = null;
                } else {
                    if (replicaEntry == null && masterEntry == null) {
                        break;
                    }
                    if (!replicaEntry.equalProperties(masterEntry)) {
                        resyncTask = this.prepareResyncTask(replicationTrigger, listener, replicaEntry, masterEntry);
                    }
                    if (replicaCursor == null) {
                        replicaCursor = replicaQuery.fetchAfter(replicaEntry);
                    }
                    lastReplicaEntry = replicaEntry;
                    replicaEntry = null;
                    masterEntry = null;
                }
                if (resyncTask == null) continue;
                ++txnCount;
                resyncTask.run();
            }
        }
        finally {
            try {
                if (masterCursor != null) {
                    masterCursor.close();
                }
            }
            finally {
                if (replicaCursor != null) {
                    replicaCursor.close();
                }
            }
        }
    }

    private <S extends Storable> S recoverReplicaKey(Storage<S> replicaStorage, CorruptEncodingException e) {
        Storable withKey = e.getStorableWithPrimaryKey();
        if (withKey != null && withKey.storableType() == replicaStorage.getStorableType()) {
            return (S)withKey;
        }
        return null;
    }

    private <S extends Storable> boolean deleteCorruptEntry(ReplicationTrigger<S> replicationTrigger, S replicaWithKeyOnly, CorruptEncodingException e) throws RepositoryException {
        if (replicaWithKeyOnly == null) {
            return false;
        }
        Log log = LogFactory.getLog(ReplicatedRepository.class);
        try {
            replicationTrigger.deleteReplica(replicaWithKeyOnly);
            log.info((Object)("Deleted corrupt replica entry: " + replicaWithKeyOnly.toStringKeyOnly()), (Throwable)e);
            return true;
        }
        catch (PersistException e2) {
            log.warn((Object)("Unable to delete corrupt replica entry: " + replicaWithKeyOnly.toStringKeyOnly()), (Throwable)e2);
            return false;
        }
    }

    private <S extends Storable> Runnable prepareResyncTask(final ReplicationTrigger<S> replicationTrigger, final ResyncCapability.Listener<? super S> listener, final S replicaEntry, final S masterEntry) throws RepositoryException {
        if (replicaEntry == null && masterEntry == null) {
            return null;
        }
        Runnable task = new Runnable(){

            public void run() {
                try {
                    replicationTrigger.resyncEntries(listener, replicaEntry, masterEntry);
                }
                catch (Exception e) {
                    LogFactory.getLog(ReplicatedRepository.class).error(null, (Throwable)e);
                }
            }
        };
        return task;
    }
}

