/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.map;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UpgradableLock<L> {
    private static final AtomicReferenceFieldUpdater<UpgradableLock, Node> cRWHeadRef = AtomicReferenceFieldUpdater.newUpdater(UpgradableLock.class, Node.class, "mRWHead");
    private static final AtomicReferenceFieldUpdater<UpgradableLock, Node> cRWTailRef = AtomicReferenceFieldUpdater.newUpdater(UpgradableLock.class, Node.class, "mRWTail");
    private static final AtomicReferenceFieldUpdater<UpgradableLock, Node> cUHeadRef = AtomicReferenceFieldUpdater.newUpdater(UpgradableLock.class, Node.class, "mUHead");
    private static final AtomicReferenceFieldUpdater<UpgradableLock, Node> cUTailRef = AtomicReferenceFieldUpdater.newUpdater(UpgradableLock.class, Node.class, "mUTail");
    private static final AtomicIntegerFieldUpdater<UpgradableLock> cStateRef = AtomicIntegerFieldUpdater.newUpdater(UpgradableLock.class, "mState");
    private static final int LOCK_STATE_UPGRADE = 0x40000000;
    private static final int LOCK_STATE_WRITE = Integer.MIN_VALUE;
    private static final int LOCK_STATE_MASK = -1073741824;
    private static final long SPIN_FOR_TIMEOUT_THRESHOLD = 1000L;
    private volatile transient Node mRWHead;
    private volatile transient Node mRWTail;
    private volatile transient Node mUHead;
    private volatile transient Node mUTail;
    private volatile transient int mState;
    private transient L mOwner;
    private transient int mUpgradeCount;
    private transient int mWriteCount;

    public final void lockForRead(L locker) {
        if (!this.tryLockForRead(locker)) {
            this.lockForReadQueued(locker, this.addReadWaiter());
        }
    }

    public final void lockForReadInterruptibly(L locker) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (!this.tryLockForRead(locker)) {
            this.lockForReadQueuedInterruptibly(locker, this.addReadWaiter());
        }
    }

    public final boolean tryLockForRead(L locker) {
        int state = this.mState;
        if (state >= 0) {
            if (this.isReadWriteFirst() || this.isReadLockHeld(locker)) {
                do {
                    if (!this.incrementReadLocks(state)) continue;
                    this.adjustReadLockCount(locker, 1);
                    return true;
                } while ((state = this.mState) >= 0);
            }
        } else if (this.mOwner == locker) {
            while (!this.incrementReadLocks(state)) {
                state = this.mState;
            }
            this.adjustReadLockCount(locker, 1);
            return true;
        }
        return false;
    }

    public final boolean tryLockForRead(L locker, long timeout, TimeUnit unit) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (!this.tryLockForRead(locker)) {
            return this.lockForReadQueuedInterruptibly(locker, this.addReadWaiter(), unit.toNanos(timeout));
        }
        return true;
    }

    public final void unlockFromRead(L locker) {
        Node h;
        int readLocks;
        this.adjustReadLockCount(locker, -1);
        while ((readLocks = this.decrementReadLocks(this.mState)) < 0) {
        }
        if (readLocks == 0 && (h = this.mRWHead) != null && h.mWaitStatus != 0) {
            this.unparkReadWriteSuccessor(h);
        }
    }

    public final boolean lockForUpgrade(L locker) {
        return this.lockForUpgrade_(locker) != Result.FAILED;
    }

    private final Result lockForUpgrade_(L locker) {
        Result result = this.tryLockForUpgrade_(locker);
        if (result == Result.FAILED) {
            result = this.lockForUpgradeQueued(locker, this.addUpgradeWaiter());
        }
        return result;
    }

    public final boolean lockForUpgradeInterruptibly(L locker) throws InterruptedException {
        return this.lockForUpgradeInterruptibly_(locker) != Result.FAILED;
    }

    private final Result lockForUpgradeInterruptibly_(L locker) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Result result = this.tryLockForUpgrade_(locker);
        if (result == Result.FAILED) {
            result = this.lockForUpgradeQueuedInterruptibly(locker, this.addUpgradeWaiter());
        }
        return result;
    }

    public final boolean tryLockForUpgrade(L locker) {
        return this.tryLockForUpgrade_(locker) != Result.FAILED;
    }

    private final Result tryLockForUpgrade_(L locker) {
        int state = this.mState;
        if ((state & 0xC0000000) == 0) {
            if (this.isUpgradeFirst()) {
                do {
                    if (!this.setUpgradeLock(state)) continue;
                    this.mOwner = locker;
                    this.incrementUpgradeCount();
                    return Result.ACQUIRED;
                } while (((state = this.mState) & 0xC0000000) == 0);
            }
        } else if (this.mOwner == locker) {
            this.incrementUpgradeCount();
            return Result.OWNED;
        }
        return Result.FAILED;
    }

    public final boolean tryLockForUpgrade(L locker, long timeout, TimeUnit unit) throws InterruptedException {
        return this.tryLockForUpgrade_(locker, timeout, unit) != Result.FAILED;
    }

    private final Result tryLockForUpgrade_(L locker, long timeout, TimeUnit unit) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Result result = this.tryLockForUpgrade_(locker);
        if (result == Result.FAILED) {
            result = this.lockForUpgradeQueuedInterruptibly(locker, this.addUpgradeWaiter(), unit.toNanos(timeout));
        }
        return result;
    }

    public final void unlockFromUpgrade(L locker) {
        int upgradeCount = this.mUpgradeCount - 1;
        if (upgradeCount < 0) {
            throw new IllegalMonitorStateException("Too many upgrade locks released");
        }
        if (upgradeCount == 0 && this.mWriteCount > 0) {
            this.clearUpgradeLock(this.mState);
            return;
        }
        this.mUpgradeCount = upgradeCount;
        if (upgradeCount > 0) {
            return;
        }
        this.mOwner = null;
        while (!this.clearUpgradeLock(this.mState)) {
        }
        Node h = this.mUHead;
        if (h != null && h.mWaitStatus != 0) {
            this.unparkUpgradeSuccessor(h);
        }
    }

    public final void lockForWrite(L locker) {
        if (!this.tryLockForWrite(locker)) {
            Result upgradeResult = this.lockForUpgrade_(locker);
            if (!this.tryLockForWrite(locker)) {
                this.lockForWriteQueued(locker, this.addWriteWaiter());
            }
            if (upgradeResult == Result.ACQUIRED) {
                while (!this.clearUpgradeLock(this.mState)) {
                }
            } else {
                --this.mUpgradeCount;
            }
        }
    }

    public final void lockForWriteInterruptibly(L locker) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (!this.tryLockForWrite(locker)) {
            Result upgradeResult = this.lockForUpgradeInterruptibly_(locker);
            if (!this.tryLockForWrite(locker)) {
                this.lockForWriteQueuedInterruptibly(locker, this.addWriteWaiter());
            }
            if (upgradeResult == Result.ACQUIRED) {
                while (!this.clearUpgradeLock(this.mState)) {
                }
            } else {
                --this.mUpgradeCount;
            }
        }
    }

    public final boolean tryLockForWrite(L locker) {
        int state = this.mState;
        if (state == 0) {
            if (this.isUpgradeOrReadWriteFirst() && this.setWriteLock(state)) {
                this.mOwner = locker;
                this.incrementUpgradeCount();
                this.incrementWriteCount();
                return true;
            }
        } else if (state == 0x40000000) {
            if (this.mOwner == locker && this.setWriteLock(state)) {
                this.incrementWriteCount();
                return true;
            }
        } else if (state < 0 && this.mOwner == locker) {
            this.incrementWriteCount();
            return true;
        }
        return false;
    }

    public final boolean tryLockForWrite(L locker, long timeout, TimeUnit unit) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (!this.tryLockForWrite(locker)) {
            long start = System.nanoTime();
            Result upgradeResult = this.tryLockForUpgrade_(locker, timeout, unit);
            if (upgradeResult == Result.FAILED) {
                return false;
            }
            if (!this.tryLockForWrite(locker)) {
                this.unlockFromUpgrade(locker);
                timeout = unit.toNanos(timeout) - (System.nanoTime() - start);
                if (timeout <= 0L) {
                    return false;
                }
                if (!this.lockForWriteQueuedInterruptibly(locker, this.addWriteWaiter(), timeout)) {
                    return false;
                }
            }
            if (upgradeResult == Result.ACQUIRED) {
                while (!this.clearUpgradeLock(this.mState)) {
                }
            } else {
                --this.mUpgradeCount;
            }
        }
        return true;
    }

    public final void unlockFromWrite(L locker) {
        int writeCount = this.mWriteCount - 1;
        if (writeCount < 0) {
            throw new IllegalMonitorStateException("Too many write locks released");
        }
        this.mWriteCount = writeCount;
        if (writeCount > 0) {
            return;
        }
        int state = this.mState;
        this.mState = 0x40000000;
        Node h = this.mRWHead;
        if (h != null && h.mWaitStatus != 0) {
            this.unparkReadWriteSuccessor(h);
        }
        if (state == Integer.MIN_VALUE) {
            this.unlockFromUpgrade(locker);
        }
    }

    public String toString() {
        int state = this.mState;
        int readLocks = state & 0x3FFFFFFF;
        int upgradeLocks = this.mUpgradeCount;
        int writeLocks = this.mWriteCount;
        return super.toString() + "[Read locks = " + readLocks + ", Upgrade locks = " + upgradeLocks + ", Write locks = " + writeLocks + ", Owner = " + this.mOwner + ']';
    }

    protected void adjustReadLockCount(L locker, int amount) {
    }

    protected boolean isReadLockHeld(L locker) {
        return false;
    }

    private Node enqForReadWrite(Node node) {
        Node t;
        while (true) {
            if ((t = this.mRWTail) == null) {
                Node h = new Node();
                h.mNext = node;
                node.mPrev = h;
                if (!cRWHeadRef.compareAndSet(this, null, h)) continue;
                this.mRWTail = node;
                return h;
            }
            node.mPrev = t;
            if (cRWTailRef.compareAndSet(this, t, node)) break;
        }
        t.mNext = node;
        return t;
    }

    private Node enqForUpgrade(Node node) {
        Node t;
        while (true) {
            if ((t = this.mUTail) == null) {
                Node h = new Node();
                h.mNext = node;
                node.mPrev = h;
                if (!cUHeadRef.compareAndSet(this, null, h)) continue;
                this.mUTail = node;
                return h;
            }
            node.mPrev = t;
            if (cUTailRef.compareAndSet(this, t, node)) break;
        }
        t.mNext = node;
        return t;
    }

    private Node addReadWaiter() {
        return this.addReadWriteWaiter(true);
    }

    private Node addWriteWaiter() {
        return this.addReadWriteWaiter(false);
    }

    private Node addReadWriteWaiter(boolean shared) {
        Node node = new Node(Thread.currentThread(), shared);
        Node pred = this.mRWTail;
        if (pred != null) {
            node.mPrev = pred;
            if (cRWTailRef.compareAndSet(this, pred, node)) {
                pred.mNext = node;
                return node;
            }
        }
        this.enqForReadWrite(node);
        return node;
    }

    private Node addUpgradeWaiter() {
        Node node = new Node(Thread.currentThread(), false);
        Node pred = this.mUTail;
        if (pred != null) {
            node.mPrev = pred;
            if (cUTailRef.compareAndSet(this, pred, node)) {
                pred.mNext = node;
                return node;
            }
        }
        this.enqForUpgrade(node);
        return node;
    }

    private void setReadWriteHead(Node node) {
        this.mRWHead = node;
        node.mThread = null;
        node.mPrev = null;
    }

    private void setUpgradeHead(Node node) {
        this.mUHead = node;
        node.mThread = null;
        node.mPrev = null;
    }

    private void unparkReadWriteSuccessor(Node node) {
        Node.cWaitStatusRef.compareAndSet(node, -1, 0);
        Node s = node.mNext;
        if (s == null || s.mWaitStatus > 0) {
            s = null;
            Node t = this.mRWTail;
            while (t != null && t != node) {
                if (t.mWaitStatus <= 0) {
                    s = t;
                }
                t = t.mPrev;
            }
        }
        if (s != null) {
            LockSupport.unpark(s.mThread);
        }
    }

    private void unparkUpgradeSuccessor(Node node) {
        Node.cWaitStatusRef.compareAndSet(node, -1, 0);
        Node s = node.mNext;
        if (s == null || s.mWaitStatus > 0) {
            s = null;
            Node t = this.mUTail;
            while (t != null && t != node) {
                if (t.mWaitStatus <= 0) {
                    s = t;
                }
                t = t.mPrev;
            }
        }
        if (s != null) {
            LockSupport.unpark(s.mThread);
        }
    }

    private void setReadWriteHeadAndPropagate(Node node) {
        Node s;
        this.setReadWriteHead(node);
        if (node.mWaitStatus != 0 && ((s = node.mNext) == null || s.mShared)) {
            this.unparkReadWriteSuccessor(node);
        }
    }

    private void cancelAcquireReadWrite(Node node) {
        if (node != null) {
            node.mThread = null;
            node.mWaitStatus = 1;
            this.unparkReadWriteSuccessor(node);
        }
    }

    private void cancelAcquireUpgrade(Node node) {
        if (node != null) {
            node.mThread = null;
            node.mWaitStatus = 1;
            this.unparkUpgradeSuccessor(node);
        }
    }

    private static boolean shouldParkAfterFailedAcquire(Node pred, Node node) {
        int s = pred.mWaitStatus;
        if (s < 0) {
            return true;
        }
        if (s > 0) {
            node.mPrev = pred.mPrev;
        } else {
            Node.cWaitStatusRef.compareAndSet(pred, 0, -1);
        }
        return false;
    }

    private static void selfInterrupt() {
        Thread.currentThread().interrupt();
    }

    private final boolean parkAndCheckInterrupt() {
        LockSupport.park(this);
        return Thread.interrupted();
    }

    private final Result lockForUpgradeQueued(L locker, Node node) {
        try {
            boolean interrupted = false;
            while (true) {
                Result result;
                Node p;
                if ((p = node.predecessor()) == this.mUHead && (result = this.tryLockForUpgrade_(locker)) != Result.FAILED) {
                    this.setUpgradeHead(node);
                    p.mNext = null;
                    if (interrupted) {
                        UpgradableLock.selfInterrupt();
                    }
                    return result;
                }
                if (!UpgradableLock.shouldParkAfterFailedAcquire(p, node) || !this.parkAndCheckInterrupt()) continue;
                interrupted = true;
            }
        }
        catch (RuntimeException e) {
            this.cancelAcquireUpgrade(node);
            throw e;
        }
    }

    private final Result lockForUpgradeQueuedInterruptibly(L locker, Node node) throws InterruptedException {
        try {
            Node p;
            do {
                Result result;
                if ((p = node.predecessor()) != this.mUHead || (result = this.tryLockForUpgrade_(locker)) == Result.FAILED) continue;
                this.setUpgradeHead(node);
                p.mNext = null;
                return result;
            } while (!UpgradableLock.shouldParkAfterFailedAcquire(p, node) || !this.parkAndCheckInterrupt());
        }
        catch (RuntimeException e) {
            this.cancelAcquireUpgrade(node);
            throw e;
        }
        this.cancelAcquireUpgrade(node);
        throw new InterruptedException();
    }

    private final Result lockForUpgradeQueuedInterruptibly(L locker, Node node, long nanosTimeout) throws InterruptedException {
        long lastTime = System.nanoTime();
        try {
            do {
                Result result;
                Node p;
                if ((p = node.predecessor()) == this.mUHead && (result = this.tryLockForUpgrade_(locker)) != Result.FAILED) {
                    this.setUpgradeHead(node);
                    p.mNext = null;
                    return result;
                }
                if (nanosTimeout <= 0L) {
                    this.cancelAcquireUpgrade(node);
                    return Result.FAILED;
                }
                if (nanosTimeout > 1000L && UpgradableLock.shouldParkAfterFailedAcquire(p, node)) {
                    LockSupport.parkNanos(this, nanosTimeout);
                }
                long now = System.nanoTime();
                nanosTimeout -= now - lastTime;
                lastTime = now;
            } while (!Thread.interrupted());
        }
        catch (RuntimeException e) {
            this.cancelAcquireUpgrade(node);
            throw e;
        }
        this.cancelAcquireUpgrade(node);
        throw new InterruptedException();
    }

    private final void lockForReadQueued(L locker, Node node) {
        try {
            boolean interrupted = false;
            while (true) {
                Node p;
                if ((p = node.predecessor()) == this.mRWHead && this.tryLockForRead(locker)) {
                    this.setReadWriteHeadAndPropagate(node);
                    p.mNext = null;
                    if (interrupted) {
                        UpgradableLock.selfInterrupt();
                    }
                    return;
                }
                if (!UpgradableLock.shouldParkAfterFailedAcquire(p, node) || !this.parkAndCheckInterrupt()) continue;
                interrupted = true;
            }
        }
        catch (RuntimeException e) {
            this.cancelAcquireReadWrite(node);
            throw e;
        }
    }

    private final void lockForReadQueuedInterruptibly(L locker, Node node) throws InterruptedException {
        try {
            Node p;
            do {
                if ((p = node.predecessor()) != this.mRWHead || !this.tryLockForRead(locker)) continue;
                this.setReadWriteHeadAndPropagate(node);
                p.mNext = null;
                return;
            } while (!UpgradableLock.shouldParkAfterFailedAcquire(p, node) || !this.parkAndCheckInterrupt());
        }
        catch (RuntimeException e) {
            this.cancelAcquireReadWrite(node);
            throw e;
        }
        this.cancelAcquireReadWrite(node);
        throw new InterruptedException();
    }

    private final boolean lockForReadQueuedInterruptibly(L locker, Node node, long nanosTimeout) throws InterruptedException {
        long lastTime = System.nanoTime();
        try {
            do {
                Node p;
                if ((p = node.predecessor()) == this.mRWHead && this.tryLockForRead(locker)) {
                    this.setReadWriteHeadAndPropagate(node);
                    p.mNext = null;
                    return true;
                }
                if (nanosTimeout <= 0L) {
                    this.cancelAcquireReadWrite(node);
                    return false;
                }
                if (nanosTimeout > 1000L && UpgradableLock.shouldParkAfterFailedAcquire(p, node)) {
                    LockSupport.parkNanos(this, nanosTimeout);
                }
                long now = System.nanoTime();
                nanosTimeout -= now - lastTime;
                lastTime = now;
            } while (!Thread.interrupted());
        }
        catch (RuntimeException e) {
            this.cancelAcquireReadWrite(node);
            throw e;
        }
        this.cancelAcquireReadWrite(node);
        throw new InterruptedException();
    }

    private final void lockForWriteQueued(L locker, Node node) {
        try {
            boolean interrupted = false;
            while (true) {
                Node p;
                if ((p = node.predecessor()) == this.mRWHead && this.tryLockForWrite(locker)) {
                    this.setReadWriteHead(node);
                    p.mNext = null;
                    if (interrupted) {
                        UpgradableLock.selfInterrupt();
                    }
                    return;
                }
                if (!UpgradableLock.shouldParkAfterFailedAcquire(p, node) || !this.parkAndCheckInterrupt()) continue;
                interrupted = true;
            }
        }
        catch (RuntimeException e) {
            this.cancelAcquireReadWrite(node);
            throw e;
        }
    }

    private final void lockForWriteQueuedInterruptibly(L locker, Node node) throws InterruptedException {
        try {
            Node p;
            do {
                if ((p = node.predecessor()) != this.mRWHead || !this.tryLockForWrite(locker)) continue;
                this.setReadWriteHead(node);
                p.mNext = null;
                return;
            } while (!UpgradableLock.shouldParkAfterFailedAcquire(p, node) || !this.parkAndCheckInterrupt());
        }
        catch (RuntimeException e) {
            this.cancelAcquireReadWrite(node);
            throw e;
        }
        this.cancelAcquireReadWrite(node);
        throw new InterruptedException();
    }

    private final boolean lockForWriteQueuedInterruptibly(L locker, Node node, long nanosTimeout) throws InterruptedException {
        long lastTime = System.nanoTime();
        try {
            do {
                Node p;
                if ((p = node.predecessor()) == this.mRWHead && this.tryLockForWrite(locker)) {
                    this.setReadWriteHead(node);
                    p.mNext = null;
                    return true;
                }
                if (nanosTimeout <= 0L) {
                    this.cancelAcquireReadWrite(node);
                    return false;
                }
                if (nanosTimeout > 1000L && UpgradableLock.shouldParkAfterFailedAcquire(p, node)) {
                    LockSupport.parkNanos(this, nanosTimeout);
                }
                long now = System.nanoTime();
                nanosTimeout -= now - lastTime;
                lastTime = now;
            } while (!Thread.interrupted());
        }
        catch (RuntimeException e) {
            this.cancelAcquireReadWrite(node);
            throw e;
        }
        this.cancelAcquireReadWrite(node);
        throw new InterruptedException();
    }

    private final boolean isReadWriteFirst() {
        Node h = this.mRWHead;
        if (h == null) {
            return true;
        }
        Thread current = Thread.currentThread();
        Node s = h.mNext;
        return s != null && s.mThread == current || this.fullIsReadWriteFirst(current);
    }

    private final boolean fullIsReadWriteFirst(Thread current) {
        Node s;
        Thread firstThread = null;
        Node h = this.mRWHead;
        if (h != null && (s = h.mNext) != null && s.mPrev == this.mRWHead && (firstThread = s.mThread) != null) {
            return firstThread == current;
        }
        Node t = this.mRWTail;
        while (t != null && t != this.mRWHead) {
            Thread tt = t.mThread;
            if (tt != null) {
                firstThread = tt;
            }
            t = t.mPrev;
        }
        return firstThread == current || firstThread == null;
    }

    private final boolean isUpgradeFirst() {
        Node h = this.mUHead;
        if (h == null) {
            return true;
        }
        Thread current = Thread.currentThread();
        Node s = h.mNext;
        return s != null && s.mThread == current || this.fullIsUpgradeFirst(current);
    }

    private final boolean fullIsUpgradeFirst(Thread current) {
        Node s;
        Thread firstThread = null;
        Node h = this.mUHead;
        if (h != null && (s = h.mNext) != null && s.mPrev == this.mUHead && (firstThread = s.mThread) != null) {
            return firstThread == current;
        }
        Node t = this.mUTail;
        while (t != null && t != this.mUHead) {
            Thread tt = t.mThread;
            if (tt != null) {
                firstThread = tt;
            }
            t = t.mPrev;
        }
        return firstThread == current || firstThread == null;
    }

    private final boolean isUpgradeOrReadWriteFirst() {
        Node rws;
        Node rwh;
        Node uh = this.mUHead;
        if (uh == null || (rwh = this.mRWHead) == null) {
            return true;
        }
        Thread current = Thread.currentThread();
        Node us = uh.mNext;
        return us != null && us.mThread == current || (rws = rwh.mNext) != null && rws.mThread == current || this.fullIsUpgradeFirst(current) || this.fullIsReadWriteFirst(current);
    }

    private boolean incrementReadLocks(int state) {
        int readLocks = (state & 0x3FFFFFFF) + 1;
        if (readLocks == -1073741824) {
            throw new IllegalMonitorStateException("Maximum read lock count exceeded");
        }
        return cStateRef.compareAndSet(this, state, state & 0xC0000000 | readLocks);
    }

    private int decrementReadLocks(int state) {
        int readLocks = (state & 0x3FFFFFFF) - 1;
        if (readLocks < 0) {
            throw new IllegalMonitorStateException("Too many read locks released");
        }
        if (cStateRef.compareAndSet(this, state, state & 0xC0000000 | readLocks)) {
            return readLocks;
        }
        return -1;
    }

    private boolean setUpgradeLock(int state) {
        return cStateRef.compareAndSet(this, state, state | 0x40000000);
    }

    private boolean clearUpgradeLock(int state) {
        return cStateRef.compareAndSet(this, state, state & 0xBFFFFFFF);
    }

    private void incrementUpgradeCount() {
        int upgradeCount = this.mUpgradeCount + 1;
        if (upgradeCount < 0) {
            throw new IllegalMonitorStateException("Maximum upgrade lock count exceeded");
        }
        this.mUpgradeCount = upgradeCount;
    }

    private boolean setWriteLock(int state) {
        return cStateRef.compareAndSet(this, state, state | Integer.MIN_VALUE);
    }

    private void incrementWriteCount() {
        int writeCount = this.mWriteCount + 1;
        if (writeCount < 0) {
            throw new IllegalMonitorStateException("Maximum write lock count exceeded");
        }
        this.mWriteCount = writeCount;
    }

    boolean noLocksHeld() {
        return this.mState == 0 && this.mOwner == null && this.mUpgradeCount == 0 && this.mWriteCount == 0;
    }

    static final class Node {
        static final AtomicIntegerFieldUpdater<Node> cWaitStatusRef = AtomicIntegerFieldUpdater.newUpdater(Node.class, "mWaitStatus");
        static final int CANCELLED = 1;
        static final int SIGNAL = -1;
        volatile int mWaitStatus;
        volatile Node mPrev;
        volatile Node mNext;
        volatile Thread mThread;
        final boolean mShared;

        Node() {
            this.mShared = false;
        }

        Node(Thread thread, boolean shared) {
            this.mThread = thread;
            this.mShared = shared;
        }

        final Node predecessor() throws NullPointerException {
            Node p = this.mPrev;
            if (p == null) {
                throw new NullPointerException();
            }
            return p;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Result {
        FAILED,
        ACQUIRED,
        OWNED;

    }
}

