/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.map;

import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.cursor.AbstractCursor;
import com.amazon.carbonado.repo.map.MapStorage;
import com.amazon.carbonado.repo.map.MapTransaction;
import com.amazon.carbonado.repo.map.UpgradableLock;
import com.amazon.carbonado.txn.TransactionScope;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MapCursor<S extends Storable>
extends AbstractCursor<S> {
    private static final AtomicReferenceFieldUpdater<MapCursor, Iterator> cIteratorRef = AtomicReferenceFieldUpdater.newUpdater(MapCursor.class, Iterator.class, "mIterator");
    private final MapStorage<S> mStorage;
    private final TransactionScope<MapTransaction> mScope;
    private final MapTransaction mTxn;
    private final boolean mIsForUpdate;
    private volatile Iterator<S> mIterator;

    MapCursor(MapStorage<S> storage, TransactionScope<MapTransaction> scope, Iterable<S> iterable) throws Exception {
        MapTransaction txn = scope.getTxn();
        this.mStorage = storage;
        this.mScope = scope;
        this.mTxn = txn;
        if (txn == null) {
            this.mStorage.mLock.lockForRead(scope);
            this.mIsForUpdate = false;
        } else {
            this.mIsForUpdate = scope.isForUpdate();
            txn.lockForUpgrade(this.mStorage.mLock, this.mIsForUpdate);
        }
        scope.register(storage.getStorableType(), this);
        this.mIterator = iterable.iterator();
    }

    @Override
    public void close() {
        Iterator<S> it = this.mIterator;
        if (it != null && cIteratorRef.compareAndSet(this, it, null)) {
            UpgradableLock<Object> lock = this.mStorage.mLock;
            if (this.mTxn == null) {
                lock.unlockFromRead(this.mScope);
            } else {
                this.mTxn.unlockFromUpgrade(lock, this.mIsForUpdate);
            }
            this.mScope.unregister(this.mStorage.getStorableType(), this);
        }
    }

    @Override
    public boolean hasNext() throws FetchException {
        Iterator<S> it = this.mIterator;
        try {
            if (it != null && it.hasNext()) {
                return true;
            }
            this.close();
            return false;
        }
        catch (ConcurrentModificationException e) {
            this.close();
            throw new FetchException(e);
        }
        catch (Error e) {
            try {
                this.close();
            }
            catch (Error error) {
                // empty catch block
            }
            throw e;
        }
    }

    @Override
    public S next() throws FetchException {
        Iterator<S> it = this.mIterator;
        if (it == null) {
            this.close();
            throw new NoSuchElementException();
        }
        try {
            Storable next = this.mStorage.copyAndFireLoadTrigger((Storable)it.next());
            if (!this.hasNext()) {
                this.close();
            }
            return (S)next;
        }
        catch (ConcurrentModificationException e) {
            this.close();
            throw new FetchException(e);
        }
        catch (Error e) {
            try {
                this.close();
            }
            catch (Error error) {
                // empty catch block
            }
            throw e;
        }
    }

    @Override
    public int skipNext(int amount) throws FetchException {
        if (amount <= 0) {
            if (amount < 0) {
                throw new IllegalArgumentException("Cannot skip negative amount: " + amount);
            }
            return 0;
        }
        int count = 0;
        Iterator<S> it = this.mIterator;
        if (it != null) {
            try {
                while (--amount >= 0 && it.hasNext()) {
                    it.next();
                    ++count;
                }
            }
            catch (ConcurrentModificationException e) {
                this.close();
                throw new FetchException(e);
            }
            catch (Error e) {
                try {
                    this.close();
                }
                catch (Error e2) {
                    // empty catch block
                }
                throw e;
            }
        }
        return count;
    }
}

