/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.map;

import com.amazon.carbonado.Storable;
import com.amazon.carbonado.gen.CodeBuilderUtil;
import com.amazon.carbonado.info.OrderedProperty;
import com.amazon.carbonado.info.StorableInfo;
import com.amazon.carbonado.info.StorableIntrospector;
import com.amazon.carbonado.info.StorableProperty;
import com.amazon.carbonado.util.SoftValuedCache;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Comparator;
import org.cojen.classfile.ClassFile;
import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.Label;
import org.cojen.classfile.LocalVariable;
import org.cojen.classfile.Location;
import org.cojen.classfile.MethodInfo;
import org.cojen.classfile.Modifiers;
import org.cojen.classfile.TypeDesc;
import org.cojen.util.ClassInjector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Key<S extends Storable>
implements Comparable<Key<S>> {
    protected final S mStorable;
    protected final Comparator<S> mComparator;
    private static final SoftValuedCache<Class, Assigner> mAssigners = SoftValuedCache.newCache(11);

    Key(S storable, Comparator<S> comparator) {
        this.mStorable = storable;
        this.mComparator = comparator;
    }

    public String toString() {
        return this.mStorable.toString();
    }

    @Override
    public int compareTo(Key<S> other) {
        int result = this.mComparator.compare(this.mStorable, other.mStorable);
        if (result == 0) {
            result = this.tieBreaker() - other.tieBreaker();
        }
        return result;
    }

    protected int tieBreaker() {
        return 0;
    }

    public static synchronized <S extends Storable> Assigner<S> getAssigner(Class<S> clazz) {
        Assigner<S> assigner = mAssigners.get(clazz);
        if (assigner == null) {
            assigner = Key.createAssigner(clazz);
            mAssigners.put(clazz, assigner);
        }
        return assigner;
    }

    private static <S extends Storable> Assigner<S> createAssigner(Class<S> clazz) {
        int prop;
        int i;
        StorableInfo<S> info = StorableIntrospector.examine(clazz);
        ClassInjector ci = ClassInjector.create((String)clazz.getName(), (ClassLoader)clazz.getClassLoader());
        ClassFile cf = new ClassFile(ci.getClassName());
        cf.addInterface(Assigner.class);
        cf.markSynthetic();
        cf.setSourceFile(Key.class.getName());
        cf.setTarget("1.5");
        cf.addDefaultConstructor();
        ArrayList<OrderedProperty<S>> pk = new ArrayList<OrderedProperty<S>>(info.getPrimaryKey().getProperties());
        TypeDesc storableType = TypeDesc.forClass(Storable.class);
        TypeDesc storableArrayType = storableType.toArrayType();
        TypeDesc userStorableType = TypeDesc.forClass(info.getStorableType());
        TypeDesc objectArrayType = TypeDesc.OBJECT.toArrayType();
        MethodInfo mi = cf.addMethod(Modifiers.PUBLIC, "setKeyValues", null, new TypeDesc[]{storableType, objectArrayType});
        CodeBuilder b = new CodeBuilder(mi);
        LocalVariable userStorableVar = b.createLocalVariable(null, userStorableType);
        b.loadLocal(b.getParameter(0));
        b.checkCast(userStorableType);
        b.storeLocal(userStorableVar);
        b.loadLocal(b.getParameter(1));
        b.arrayLength();
        int[] cases = new int[pk.size() + 1];
        Label[] labels = new Label[pk.size() + 1];
        for (int i2 = 0; i2 < labels.length; ++i2) {
            cases[i2] = pk.size() - i2;
            labels[i2] = b.createLabel();
        }
        Label defaultLabel = b.createLabel();
        b.switchBranch(cases, (Location[])labels, (Location)defaultLabel);
        for (i = 0; i < labels.length; ++i) {
            labels[i].setLocation();
            prop = cases[i] - 1;
            if (prop < 0) continue;
            b.loadLocal(userStorableVar);
            b.loadLocal(b.getParameter(1));
            b.loadConstant(prop);
            b.loadFromArray(storableArrayType);
            Key.callSetPropertyValue(b, (OrderedProperty)pk.get(prop));
        }
        b.returnVoid();
        defaultLabel.setLocation();
        CodeBuilderUtil.throwException(b, IllegalArgumentException.class, null);
        mi = cf.addMethod(Modifiers.PUBLIC, "setKeyValues", null, new TypeDesc[]{storableType, objectArrayType, TypeDesc.OBJECT});
        b = new CodeBuilder(mi);
        b.loadThis();
        b.loadLocal(b.getParameter(0));
        b.loadLocal(b.getParameter(1));
        b.invokeVirtual("setKeyValues", null, new TypeDesc[]{storableType, objectArrayType});
        userStorableVar = b.createLocalVariable(null, userStorableType);
        b.loadLocal(b.getParameter(0));
        b.checkCast(userStorableType);
        b.storeLocal(userStorableVar);
        b.loadLocal(b.getParameter(1));
        b.arrayLength();
        cases = new int[pk.size()];
        labels = new Label[pk.size()];
        for (i = 0; i < labels.length; ++i) {
            cases[i] = i;
            labels[i] = b.createLabel();
        }
        defaultLabel = b.createLabel();
        b.switchBranch(cases, (Location[])labels, (Location)defaultLabel);
        for (i = 0; i < labels.length; ++i) {
            labels[i].setLocation();
            prop = cases[i];
            b.loadLocal(userStorableVar);
            b.loadLocal(b.getParameter(2));
            Key.callSetPropertyValue(b, (OrderedProperty)pk.get(prop));
            b.returnVoid();
        }
        defaultLabel.setLocation();
        CodeBuilderUtil.throwException(b, IllegalArgumentException.class, null);
        try {
            return (Assigner)ci.defineClass(cf).newInstance();
        }
        catch (IllegalAccessException e) {
            throw new UndeclaredThrowableException(e);
        }
        catch (InstantiationException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    private static void callSetPropertyValue(CodeBuilder b, OrderedProperty<?> op) {
        StorableProperty<?> property = op.getChainedProperty().getLastProperty();
        TypeDesc propType = TypeDesc.forClass(property.getType());
        if (propType != TypeDesc.OBJECT) {
            TypeDesc objectType = propType.toObjectType();
            b.checkCast(objectType);
            b.convert(objectType, propType);
        }
        b.invoke(property.getWriteMethod());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Assigner<S extends Storable> {
        public void setKeyValues(S var1, Object[] var2);

        public void setKeyValues(S var1, Object[] var2, Object var3);
    }
}

