/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.logging;

import com.amazon.carbonado.Cursor;
import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.PersistException;
import com.amazon.carbonado.Query;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.filter.Filter;
import com.amazon.carbonado.filter.FilterValues;
import com.amazon.carbonado.repo.logging.Log;
import com.amazon.carbonado.repo.logging.LoggingStorage;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LoggingQuery<S extends Storable>
implements Query<S> {
    private final LoggingStorage<S> mStorage;
    private final Query<S> mQuery;

    LoggingQuery(LoggingStorage<S> storage, Query<S> query) {
        this.mStorage = storage;
        this.mQuery = query;
    }

    @Override
    public Class<S> getStorableType() {
        return this.mQuery.getStorableType();
    }

    @Override
    public Filter<S> getFilter() {
        return this.mQuery.getFilter();
    }

    @Override
    public FilterValues<S> getFilterValues() {
        return this.mQuery.getFilterValues();
    }

    @Override
    public int getBlankParameterCount() {
        return this.mQuery.getBlankParameterCount();
    }

    @Override
    public Query<S> with(int value) {
        return this.newInstance(this.mQuery.with(value));
    }

    @Override
    public Query<S> with(long value) {
        return this.newInstance(this.mQuery.with(value));
    }

    @Override
    public Query<S> with(float value) {
        return this.newInstance(this.mQuery.with(value));
    }

    @Override
    public Query<S> with(double value) {
        return this.newInstance(this.mQuery.with(value));
    }

    @Override
    public Query<S> with(boolean value) {
        return this.newInstance(this.mQuery.with(value));
    }

    @Override
    public Query<S> with(char value) {
        return this.newInstance(this.mQuery.with(value));
    }

    @Override
    public Query<S> with(byte value) {
        return this.newInstance(this.mQuery.with(value));
    }

    @Override
    public Query<S> with(short value) {
        return this.newInstance(this.mQuery.with(value));
    }

    @Override
    public Query<S> with(Object value) {
        return this.newInstance(this.mQuery.with(value));
    }

    @Override
    public Query<S> withValues(Object ... objects) {
        return this.newInstance(this.mQuery.withValues(objects));
    }

    @Override
    public Query<S> and(String filter) throws FetchException {
        return this.newInstance(this.mQuery.and(filter));
    }

    @Override
    public Query<S> and(Filter<S> filter) throws FetchException {
        return this.newInstance(this.mQuery.and(filter));
    }

    @Override
    public Query<S> or(String filter) throws FetchException {
        return this.newInstance(this.mQuery.or(filter));
    }

    @Override
    public Query<S> or(Filter<S> filter) throws FetchException {
        return this.newInstance(this.mQuery.or(filter));
    }

    @Override
    public Query<S> not() throws FetchException {
        return this.newInstance(this.mQuery.not());
    }

    @Override
    public Query<S> orderBy(String property) throws FetchException, UnsupportedOperationException {
        return this.newInstance(this.mQuery.orderBy(property));
    }

    @Override
    public Query<S> orderBy(String ... strings) throws FetchException, UnsupportedOperationException {
        return this.newInstance(this.mQuery.orderBy(strings));
    }

    @Override
    public <T extends S> Query<S> after(T start) throws FetchException {
        return this.newInstance(this.mQuery.after(start));
    }

    @Override
    public Cursor<S> fetch() throws FetchException {
        Log log = this.mStorage.mLog;
        if (log.isEnabled()) {
            log.write("Query.fetch() on " + this);
        }
        return this.mQuery.fetch();
    }

    @Override
    public Cursor<S> fetchSlice(long from, Long to) throws FetchException {
        Log log = this.mStorage.mLog;
        if (log.isEnabled()) {
            log.write("Query.fetchSlice(start, to) on " + this + ", from: " + from + ", to: " + to);
        }
        return this.mQuery.fetchSlice(from, to);
    }

    @Override
    public <T extends S> Cursor<S> fetchAfter(T start) throws FetchException {
        Log log = this.mStorage.mLog;
        if (log.isEnabled()) {
            log.write("Query.fetchAfter(start) on " + this + ", start: " + start);
        }
        return this.mQuery.fetchAfter(start);
    }

    @Override
    public S loadOne() throws FetchException {
        Log log = this.mStorage.mLog;
        if (log.isEnabled()) {
            log.write("Query.loadOne() on " + this);
        }
        return this.mQuery.loadOne();
    }

    @Override
    public S tryLoadOne() throws FetchException {
        Log log = this.mStorage.mLog;
        if (log.isEnabled()) {
            log.write("Query.tryLoadOne() on " + this);
        }
        return this.mQuery.tryLoadOne();
    }

    @Override
    public void deleteOne() throws PersistException {
        Log log = this.mStorage.mLog;
        if (log.isEnabled()) {
            log.write("Query.deleteOne() on " + this);
        }
        this.mQuery.deleteOne();
    }

    @Override
    public boolean tryDeleteOne() throws PersistException {
        Log log = this.mStorage.mLog;
        if (log.isEnabled()) {
            log.write("Query.tryDeleteOne() on " + this);
        }
        return this.mQuery.tryDeleteOne();
    }

    @Override
    public void deleteAll() throws PersistException {
        Log log = this.mStorage.mLog;
        if (log.isEnabled()) {
            log.write("Query.deleteAll() on " + this);
        }
        this.mQuery.deleteAll();
    }

    @Override
    public long count() throws FetchException {
        Log log = this.mStorage.mLog;
        if (log.isEnabled()) {
            log.write("Query.count() on " + this);
        }
        return this.mQuery.count();
    }

    @Override
    public boolean exists() throws FetchException {
        Log log = this.mStorage.mLog;
        if (log.isEnabled()) {
            log.write("Query.exists() on " + this);
        }
        return this.mQuery.exists();
    }

    @Override
    public boolean printNative() {
        return this.mQuery.printNative();
    }

    @Override
    public boolean printNative(Appendable app) throws IOException {
        return this.mQuery.printNative(app);
    }

    @Override
    public boolean printNative(Appendable app, int indentLevel) throws IOException {
        return this.mQuery.printNative(app, indentLevel);
    }

    @Override
    public boolean printPlan() {
        return this.mQuery.printPlan();
    }

    @Override
    public boolean printPlan(Appendable app) throws IOException {
        return this.mQuery.printPlan(app);
    }

    @Override
    public boolean printPlan(Appendable app, int indentLevel) throws IOException {
        return this.mQuery.printPlan(app, indentLevel);
    }

    @Override
    public String toString() {
        return ((Object)this.mQuery).toString();
    }

    @Override
    public int hashCode() {
        return ((Object)this.mQuery).hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LoggingQuery) {
            LoggingQuery other = (LoggingQuery)obj;
            return ((Object)this.mQuery).equals(other.mQuery);
        }
        return false;
    }

    private LoggingQuery<S> newInstance(Query<S> query) {
        return new LoggingQuery<S>(this.mStorage, query);
    }
}

