/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.jdbc;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleDataSource
implements DataSource {
    private final String mURL;
    private final Properties mProperties;
    private PrintWriter mLogWriter;

    public SimpleDataSource(String driverClass, String driverURL, Properties properties) throws SQLException {
        this(driverClass, driverURL, null, null, properties);
    }

    public SimpleDataSource(String driverClass, String driverURL, String username, String password) throws SQLException {
        this(driverClass, driverURL, username, password, null);
    }

    public SimpleDataSource(String driverClass, String driverURL, String username, String password, Properties properties) throws SQLException {
        if (driverURL == null) {
            throw new IllegalArgumentException("Must supply JDBC URL");
        }
        if (driverClass != null) {
            try {
                Class.forName(driverClass);
            }
            catch (ClassNotFoundException e) {
                SQLException e2 = new SQLException();
                e2.initCause(e);
                throw e2;
            }
        }
        if (properties == null) {
            properties = new Properties();
        }
        if (username != null) {
            properties.put("user", username);
        }
        if (password != null) {
            properties.put("password", password);
        }
        this.mURL = driverURL;
        this.mProperties = properties;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return DriverManager.getConnection(this.mURL, this.mProperties);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        Properties properties = new Properties(this.mProperties);
        if (username != null) {
            properties.put("user", username);
        }
        if (password != null) {
            properties.put("password", password);
        }
        return DriverManager.getConnection(this.mURL, properties);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.mLogWriter;
    }

    @Override
    public void setLogWriter(PrintWriter writer) throws SQLException {
        this.mLogWriter = writer;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    public void close() throws SQLException {
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }
}

