/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.jdbc;

import com.amazon.carbonado.Storable;
import com.amazon.carbonado.filter.FilterValues;
import com.amazon.carbonado.filter.PropertyFilter;
import com.amazon.carbonado.repo.jdbc.SQLStatement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NullablePropertyStatement<S extends Storable>
extends SQLStatement<S> {
    private final PropertyFilter<S> mFilter;
    private final boolean mIsNullOp;

    NullablePropertyStatement(PropertyFilter<S> filter, boolean isNullOp) {
        this.mFilter = filter;
        this.mIsNullOp = isNullOp;
    }

    @Override
    public int maxLength() {
        return this.mIsNullOp ? 8 : 12;
    }

    @Override
    public void appendTo(StringBuilder b, FilterValues<S> filterValues) {
        if (filterValues != null && filterValues.getValue(this.mFilter) == null && filterValues.isAssigned(this.mFilter)) {
            if (this.mIsNullOp) {
                b.append(" IS NULL");
            } else {
                b.append(" IS NOT NULL");
            }
        } else if (this.mIsNullOp) {
            b.append("=?");
        } else {
            b.append("<>?");
        }
    }
}

