/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.jdbc;

import com.amazon.carbonado.repo.jdbc.JDBCExceptionTransformer;
import com.amazon.carbonado.repo.jdbc.JDBCRepository;
import com.amazon.carbonado.repo.jdbc.JDBCSupportStrategy;
import com.amazon.carbonado.repo.jdbc.MysqlExceptionTransformer;

class MysqlSupportStrategy
extends JDBCSupportStrategy {
    private static final String TRUNCATE_STATEMENT = "TRUNCATE TABLE %s";

    protected MysqlSupportStrategy(JDBCRepository repo) {
        super(repo);
        this.setTruncateTableStatement(TRUNCATE_STATEMENT);
    }

    JDBCExceptionTransformer createExceptionTransformer() {
        return new MysqlExceptionTransformer();
    }

    JDBCSupportStrategy.SliceOption getSliceOption() {
        return JDBCSupportStrategy.SliceOption.OFFSET_AND_LIMIT;
    }

    String buildSelectWithSlice(String select, boolean from, boolean to) {
        if (to) {
            if (from) {
                return select.concat(" LIMIT ?,?");
            }
            return select.concat(" LIMIT ?");
        }
        if (from) {
            return select.concat(" LIMIT ?,18446744073709551615");
        }
        return select;
    }
}

