/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.jdbc;

import com.amazon.carbonado.repo.jdbc.LoggingStatement;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.apache.commons.logging.Log;

class LoggingPreparedStatement
extends LoggingStatement
implements PreparedStatement {
    protected final String mSQL;
    private Object[] mParams;
    private BigInteger mSetParams = BigInteger.ZERO;

    LoggingPreparedStatement(Log log, Connection con, PreparedStatement ps, String sql) {
        super(log, con, ps);
        this.mSQL = sql;
    }

    public ResultSet executeQuery() throws SQLException {
        this.logStatement();
        return this.ps().executeQuery();
    }

    public int executeUpdate() throws SQLException {
        this.logStatement();
        return this.ps().executeUpdate();
    }

    public boolean execute() throws SQLException {
        this.logStatement();
        return this.ps().execute();
    }

    private void logStatement() {
        BigInteger setParams;
        String statement = this.mSQL;
        Object[] params = this.mParams;
        if (this.mParams != null && (setParams = this.mSetParams) != BigInteger.ZERO) {
            int length = setParams.bitLength();
            StringBuilder b = new StringBuilder(statement.length() + length * 10);
            b.append(statement);
            b.append(" -- ");
            boolean any = false;
            for (int i = 0; i < length; ++i) {
                if (!setParams.testBit(i)) continue;
                if (any) {
                    b.append(", [");
                } else {
                    b.append('[');
                    any = true;
                }
                b.append(i);
                b.append("]=");
                b.append(params[i]);
            }
            statement = b.toString();
        }
        this.mLog.debug((Object)statement);
    }

    public void addBatch() throws SQLException {
        this.ps().addBatch();
    }

    public void clearParameters() throws SQLException {
        this.mParams = null;
        this.mSetParams = BigInteger.ZERO;
        this.ps().clearParameters();
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.setParam(parameterIndex, null);
        this.ps().setNull(parameterIndex, sqlType);
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.setParam(parameterIndex, x);
        this.ps().setBoolean(parameterIndex, x);
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.setParam(parameterIndex, x);
        this.ps().setByte(parameterIndex, x);
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.setParam(parameterIndex, x);
        this.ps().setShort(parameterIndex, x);
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.setParam(parameterIndex, x);
        this.ps().setInt(parameterIndex, x);
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.setParam(parameterIndex, x);
        this.ps().setLong(parameterIndex, x);
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.setParam(parameterIndex, Float.valueOf(x));
        this.ps().setFloat(parameterIndex, x);
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.setParam(parameterIndex, x);
        this.ps().setDouble(parameterIndex, x);
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.setParam(parameterIndex, x);
        this.ps().setBigDecimal(parameterIndex, x);
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        this.setParam(parameterIndex, x);
        this.ps().setString(parameterIndex, x);
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.setParam(parameterIndex, x);
        this.ps().setBytes(parameterIndex, x);
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.setParam(parameterIndex, x);
        this.ps().setDate(parameterIndex, x);
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.setParam(parameterIndex, x);
        this.ps().setTime(parameterIndex, x);
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.setParam(parameterIndex, x);
        this.ps().setTimestamp(parameterIndex, x);
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setParam(parameterIndex, "{asciiStream=" + x + ", length=" + length + '}');
        this.ps().setAsciiStream(parameterIndex, x, length);
    }

    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setParam(parameterIndex, "{unicodeStream=" + x + ", length=" + length + '}');
        this.ps().setUnicodeStream(parameterIndex, x, length);
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setParam(parameterIndex, "{binaryStream=" + x + ", length=" + length + '}');
        this.ps().setBinaryStream(parameterIndex, x, length);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        this.setParam(parameterIndex, "{object=" + x + ", targetSqlType=" + targetSqlType + ", scale=" + scale + '}');
        this.ps().setObject(parameterIndex, x, targetSqlType, scale);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setParam(parameterIndex, "{object=" + x + ", targetSqlType=" + targetSqlType + '}');
        this.ps().setObject(parameterIndex, x, targetSqlType);
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.setParam(parameterIndex, x);
        this.ps().setObject(parameterIndex, x);
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.setParam(parameterIndex, "{characterStream=" + reader + ", length=" + length + '}');
        this.ps().setCharacterStream(parameterIndex, reader, length);
    }

    public void setRef(int i, Ref x) throws SQLException {
        this.setParam(i, x);
        this.ps().setRef(i, x);
    }

    public void setBlob(int i, Blob x) throws SQLException {
        this.setParam(i, x);
        this.ps().setBlob(i, x);
    }

    public void setClob(int i, Clob x) throws SQLException {
        this.setParam(i, x);
        this.ps().setClob(i, x);
    }

    public void setArray(int i, Array x) throws SQLException {
        this.setParam(i, x);
        this.ps().setArray(i, x);
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.setParam(parameterIndex, "{date=" + x + ", calendar=" + cal + '}');
        this.ps().setDate(parameterIndex, x, cal);
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.setParam(parameterIndex, "{time=" + x + ", calendar=" + cal + '}');
        this.ps().setTime(parameterIndex, x, cal);
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.setParam(parameterIndex, "{timestamp=" + x + ", calendar=" + cal + '}');
        this.ps().setTimestamp(parameterIndex, x, cal);
    }

    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.setParam(paramIndex, "{null, sqlType=" + sqlType + ", typeName=" + typeName + '}');
        this.ps().setNull(paramIndex, sqlType, typeName);
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.setParam(parameterIndex, x);
        this.ps().setURL(parameterIndex, x);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.ps().getMetaData();
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.ps().getParameterMetaData();
    }

    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.ps().setRowId(parameterIndex, x);
    }

    public void setNString(int parameterIndex, String value) throws SQLException {
        this.ps().setNString(parameterIndex, value);
    }

    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.ps().setNCharacterStream(parameterIndex, value, length);
    }

    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.ps().setNClob(parameterIndex, value);
    }

    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.ps().setClob(parameterIndex, reader, length);
    }

    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.ps().setBlob(parameterIndex, inputStream, length);
    }

    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.ps().setNClob(parameterIndex, reader, length);
    }

    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.ps().setSQLXML(parameterIndex, xmlObject);
    }

    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.ps().setAsciiStream(parameterIndex, x, length);
    }

    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.ps().setBinaryStream(parameterIndex, x, length);
    }

    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.ps().setCharacterStream(parameterIndex, reader, length);
    }

    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.ps().setAsciiStream(parameterIndex, x);
    }

    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.ps().setBinaryStream(parameterIndex, x);
    }

    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.ps().setCharacterStream(parameterIndex, reader);
    }

    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.ps().setNCharacterStream(parameterIndex, value);
    }

    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.ps().setClob(parameterIndex, reader);
    }

    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.ps().setBlob(parameterIndex, inputStream);
    }

    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.ps().setNClob(parameterIndex, reader);
    }

    private void setParam(int parameterIndex, Object value) {
        Object[] params = this.mParams;
        if (params == null) {
            this.mParams = params = new Object[Math.max(parameterIndex + 1, 10)];
        } else if (parameterIndex + 1 >= params.length) {
            Object[] newParams = new Object[Math.max(parameterIndex + 1, params.length * 2)];
            System.arraycopy(params, 0, newParams, 0, params.length);
            params = newParams;
            this.mParams = newParams;
        }
        params[parameterIndex] = value;
        this.mSetParams = this.mSetParams.setBit(parameterIndex);
    }

    private PreparedStatement ps() {
        return (PreparedStatement)this.mStatement;
    }
}

