/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.jdbc;

import com.amazon.carbonado.Cursor;
import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.IsolationLevel;
import com.amazon.carbonado.PersistException;
import com.amazon.carbonado.Repository;
import com.amazon.carbonado.RepositoryException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.Storage;
import com.amazon.carbonado.SupportException;
import com.amazon.carbonado.Transaction;
import com.amazon.carbonado.Trigger;
import com.amazon.carbonado.capability.IndexInfo;
import com.amazon.carbonado.cursor.EmptyCursor;
import com.amazon.carbonado.cursor.LimitCursor;
import com.amazon.carbonado.filter.AndFilter;
import com.amazon.carbonado.filter.Filter;
import com.amazon.carbonado.filter.FilterValues;
import com.amazon.carbonado.filter.OrFilter;
import com.amazon.carbonado.filter.PropertyFilter;
import com.amazon.carbonado.filter.Visitor;
import com.amazon.carbonado.info.ChainedProperty;
import com.amazon.carbonado.info.Direction;
import com.amazon.carbonado.info.OrderedProperty;
import com.amazon.carbonado.info.StorableProperty;
import com.amazon.carbonado.info.StorablePropertyAdapter;
import com.amazon.carbonado.lob.Clob;
import com.amazon.carbonado.qe.AbstractQueryExecutor;
import com.amazon.carbonado.qe.FilteredQueryExecutor;
import com.amazon.carbonado.qe.OrderingList;
import com.amazon.carbonado.qe.QueryExecutor;
import com.amazon.carbonado.qe.QueryExecutorCache;
import com.amazon.carbonado.qe.QueryExecutorFactory;
import com.amazon.carbonado.qe.QueryFactory;
import com.amazon.carbonado.qe.QueryHints;
import com.amazon.carbonado.qe.SortedQueryExecutor;
import com.amazon.carbonado.qe.StandardQuery;
import com.amazon.carbonado.qe.StandardQueryFactory;
import com.amazon.carbonado.repo.jdbc.JDBCBlob;
import com.amazon.carbonado.repo.jdbc.JDBCBlobLoader;
import com.amazon.carbonado.repo.jdbc.JDBCClob;
import com.amazon.carbonado.repo.jdbc.JDBCClobLoader;
import com.amazon.carbonado.repo.jdbc.JDBCCursor;
import com.amazon.carbonado.repo.jdbc.JDBCRepository;
import com.amazon.carbonado.repo.jdbc.JDBCStorableGenerator;
import com.amazon.carbonado.repo.jdbc.JDBCStorableInfo;
import com.amazon.carbonado.repo.jdbc.JDBCStorableProperty;
import com.amazon.carbonado.repo.jdbc.JDBCSupport;
import com.amazon.carbonado.repo.jdbc.JDBCSupportStrategy;
import com.amazon.carbonado.repo.jdbc.JDBCTransaction;
import com.amazon.carbonado.repo.jdbc.JoinNode;
import com.amazon.carbonado.repo.jdbc.JoinNodeBuilder;
import com.amazon.carbonado.repo.jdbc.SQLStatement;
import com.amazon.carbonado.repo.jdbc.SQLStatementBuilder;
import com.amazon.carbonado.repo.jdbc.TableAliasGenerator;
import com.amazon.carbonado.repo.jdbc.WhereBuilder;
import com.amazon.carbonado.sequence.SequenceValueProducer;
import com.amazon.carbonado.spi.TriggerManager;
import com.amazon.carbonado.txn.TransactionScope;
import com.amazon.carbonado.util.QuickConstructorGenerator;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JDBCStorage<S extends Storable>
extends StandardQueryFactory<S>
implements Storage<S>,
JDBCSupport<S> {
    private static final int FIRST_RESULT_INDEX = 1;
    final JDBCRepository mRepository;
    final JDBCSupportStrategy mSupportStrategy;
    final JDBCStorableInfo<S> mInfo;
    final InstanceFactory mInstanceFactory;
    final QueryExecutorFactory<S> mExecutorFactory;
    final TriggerManager<S> mTriggerManager;

    JDBCStorage(JDBCRepository repository, JDBCStorableInfo<S> info, boolean isMaster, boolean autoVersioning, boolean suppressReload) throws SupportException, RepositoryException {
        super(info.getStorableType());
        this.mRepository = repository;
        this.mSupportStrategy = repository.getSupportStrategy();
        this.mInfo = info;
        Class<S> generatedStorableClass = JDBCStorableGenerator.getGeneratedClass(info, isMaster, autoVersioning, suppressReload);
        this.mInstanceFactory = QuickConstructorGenerator.getInstance(generatedStorableClass, InstanceFactory.class);
        this.mExecutorFactory = new QueryExecutorCache(new ExecutorFactory());
        this.mTriggerManager = new TriggerManager(info.getStorableType(), repository.mTriggerFactories);
    }

    @Override
    public Class<S> getStorableType() {
        return this.mInfo.getStorableType();
    }

    @Override
    public S prepare() {
        return (S)this.mInstanceFactory.instantiate(this);
    }

    public JDBCRepository getJDBCRepository() {
        return this.mRepository;
    }

    @Override
    public Repository getRootRepository() {
        return this.mRepository.getRootRepository();
    }

    @Override
    public boolean isPropertySupported(String propertyName) {
        JDBCStorableProperty<S> property = this.mInfo.getAllProperties().get(propertyName);
        return property != null && property.isSupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void truncate() throws PersistException {
        String truncateFormat = this.mSupportStrategy.getTruncateTableStatement();
        try {
            if (truncateFormat == null || this.mTriggerManager.getDeleteTrigger() != null) {
                this.query().deleteAll();
                return;
            }
            Connection con = this.getConnection();
            try {
                Statement st = con.createStatement();
                try {
                    st.execute(String.format(truncateFormat, this.mInfo.getQualifiedTableName()));
                }
                finally {
                    st.close();
                }
            }
            catch (SQLException e) {
                throw this.toPersistException(e);
            }
            finally {
                this.yieldConnection(con);
            }
        }
        catch (FetchException e) {
            throw e.toPersistException();
        }
    }

    @Override
    public boolean addTrigger(Trigger<? super S> trigger) {
        return this.mTriggerManager.addTrigger(trigger);
    }

    @Override
    public boolean removeTrigger(Trigger<? super S> trigger) {
        return this.mTriggerManager.removeTrigger(trigger);
    }

    public IndexInfo[] getIndexInfo() {
        return this.mInfo.getIndexInfo();
    }

    @Override
    public SequenceValueProducer getSequenceValueProducer(String name) throws PersistException {
        try {
            return this.mRepository.getSequenceValueProducer(name);
        }
        catch (RepositoryException e) {
            throw e.toPersistException();
        }
    }

    @Override
    public Trigger<? super S> getInsertTrigger() {
        return this.mTriggerManager.getInsertTrigger();
    }

    @Override
    public Trigger<? super S> getUpdateTrigger() {
        return this.mTriggerManager.getUpdateTrigger();
    }

    @Override
    public Trigger<? super S> getDeleteTrigger() {
        return this.mTriggerManager.getDeleteTrigger();
    }

    @Override
    public Trigger<? super S> getLoadTrigger() {
        return this.mTriggerManager.getLoadTrigger();
    }

    @Override
    public void locallyDisableLoadTrigger() {
        this.mTriggerManager.locallyDisableLoad();
    }

    @Override
    public void locallyEnableLoadTrigger() {
        this.mTriggerManager.locallyEnableLoad();
    }

    @Override
    public boolean isTransactionForUpdate() {
        return this.mRepository.isTransactionForUpdate();
    }

    @Override
    public FetchException toFetchException(Throwable e) {
        return this.mRepository.toFetchException(e);
    }

    @Override
    public PersistException toPersistException(Throwable e) {
        return this.mRepository.toPersistException(e);
    }

    @Override
    public boolean isUniqueConstraintError(SQLException e) {
        return this.mRepository.isUniqueConstraintError(e);
    }

    @Override
    public Connection getConnection() throws FetchException {
        return this.mRepository.getConnection();
    }

    @Override
    public void yieldConnection(Connection con) throws FetchException {
        this.mRepository.yieldConnection(con);
    }

    @Override
    public String getDatabaseProductName() {
        return this.mRepository.getDatabaseProductName();
    }

    @Override
    public com.amazon.carbonado.lob.Blob convertBlob(Blob blob, JDBCBlobLoader loader) throws FetchException {
        JDBCBlob jblob = this.mSupportStrategy.convertBlob(blob, loader);
        if (jblob != null) {
            try {
                JDBCTransaction txn = this.mRepository.localTransactionScope().getTxn();
                if (txn != null) {
                    txn.register(jblob);
                }
            }
            catch (Exception e) {
                throw this.toFetchException(e);
            }
        }
        return jblob;
    }

    @Override
    public Clob convertClob(java.sql.Clob clob, JDBCClobLoader loader) throws FetchException {
        JDBCClob jclob = this.mSupportStrategy.convertClob(clob, loader);
        if (jclob != null) {
            try {
                JDBCTransaction txn = this.mRepository.localTransactionScope().getTxn();
                if (txn != null) {
                    txn.register(jclob);
                }
            }
            catch (Exception e) {
                throw this.toFetchException(e);
            }
        }
        return jclob;
    }

    @Override
    public com.amazon.carbonado.lob.Blob setBlobValue(PreparedStatement ps, int column, com.amazon.carbonado.lob.Blob blob) throws PersistException {
        return this.mSupportStrategy.setBlobValue(ps, column, blob);
    }

    @Override
    public Clob setClobValue(PreparedStatement ps, int column, Clob clob) throws PersistException {
        return this.mSupportStrategy.setClobValue(ps, column, clob);
    }

    @Override
    public void updateBlob(com.amazon.carbonado.lob.Blob oldBlob, com.amazon.carbonado.lob.Blob newBlob) throws PersistException {
        this.mSupportStrategy.updateBlob(oldBlob, newBlob);
    }

    @Override
    public void updateClob(Clob oldClob, Clob newClob) throws PersistException {
        this.mSupportStrategy.updateClob(oldClob, newClob);
    }

    protected JDBCStorableInfo<S> getStorableInfo() {
        return this.mInfo;
    }

    @Override
    protected StandardQuery<S> createQuery(Filter<S> filter, FilterValues<S> values, OrderingList<S> ordering, QueryHints hints) {
        return new JDBCQuery(filter, values, ordering, hints);
    }

    public S instantiate(ResultSet rs) throws SQLException {
        return (S)this.mInstanceFactory.instantiate(this, rs, 1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JDBCQuery
    extends StandardQuery<S> {
        JDBCQuery(Filter<S> filter, FilterValues<S> values, OrderingList<S> ordering, QueryHints hints) {
            super(filter, values, ordering, hints);
        }

        @Override
        public void deleteAll() throws PersistException {
            if (JDBCStorage.this.mTriggerManager.getDeleteTrigger() != null) {
                super.deleteAll();
            } else {
                try {
                    ((Executor)this.executor()).executeDelete(this.getFilterValues());
                }
                catch (RepositoryException e) {
                    throw e.toPersistException();
                }
            }
        }

        @Override
        protected Transaction enterTransaction(IsolationLevel level) {
            return JDBCStorage.this.getRootRepository().enterTransaction(level);
        }

        @Override
        protected QueryFactory<S> queryFactory() {
            return JDBCStorage.this;
        }

        @Override
        protected QueryExecutorFactory<S> executorFactory() {
            return JDBCStorage.this.mExecutorFactory;
        }

        @Override
        protected StandardQuery<S> newInstance(FilterValues<S> values, OrderingList<S> ordering, QueryHints hints) {
            return new JDBCQuery(values.getFilter(), values, ordering, hints);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Executor
    extends AbstractQueryExecutor<S> {
        private final Filter<S> mFilter;
        private final OrderingList<S> mOrdering;
        private final SQLStatement<S> mSelectStatement;
        private final int mMaxSelectStatementLength;
        private final SQLStatement<S> mFromWhere;
        private final int mMaxFromWhereLength;
        private final SQLStatement<S> mDeleteFromWhere;
        private final int mMaxDeleteFromWhereLength;
        private final PropertyFilter<S>[] mPropertyFilters;
        private final boolean[] mPropertyFilterNullable;
        private final Method[] mPreparedStatementSetMethods;
        private final Method[] mAdapterMethods;
        private final Object[] mAdapterInstances;

        Executor(Filter<S> filter, OrderingList<S> ordering, SQLStatement<S> selectStatement, SQLStatement<S> fromWhere, SQLStatement<S> deleteFromWhere, PropertyFilter<S>[] propertyFilters, boolean[] propertyFilterNullable) throws RepositoryException {
            this.mFilter = filter;
            this.mOrdering = ordering;
            this.mSelectStatement = selectStatement;
            this.mMaxSelectStatementLength = selectStatement.maxLength();
            this.mFromWhere = fromWhere;
            this.mMaxFromWhereLength = fromWhere.maxLength();
            if (deleteFromWhere == null) {
                this.mDeleteFromWhere = this.mFromWhere;
                this.mMaxDeleteFromWhereLength = this.mMaxFromWhereLength;
            } else {
                this.mDeleteFromWhere = deleteFromWhere;
                this.mMaxDeleteFromWhereLength = deleteFromWhere.maxLength();
            }
            if (propertyFilters == null) {
                this.mPropertyFilters = null;
                this.mPropertyFilterNullable = null;
                this.mPreparedStatementSetMethods = null;
                this.mAdapterMethods = null;
                this.mAdapterInstances = null;
            } else {
                this.mPropertyFilters = propertyFilters;
                this.mPropertyFilterNullable = propertyFilterNullable;
                int length = propertyFilters.length;
                this.mPreparedStatementSetMethods = new Method[length];
                this.mAdapterMethods = new Method[length];
                this.mAdapterInstances = new Object[length];
                this.gatherAdapterMethods(propertyFilters);
            }
        }

        private void gatherAdapterMethods(PropertyFilter<S>[] filters) throws RepositoryException {
            for (int i = 0; i < filters.length; ++i) {
                Method psSetMethod;
                PropertyFilter filter = filters[i];
                ChainedProperty chained = filter.getChainedProperty();
                StorableProperty<?> property = chained.getLastProperty();
                JDBCStorableProperty<?> jProperty = JDBCStorage.this.mRepository.getJDBCStorableProperty(property);
                this.mPreparedStatementSetMethods[i] = psSetMethod = jProperty.getPreparedStatementSetMethod();
                StorablePropertyAdapter adapter = jProperty.getAppliedAdapter();
                if (adapter == null) continue;
                Class<?> toType = psSetMethod.getParameterTypes()[1];
                this.mAdapterMethods[i] = adapter.findAdaptMethod(jProperty.getType(), toType);
                if (this.mAdapterMethods[i] == null && toType == String.class) {
                    this.mAdapterMethods[i] = adapter.findAdaptMethod(jProperty.getType(), Character.class);
                    if (this.mAdapterMethods[i] == null) {
                        this.mAdapterMethods[i] = adapter.findAdaptMethod(jProperty.getType(), Character.TYPE);
                    }
                }
                this.mAdapterInstances[i] = adapter.getAdapterInstance();
            }
        }

        @Override
        public Cursor<S> fetch(FilterValues<S> values) throws FetchException {
            TransactionScope<JDBCTransaction> scope = JDBCStorage.this.mRepository.localTransactionScope();
            boolean forUpdate = scope.isForUpdate();
            Connection con = JDBCStorage.this.getConnection();
            try {
                PreparedStatement ps = con.prepareStatement(this.prepareSelect(values, forUpdate));
                Integer fetchSize = JDBCStorage.this.mRepository.getFetchSize();
                if (fetchSize != null) {
                    ps.setFetchSize(fetchSize);
                }
                try {
                    this.setParameters(ps, values);
                    return new JDBCCursor(JDBCStorage.this, scope, con, ps);
                }
                catch (Exception e) {
                    try {
                        ps.close();
                    }
                    catch (SQLException e2) {
                        // empty catch block
                    }
                    throw e;
                }
            }
            catch (Exception e) {
                try {
                    JDBCStorage.this.yieldConnection(con);
                }
                catch (FetchException e2) {
                    // empty catch block
                }
                throw JDBCStorage.this.toFetchException(e);
            }
        }

        @Override
        public Cursor<S> fetchSlice(FilterValues<S> values, long from, Long to) throws FetchException {
            String select;
            if (to != null && to - from <= 0L) {
                return EmptyCursor.the();
            }
            JDBCSupportStrategy.SliceOption option = JDBCStorage.this.mSupportStrategy.getSliceOption();
            switch (option) {
                default: {
                    return super.fetchSlice(values, from, to);
                }
                case LIMIT_ONLY: {
                    if (from > 0L || to == null) {
                        return super.fetchSlice(values, from, to);
                    }
                    select = this.prepareSelect(values, false);
                    select = JDBCStorage.this.mSupportStrategy.buildSelectWithSlice(select, false, true);
                    break;
                }
                case OFFSET_ONLY: {
                    if (from <= 0L) {
                        return super.fetchSlice(values, from, to);
                    }
                    select = this.prepareSelect(values, false);
                    select = JDBCStorage.this.mSupportStrategy.buildSelectWithSlice(select, true, false);
                    break;
                }
                case LIMIT_AND_OFFSET: 
                case OFFSET_AND_LIMIT: 
                case FROM_AND_TO: {
                    select = this.prepareSelect(values, false);
                    select = JDBCStorage.this.mSupportStrategy.buildSelectWithSlice(select, from > 0L, to != null);
                }
            }
            TransactionScope<JDBCTransaction> scope = JDBCStorage.this.mRepository.localTransactionScope();
            if (scope.isForUpdate()) {
                select = select.concat(" FOR UPDATE");
            }
            Connection con = JDBCStorage.this.getConnection();
            PreparedStatement ps = con.prepareStatement(select);
            Integer fetchSize = JDBCStorage.this.mRepository.getFetchSize();
            if (fetchSize != null) {
                ps.setFetchSize(fetchSize);
            }
            try {
                int psOrdinal = this.setParameters(ps, values);
                if (from > 0L) {
                    if (to != null) {
                        switch (option) {
                            case OFFSET_ONLY: {
                                ps.setLong(psOrdinal, from);
                                JDBCCursor c = new JDBCCursor(JDBCStorage.this, scope, con, ps);
                                return new LimitCursor(c, to - from);
                            }
                            case LIMIT_AND_OFFSET: {
                                ps.setLong(psOrdinal, to - from);
                                ps.setLong(psOrdinal + 1, from);
                                break;
                            }
                            case OFFSET_AND_LIMIT: {
                                ps.setLong(psOrdinal, from);
                                ps.setLong(psOrdinal + 1, to - from);
                                break;
                            }
                            case FROM_AND_TO: {
                                ps.setLong(psOrdinal, from);
                                ps.setLong(psOrdinal + 1, to);
                            }
                        }
                    } else {
                        ps.setLong(psOrdinal, from);
                    }
                } else if (to != null) {
                    ps.setLong(psOrdinal, to);
                }
                return new JDBCCursor(JDBCStorage.this, scope, con, ps);
            }
            catch (Exception e) {
                try {
                    try {
                        ps.close();
                    }
                    catch (SQLException e2) {
                        // empty catch block
                    }
                    throw e;
                }
                catch (Exception e2) {
                    try {
                        JDBCStorage.this.yieldConnection(con);
                    }
                    catch (FetchException e22) {
                        // empty catch block
                    }
                    throw JDBCStorage.this.toFetchException(e2);
                }
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        public long count(FilterValues<S> values) throws FetchException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public Filter<S> getFilter() {
            return this.mFilter;
        }

        @Override
        public OrderingList<S> getOrdering() {
            return this.mOrdering;
        }

        @Override
        public boolean printNative(Appendable app, int indentLevel, FilterValues<S> values) throws IOException {
            this.indent(app, indentLevel);
            boolean forUpdate = JDBCStorage.this.mRepository.localTransactionScope().isForUpdate();
            app.append(this.prepareSelect(values, forUpdate));
            app.append('\n');
            return true;
        }

        @Override
        public boolean printPlan(Appendable app, int indentLevel, FilterValues<S> values) throws IOException {
            try {
                boolean forUpdate = JDBCStorage.this.mRepository.localTransactionScope().isForUpdate();
                String statement = this.prepareSelect(values, forUpdate);
                return JDBCStorage.this.mRepository.getSupportStrategy().printPlan(app, indentLevel, statement);
            }
            catch (FetchException e) {
                LogFactory.getLog(JDBCStorage.class).error(null, (Throwable)e);
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int executeDelete(FilterValues<S> filterValues) throws PersistException {
            Connection con;
            try {
                con = JDBCStorage.this.getConnection();
            }
            catch (FetchException e) {
                throw e.toPersistException();
            }
            try {
                int n;
                PreparedStatement ps = con.prepareStatement(this.prepareDelete(filterValues));
                try {
                    this.setParameters(ps, filterValues);
                    n = ps.executeUpdate();
                }
                catch (Throwable throwable) {
                    try {
                        ps.close();
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw JDBCStorage.this.toPersistException(e);
                    }
                }
                ps.close();
                return n;
            }
            finally {
                try {
                    JDBCStorage.this.yieldConnection(con);
                }
                catch (FetchException e) {
                    throw e.toPersistException();
                }
            }
        }

        private String prepareSelect(FilterValues<S> filterValues, boolean forUpdate) {
            if (!forUpdate) {
                return this.mSelectStatement.buildStatement(this.mMaxSelectStatementLength, filterValues);
            }
            StringBuilder b = new StringBuilder(this.mMaxSelectStatementLength + 11);
            this.mSelectStatement.appendTo(b, filterValues);
            b.append(" FOR UPDATE");
            return b.toString();
        }

        private String prepareCount(FilterValues<S> filterValues) {
            StringBuilder b = new StringBuilder(15 + this.mMaxFromWhereLength);
            b.append("SELECT COUNT(*)");
            this.mFromWhere.appendTo(b, filterValues);
            return b.toString();
        }

        private String prepareDelete(FilterValues<S> filterValues) {
            StringBuilder b = new StringBuilder(6 + this.mMaxDeleteFromWhereLength);
            b.append("DELETE");
            this.mDeleteFromWhere.appendTo(b, filterValues);
            return b.toString();
        }

        private int setParameters(PreparedStatement ps, FilterValues<S> filterValues) throws Exception {
            PropertyFilter<S>[] propertyFilters = this.mPropertyFilters;
            if (propertyFilters == null) {
                return 1;
            }
            boolean[] propertyFilterNullable = this.mPropertyFilterNullable;
            Method[] psSetMethods = this.mPreparedStatementSetMethods;
            Method[] adapterMethods = this.mAdapterMethods;
            Object[] adapterInstances = this.mAdapterInstances;
            int ordinal = 0;
            int psOrdinal = 1;
            for (PropertyFilter filter : propertyFilters) {
                Object value = filterValues.getAssignedValue(filter);
                if (value != null || !propertyFilterNullable[ordinal]) {
                    Method adapter = adapterMethods[ordinal];
                    if (adapter != null) {
                        value = adapter.invoke(adapterInstances[ordinal], value);
                    }
                    if (value != null && value instanceof Character) {
                        value = String.valueOf((Character)value);
                    }
                    psSetMethods[ordinal].invoke((Object)ps, psOrdinal, value);
                    ++psOrdinal;
                }
                ++ordinal;
            }
            return psOrdinal;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExecutorFactory
    implements QueryExecutorFactory<S> {
        ExecutorFactory() {
        }

        @Override
        public Class<S> getStorableType() {
            return JDBCStorage.this.getStorableType();
        }

        @Override
        public QueryExecutor<S> executor(Filter<S> filter, OrderingList<S> ordering, QueryHints hints) throws RepositoryException {
            SQLStatementBuilder deleteFromWhereBuilder;
            JoinNode jn;
            TableAliasGenerator aliasGenerator = new TableAliasGenerator();
            try {
                JoinNodeBuilder jnb = new JoinNodeBuilder(JDBCStorage.this.mRepository, JDBCStorage.this.getStorableInfo(), aliasGenerator);
                if (filter != null) {
                    filter.accept(jnb, null);
                }
                jn = jnb.getRootJoinNode();
                jnb.captureOrderings(ordering);
            }
            catch (UndeclaredThrowableException e) {
                throw JDBCStorage.this.toFetchException(e);
            }
            SQLStatementBuilder selectBuilder = new SQLStatementBuilder(JDBCStorage.this.mRepository);
            selectBuilder.append("SELECT ");
            String alias = jn.isAliasRequired() ? jn.getAlias() : null;
            Map properties = JDBCStorage.this.getStorableInfo().getAllProperties();
            int ordinal = 0;
            for (JDBCStorableProperty property : properties.values()) {
                if (!property.isSelectable()) continue;
                if (ordinal > 0) {
                    selectBuilder.append(',');
                }
                if (alias != null) {
                    selectBuilder.append(alias);
                    selectBuilder.append('.');
                }
                selectBuilder.append(property.getColumnName());
                ++ordinal;
            }
            selectBuilder.append(" FROM");
            SQLStatementBuilder fromWhereBuilder = new SQLStatementBuilder(JDBCStorage.this.mRepository);
            fromWhereBuilder.append(" FROM");
            if (alias == null) {
                jn.appendTableNameTo(selectBuilder);
                jn.appendTableNameTo(fromWhereBuilder);
                deleteFromWhereBuilder = null;
            } else {
                jn.appendFullJoinTo(selectBuilder);
                jn.appendFullJoinTo(fromWhereBuilder);
                deleteFromWhereBuilder = new SQLStatementBuilder(JDBCStorage.this.mRepository);
                deleteFromWhereBuilder.append(" FROM");
                jn.appendTableNameAndAliasTo(deleteFromWhereBuilder);
            }
            Filter remainderFilter = null;
            PropertyFilter<S>[] propertyFilters = null;
            boolean[] propertyFilterNullable = null;
            if (filter != null && !filter.isOpen()) {
                Filter sqlFilter = null;
                List splitList = filter.conjunctiveNormalFormSplit();
                for (Filter<Object> filter2 : splitList) {
                    if (this.usesDerivedProperty(filter2)) {
                        remainderFilter = this.and(remainderFilter, filter2);
                        continue;
                    }
                    sqlFilter = this.and(sqlFilter, filter2);
                }
                if (remainderFilter == null) {
                    sqlFilter = filter;
                }
                if (sqlFilter == null) {
                    remainderFilter = filter;
                } else {
                    WhereBuilder wb = new WhereBuilder(selectBuilder, alias == null ? null : jn, aliasGenerator);
                    wb.append(sqlFilter);
                    propertyFilters = wb.getPropertyFilters();
                    propertyFilterNullable = wb.getPropertyFilterNullable();
                    wb = new WhereBuilder(fromWhereBuilder, alias == null ? null : jn, aliasGenerator);
                    wb.append(sqlFilter);
                    if (deleteFromWhereBuilder != null) {
                        wb = new WhereBuilder(deleteFromWhereBuilder, jn, aliasGenerator);
                        wb.appendExists(sqlFilter);
                    }
                }
            }
            List sqlOrdering = ordering;
            List remainderOrdering = null;
            if (ordering != null && ordering.size() > 0) {
                ordinal = 0;
                for (OrderedProperty orderedProperty : ordering) {
                    if (orderedProperty.getChainedProperty().isDerived()) {
                        sqlOrdering = ordering.subList(0, ordinal);
                        remainderOrdering = ordering.subList(ordinal, ordering.size());
                        break;
                    }
                    ++ordinal;
                }
                if (sqlOrdering != null && sqlOrdering.size() > 0) {
                    selectBuilder.append(" ORDER BY ");
                    ordinal = 0;
                    for (OrderedProperty orderedProperty : sqlOrdering) {
                        if (ordinal > 0) {
                            selectBuilder.append(',');
                        }
                        selectBuilder.appendColumn(alias == null ? null : jn, orderedProperty.getChainedProperty());
                        if (orderedProperty.getDirection() == Direction.DESCENDING) {
                            selectBuilder.append(" DESC");
                        }
                        ++ordinal;
                    }
                }
            }
            SQLStatement selectStatement = selectBuilder.build();
            SQLStatement sQLStatement = fromWhereBuilder.build();
            SQLStatement deleteFromWhere = deleteFromWhereBuilder == null ? null : deleteFromWhereBuilder.build();
            AbstractQueryExecutor executor = new Executor(filter, sqlOrdering, selectStatement, sQLStatement, deleteFromWhere, propertyFilters, propertyFilterNullable);
            if (remainderFilter != null && !remainderFilter.isOpen()) {
                executor = new FilteredQueryExecutor(executor, remainderFilter);
            }
            if (remainderOrdering != null && ((OrderingList)remainderOrdering).size() > 0) {
                executor = new SortedQueryExecutor(new SortedQueryExecutor.MergeSortSupport(), executor, sqlOrdering, remainderOrdering);
            }
            return executor;
        }

        private Filter<S> and(Filter<S> left, Filter<S> right) {
            if (left == null) {
                return right;
            }
            if (right == null) {
                return left;
            }
            return left.and(right);
        }

        private boolean usesDerivedProperty(Filter<S> filter) {
            Boolean result = (Boolean)filter.accept(new Visitor<S, Boolean, Object>(){

                @Override
                public Boolean visit(OrFilter<S> orFilter, Object param) {
                    Boolean result = (Boolean)orFilter.getLeftFilter().accept(this, param);
                    if (result != null && result.booleanValue()) {
                        return result;
                    }
                    return (Boolean)orFilter.getRightFilter().accept(this, param);
                }

                @Override
                public Boolean visit(AndFilter<S> andFilter, Object param) {
                    Boolean result = (Boolean)andFilter.getLeftFilter().accept(this, param);
                    if (result != null && result.booleanValue()) {
                        return result;
                    }
                    return (Boolean)andFilter.getRightFilter().accept(this, param);
                }

                @Override
                public Boolean visit(PropertyFilter<S> propFilter, Object param) {
                    return propFilter.getChainedProperty().isDerived();
                }
            }, null);
            return result != null && result != false;
        }
    }

    public static interface InstanceFactory {
        public Storable instantiate(JDBCSupport var1);

        public Storable instantiate(JDBCSupport var1, ResultSet var2, int var3) throws SQLException;
    }
}

