/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.jdbc;

import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.OptimisticLockException;
import com.amazon.carbonado.PersistException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.SupportException;
import com.amazon.carbonado.gen.CodeBuilderUtil;
import com.amazon.carbonado.gen.MasterFeature;
import com.amazon.carbonado.gen.MasterStorableGenerator;
import com.amazon.carbonado.gen.MasterSupport;
import com.amazon.carbonado.gen.TriggerSupport;
import com.amazon.carbonado.info.StorablePropertyAdapter;
import com.amazon.carbonado.lob.Clob;
import com.amazon.carbonado.lob.Lob;
import com.amazon.carbonado.repo.jdbc.JDBCBlobLoader;
import com.amazon.carbonado.repo.jdbc.JDBCClobLoader;
import com.amazon.carbonado.repo.jdbc.JDBCConnectionCapability;
import com.amazon.carbonado.repo.jdbc.JDBCStorableInfo;
import com.amazon.carbonado.repo.jdbc.JDBCStorableProperty;
import com.amazon.carbonado.repo.jdbc.JDBCSupport;
import com.amazon.carbonado.util.SoftValuedCache;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.Map;
import org.cojen.classfile.ClassFile;
import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.Label;
import org.cojen.classfile.LocalVariable;
import org.cojen.classfile.Location;
import org.cojen.classfile.MethodInfo;
import org.cojen.classfile.Modifiers;
import org.cojen.classfile.TypeDesc;
import org.cojen.util.ClassInjector;
import org.cojen.util.KeyFactory;
import org.joda.time.ReadableInstant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JDBCStorableGenerator<S extends Storable> {
    private static final String EXTRACT_ALL_METHOD_NAME = "extractAll$";
    private static final String EXTRACT_DATA_METHOD_NAME = "extractData$";
    private static final String LOB_LOADER_FIELD_PREFIX = "lobLoader$";
    private static final int INITIAL_UPDATE_BUFFER_SIZE = 100;
    private static final int NORMAL = 0;
    private static final int NOT_NULL = 1;
    private static final int INITIAL_VERSION = 2;
    private static final int INCREMENT_VERSION = 3;
    private static final SoftValuedCache<Object, Class<? extends Storable>> cCache = SoftValuedCache.newCache(11);
    private final Class<S> mStorableType;
    private final JDBCStorableInfo<S> mInfo;
    private final Versioning mVersioning;
    private final boolean mSuppressReload;
    private final Map<String, ? extends JDBCStorableProperty<S>> mAllProperties;
    private final ClassLoader mParentClassLoader;
    private final ClassInjector mClassInjector;
    private final ClassFile mClassFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <S extends Storable> Class<? extends S> getGeneratedClass(JDBCStorableInfo<S> info, boolean isMaster, boolean autoVersioning, boolean suppressReload) throws SupportException {
        Object key = KeyFactory.createKey((Object[])new Object[]{info, isMaster, autoVersioning, suppressReload});
        SoftValuedCache<Object, Class<? extends Storable>> softValuedCache = cCache;
        synchronized (softValuedCache) {
            Class generatedClass = cCache.get(key);
            if (generatedClass != null) {
                return generatedClass;
            }
            generatedClass = super.generateAndInjectClass();
            cCache.put(key, generatedClass);
            return generatedClass;
        }
    }

    private JDBCStorableGenerator(JDBCStorableInfo<S> info, boolean isMaster, boolean autoVersioning, boolean suppressReload) throws SupportException {
        EnumSet<MasterFeature> features;
        block8: {
            this.mStorableType = info.getStorableType();
            this.mInfo = info;
            this.mAllProperties = this.mInfo.getAllProperties();
            features = EnumSet.of(MasterFeature.INSERT_TXN, MasterFeature.UPDATE_TXN);
            if (!isMaster) {
                this.mVersioning = Versioning.NONE;
            } else {
                features.add(MasterFeature.INSERT_SEQUENCES);
                features.add(MasterFeature.INSERT_CHECK_REQUIRED);
                if (info.getVersionProperty() != null && info.getVersionProperty().isDerived()) {
                    features.add(MasterFeature.VERSIONING);
                    this.mVersioning = Versioning.NONE;
                } else {
                    Versioning versioning = this.mVersioning = autoVersioning ? Versioning.AUTO : Versioning.EXTERNAL;
                }
            }
            if (suppressReload) {
                Map<String, JDBCStorableProperty<S>> identityProperties = info.getIdentityProperties();
                for (JDBCStorableProperty<S> prop : this.mAllProperties.values()) {
                    if (!prop.isSelectable()) continue;
                    if (prop.isAutomatic() && !identityProperties.containsKey(prop.getName())) {
                        suppressReload = false;
                    } else {
                        if (!prop.isVersion() || this.mVersioning != Versioning.EXTERNAL) continue;
                        suppressReload = false;
                    }
                    break block8;
                }
                features.remove((Object)MasterFeature.INSERT_TXN);
                features.remove((Object)MasterFeature.UPDATE_TXN);
            }
        }
        this.mSuppressReload = suppressReload;
        Class<S> abstractClass = MasterStorableGenerator.getAbstractClass(this.mStorableType, features);
        this.mParentClassLoader = abstractClass.getClassLoader();
        this.mClassInjector = ClassInjector.create((String)this.mStorableType.getName(), (ClassLoader)this.mParentClassLoader);
        this.mClassFile = new ClassFile(this.mClassInjector.getClassName(), abstractClass);
        this.mClassFile.markSynthetic();
        this.mClassFile.setSourceFile(JDBCStorableGenerator.class.getName());
        this.mClassFile.setTarget("1.5");
    }

    private Class<? extends S> generateAndInjectClass() throws SupportException {
        CodeBuilder b;
        MethodInfo mi;
        Map<JDBCStorableProperty<S>, Class<?>> lobLoaderMap = this.generateLobLoaders();
        TypeDesc jdbcSupportType = TypeDesc.forClass(JDBCSupport.class);
        TypeDesc resultSetType = TypeDesc.forClass(ResultSet.class);
        TypeDesc connectionType = TypeDesc.forClass(Connection.class);
        TypeDesc preparedStatementType = TypeDesc.forClass(PreparedStatement.class);
        TypeDesc lobArrayType = TypeDesc.forClass(Lob.class).toArrayType();
        TypeDesc masterSupportType = TypeDesc.forClass(MasterSupport.class);
        TypeDesc classType = TypeDesc.forClass(Class.class);
        if (lobLoaderMap.size() > 0) {
            mi = this.mClassFile.addInitializer();
            b = new CodeBuilder(mi);
            int i = 0;
            for (Class<?> clazz : lobLoaderMap.values()) {
                String fieldName = LOB_LOADER_FIELD_PREFIX + i;
                this.mClassFile.addField(Modifiers.PRIVATE.toStatic(true).toFinal(true), fieldName, classType);
                b.loadConstant(TypeDesc.forClass(clazz));
                b.storeStaticField(fieldName, classType);
                ++i;
            }
            b.returnVoid();
        }
        TypeDesc[] params = new TypeDesc[]{jdbcSupportType};
        MethodInfo mi2 = this.mClassFile.addConstructor(Modifiers.PUBLIC, params);
        CodeBuilder b2 = new CodeBuilder(mi2);
        b2.loadThis();
        b2.loadLocal(b2.getParameter(0));
        b2.checkCast(masterSupportType);
        b2.invokeSuperConstructor(new TypeDesc[]{masterSupportType});
        b2.returnVoid();
        params = new TypeDesc[]{jdbcSupportType, resultSetType, TypeDesc.INT};
        MethodInfo mi3 = this.mClassFile.addConstructor(Modifiers.PUBLIC, params);
        CodeBuilder b3 = new CodeBuilder(mi3);
        b3.loadThis();
        b3.loadLocal(b3.getParameter(0));
        b3.checkCast(masterSupportType);
        b3.invokeSuperConstructor(new TypeDesc[]{masterSupportType});
        b3.loadThis();
        b3.loadLocal(b3.getParameter(1));
        b3.loadLocal(b3.getParameter(2));
        b3.invokePrivate(EXTRACT_ALL_METHOD_NAME, null, new TypeDesc[]{resultSetType, TypeDesc.INT});
        b3.loadThis();
        b3.invokeVirtual("loadCompleted$", null, null);
        b3.returnVoid();
        CodeBuilderUtil.definePrepareMethod(this.mClassFile, this.mStorableType, jdbcSupportType);
        this.defineExtractAllMethod(lobLoaderMap);
        this.defineExtractDataMethod(lobLoaderMap);
        for (JDBCStorableProperty<S> property : this.mAllProperties.values()) {
            if (property.isDerived() || property.isJoin() || property.isSupported()) continue;
            Class<UnsupportedOperationException> exClass = UnsupportedOperationException.class;
            String string = "Independent property \"" + property.getName() + "\" is not supported by the SQL schema: ";
            if (property.isNullable()) {
                b3 = new CodeBuilder(this.mClassFile.addMethod(property.getReadMethod()));
                b3.loadNull();
                b3.returnValue(TypeDesc.OBJECT);
                b3 = new CodeBuilder(this.mClassFile.addMethod(property.getWriteMethod()));
                b3.loadLocal(b3.getParameter(0));
                Label notNull = b3.createLabel();
                b3.ifNullBranch((Location)notNull, false);
                b3.returnVoid();
                notNull.setLocation();
                CodeBuilderUtil.throwException(b3, exClass, string);
                continue;
            }
            String string2 = string + this.mInfo.getTableName();
            b3 = new CodeBuilder(this.mClassFile.addMethod(property.getReadMethod()));
            CodeBuilderUtil.throwException(b3, exClass, string2);
            b3 = new CodeBuilder(this.mClassFile.addMethod(property.getWriteMethod()));
            CodeBuilderUtil.throwException(b3, exClass, string2);
        }
        mi = this.mClassFile.addMethod(Modifiers.PROTECTED, "doTryLoad$", TypeDesc.BOOLEAN, null);
        mi.addException(TypeDesc.forClass(FetchException.class));
        b = new CodeBuilder(mi);
        LocalVariable supportVar = this.getJDBCSupport(b);
        Label tryBeforeCon = b.createLabel().setLocation();
        LocalVariable localVariable = this.getConnection(b, supportVar);
        Label tryAfterCon = b.createLabel().setLocation();
        b.loadThis();
        b.loadLocal(supportVar);
        b.loadLocal(localVariable);
        b.loadNull();
        b.invokeVirtual("doTryLoad$", TypeDesc.BOOLEAN, new TypeDesc[]{jdbcSupportType, connectionType, lobArrayType});
        LocalVariable resultVar = b.createLocalVariable("result", TypeDesc.BOOLEAN);
        b.storeLocal(resultVar);
        this.yieldConAndHandleException(b, supportVar, tryBeforeCon, localVariable, tryAfterCon, false);
        b.loadLocal(resultVar);
        b.returnValue(TypeDesc.BOOLEAN);
        mi = this.mClassFile.addMethod(Modifiers.PROTECTED, "doTryLoad$", TypeDesc.BOOLEAN, new TypeDesc[]{jdbcSupportType, connectionType, lobArrayType});
        mi.addException(TypeDesc.forClass(Exception.class));
        b = new CodeBuilder(mi);
        StringBuilder selectBuilder = null;
        for (JDBCStorableProperty jDBCStorableProperty : this.mAllProperties.values()) {
            if (!jDBCStorableProperty.isSelectable() || jDBCStorableProperty.isPrimaryKeyMember()) continue;
            if (selectBuilder == null) {
                selectBuilder = new StringBuilder();
                selectBuilder.append("SELECT ");
            } else {
                selectBuilder.append(',');
            }
            selectBuilder.append(jDBCStorableProperty.getColumnName());
        }
        if (selectBuilder == null) {
            selectBuilder = new StringBuilder();
            selectBuilder.append("SELECT ");
            selectBuilder.append(this.mInfo.getPrimaryKeyProperties().values().iterator().next().getColumnName());
        }
        selectBuilder.append(" FROM ");
        selectBuilder.append(this.mInfo.getQualifiedTableName());
        LocalVariable psVar = b.createLocalVariable("ps", preparedStatementType);
        Label label = this.buildWhereClauseAndPreparedStatement(b, selectBuilder, b.getParameter(1), psVar, b.getParameter(0), null);
        b.loadLocal(psVar);
        b.invokeInterface(preparedStatementType, "executeQuery", resultSetType, null);
        LocalVariable rsVar = b.createLocalVariable("rs", resultSetType);
        b.storeLocal(rsVar);
        Label tryAfterRs = b.createLabel().setLocation();
        LocalVariable resultVar2 = b.createLocalVariable("result", TypeDesc.BOOLEAN);
        b.loadLocal(rsVar);
        b.invokeInterface(resultSetType, "next", TypeDesc.BOOLEAN, null);
        b.storeLocal(resultVar2);
        b.loadLocal(resultVar2);
        Label noResults = b.createLabel();
        b.ifZeroComparisonBranch((Location)noResults, "==");
        b.loadThis();
        b.loadLocal(rsVar);
        b.loadConstant(1);
        b.loadLocal(b.getParameter(2));
        b.invokePrivate(EXTRACT_DATA_METHOD_NAME, null, new TypeDesc[]{resultSetType, TypeDesc.INT, lobArrayType});
        noResults.setLocation();
        this.closeResultSet(b, rsVar, tryAfterRs);
        this.closeStatement(b, psVar, label);
        b.loadLocal(resultVar2);
        b.returnValue(TypeDesc.BOOLEAN);
        mi = this.mClassFile.addMethod(Modifiers.PUBLIC, "insert", null, null);
        mi.addException(TypeDesc.forClass(PersistException.class));
        b = new CodeBuilder(mi);
        Label tryStart = b.createLabel().setLocation();
        b.loadThis();
        b.invokeSuper(this.mClassFile.getSuperClassName(), "insert", null, null);
        Label tryEnd = b.createLabel().setLocation();
        b.returnVoid();
        b.exceptionHandler((Location)tryStart, (Location)tryEnd, RuntimeException.class.getName());
        b.throwObject();
        b.exceptionHandler((Location)tryStart, (Location)tryEnd, Exception.class.getName());
        this.pushJDBCSupport(b);
        b.swap();
        TypeDesc[] typeDescArray = new TypeDesc[]{TypeDesc.forClass(Throwable.class)};
        b.invokeInterface(jdbcSupportType, "toPersistException", TypeDesc.forClass(PersistException.class), typeDescArray);
        b.throwObject();
        mi = this.mClassFile.addMethod(Modifiers.PUBLIC, "tryInsert", TypeDesc.BOOLEAN, null);
        mi.addException(TypeDesc.forClass(PersistException.class));
        b = new CodeBuilder(mi);
        tryStart = b.createLabel().setLocation();
        b.loadThis();
        b.invokeSuper(this.mClassFile.getSuperClassName(), "tryInsert", TypeDesc.BOOLEAN, null);
        Label innerTryEnd = b.createLabel().setLocation();
        b.returnValue(TypeDesc.BOOLEAN);
        b.exceptionHandler((Location)tryStart, (Location)innerTryEnd, SQLException.class.getName());
        b.dup();
        this.pushJDBCSupport(b);
        b.swap();
        b.invokeInterface(jdbcSupportType, "isUniqueConstraintError", TypeDesc.BOOLEAN, new TypeDesc[]{TypeDesc.forClass(SQLException.class)});
        Label label2 = b.createLabel();
        b.ifZeroComparisonBranch((Location)label2, "==");
        b.loadConstant(false);
        b.returnValue(TypeDesc.BOOLEAN);
        label2.setLocation();
        b.throwObject();
        Label outerTryEnd = b.createLabel().setLocation();
        b.exceptionHandler((Location)tryStart, (Location)outerTryEnd, RuntimeException.class.getName());
        b.throwObject();
        b.exceptionHandler((Location)tryStart, (Location)outerTryEnd, Exception.class.getName());
        this.pushJDBCSupport(b);
        b.swap();
        TypeDesc[] params3 = new TypeDesc[]{TypeDesc.forClass(Throwable.class)};
        b.invokeInterface(jdbcSupportType, "toPersistException", TypeDesc.forClass(PersistException.class), params3);
        b.throwObject();
        mi = this.mClassFile.addMethod(Modifiers.PROTECTED, "doTryInsert$master", TypeDesc.BOOLEAN, null);
        mi.addException(TypeDesc.forClass(PersistException.class));
        b = new CodeBuilder(mi);
        supportVar = this.getJDBCSupport(b);
        LocalVariable conVar2 = this.getConnection(b, supportVar);
        Label label3 = b.createLabel().setLocation();
        b.loadLocal(conVar2);
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO ");
        sb.append(this.mInfo.getQualifiedTableName());
        sb.append(" ( ");
        int ordinal = 0;
        for (JDBCStorableProperty<S> property : this.mAllProperties.values()) {
            if (!property.isSelectable()) continue;
            if (ordinal > 0) {
                sb.append(',');
            }
            sb.append(property.getColumnName());
            ++ordinal;
        }
        sb.append(" ) VALUES (");
        for (int i = 0; i < ordinal; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append('?');
        }
        sb.append(')');
        String staticInsertStatement = sb.toString();
        boolean useStaticInsertStatement = true;
        for (JDBCStorableProperty<S> property : this.mAllProperties.values()) {
            if (property.isDerived() || !property.isVersion() && !property.isAutomatic()) continue;
            useStaticInsertStatement = false;
            break;
        }
        LocalVariable insertCountVar = null;
        if (useStaticInsertStatement) {
            b.loadConstant(staticInsertStatement);
        } else {
            insertCountVar = b.createLocalVariable(null, TypeDesc.INT);
            int initialCount = 0;
            for (JDBCStorableProperty<S> property : this.mAllProperties.values()) {
                if (!property.isSelectable() || !this.isAlwaysInserted(property)) continue;
                ++initialCount;
            }
            b.loadConstant(initialCount);
            b.storeLocal(insertCountVar);
            TypeDesc stringBuilderType = TypeDesc.forClass(StringBuilder.class);
            b.newObject(stringBuilderType);
            b.dup();
            b.loadConstant(staticInsertStatement.length());
            b.invokeConstructor(stringBuilderType, new TypeDesc[]{TypeDesc.INT});
            b.loadConstant("INSERT INTO " + this.mInfo.getQualifiedTableName() + " ( ");
            CodeBuilderUtil.callStringBuilderAppendString(b);
            int propNumber = -1;
            for (JDBCStorableProperty<S> property : this.mAllProperties.values()) {
                ++propNumber;
                if (!property.isSelectable()) continue;
                Label nextProperty = b.createLabel();
                if (!this.isAlwaysInserted(property)) {
                    this.branchIfDirty(b, propNumber, nextProperty, false);
                    b.integerIncrement(insertCountVar, 1);
                }
                b.loadConstant(property.getColumnName() + ',');
                CodeBuilderUtil.callStringBuilderAppendString(b);
                nextProperty.setLocation();
            }
            LocalVariable sbVar = b.createLocalVariable(null, stringBuilderType);
            b.storeLocal(sbVar);
            b.loadLocal(sbVar);
            b.loadLocal(sbVar);
            CodeBuilderUtil.callStringBuilderLength(b);
            b.loadConstant(1);
            b.math((byte)100);
            CodeBuilderUtil.callStringBuilderSetLength(b);
            b.loadLocal(sbVar);
            b.loadConstant(" ) VALUES (");
            CodeBuilderUtil.callStringBuilderAppendString(b);
            b.loadLocal(insertCountVar);
            Label finishStatement = b.createLabel();
            b.ifZeroComparisonBranch((Location)finishStatement, "<=");
            b.loadConstant(63);
            CodeBuilderUtil.callStringBuilderAppendChar(b);
            Label loopStart = b.createLabel().setLocation();
            b.integerIncrement(insertCountVar, -1);
            b.loadLocal(insertCountVar);
            b.ifZeroComparisonBranch((Location)finishStatement, "<=");
            b.loadConstant(",?");
            CodeBuilderUtil.callStringBuilderAppendString(b);
            b.branch((Location)loopStart);
            finishStatement.setLocation();
            b.loadConstant(41);
            CodeBuilderUtil.callStringBuilderAppendChar(b);
            CodeBuilderUtil.callStringBuilderToString(b);
        }
        Collection<JDBCStorableProperty<S>> identityProperties = this.mInfo.getIdentityProperties().values();
        LocalVariable psVar2 = b.createLocalVariable("ps", preparedStatementType);
        if (identityProperties.size() == 0) {
            b.invokeInterface(connectionType, "prepareStatement", preparedStatementType, new TypeDesc[]{TypeDesc.STRING});
        } else {
            b.loadConstant(1);
            b.invokeInterface(connectionType, "prepareStatement", preparedStatementType, new TypeDesc[]{TypeDesc.STRING, TypeDesc.INT});
        }
        b.storeLocal(psVar2);
        Label tryAfterPs2 = b.createLabel().setLocation();
        Map<JDBCStorableProperty<S>, Integer> lobIndexMap = this.findLobs();
        LocalVariable lobArrayVar = null;
        if (lobIndexMap.size() != 0) {
            lobArrayVar = b.createLocalVariable(null, lobArrayType);
            b.loadConstant(lobIndexMap.size());
            b.newObject(lobArrayType);
            b.storeLocal(lobArrayVar);
        }
        int ordinal2 = 0;
        LocalVariable ordinalVar = null;
        if (!useStaticInsertStatement) {
            ordinalVar = b.createLocalVariable(null, TypeDesc.INT);
            b.loadConstant(0);
            b.storeLocal(ordinalVar);
        }
        int propNumber = -1;
        for (JDBCStorableProperty<S> property : this.mAllProperties.values()) {
            ++propNumber;
            if (!property.isSelectable()) continue;
            Label nextProperty = b.createLabel();
            if (!this.isAlwaysInserted(property)) {
                this.branchIfDirty(b, propNumber, nextProperty, false);
            }
            b.loadLocal(psVar2);
            if (ordinalVar == null) {
                b.loadConstant(++ordinal2);
            } else {
                b.integerIncrement(ordinalVar, 1);
                b.loadLocal(ordinalVar);
            }
            Label setNormally = b.createLabel();
            if (property.isVersion() && this.mVersioning == Versioning.AUTO) {
                this.branchIfDirty(b, propNumber, setNormally, true);
                this.setPreparedStatementValue(b, property, 2, null, lobArrayVar, lobIndexMap.get(property));
                b.branch((Location)nextProperty);
            }
            setNormally.setLocation();
            this.setPreparedStatementValue(b, property, 0, null, lobArrayVar, lobIndexMap.get(property));
            nextProperty.setLocation();
        }
        b.loadLocal(psVar2);
        b.invokeInterface(preparedStatementType, "executeUpdate", TypeDesc.INT, null);
        b.pop();
        if (identityProperties.size() > 0) {
            b.loadLocal(psVar2);
            b.invokeInterface(preparedStatementType, "getGeneratedKeys", resultSetType, null);
            LocalVariable rsVar2 = b.createLocalVariable("rs", resultSetType);
            b.storeLocal(rsVar2);
            Label tryAfterRs2 = b.createLabel().setLocation();
            b.loadLocal(rsVar2);
            b.invokeInterface(resultSetType, "next", TypeDesc.BOOLEAN, null);
            Label noResults2 = b.createLabel();
            b.ifZeroComparisonBranch((Location)noResults2, "==");
            LocalVariable initialOffsetVar = b.createLocalVariable(null, TypeDesc.INT);
            b.loadConstant(1);
            b.storeLocal(initialOffsetVar);
            this.defineExtract(b, rsVar2, initialOffsetVar, null, this.mInfo.getIdentityProperties().values(), lobLoaderMap);
            noResults2.setLocation();
            this.closeResultSet(b, rsVar2, tryAfterRs2);
        }
        this.closeStatement(b, psVar2, tryAfterPs2);
        if (!this.mSuppressReload) {
            b.loadThis();
            b.loadLocal(supportVar);
            b.loadLocal(conVar2);
            if (lobArrayVar == null) {
                b.loadNull();
            } else {
                b.loadLocal(lobArrayVar);
            }
            b.invokeVirtual("doTryLoad$", TypeDesc.BOOLEAN, new TypeDesc[]{jdbcSupportType, connectionType, lobArrayType});
            Label reloaded = b.createLabel();
            b.ifZeroComparisonBranch((Location)reloaded, "!=");
            String message = "Reload after insert failed, possibly because database changed the primary key: ";
            for (JDBCStorableProperty<S> prop : this.mInfo.getPrimaryKeyProperties().values()) {
                Class<?> type = prop.getType();
                if (!Date.class.isAssignableFrom(type) && !ReadableInstant.class.isAssignableFrom(type)) continue;
                message = message + "Property type of date may have been truncated: " + prop.getName() + ": ";
            }
            TypeDesc persistExType = TypeDesc.forClass(PersistException.class);
            b.newObject(persistExType);
            b.dup();
            b.loadConstant(message);
            b.loadThis();
            b.invokeVirtual("toStringKeyOnly", TypeDesc.STRING, null);
            b.invokeVirtual(TypeDesc.STRING, "concat", TypeDesc.STRING, new TypeDesc[]{TypeDesc.STRING});
            b.invokeConstructor(persistExType, new TypeDesc[]{TypeDesc.STRING});
            b.throwObject();
            reloaded.setLocation();
        }
        this.yieldCon(b, supportVar, conVar2, label3);
        b.loadConstant(true);
        b.returnValue(TypeDesc.BOOLEAN);
        mi = this.mClassFile.addMethod(Modifiers.PROTECTED, "doTryUpdate$master", TypeDesc.BOOLEAN, null);
        mi.addException(TypeDesc.forClass(PersistException.class));
        b = new CodeBuilder(mi);
        supportVar = this.getJDBCSupport(b);
        tryBeforeCon = b.createLabel().setLocation();
        LocalVariable localVariable2 = this.getConnection(b, supportVar);
        tryAfterCon = b.createLabel().setLocation();
        b.loadLocal(localVariable2);
        TypeDesc stringBuilderType = TypeDesc.forClass(StringBuilder.class);
        b.newObject(stringBuilderType);
        b.dup();
        b.loadConstant(100);
        b.invokeConstructor(stringBuilderType, new TypeDesc[]{TypeDesc.INT});
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("UPDATE ");
        sqlBuilder.append(this.mInfo.getQualifiedTableName());
        sqlBuilder.append(" SET ");
        b.loadConstant(sqlBuilder.toString());
        CodeBuilderUtil.callStringBuilderAppendString(b);
        LocalVariable countVar = b.createLocalVariable("count", TypeDesc.INT);
        b.loadConstant(0);
        b.storeLocal(countVar);
        int propNumber2 = -1;
        for (JDBCStorableProperty<S> property : this.mAllProperties.values()) {
            ++propNumber2;
            if (!property.isSelectable() || property.isPrimaryKeyMember() || property.isVersion() && this.mVersioning == Versioning.EXTERNAL) continue;
            Label isNotDirty = null;
            if (!property.isVersion() || this.mVersioning != Versioning.AUTO) {
                isNotDirty = b.createLabel();
                this.branchIfDirty(b, propNumber2, isNotDirty, false);
            }
            b.loadLocal(countVar);
            Label isZero = b.createLabel();
            b.ifZeroComparisonBranch((Location)isZero, "==");
            b.loadConstant(44);
            CodeBuilderUtil.callStringBuilderAppendChar(b);
            isZero.setLocation();
            b.loadConstant(property.getColumnName());
            CodeBuilderUtil.callStringBuilderAppendString(b);
            b.loadConstant("=?");
            CodeBuilderUtil.callStringBuilderAppendString(b);
            b.integerIncrement(countVar, 1);
            if (isNotDirty == null) continue;
            isNotDirty.setLocation();
        }
        Collection<JDBCStorableProperty<S>> whereProperties = this.mInfo.getPrimaryKeyProperties().values();
        JDBCStorableProperty<S> versionProperty = this.mInfo.getVersionProperty();
        if (versionProperty != null) {
            if (!versionProperty.isSelectable() || this.mVersioning == Versioning.NONE) {
                versionProperty = null;
            } else {
                ArrayList<JDBCStorableProperty<S>> list = new ArrayList<JDBCStorableProperty<S>>(whereProperties);
                list.add(versionProperty);
                whereProperties = list;
            }
        }
        b.loadLocal(countVar);
        Label notZero = b.createLabel();
        b.ifZeroComparisonBranch((Location)notZero, "!=");
        b.loadConstant(whereProperties.iterator().next().getColumnName());
        CodeBuilderUtil.callStringBuilderAppendString(b);
        b.loadConstant("=?");
        CodeBuilderUtil.callStringBuilderAppendString(b);
        notZero.setLocation();
        b.loadConstant(" WHERE ");
        CodeBuilderUtil.callStringBuilderAppendString(b);
        int ordinal3 = 0;
        for (JDBCStorableProperty<S> property : whereProperties) {
            if (ordinal3 > 0) {
                b.loadConstant(" AND ");
                CodeBuilderUtil.callStringBuilderAppendString(b);
            }
            b.loadConstant(property.getColumnName());
            CodeBuilderUtil.callStringBuilderAppendString(b);
            Label next = b.createLabel();
            if (property.isNullable()) {
                b.loadThis();
                b.loadField(property.getName(), TypeDesc.forClass(property.getType()));
                Label notNull = b.createLabel();
                b.ifNullBranch((Location)notNull, false);
                b.loadConstant(" IS NULL");
                CodeBuilderUtil.callStringBuilderAppendString(b);
                b.branch((Location)next);
                notNull.setLocation();
            }
            b.loadConstant("=?");
            CodeBuilderUtil.callStringBuilderAppendString(b);
            next.setLocation();
            ++ordinal3;
        }
        CodeBuilderUtil.callStringBuilderToString(b);
        LocalVariable psVar3 = b.createLocalVariable("ps", preparedStatementType);
        b.invokeInterface(connectionType, "prepareStatement", preparedStatementType, new TypeDesc[]{TypeDesc.STRING});
        b.storeLocal(psVar3);
        Label tryAfterPs3 = b.createLabel().setLocation();
        LocalVariable indexVar = b.createLocalVariable("index", TypeDesc.INT);
        b.loadConstant(1);
        b.storeLocal(indexVar);
        Map<JDBCStorableProperty<S>, Integer> lobIndexMap2 = this.findLobs();
        LocalVariable lobArrayVar2 = null;
        if (lobIndexMap2.size() != 0) {
            lobArrayVar2 = b.createLocalVariable(null, lobArrayType);
            b.loadConstant(lobIndexMap2.size());
            b.newObject(lobArrayType);
            b.storeLocal(lobArrayVar2);
        }
        b.loadLocal(countVar);
        Label notZero2 = b.createLabel();
        b.ifZeroComparisonBranch((Location)notZero2, "!=");
        JDBCStorableProperty<S> property2 = whereProperties.iterator().next();
        b.loadLocal(psVar3);
        b.loadLocal(indexVar);
        this.setPreparedStatementValue(b, property2, 0, null, lobArrayVar2, lobIndexMap2.get(property2));
        b.integerIncrement(indexVar, 1);
        notZero2.setLocation();
        propNumber2 = -1;
        for (JDBCStorableProperty<S> property : this.mAllProperties.values()) {
            ++propNumber2;
            if (!property.isSelectable() || property.isPrimaryKeyMember() || property.isVersion() && this.mVersioning == Versioning.EXTERNAL) continue;
            Label isNotDirty = null;
            if (!property.isVersion() || this.mVersioning != Versioning.AUTO) {
                isNotDirty = b.createLabel();
                this.branchIfDirty(b, propNumber2, isNotDirty, false);
            }
            b.loadLocal(psVar3);
            b.loadLocal(indexVar);
            int mode = property.isVersion() && this.mVersioning == Versioning.AUTO ? 3 : 0;
            this.setPreparedStatementValue(b, property, mode, null, lobArrayVar2, lobIndexMap2.get(property));
            b.integerIncrement(indexVar, 1);
            if (isNotDirty == null) continue;
            isNotDirty.setLocation();
        }
        for (JDBCStorableProperty<S> property : whereProperties) {
            Label nextProperty = b.createLabel();
            if (property.isNullable()) {
                b.loadThis();
                b.loadField(property.getName(), TypeDesc.forClass(property.getType()));
                b.ifNullBranch((Location)nextProperty, true);
            }
            b.loadLocal(psVar3);
            b.loadLocal(indexVar);
            this.setPreparedStatementValue(b, property, 1, null, null, null);
            b.integerIncrement(indexVar, 1);
            nextProperty.setLocation();
        }
        b.loadLocal(psVar3);
        LocalVariable updateCount = b.createLocalVariable("updateCount", TypeDesc.INT);
        b.invokeInterface(preparedStatementType, "executeUpdate", TypeDesc.INT, null);
        b.storeLocal(updateCount);
        this.closeStatement(b, psVar3, tryAfterPs3);
        Label doReload = b.createLabel();
        Label skipReload = b.createLabel();
        if (versionProperty == null) {
            b.loadLocal(updateCount);
            b.ifZeroComparisonBranch((Location)skipReload, "==");
        } else {
            b.loadLocal(updateCount);
            b.ifZeroComparisonBranch((Location)doReload, "!=");
            StringBuilder selectBuilder2 = new StringBuilder();
            selectBuilder2.append("SELECT ");
            selectBuilder2.append(versionProperty.getColumnName());
            selectBuilder2.append(" FROM ");
            selectBuilder2.append(this.mInfo.getQualifiedTableName());
            LocalVariable countPsVar = b.createLocalVariable("ps", preparedStatementType);
            Label tryAfterCountPs = this.buildWhereClauseAndPreparedStatement(b, selectBuilder2, localVariable2, countPsVar, null, null);
            b.loadLocal(countPsVar);
            b.invokeInterface(preparedStatementType, "executeQuery", resultSetType, null);
            LocalVariable rsVar3 = b.createLocalVariable("rs", resultSetType);
            b.storeLocal(rsVar3);
            Label tryAfterRs3 = b.createLabel().setLocation();
            b.loadLocal(rsVar3);
            b.invokeInterface(resultSetType, "next", TypeDesc.BOOLEAN, null);
            b.ifZeroComparisonBranch((Location)skipReload, "==");
            b.loadLocal(rsVar3);
            b.loadConstant(1);
            b.invokeInterface(resultSetType, "getLong", TypeDesc.LONG, new TypeDesc[]{TypeDesc.INT});
            LocalVariable actualVersion = b.createLocalVariable(null, TypeDesc.LONG);
            b.storeLocal(actualVersion);
            this.closeResultSet(b, rsVar3, tryAfterRs3);
            this.closeStatement(b, countPsVar, tryAfterCountPs);
            TypeDesc desc = TypeDesc.forClass(OptimisticLockException.class);
            b.newObject(desc);
            b.dup();
            b.loadThis();
            TypeDesc propertyType = TypeDesc.forClass(versionProperty.getType());
            b.loadField(versionProperty.getName(), propertyType);
            b.convert(propertyType, TypeDesc.LONG.toObjectType());
            b.loadLocal(actualVersion);
            b.convert(TypeDesc.LONG, TypeDesc.LONG.toObjectType());
            b.invokeConstructor(desc, new TypeDesc[]{TypeDesc.OBJECT, TypeDesc.OBJECT});
            b.throwObject();
        }
        doReload.setLocation();
        if (!this.mSuppressReload) {
            b.loadThis();
            b.loadLocal(supportVar);
            b.loadLocal(localVariable2);
            if (lobArrayVar2 == null) {
                b.loadNull();
            } else {
                b.loadLocal(lobArrayVar2);
            }
            b.invokeVirtual("doTryLoad$", TypeDesc.BOOLEAN, new TypeDesc[]{jdbcSupportType, connectionType, lobArrayType});
            b.storeLocal(updateCount);
        }
        skipReload.setLocation();
        this.yieldConAndHandleException(b, supportVar, tryBeforeCon, localVariable2, tryAfterCon, true);
        b.loadLocal(updateCount);
        b.returnValue(TypeDesc.BOOLEAN);
        mi = this.mClassFile.addMethod(Modifiers.PROTECTED, "doTryDelete$master", TypeDesc.BOOLEAN, null);
        mi.addException(TypeDesc.forClass(PersistException.class));
        b = new CodeBuilder(mi);
        StringBuilder deleteBuilder = new StringBuilder();
        deleteBuilder.append("DELETE FROM ");
        deleteBuilder.append(this.mInfo.getQualifiedTableName());
        LocalVariable supportVar2 = this.getJDBCSupport(b);
        Label label4 = b.createLabel().setLocation();
        LocalVariable conVar3 = this.getConnection(b, supportVar2);
        Label tryAfterCon3 = b.createLabel().setLocation();
        LocalVariable psVar4 = b.createLocalVariable("ps", preparedStatementType);
        Label tryAfterPs4 = this.buildWhereClauseAndPreparedStatement(b, deleteBuilder, conVar3, psVar4, null, null);
        b.loadLocal(psVar4);
        b.invokeInterface(preparedStatementType, "executeUpdate", TypeDesc.INT, null);
        LocalVariable resultVar3 = b.createLocalVariable("result", TypeDesc.INT);
        b.storeLocal(resultVar3);
        this.closeStatement(b, psVar4, tryAfterPs4);
        this.yieldConAndHandleException(b, supportVar2, label4, conVar3, tryAfterCon3, true);
        b.loadLocal(resultVar3);
        b.returnValue(TypeDesc.BOOLEAN);
        Class generatedClass = this.mClassInjector.defineClass(this.mClassFile);
        lobLoaderMap.size();
        return generatedClass;
    }

    private boolean isAlwaysInserted(JDBCStorableProperty<?> property) {
        return property.isVersion() ? this.mVersioning == Versioning.AUTO : !property.isAutomatic();
    }

    private Map<JDBCStorableProperty<S>, Integer> findLobs() {
        IdentityHashMap<JDBCStorableProperty<S>, Integer> lobIndexMap = new IdentityHashMap<JDBCStorableProperty<S>, Integer>();
        int lobIndex = 0;
        for (JDBCStorableProperty<S> property : this.mAllProperties.values()) {
            if (!property.isSelectable() || property.isVersion()) continue;
            Class<?> psClass = property.getPreparedStatementSetMethod().getParameterTypes()[1];
            if (!Lob.class.isAssignableFrom(property.getType()) && !Blob.class.isAssignableFrom(psClass) && !java.sql.Clob.class.isAssignableFrom(psClass)) continue;
            lobIndexMap.put(property, lobIndex++);
        }
        return lobIndexMap;
    }

    private LocalVariable getJDBCSupport(CodeBuilder b) {
        this.pushJDBCSupport(b);
        LocalVariable supportVar = b.createLocalVariable("support", TypeDesc.forClass(JDBCSupport.class));
        b.storeLocal(supportVar);
        return supportVar;
    }

    private void pushJDBCSupport(CodeBuilder b) {
        b.loadThis();
        b.loadField("support$", TypeDesc.forClass(TriggerSupport.class));
        b.checkCast(TypeDesc.forClass(JDBCSupport.class));
    }

    private LocalVariable getConnection(CodeBuilder b, LocalVariable capVar) {
        b.loadLocal(capVar);
        b.invokeInterface(TypeDesc.forClass(JDBCConnectionCapability.class), "getConnection", TypeDesc.forClass(Connection.class), null);
        LocalVariable conVar = b.createLocalVariable("con", TypeDesc.forClass(Connection.class));
        b.storeLocal(conVar);
        return conVar;
    }

    private void yieldConnection(CodeBuilder b, LocalVariable capVar, LocalVariable conVar) {
        if (conVar != null) {
            b.loadLocal(capVar);
            b.loadLocal(conVar);
            b.invokeInterface(TypeDesc.forClass(JDBCConnectionCapability.class), "yieldConnection", null, new TypeDesc[]{TypeDesc.forClass(Connection.class)});
        }
    }

    private Label buildWhereClauseAndPreparedStatement(CodeBuilder b, StringBuilder sqlBuilder, LocalVariable conVar, LocalVariable psVar, LocalVariable capVar, LocalVariable instanceVar) throws SupportException {
        TypeDesc superType = TypeDesc.forClass((String)this.mClassFile.getSuperClassName());
        Collection<JDBCStorableProperty<S>> properties = this.mInfo.getPrimaryKeyProperties().values();
        sqlBuilder.append(" WHERE ");
        ArrayList<JDBCStorableProperty> nullableProperties = new ArrayList<JDBCStorableProperty>();
        int ordinal = 0;
        for (JDBCStorableProperty jDBCStorableProperty : properties) {
            if (!jDBCStorableProperty.isSelectable()) continue;
            if (jDBCStorableProperty.isNullable()) {
                nullableProperties.add(jDBCStorableProperty);
                continue;
            }
            if (ordinal > 0) {
                sqlBuilder.append(" AND ");
            }
            sqlBuilder.append(jDBCStorableProperty.getColumnName());
            sqlBuilder.append("=?");
            ++ordinal;
        }
        b.loadLocal(conVar);
        if (nullableProperties.size() == 0) {
            b.loadConstant(sqlBuilder.toString());
            if (capVar != null) {
                b.loadLocal(capVar);
                b.invokeInterface(TypeDesc.forClass(JDBCConnectionCapability.class), "isTransactionForUpdate", TypeDesc.BOOLEAN, null);
                Label notForUpdate = b.createLabel();
                b.ifZeroComparisonBranch((Location)notForUpdate, "==");
                b.loadConstant(" FOR UPDATE");
                b.invokeVirtual(TypeDesc.STRING, "concat", TypeDesc.STRING, new TypeDesc[]{TypeDesc.STRING});
                notForUpdate.setLocation();
            }
        } else {
            if (ordinal > 0) {
                sqlBuilder.append(" AND ");
            }
            int capacity = sqlBuilder.length() + 7 * nullableProperties.size();
            if (nullableProperties.size() > 1) {
                capacity += 5 * (nullableProperties.size() - 1);
            }
            for (JDBCStorableProperty property : nullableProperties) {
                capacity += property.getColumnName().length();
            }
            TypeDesc typeDesc = TypeDesc.forClass(StringBuilder.class);
            b.newObject(typeDesc);
            b.dup();
            b.loadConstant(capacity);
            b.invokeConstructor(typeDesc, new TypeDesc[]{TypeDesc.INT});
            b.loadConstant(sqlBuilder.toString());
            CodeBuilderUtil.callStringBuilderAppendString(b);
            ordinal = 0;
            for (JDBCStorableProperty property : nullableProperties) {
                if (ordinal > 0) {
                    b.loadConstant(" AND ");
                    CodeBuilderUtil.callStringBuilderAppendString(b);
                }
                b.loadConstant(property.getColumnName());
                CodeBuilderUtil.callStringBuilderAppendString(b);
                b.loadThis();
                TypeDesc propertyType = TypeDesc.forClass(property.getType());
                b.loadField(superType, property.getName(), propertyType);
                Label notNull = b.createLabel();
                b.ifNullBranch((Location)notNull, false);
                b.loadConstant(" IS NULL");
                CodeBuilderUtil.callStringBuilderAppendString(b);
                Label label = b.createLabel();
                b.branch((Location)label);
                notNull.setLocation();
                b.loadConstant("=?");
                CodeBuilderUtil.callStringBuilderAppendString(b);
                label.setLocation();
                ++ordinal;
            }
            if (capVar != null) {
                b.loadLocal(capVar);
                b.invokeInterface(TypeDesc.forClass(JDBCConnectionCapability.class), "isTransactionForUpdate", TypeDesc.BOOLEAN, null);
                Label notForUpdate = b.createLabel();
                b.ifZeroComparisonBranch((Location)notForUpdate, "==");
                b.loadConstant(" FOR UPDATE");
                CodeBuilderUtil.callStringBuilderAppendString(b);
                notForUpdate.setLocation();
            }
            CodeBuilderUtil.callStringBuilderToString(b);
        }
        TypeDesc connectionType = TypeDesc.forClass(Connection.class);
        TypeDesc typeDesc = TypeDesc.forClass(PreparedStatement.class);
        b.invokeInterface(connectionType, "prepareStatement", typeDesc, new TypeDesc[]{TypeDesc.STRING});
        b.storeLocal(psVar);
        Label tryAfterPs = b.createLabel().setLocation();
        Label nextProperty = null;
        LocalVariable indexVar = null;
        ordinal = 0;
        for (JDBCStorableProperty jDBCStorableProperty : properties) {
            if (!jDBCStorableProperty.isSelectable()) continue;
            if (indexVar == null) {
                ++ordinal;
            } else {
                b.integerIncrement(indexVar, 1);
            }
            if (nextProperty != null) {
                nextProperty.setLocation();
                nextProperty = null;
            }
            nextProperty = b.createLabel();
            TypeDesc propertyType = TypeDesc.forClass(jDBCStorableProperty.getType());
            if (jDBCStorableProperty.isNullable()) {
                if (indexVar == null) {
                    indexVar = b.createLocalVariable(null, TypeDesc.INT);
                    b.loadConstant(ordinal);
                    b.storeLocal(indexVar);
                }
                b.loadThis();
                b.loadField(superType, jDBCStorableProperty.getName(), propertyType);
                b.ifNullBranch((Location)nextProperty, true);
            }
            b.loadLocal(psVar);
            if (indexVar == null) {
                b.loadConstant(ordinal);
            } else {
                b.loadLocal(indexVar);
            }
            this.setPreparedStatementValue(b, jDBCStorableProperty, 1, instanceVar, null, null);
        }
        if (nextProperty != null) {
            nextProperty.setLocation();
            nextProperty = null;
        }
        return tryAfterPs;
    }

    private void setPreparedStatementValue(CodeBuilder b, JDBCStorableProperty<?> property, int mode, LocalVariable instanceVar, LocalVariable lobArrayVar, Integer lobIndex) throws SupportException {
        TypeDesc fromType;
        Class<?> psClass = property.getPreparedStatementSetMethod().getParameterTypes()[1];
        TypeDesc psType = TypeDesc.forClass(psClass);
        TypeDesc propertyType = TypeDesc.forClass(property.getType());
        StorablePropertyAdapter adapter = property.getAppliedAdapter();
        if (mode != 2) {
            if (instanceVar == null) {
                b.loadThis();
            } else {
                b.loadLocal(instanceVar);
            }
        }
        if (adapter == null) {
            if (mode != 2) {
                if (instanceVar == null) {
                    b.loadField(property.getName(), propertyType);
                } else {
                    b.loadField(instanceVar.getType(), property.getName(), propertyType);
                }
            }
            fromType = propertyType;
        } else {
            Class<Object> toClass = psClass;
            if (Blob.class.isAssignableFrom(toClass)) {
                toClass = com.amazon.carbonado.lob.Blob.class;
            } else if (java.sql.Clob.class.isAssignableFrom(toClass)) {
                toClass = Clob.class;
            }
            Method adaptMethod = adapter.findAdaptMethod(property.getType(), toClass);
            if (adaptMethod == null) {
                if (toClass == String.class && (adaptMethod = adapter.findAdaptMethod(property.getType(), Character.TYPE)) == null) {
                    adaptMethod = adapter.findAdaptMethod(property.getType(), Character.class);
                }
                if (adaptMethod == null) {
                    throw new SupportException("Unable to adapt " + property.getType() + " to " + toClass.getName());
                }
            }
            TypeDesc adaptType = TypeDesc.forClass(adaptMethod.getReturnType());
            if (mode != 2) {
                String methodName = property.getReadMethodName() + '$';
                if (instanceVar == null) {
                    b.invokeVirtual(methodName, adaptType, null);
                } else {
                    b.invokeVirtual(instanceVar.getType(), methodName, adaptType, null);
                }
            }
            fromType = adaptType;
        }
        Label done = b.createLabel();
        if (mode == 2) {
            CodeBuilderUtil.initialVersion(b, fromType, 1);
        } else if (mode == 3) {
            CodeBuilderUtil.incrementVersion(b, fromType);
        } else if (!fromType.isPrimitive() && mode != 1) {
            b.dup();
            Label notNull = b.createLabel();
            b.ifNullBranch((Location)notNull, false);
            b.pop();
            b.loadConstant(property.getDataType().intValue());
            b.invokeInterface(TypeDesc.forClass(PreparedStatement.class), "setNull", null, new TypeDesc[]{TypeDesc.INT, TypeDesc.INT});
            b.branch((Location)done);
            notNull.setLocation();
        }
        if (Lob.class.isAssignableFrom(fromType.toClass())) {
            Method setValueMethod;
            LocalVariable lobVar = b.createLocalVariable(null, fromType);
            b.storeLocal(lobVar);
            LocalVariable columnVar = b.createLocalVariable(null, TypeDesc.INT);
            b.storeLocal(columnVar);
            LocalVariable psVar = b.createLocalVariable("ps", TypeDesc.forClass(PreparedStatement.class));
            b.storeLocal(psVar);
            if (lobArrayVar != null && lobIndex != null) {
                b.loadLocal(lobArrayVar);
                b.loadConstant(lobIndex.intValue());
            }
            this.pushJDBCSupport(b);
            b.loadLocal(psVar);
            b.loadLocal(columnVar);
            b.loadLocal(lobVar);
            try {
                String name = fromType.toClass().getName();
                name = "set" + name.substring(name.lastIndexOf(46) + 1) + "Value";
                setValueMethod = JDBCSupport.class.getMethod(name, PreparedStatement.class, Integer.TYPE, fromType.toClass());
            }
            catch (NoSuchMethodException e) {
                throw new UndeclaredThrowableException(e);
            }
            b.invoke(setValueMethod);
            if (lobArrayVar == null || lobIndex == null) {
                b.pop();
            } else {
                b.storeToArray(TypeDesc.OBJECT);
            }
        } else {
            if (psType == TypeDesc.STRING && fromType.toPrimitiveType() == TypeDesc.CHAR) {
                b.convert(fromType, fromType.toPrimitiveType());
                b.invokeStatic(String.class.getName(), "valueOf", TypeDesc.STRING, new TypeDesc[]{TypeDesc.CHAR});
            } else {
                b.convert(fromType, psType);
            }
            b.invoke(property.getPreparedStatementSetMethod());
        }
        done.setLocation();
    }

    private void yieldCon(CodeBuilder b, LocalVariable capVar, LocalVariable conVar, Label tryAfterCon) {
        Label endFinallyLabel = b.createLabel().setLocation();
        Label contLabel = b.createLabel();
        this.yieldConnection(b, capVar, conVar);
        b.branch((Location)contLabel);
        b.exceptionHandler((Location)tryAfterCon, (Location)endFinallyLabel, null);
        this.yieldConnection(b, capVar, conVar);
        b.throwObject();
        contLabel.setLocation();
    }

    private void yieldConAndHandleException(CodeBuilder b, LocalVariable capVar, Label tryBeforeCon, LocalVariable conVar, Label tryAfterCon, boolean forPersist) {
        Label endFinallyLabel = b.createLabel().setLocation();
        Label contLabel = b.createLabel();
        this.yieldConnection(b, capVar, conVar);
        b.branch((Location)contLabel);
        b.exceptionHandler((Location)tryAfterCon, (Location)endFinallyLabel, null);
        this.yieldConnection(b, capVar, conVar);
        b.throwObject();
        b.exceptionHandler((Location)tryBeforeCon, (Location)b.createLabel().setLocation(), RuntimeException.class.getName());
        b.throwObject();
        b.exceptionHandler((Location)tryBeforeCon, (Location)b.createLabel().setLocation(), Exception.class.getName());
        b.loadLocal(capVar);
        b.swap();
        TypeDesc[] params = new TypeDesc[]{TypeDesc.forClass(Throwable.class)};
        if (forPersist) {
            b.invokeInterface(TypeDesc.forClass(JDBCConnectionCapability.class), "toPersistException", TypeDesc.forClass(PersistException.class), params);
        } else {
            b.invokeInterface(TypeDesc.forClass(JDBCConnectionCapability.class), "toFetchException", TypeDesc.forClass(FetchException.class), params);
        }
        b.throwObject();
        contLabel.setLocation();
    }

    private void closeStatement(CodeBuilder b, LocalVariable statementVar, Label tryAfterStatement) {
        Label contLabel = b.createLabel();
        Label endFinallyLabel = b.createLabel().setLocation();
        b.loadLocal(statementVar);
        b.invokeInterface(TypeDesc.forClass(Statement.class), "close", null, null);
        b.branch((Location)contLabel);
        b.exceptionHandler((Location)tryAfterStatement, (Location)endFinallyLabel, null);
        b.loadLocal(statementVar);
        b.invokeInterface(TypeDesc.forClass(Statement.class), "close", null, null);
        b.throwObject();
        contLabel.setLocation();
    }

    private void closeResultSet(CodeBuilder b, LocalVariable rsVar, Label tryAfterRs) {
        Label contLabel = b.createLabel();
        Label endFinallyLabel = b.createLabel().setLocation();
        b.loadLocal(rsVar);
        b.invokeInterface(TypeDesc.forClass(ResultSet.class), "close", null, null);
        b.branch((Location)contLabel);
        b.exceptionHandler((Location)tryAfterRs, (Location)endFinallyLabel, null);
        b.loadLocal(rsVar);
        b.invokeInterface(TypeDesc.forClass(ResultSet.class), "close", null, null);
        b.throwObject();
        contLabel.setLocation();
    }

    private void branchIfDirty(CodeBuilder b, int propNumber, Label target, boolean branchIfDirty) {
        String stateFieldName = "propertyState$" + (propNumber >> 4);
        b.loadThis();
        b.loadField(stateFieldName, TypeDesc.INT);
        int shift = (propNumber & 0xF) * 2;
        b.loadConstant(3 << shift);
        b.math((byte)126);
        b.loadConstant(3 << shift);
        b.ifComparisonBranch((Location)target, branchIfDirty ? "==" : "!=");
    }

    private void defineExtractAllMethod(Map<JDBCStorableProperty<S>, Class<?>> lobLoaderMap) throws SupportException {
        MethodInfo mi = this.mClassFile.addMethod(Modifiers.PRIVATE, EXTRACT_ALL_METHOD_NAME, null, new TypeDesc[]{TypeDesc.forClass(ResultSet.class), TypeDesc.INT});
        CodeBuilder b = new CodeBuilder(mi);
        this.defineExtract(b, b.getParameter(0), b.getParameter(1), null, this.mInfo.getPrimaryKeyProperties().values(), lobLoaderMap);
        b.loadThis();
        b.loadLocal(b.getParameter(0));
        b.loadLocal(b.getParameter(1));
        b.loadConstant(1);
        b.math((byte)96);
        b.loadNull();
        b.invokePrivate(EXTRACT_DATA_METHOD_NAME, null, new TypeDesc[]{TypeDesc.forClass(ResultSet.class), TypeDesc.INT, TypeDesc.forClass(Lob.class).toArrayType()});
        b.returnVoid();
    }

    private void defineExtractDataMethod(Map<JDBCStorableProperty<S>, Class<?>> lobLoaderMap) throws SupportException {
        MethodInfo mi = this.mClassFile.addMethod(Modifiers.PRIVATE, EXTRACT_DATA_METHOD_NAME, null, new TypeDesc[]{TypeDesc.forClass(ResultSet.class), TypeDesc.INT, TypeDesc.forClass(Lob.class).toArrayType()});
        CodeBuilder b = new CodeBuilder(mi);
        this.defineExtract(b, b.getParameter(0), b.getParameter(1), b.getParameter(2), this.mInfo.getDataProperties().values(), lobLoaderMap);
        b.returnVoid();
    }

    private void defineExtract(CodeBuilder b, LocalVariable rsVar, LocalVariable initialOffsetVar, LocalVariable lobArrayVar, Iterable<JDBCStorableProperty<S>> properties, Map<JDBCStorableProperty<S>, Class<?>> lobLoaderMap) throws SupportException {
        LocalVariable offsetVar = null;
        int lobIndex = 0;
        for (JDBCStorableProperty<S> property : properties) {
            if (!property.isSelectable()) continue;
            b.loadThis();
            b.loadLocal(rsVar);
            if (offsetVar == null) {
                offsetVar = initialOffsetVar;
            } else {
                b.integerIncrement(offsetVar, 1);
            }
            b.loadLocal(offsetVar);
            Method resultSetGetMethod = property.getResultSetGetMethod();
            b.invoke(resultSetGetMethod);
            TypeDesc resultSetType = TypeDesc.forClass(resultSetGetMethod.getReturnType());
            Label wasNull = b.createLabel();
            if (resultSetType.isPrimitive() && property.isColumnNullable()) {
                b.loadLocal(rsVar);
                b.invokeInterface(TypeDesc.forClass(ResultSet.class), "wasNull", TypeDesc.BOOLEAN, null);
                Label wasNotNull = b.createLabel();
                b.ifZeroComparisonBranch((Location)wasNotNull, "==");
                if (resultSetType.isDoubleWord()) {
                    b.pop2();
                } else {
                    b.pop();
                }
                b.loadNull();
                b.branch((Location)wasNull);
                wasNotNull.setLocation();
            }
            if (Lob.class.isAssignableFrom(property.getType()) || Blob.class.isAssignableFrom(resultSetType.toClass()) || java.sql.Clob.class.isAssignableFrom(resultSetType.toClass())) {
                Method convertMethod;
                boolean isClob = Clob.class.isAssignableFrom(property.getType()) || java.sql.Clob.class.isAssignableFrom(resultSetType.toClass());
                String lobTypeName = isClob ? "Clob" : "Blob";
                try {
                    String loaderName = "com.amazon.carbonado.repo.jdbc.JDBC" + lobTypeName + "Loader";
                    convertMethod = JDBCSupport.class.getMethod("convert".concat(lobTypeName), resultSetType.toClass(), Class.forName(loaderName));
                }
                catch (ClassNotFoundException e) {
                    throw new UndeclaredThrowableException(e);
                }
                catch (NoSuchMethodException e) {
                    throw new UndeclaredThrowableException(e);
                }
                this.pushJDBCSupport(b);
                b.swap();
                TypeDesc lobLoaderType = TypeDesc.forClass(lobLoaderMap.get(property));
                b.newObject(lobLoaderType);
                b.dup();
                b.loadThis();
                b.invokeConstructor(lobLoaderType, new TypeDesc[]{this.mClassFile.getType()});
                b.invoke(convertMethod);
                resultSetType = TypeDesc.forClass(convertMethod.getReturnType());
                if (lobArrayVar != null) {
                    b.loadLocal(lobArrayVar);
                    Label noUpdateLob = b.createLabel();
                    b.ifNullBranch((Location)noUpdateLob, true);
                    b.loadLocal(lobArrayVar);
                    b.loadConstant(lobIndex);
                    b.loadFromArray(TypeDesc.OBJECT);
                    b.ifNullBranch((Location)noUpdateLob, true);
                    TypeDesc lobType = TypeDesc.forClass(convertMethod.getReturnType());
                    LocalVariable lob = b.createLocalVariable(null, lobType);
                    b.storeLocal(lob);
                    this.pushJDBCSupport(b);
                    b.loadLocal(lob);
                    b.loadLocal(lobArrayVar);
                    b.loadConstant(lobIndex);
                    b.loadFromArray(TypeDesc.OBJECT);
                    b.checkCast(lobType);
                    TypeDesc[] params = new TypeDesc[]{lobType, lobType};
                    b.invokeInterface(TypeDesc.forClass(JDBCSupport.class), "update".concat(lobTypeName), null, params);
                    b.loadLocal(lob);
                    noUpdateLob.setLocation();
                    ++lobIndex;
                }
            }
            TypeDesc superType = TypeDesc.forClass((String)this.mClassFile.getSuperClassName());
            StorablePropertyAdapter adapter = property.getAppliedAdapter();
            if (adapter == null) {
                TypeDesc propertyType = TypeDesc.forClass(property.getType());
                this.convertFromResultSet(b, property, resultSetType, propertyType);
                wasNull.setLocation();
                b.storeField(superType, property.getName(), propertyType);
                continue;
            }
            Method adaptMethod = adapter.findAdaptMethod(resultSetType.toClass(), property.getType());
            if (adaptMethod == null) {
                if (resultSetType == TypeDesc.STRING && (adaptMethod = adapter.findAdaptMethod(Character.TYPE, property.getType())) == null) {
                    adaptMethod = adapter.findAdaptMethod(Character.class, property.getType());
                }
                if (adaptMethod == null) {
                    throw new SupportException("Unable to adapt " + resultSetType.toClass().getName() + " to " + property.getType());
                }
            }
            TypeDesc adaptType = TypeDesc.forClass(adaptMethod.getParameterTypes()[0]);
            this.convertFromResultSet(b, property, resultSetType, adaptType);
            wasNull.setLocation();
            b.invokeVirtual(superType, property.getWriteMethodName() + '$', null, new TypeDesc[]{adaptType});
        }
    }

    private void convertFromResultSet(CodeBuilder b, JDBCStorableProperty<S> property, TypeDesc resultSetType, TypeDesc toType) {
        if (resultSetType == TypeDesc.STRING && toType.toPrimitiveType() == TypeDesc.CHAR) {
            Label charWasNull = null;
            if (property.isNullable()) {
                charWasNull = b.createLabel();
                LocalVariable temp = b.createLocalVariable(null, resultSetType);
                b.storeLocal(temp);
                b.loadLocal(temp);
                b.ifNullBranch((Location)charWasNull, true);
                b.loadLocal(temp);
            }
            b.loadConstant(0);
            b.invokeVirtual(String.class.getName(), "charAt", TypeDesc.CHAR, new TypeDesc[]{TypeDesc.INT});
            b.convert(TypeDesc.CHAR, toType);
            if (charWasNull != null) {
                Label skipNull = b.createLabel();
                b.branch((Location)skipNull);
                charWasNull.setLocation();
                b.loadNull();
                skipNull.setLocation();
            }
        } else {
            b.convert(resultSetType, toType);
        }
    }

    private Map<JDBCStorableProperty<S>, Class<?>> generateLobLoaders() throws SupportException {
        IdentityHashMap lobLoaderMap = new IdentityHashMap();
        for (JDBCStorableProperty<S> property : this.mAllProperties.values()) {
            Class<Object> lobLoader;
            if (!property.isSelectable() || property.isVersion()) continue;
            Class<?> psClass = property.getPreparedStatementSetMethod().getParameterTypes()[1];
            if (com.amazon.carbonado.lob.Blob.class.isAssignableFrom(property.getType()) || Blob.class.isAssignableFrom(psClass)) {
                lobLoader = this.generateLobLoader(property, JDBCBlobLoader.class);
            } else {
                if (!Clob.class.isAssignableFrom(property.getType()) && !java.sql.Clob.class.isAssignableFrom(psClass)) continue;
                lobLoader = this.generateLobLoader(property, JDBCClobLoader.class);
            }
            lobLoaderMap.put(property, lobLoader);
        }
        return lobLoaderMap;
    }

    private Class<?> generateLobLoader(JDBCStorableProperty<S> property, Class<?> loaderType) throws SupportException {
        ClassInjector ci = ClassInjector.create((String)property.getEnclosingType().getName(), (ClassLoader)this.mParentClassLoader);
        ClassFile cf = new ClassFile(ci.getClassName());
        cf.markSynthetic();
        cf.setSourceFile(JDBCStorableGenerator.class.getName());
        cf.setTarget("1.5");
        cf.addInterface(loaderType);
        boolean isClob = loaderType == JDBCClobLoader.class;
        TypeDesc capType = TypeDesc.forClass(JDBCConnectionCapability.class);
        TypeDesc resultSetType = TypeDesc.forClass(ResultSet.class);
        TypeDesc preparedStatementType = TypeDesc.forClass(PreparedStatement.class);
        TypeDesc sqlLobType = TypeDesc.forClass(isClob ? java.sql.Clob.class : Blob.class);
        String enclosingFieldName = "enclosing";
        TypeDesc enclosingType = this.mClassFile.getType();
        cf.addField(Modifiers.PRIVATE, "enclosing", enclosingType);
        MethodInfo mi = cf.addConstructor(Modifiers.PUBLIC, new TypeDesc[]{enclosingType});
        CodeBuilder b = new CodeBuilder(mi);
        b.loadThis();
        b.invokeSuperConstructor(null);
        b.loadThis();
        b.loadLocal(b.getParameter(0));
        b.storeField("enclosing", enclosingType);
        b.returnVoid();
        mi = cf.addMethod(Modifiers.PUBLIC, "load", sqlLobType, new TypeDesc[]{capType});
        mi.addException(TypeDesc.forClass(FetchException.class));
        b = new CodeBuilder(mi);
        LocalVariable capVar = b.getParameter(0);
        Label tryBeforeCon = b.createLabel().setLocation();
        LocalVariable conVar = this.getConnection(b, capVar);
        Label tryAfterCon = b.createLabel().setLocation();
        StringBuilder selectBuilder = new StringBuilder();
        selectBuilder.append("SELECT ");
        selectBuilder.append(property.getColumnName());
        selectBuilder.append(" FROM ");
        selectBuilder.append(this.mInfo.getQualifiedTableName());
        LocalVariable psVar = b.createLocalVariable("ps", preparedStatementType);
        LocalVariable instanceVar = b.createLocalVariable(null, enclosingType);
        b.loadThis();
        b.loadField("enclosing", enclosingType);
        b.storeLocal(instanceVar);
        Label tryAfterPs = this.buildWhereClauseAndPreparedStatement(b, selectBuilder, conVar, psVar, capVar, instanceVar);
        b.loadLocal(psVar);
        b.invokeInterface(preparedStatementType, "executeQuery", resultSetType, null);
        LocalVariable rsVar = b.createLocalVariable("rs", resultSetType);
        b.storeLocal(rsVar);
        Label tryAfterRs = b.createLabel().setLocation();
        LocalVariable resultVar = b.createLocalVariable(null, sqlLobType);
        b.loadNull();
        b.storeLocal(resultVar);
        b.loadLocal(rsVar);
        b.invokeInterface(resultSetType, "next", TypeDesc.BOOLEAN, null);
        Label noResults = b.createLabel();
        b.ifZeroComparisonBranch((Location)noResults, "==");
        b.loadLocal(rsVar);
        b.loadConstant(1);
        b.invokeInterface(resultSetType, isClob ? "getClob" : "getBlob", sqlLobType, new TypeDesc[]{TypeDesc.INT});
        b.storeLocal(resultVar);
        noResults.setLocation();
        this.closeResultSet(b, rsVar, tryAfterRs);
        this.closeStatement(b, psVar, tryAfterPs);
        this.yieldConAndHandleException(b, capVar, tryBeforeCon, conVar, tryAfterCon, false);
        b.loadLocal(resultVar);
        b.returnValue(sqlLobType);
        return ci.defineClass(cf);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Versioning {
        NONE,
        EXTERNAL,
        AUTO;

    }
}

