/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.jdbc;

import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.FetchNoneException;
import com.amazon.carbonado.PersistException;
import com.amazon.carbonado.PersistNoneException;
import com.amazon.carbonado.lob.AbstractClob;
import com.amazon.carbonado.repo.jdbc.JDBCClobLoader;
import com.amazon.carbonado.repo.jdbc.JDBCLob;
import com.amazon.carbonado.repo.jdbc.JDBCRepository;
import com.amazon.carbonado.repo.jdbc.JDBCTransaction;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

class JDBCClob
extends AbstractClob
implements JDBCLob {
    private static final int DEFAULT_BUFFER = 4000;
    protected final JDBCRepository mRepo;
    private Clob mClob;
    private final JDBCClobLoader mLoader;

    JDBCClob(JDBCRepository repo, Clob clob, JDBCClobLoader loader) {
        super(repo);
        this.mRepo = repo;
        this.mClob = clob;
        this.mLoader = loader;
    }

    public Reader openReader() throws FetchException {
        try {
            return this.getInternalClobForFetch().getCharacterStream();
        }
        catch (SQLException e) {
            throw this.mRepo.toFetchException(e);
        }
    }

    public Reader openReader(long pos) throws FetchException {
        try {
            if (pos == 0L) {
                return this.getInternalClobForFetch().getCharacterStream();
            }
            return new Input(this.getInternalClobForFetch(), 4000, pos);
        }
        catch (SQLException e) {
            throw this.mRepo.toFetchException(e);
        }
    }

    public Reader openReader(long pos, int bufferSize) throws FetchException {
        try {
            if (pos == 0L) {
                return this.getInternalClobForFetch().getCharacterStream();
            }
            if (bufferSize <= 0) {
                bufferSize = 4000;
            }
            return new Input(this.getInternalClobForFetch(), bufferSize, pos);
        }
        catch (SQLException e) {
            throw this.mRepo.toFetchException(e);
        }
    }

    public long getLength() throws FetchException {
        try {
            return this.getInternalClobForFetch().length();
        }
        catch (SQLException e) {
            throw this.mRepo.toFetchException(e);
        }
    }

    public Writer openWriter() throws PersistException {
        return this.openWriter(0L);
    }

    public Writer openWriter(long pos) throws PersistException {
        try {
            return this.getInternalClobForPersist().setCharacterStream(pos);
        }
        catch (SQLException e) {
            throw this.mRepo.toPersistException(e);
        }
    }

    public Writer openWriter(long pos, int bufferSize) throws PersistException {
        return this.openWriter(pos);
    }

    public void setLength(long length) throws PersistException {
        try {
            this.getInternalClobForPersist().truncate(length);
        }
        catch (SQLException e) {
            throw this.mRepo.toPersistException(e);
        }
    }

    public Object getLocator() {
        return null;
    }

    public void close() {
        this.mClob = null;
    }

    Clob getInternalClobForFetch() throws FetchException {
        if (this.mClob == null) {
            this.mClob = this.mLoader.load(this.mRepo);
            if (this.mClob == null) {
                throw new FetchNoneException("Clob value is null");
            }
            try {
                JDBCTransaction txn = this.mRepo.localTransactionScope().getTxn();
                if (txn != null) {
                    txn.register(this);
                }
            }
            catch (Exception e) {
                throw this.mRepo.toFetchException(e);
            }
        }
        return this.mClob;
    }

    Clob getInternalClobForPersist() throws PersistException {
        if (this.mClob == null) {
            try {
                this.mClob = this.mLoader.load(this.mRepo);
                if (this.mClob == null) {
                    throw new PersistNoneException("Clob value is null");
                }
                JDBCTransaction txn = this.mRepo.localTransactionScope().getTxn();
                if (txn != null) {
                    txn.register(this);
                }
            }
            catch (Exception e) {
                throw this.mRepo.toPersistException(e);
            }
        }
        return this.mClob;
    }

    private static class Input
    extends Reader {
        private final Clob mClob;
        private final int mBufferSize;
        private long mPos;
        private String mBuffer;
        private int mBufferPos;

        Input(Clob clob, int bufferSize, long pos) {
            this.mClob = clob;
            this.mBufferSize = bufferSize;
            this.mPos = pos;
        }

        public int read() throws IOException {
            if (this.fillBuffer() <= 0) {
                return -1;
            }
            return this.mBuffer.charAt(this.mBufferPos++);
        }

        public int read(char[] c, int off, int len) throws IOException {
            int avail = this.fillBuffer();
            if (avail <= 0) {
                return -1;
            }
            if (len > avail) {
                len = avail;
            }
            this.mBuffer.getChars(this.mBufferPos, this.mBufferPos + len, c, off);
            this.mBufferPos += len;
            return len;
        }

        public long skip(long n) throws IOException {
            long length;
            if (n <= 0L) {
                return 0L;
            }
            long newPos = this.mPos + n;
            try {
                length = this.mClob.length();
            }
            catch (SQLException e) {
                IOException ioe = new IOException();
                ioe.initCause(e);
                throw ioe;
            }
            if (newPos >= length) {
                newPos = length;
                n = newPos - this.mPos;
            }
            long newBufferPos = (long)this.mBufferPos + n;
            if (this.mBuffer == null || newBufferPos >= (long)this.mBuffer.length()) {
                this.mBuffer = null;
                this.mBufferPos = 0;
            } else {
                this.mBufferPos = (int)newBufferPos;
            }
            this.mPos = newPos;
            return n;
        }

        public void close() {
        }

        private int fillBuffer() throws IOException {
            try {
                if (this.mBuffer == null || this.mBufferPos >= this.mBuffer.length()) {
                    this.mBuffer = this.mClob.getSubString(this.mPos, this.mBufferSize);
                    this.mPos += (long)this.mBuffer.length();
                    this.mBufferPos = 0;
                }
                return this.mBuffer.length() - this.mBufferPos;
            }
            catch (SQLException e) {
                IOException ioe = new IOException();
                ioe.initCause(e);
                throw ioe;
            }
        }
    }
}

