/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.jdbc;

import com.amazon.carbonado.repo.jdbc.H2ExceptionTransformer;
import com.amazon.carbonado.repo.jdbc.JDBCExceptionTransformer;
import com.amazon.carbonado.repo.jdbc.JDBCRepository;
import com.amazon.carbonado.repo.jdbc.JDBCSupportStrategy;

class H2SupportStrategy
extends JDBCSupportStrategy {
    private static final String DEFAULT_SEQUENCE_SELECT_STATEMENT = "SELECT NEXT VALUE FOR %s";
    private static final String TRUNCATE_STATEMENT = "TRUNCATE TABLE %s";

    protected H2SupportStrategy(JDBCRepository repo) {
        super(repo);
        this.setSequenceSelectStatement(DEFAULT_SEQUENCE_SELECT_STATEMENT);
        this.setTruncateTableStatement(TRUNCATE_STATEMENT);
    }

    JDBCExceptionTransformer createExceptionTransformer() {
        return new H2ExceptionTransformer();
    }

    JDBCSupportStrategy.SliceOption getSliceOption() {
        return JDBCSupportStrategy.SliceOption.LIMIT_AND_OFFSET;
    }

    String buildSelectWithSlice(String select, boolean from, boolean to) {
        if (to) {
            if (from) {
                return select.concat(" LIMIT ? OFFSET ?");
            }
            return select.concat(" LIMIT ?");
        }
        if (from) {
            return select.concat(" LIMIT 2147483647 OFFSET ?");
        }
        return select;
    }
}

