/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.jdbc;

import com.amazon.carbonado.Storable;
import com.amazon.carbonado.filter.FilterValues;
import com.amazon.carbonado.repo.jdbc.SQLStatement;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CompositeStatement<S extends Storable>
extends SQLStatement<S> {
    private final SQLStatement<S>[] mStatements;

    CompositeStatement(List<SQLStatement<S>> statements) {
        this.mStatements = statements.toArray(new SQLStatement[statements.size()]);
    }

    @Override
    public int maxLength() {
        int max = 0;
        for (SQLStatement<S> statement : this.mStatements) {
            max += statement.maxLength();
        }
        return max;
    }

    @Override
    public void appendTo(StringBuilder b, FilterValues<S> filterValues) {
        for (SQLStatement<S> statement : this.mStatements) {
            statement.appendTo(b, filterValues);
        }
    }
}

