/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.indexed;

import com.amazon.carbonado.Cursor;
import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.PersistException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.Storage;
import com.amazon.carbonado.Transaction;
import com.amazon.carbonado.cursor.AbstractCursor;
import com.amazon.carbonado.repo.indexed.IndexedRepository;
import com.amazon.carbonado.repo.indexed.IndexedStorage;
import com.amazon.carbonado.spi.RepairExecutor;
import com.amazon.carbonado.synthetic.SyntheticStorableReferenceAccess;
import java.util.NoSuchElementException;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IndexedCursor<S extends Storable>
extends AbstractCursor<S> {
    private final Cursor<? extends Storable> mCursor;
    private final IndexedStorage<S> mStorage;
    private final SyntheticStorableReferenceAccess<S> mAccessor;
    private S mNext;

    IndexedCursor(Cursor<? extends Storable> indexEntryCursor, IndexedStorage<S> storage, SyntheticStorableReferenceAccess<S> indexAccessor) {
        this.mCursor = indexEntryCursor;
        this.mStorage = storage;
        this.mAccessor = indexAccessor;
    }

    @Override
    public void close() throws FetchException {
        this.mCursor.close();
    }

    @Override
    public boolean hasNext() throws FetchException {
        if (this.mNext != null) {
            return true;
        }
        try {
            while (this.mCursor.hasNext()) {
                final Storable indexEntry = this.mCursor.next();
                Object master = this.mStorage.mMasterStorage.prepare();
                this.mAccessor.copyToMasterPrimaryKey(indexEntry, master);
                if (!master.tryLoad()) {
                    LogFactory.getLog(this.getClass()).warn((Object)("Master is missing for index entry: " + indexEntry));
                    continue;
                }
                if (this.mAccessor.isConsistent(indexEntry, master)) {
                    this.mNext = master;
                    return true;
                }
                try {
                    final IndexedRepository repo = this.mStorage.mRepository;
                    final Storage<?> indexEntryStorage = repo.getIndexEntryStorageFor(this.mAccessor.getReferenceClass());
                    Object newIndexEntry = indexEntryStorage.prepare();
                    this.mAccessor.copyFromMaster((Storable)newIndexEntry, master);
                    if (!newIndexEntry.tryLoad()) {
                        LogFactory.getLog(this.getClass()).warn((Object)("Inconsistent index entry: " + indexEntry + ", " + master));
                        this.mNext = master;
                    }
                    RepairExecutor.execute(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            Transaction txn = repo.enterTransaction();
                            try {
                                Object master = ((IndexedCursor)IndexedCursor.this).mStorage.mMasterStorage.prepare();
                                IndexedCursor.this.mAccessor.copyToMasterPrimaryKey(indexEntry, master);
                                if (master.tryLoad()) {
                                    Object newIndexEntry = indexEntryStorage.prepare();
                                    IndexedCursor.this.mAccessor.copyFromMaster((Storable)newIndexEntry, master);
                                    newIndexEntry.tryInsert();
                                    indexEntry.tryDelete();
                                    txn.commit();
                                }
                            }
                            catch (FetchException fe) {
                                LogFactory.getLog(IndexedCursor.class).warn((Object)("Unable to check if repair required for inconsistent index entry " + indexEntry), (Throwable)fe);
                            }
                            catch (PersistException pe) {
                                LogFactory.getLog(IndexedCursor.class).error((Object)("Unable to repair inconsistent index entry " + indexEntry), (Throwable)pe);
                            }
                            finally {
                                try {
                                    txn.exit();
                                }
                                catch (PersistException pe) {
                                    LogFactory.getLog(IndexedCursor.class).error((Object)("Unable to repair inconsistent index entry " + indexEntry), (Throwable)pe);
                                }
                            }
                        }
                    });
                }
                catch (Exception re) {
                    LogFactory.getLog(this.getClass()).error((Object)("Unable to inspect inconsistent index entry " + indexEntry), (Throwable)re);
                }
                if (this.mNext == null) continue;
                return true;
            }
        }
        catch (NoSuchElementException e) {
        }
        catch (FetchException e) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
        return false;
    }

    @Override
    public S next() throws FetchException {
        try {
            if (this.hasNext()) {
                S next = this.mNext;
                this.mNext = null;
                return next;
            }
        }
        catch (FetchException e) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
        throw new NoSuchElementException();
    }

    @Override
    public int skipNext(int amount) throws FetchException {
        try {
            if (this.mNext == null) {
                return this.mCursor.skipNext(amount);
            }
            if (amount <= 0) {
                if (amount < 0) {
                    throw new IllegalArgumentException("Cannot skip negative amount: " + amount);
                }
                return 0;
            }
            this.mNext = null;
            return 1 + this.mCursor.skipNext(amount - 1);
        }
        catch (FetchException e) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }
}

