/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.indexed;

import com.amazon.carbonado.FetchDeadlockException;
import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.FetchTimeoutException;
import com.amazon.carbonado.IsolationLevel;
import com.amazon.carbonado.Query;
import com.amazon.carbonado.RepositoryException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.Storage;
import com.amazon.carbonado.Transaction;
import com.amazon.carbonado.capability.IndexInfo;
import com.amazon.carbonado.capability.IndexInfoCapability;
import com.amazon.carbonado.filter.Filter;
import com.amazon.carbonado.filter.RelOp;
import com.amazon.carbonado.info.ChainedProperty;
import com.amazon.carbonado.info.Direction;
import com.amazon.carbonado.info.StorableIndex;
import com.amazon.carbonado.info.StorableInfo;
import com.amazon.carbonado.info.StorableIntrospector;
import com.amazon.carbonado.info.StorableProperty;
import com.amazon.carbonado.qe.FilteringScore;
import com.amazon.carbonado.qe.StorableIndexSet;
import com.amazon.carbonado.repo.indexed.IndexEntryGenerator;
import com.amazon.carbonado.repo.indexed.IndexedRepository;
import com.amazon.carbonado.repo.indexed.IndexesTrigger;
import com.amazon.carbonado.repo.indexed.ManagedIndex;
import com.amazon.carbonado.repo.indexed.StoredIndexInfo;
import com.amazon.carbonado.synthetic.SyntheticStorableReferenceAccess;
import java.util.Arrays;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IndexAnalysis<S extends Storable> {
    final IndexedRepository repository;
    final Storage<S> masterStorage;
    final StorableIndexSet<S> queryableIndexSet;
    final StorableIndexSet<S> removeIndexSet;
    final StorableIndexSet<S> addIndexSet;
    final Map<StorableIndex<S>, IndexInfo> allIndexInfoMap;
    final IndexesTrigger<S> indexesTrigger;
    final Set<ChainedProperty<?>> derivedToDependencies;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public IndexAnalysis(IndexedRepository repository, Storage<S> masterStorage) throws RepositoryException {
        StorableIndexSet bogusIndexSet;
        StorableIndexSet existingIndexSet;
        StorableIndexSet<S> desiredIndexSet;
        StorableInfo<S> info;
        block28: {
            void var8_12;
            this.repository = repository;
            this.masterStorage = masterStorage;
            info = StorableIntrospector.examine(masterStorage.getStorableType());
            desiredIndexSet = IndexAnalysis.gatherDesiredIndexes(info);
            desiredIndexSet.reduce(Direction.ASCENDING);
            if (repository.isAllClustered()) {
                desiredIndexSet.markClustered(true);
            }
            existingIndexSet = new StorableIndexSet();
            bogusIndexSet = new StorableIndexSet();
            Query<StoredIndexInfo> query = repository.getWrappedRepository().storageFor(StoredIndexInfo.class).query("indexName >= ? & indexName < ?").with(info.getStorableType().getName() + '~').with(info.getStorableType().getName() + '~' + '\uffff');
            try {
                Transaction txn = repository.getWrappedRepository().enterTopTransaction(IsolationLevel.READ_COMMITTED);
                try {
                    List<StoredIndexInfo> list = query.fetch().toList();
                }
                finally {
                    txn.exit();
                }
            }
            catch (FetchException e) {
                if (e instanceof FetchDeadlockException || e instanceof FetchTimeoutException) {
                    Transaction txn = repository.getWrappedRepository().enterTransaction(IsolationLevel.READ_COMMITTED);
                    try {
                        List<StoredIndexInfo> list = query.fetch().toList();
                    }
                    finally {
                        txn.exit();
                    }
                }
                throw e;
            }
            for (StoredIndexInfo indexInfo : var8_12) {
                StorableIndex<S> storableIndex;
                String name = indexInfo.getIndexName();
                try {
                    storableIndex = StorableIndex.parseNameDescriptor(name, info);
                }
                catch (IllegalArgumentException e) {
                    continue;
                }
                if (storableIndex.getTypeDescriptor().equals(indexInfo.getIndexTypeDescriptor())) {
                    existingIndexSet.add(storableIndex);
                    continue;
                }
                bogusIndexSet.add(storableIndex);
            }
            for (StorableIndex storableIndex : existingIndexSet) {
                if (storableIndex.isUnique()) continue;
                break block28;
            }
            desiredIndexSet.uniquify(info);
        }
        StorableIndexSet freeIndexSet = new StorableIndexSet();
        this.allIndexInfoMap = new IdentityHashMap<StorableIndex<S>, IndexInfo>();
        IndexInfoCapability indexInfoCapability = repository.getWrappedRepository().getCapability(IndexInfoCapability.class);
        if (indexInfoCapability != null) {
            for (IndexInfo indexInfo : indexInfoCapability.getIndexInfo(info.getStorableType())) {
                StorableIndex<S> freeIndex;
                try {
                    freeIndex = new StorableIndex<S>(info.getStorableType(), indexInfo);
                }
                catch (IllegalArgumentException e) {
                    continue;
                }
                if (repository.isAllClustered()) {
                    freeIndex = freeIndex.clustered(true);
                }
                freeIndexSet.add(freeIndex);
                this.allIndexInfoMap.put(freeIndex, indexInfo);
            }
        }
        this.queryableIndexSet = new StorableIndexSet<S>(desiredIndexSet);
        if (!repository.isIndexRepairEnabled()) {
            this.queryableIndexSet.retainAll(existingIndexSet);
        }
        this.queryableIndexSet.addAll(freeIndexSet);
        StorableIndexSet<S> storableIndexSet = new StorableIndexSet<S>(desiredIndexSet);
        if (repository.isIndexRepairEnabled()) {
            storableIndexSet.addAll(existingIndexSet);
        }
        storableIndexSet.removeAll(freeIndexSet);
        this.removeIndexSet = new StorableIndexSet();
        if (repository.isIndexRepairEnabled()) {
            this.removeIndexSet.addAll(existingIndexSet);
            this.removeIndexSet.removeAll(desiredIndexSet);
            this.removeIndexSet.removeAll(freeIndexSet);
            this.removeIndexSet.addAll(bogusIndexSet);
        }
        this.addIndexSet = new StorableIndexSet();
        if (repository.isIndexRepairEnabled()) {
            this.addIndexSet.addAll(desiredIndexSet);
            this.addIndexSet.removeAll(existingIndexSet);
            this.addIndexSet.removeAll(freeIndexSet);
        }
        if (storableIndexSet.size() <= 0) {
            this.indexesTrigger = null;
        } else {
            ManagedIndex[] managedIndexes = new ManagedIndex[storableIndexSet.size()];
            int i = 0;
            for (StorableIndex storableIndex : storableIndexSet) {
                SyntheticStorableReferenceAccess accessor = IndexEntryGenerator.getIndexAccess(storableIndex);
                Class<Storable> indexEntryClass = accessor.getReferenceClass();
                Storage<?> indexEntryStorage = repository.getIndexEntryStorageFor(indexEntryClass);
                ManagedIndex<S> managedIndex = new ManagedIndex<S>(repository, masterStorage, storableIndex, accessor, indexEntryStorage);
                this.allIndexInfoMap.put(storableIndex, managedIndex);
                managedIndexes[i++] = managedIndex;
            }
            this.indexesTrigger = new IndexesTrigger(managedIndexes);
        }
        this.derivedToDependencies = IndexAnalysis.gatherDerivedToDependencies(info);
    }

    static <S extends Storable> StorableIndexSet<S> gatherDesiredIndexes(StorableInfo<S> info) {
        StorableIndexSet<S> indexSet = new StorableIndexSet<S>();
        indexSet.addIndexes(info);
        indexSet.addAlternateKeys(info);
        for (StorableProperty<S> property : info.getAllProperties().values()) {
            if (!IndexAnalysis.isJoinAndUsedByIndexedDerivedProperty(property)) continue;
            Filter filter = Filter.getOpenFilter(info.getStorableType());
            int i = property.getJoinElementCount();
            while (--i >= 0) {
                filter = filter.and(property.getInternalJoinElement(i).getName(), RelOp.EQ);
            }
            i = info.getIndexCount();
            while (--i >= 0) {
                FilteringScore<S> score = FilteringScore.evaluate(info.getIndex(i), filter);
                if (score.getIdentityCount() != property.getJoinElementCount()) continue;
            }
            Direction[] directions = new Direction[property.getJoinElementCount()];
            Arrays.fill((Object[])directions, (Object)Direction.UNSPECIFIED);
            StorableIndex<S> index = new StorableIndex<S>(property.getInternalJoinElements(), directions);
            indexSet.add(index);
        }
        return indexSet;
    }

    private static boolean isUsedByIndex(StorableProperty<?> property) {
        StorableInfo<?> info = StorableIntrospector.examine(property.getEnclosingType());
        int i = info.getIndexCount();
        while (--i >= 0) {
            StorableIndex<?> index = info.getIndex(i);
            int propertyCount = index.getPropertyCount();
            for (int j = 0; j < propertyCount; ++j) {
                if (!index.getProperty(j).equals(property)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isJoinAndUsedByIndexedDerivedProperty(StorableProperty<?> property) {
        if (property.isJoin()) {
            for (ChainedProperty<?> derivedTo : property.getDerivedToProperties()) {
                if (!IndexAnalysis.isUsedByIndex(derivedTo.getPrimeProperty())) continue;
                return true;
            }
        }
        return false;
    }

    private static Set<ChainedProperty<?>> gatherDerivedToDependencies(StorableInfo<?> info) {
        HashSet set = null;
        for (StorableProperty<?> property : info.getAllProperties().values()) {
            for (ChainedProperty<?> derivedTo : property.getDerivedToProperties()) {
                if (derivedTo.getChainCount() <= 0 || !IndexAnalysis.isUsedByIndex(derivedTo.getPrimeProperty())) continue;
                if (set == null) {
                    set = new HashSet();
                }
                set.add(derivedTo);
            }
        }
        return set;
    }
}

