/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.raw;

import com.amazon.carbonado.raw.DataEncoder;
import com.amazon.carbonado.raw.EncodingConstants;
import java.math.BigDecimal;
import java.math.BigInteger;

public class KeyEncoder {
    public static void encodeDesc(int value, byte[] dst, int dstOffset) {
        DataEncoder.encode(~value, dst, dstOffset);
    }

    public static int encodeDesc(Integer value, byte[] dst, int dstOffset) {
        if (value == null) {
            dst[dstOffset] = 0;
            return 1;
        }
        dst[dstOffset] = 127;
        DataEncoder.encode(~value.intValue(), dst, dstOffset + 1);
        return 5;
    }

    public static void encodeDesc(long value, byte[] dst, int dstOffset) {
        DataEncoder.encode(value ^ 0xFFFFFFFFFFFFFFFFL, dst, dstOffset);
    }

    public static int encodeDesc(Long value, byte[] dst, int dstOffset) {
        if (value == null) {
            dst[dstOffset] = 0;
            return 1;
        }
        dst[dstOffset] = 127;
        DataEncoder.encode(value ^ 0xFFFFFFFFFFFFFFFFL, dst, dstOffset + 1);
        return 9;
    }

    public static void encodeDesc(byte value, byte[] dst, int dstOffset) {
        dst[dstOffset] = (byte)(value ^ 0x7F);
    }

    public static int encodeDesc(Byte value, byte[] dst, int dstOffset) {
        if (value == null) {
            dst[dstOffset] = 0;
            return 1;
        }
        dst[dstOffset] = 127;
        dst[dstOffset + 1] = (byte)(value ^ 0x7F);
        return 2;
    }

    public static void encodeDesc(short value, byte[] dst, int dstOffset) {
        DataEncoder.encode(~value, dst, dstOffset);
    }

    public static int encodeDesc(Short value, byte[] dst, int dstOffset) {
        if (value == null) {
            dst[dstOffset] = 0;
            return 1;
        }
        dst[dstOffset] = 127;
        DataEncoder.encode(~value.shortValue(), dst, dstOffset + 1);
        return 3;
    }

    public static void encodeDesc(char value, byte[] dst, int dstOffset) {
        DataEncoder.encode(~value, dst, dstOffset);
    }

    public static int encodeDesc(Character value, byte[] dst, int dstOffset) {
        if (value == null) {
            dst[dstOffset] = 0;
            return 1;
        }
        dst[dstOffset] = 127;
        DataEncoder.encode(~value.charValue(), dst, dstOffset + 1);
        return 3;
    }

    public static void encodeDesc(boolean value, byte[] dst, int dstOffset) {
        dst[dstOffset] = value ? 127 : -128;
    }

    public static void encodeDesc(Boolean value, byte[] dst, int dstOffset) {
        dst[dstOffset] = value == null ? 0 : (value != false ? 127 : -128);
    }

    public static void encodeDesc(float value, byte[] dst, int dstOffset) {
        int bits = Float.floatToIntBits(value);
        if (bits >= 0) {
            bits ^= Integer.MAX_VALUE;
        }
        dst[dstOffset] = (byte)(bits >> 24);
        dst[dstOffset + 1] = (byte)(bits >> 16);
        dst[dstOffset + 2] = (byte)(bits >> 8);
        dst[dstOffset + 3] = (byte)bits;
    }

    public static void encodeDesc(Float value, byte[] dst, int dstOffset) {
        if (value == null) {
            DataEncoder.encode(Integer.MIN_VALUE, dst, dstOffset);
        } else {
            KeyEncoder.encodeDesc(value.floatValue(), dst, dstOffset);
        }
    }

    public static void encodeDesc(double value, byte[] dst, int dstOffset) {
        long bits = Double.doubleToLongBits(value);
        if (bits >= 0L) {
            bits ^= Long.MAX_VALUE;
        }
        int w = (int)(bits >> 32);
        dst[dstOffset] = (byte)(w >> 24);
        dst[dstOffset + 1] = (byte)(w >> 16);
        dst[dstOffset + 2] = (byte)(w >> 8);
        dst[dstOffset + 3] = (byte)w;
        w = (int)bits;
        dst[dstOffset + 4] = (byte)(w >> 24);
        dst[dstOffset + 5] = (byte)(w >> 16);
        dst[dstOffset + 6] = (byte)(w >> 8);
        dst[dstOffset + 7] = (byte)w;
    }

    public static void encodeDesc(Double value, byte[] dst, int dstOffset) {
        if (value == null) {
            DataEncoder.encode(Long.MIN_VALUE, dst, dstOffset);
        } else {
            KeyEncoder.encodeDesc((double)value, dst, dstOffset);
        }
    }

    public static int encode(BigInteger value, byte[] dst, int dstOffset) {
        int headerSize;
        if (value == null) {
            dst[dstOffset] = -1;
            return 1;
        }
        byte[] bytes = value.toByteArray();
        int bytesLength = bytes.length;
        if (bytesLength < 127) {
            dst[dstOffset] = value.signum() < 0 ? (byte)(128 - bytesLength) : (byte)(bytesLength + 127);
            headerSize = 1;
        } else {
            dst[dstOffset] = (byte)(value.signum() < 0 ? 1 : 254);
            int encodedLen = value.signum() < 0 ? -bytesLength : bytesLength;
            DataEncoder.encode(encodedLen, dst, dstOffset + 1);
            headerSize = 5;
        }
        System.arraycopy(bytes, 0, dst, headerSize + dstOffset, bytesLength);
        return headerSize + bytesLength;
    }

    public static int encodeDesc(BigInteger value, byte[] dst, int dstOffset) {
        int headerSize;
        if (value == null) {
            dst[dstOffset] = 0;
            return 1;
        }
        byte[] bytes = value.toByteArray();
        int bytesLength = bytes.length;
        if (bytesLength < 127) {
            dst[dstOffset] = value.signum() < 0 ? (byte)(bytesLength + 127) : (byte)(128 - bytesLength);
            headerSize = 1;
        } else {
            dst[dstOffset] = (byte)(value.signum() < 0 ? 254 : 1);
            int encodedLen = value.signum() < 0 ? bytesLength : -bytesLength;
            DataEncoder.encode(encodedLen, dst, dstOffset + 1);
            headerSize = 5;
        }
        dstOffset += headerSize;
        for (int i = 0; i < bytesLength; ++i) {
            dst[dstOffset + i] = ~bytes[i];
        }
        return headerSize + bytesLength;
    }

    public static int calculateEncodedLength(BigInteger value) {
        if (value == null) {
            return 1;
        }
        int bytesLength = (value.bitLength() >> 3) + 1;
        return bytesLength < 127 ? 1 + bytesLength : 5 + bytesLength;
    }

    public static int encode(BigDecimal value, byte[] dst, int dstOffset) {
        if (value == null) {
            dst[dstOffset] = -1;
            return 1;
        }
        if (value.signum() == 0) {
            dst[dstOffset] = -128;
            return 1;
        }
        return KeyEncoder.encode(value).copyTo(dst, dstOffset);
    }

    public static int encodeDesc(BigDecimal value, byte[] dst, int dstOffset) {
        if (value == null) {
            dst[dstOffset] = 0;
            return 1;
        }
        if (value.signum() == 0) {
            dst[dstOffset] = 127;
            return 1;
        }
        return KeyEncoder.encode(value).copyDescTo(dst, dstOffset);
    }

    public static int calculateEncodedLength(BigDecimal value) {
        if (value == null || value.signum() == 0) {
            return 1;
        }
        return KeyEncoder.encode((BigDecimal)value).mLength;
    }

    private static CachedBigDecimal encode(BigDecimal value) {
        CachedBigDecimal cached = CachedBigDecimal.cLocal.get();
        if (cached != null && cached.mValue.equals(value)) {
            return cached;
        }
        int length = 6 + (value.unscaledValue().bitLength() + 20 + 7 >> 3);
        byte[] encoded = new byte[length];
        length = KeyEncoder.encodeUncached(value, encoded);
        cached = new CachedBigDecimal(value, encoded, length);
        CachedBigDecimal.cLocal.set(cached);
        return cached;
    }

    private static int encodeUncached(BigDecimal value, byte[] dst) {
        int digitAdjust;
        int terminator;
        int dstOffset = 0;
        int precision = value.precision();
        int exponent = precision - value.scale();
        if (value.signum() < 0) {
            if (exponent >= -62 && exponent < 62) {
                dst[dstOffset++] = (byte)(63 - exponent);
            } else {
                dst[dstOffset] = exponent < 0 ? 126 : 1;
                DataEncoder.encode(~exponent, dst, dstOffset + 1);
                dstOffset += 5;
            }
        } else if (exponent >= -62 && exponent < 62) {
            dst[dstOffset++] = (byte)(exponent + 192);
        } else {
            dst[dstOffset] = exponent < 0 ? -127 : -2;
            DataEncoder.encode(exponent, dst, dstOffset + 1);
            dstOffset += 5;
        }
        BigInteger unscaledValue = value.unscaledValue();
        switch (precision % 3) {
            default: {
                terminator = 2;
                break;
            }
            case 1: {
                terminator = 0;
                unscaledValue = unscaledValue.multiply(EncodingConstants.ONE_HUNDRED);
                break;
            }
            case 2: {
                terminator = 1;
                unscaledValue = unscaledValue.multiply(BigInteger.TEN);
            }
        }
        if (unscaledValue.signum() >= 0) {
            digitAdjust = 12;
        } else {
            digitAdjust = 1011;
            terminator = 1023 - terminator;
        }
        int pos = (unscaledValue.bitLength() + 9) / 10 + 1;
        int[] digits = new int[pos];
        digits[--pos] = terminator;
        while (unscaledValue.signum() != 0) {
            BigInteger[] divrem = unscaledValue.divideAndRemainder(EncodingConstants.ONE_THOUSAND);
            if (--pos < 0) {
                int[] newDigits = new int[digits.length + 1];
                System.arraycopy(digits, 0, newDigits, 1, digits.length);
                digits = newDigits;
                pos = 0;
            }
            digits[pos] = divrem[1].intValue() + digitAdjust;
            unscaledValue = divrem[0];
        }
        int accum = 0;
        int bits = 0;
        for (int i = 0; i < digits.length; ++i) {
            accum = accum << 10 | digits[i];
            bits += 10;
            do {
                dst[dstOffset++] = (byte)(accum >> (bits -= 8));
            } while (bits >= 8);
        }
        if (bits != 0) {
            dst[dstOffset++] = (byte)(accum << 8 - bits);
        }
        return dstOffset;
    }

    public static int encode(byte[] value, byte[] dst, int dstOffset) {
        if (value == null) {
            dst[dstOffset] = -1;
            return 1;
        }
        return KeyEncoder.encode(value, 0, value.length, dst, dstOffset, 0);
    }

    public static int encode(byte[] value, int valueOffset, int valueLength, byte[] dst, int dstOffset) {
        return KeyEncoder.encode(value, valueOffset, valueLength, dst, dstOffset, 0);
    }

    public static int encodeDesc(byte[] value, byte[] dst, int dstOffset) {
        if (value == null) {
            dst[dstOffset] = 0;
            return 1;
        }
        return KeyEncoder.encode(value, 0, value.length, dst, dstOffset, -1);
    }

    public static int encodeDesc(byte[] value, int valueOffset, int valueLength, byte[] dst, int dstOffset) {
        return KeyEncoder.encode(value, valueOffset, valueLength, dst, dstOffset, -1);
    }

    private static int encode(byte[] value, int valueOffset, int valueLength, byte[] dst, int dstOffset, int xorMask) {
        if (value == null) {
            dst[dstOffset] = (byte)(0xFFFFFFFF ^ xorMask);
            return 1;
        }
        int originalOffset = dstOffset;
        int accumBits = 0;
        int accum = 0;
        int end = valueOffset + valueLength;
        for (int i = valueOffset; i < end; ++i) {
            if (accumBits <= 7) {
                accum = accum << 8 | value[i] & 0xFF;
                if ((accumBits += 8) != 15) continue;
                KeyEncoder.emitDigit(accum, dst, dstOffset, xorMask);
                dstOffset += 2;
                accum = 0;
                accumBits = 0;
                continue;
            }
            int supply = 15 - accumBits;
            accum = accum << supply | (value[i] & 0xFF) >> 8 - supply;
            KeyEncoder.emitDigit(accum, dst, dstOffset, xorMask);
            dstOffset += 2;
            accumBits = 8 - supply;
            accum = value[i] & (1 << accumBits) - 1;
        }
        if (accumBits > 0) {
            accum <<= 15 - accumBits;
            if (accumBits <= 7) {
                int a = accum * 21845 >> 22;
                if (accum - ((a << 7) + (a << 6)) == 192) {
                    ++a;
                }
                dst[dstOffset++] = (byte)(a + 32 ^ xorMask);
            } else {
                KeyEncoder.emitDigit(accum, dst, dstOffset, xorMask);
                dstOffset += 2;
            }
        }
        dst[dstOffset++] = (byte)(1 ^ xorMask);
        return dstOffset - originalOffset;
    }

    private static void emitDigit(int value, byte[] dst, int dstOffset, int xorMask) {
        int a = value * 21845 >> 22;
        int b = value - ((a << 7) + (a << 6));
        if (b == 192) {
            ++a;
            b = 0;
        }
        dst[dstOffset++] = (byte)(a + 32 ^ xorMask);
        dst[dstOffset] = (byte)(b + 32 ^ xorMask);
    }

    public static int calculateEncodedLength(byte[] value) {
        return value == null ? 1 : KeyEncoder.calculateEncodedLength(value, 0, value.length);
    }

    public static int calculateEncodedLength(byte[] value, int valueOffset, int valueLength) {
        return value == null ? 1 : ((valueLength << 7) + 119) / 120 + 1;
    }

    public static int encode(String value, byte[] dst, int dstOffset) {
        return KeyEncoder.encode(value, dst, dstOffset, 0);
    }

    public static int encodeDesc(String value, byte[] dst, int dstOffset) {
        return KeyEncoder.encode(value, dst, dstOffset, -1);
    }

    private static int encode(String value, byte[] dst, int dstOffset, int xorMask) {
        if (value == null) {
            dst[dstOffset] = (byte)(0xFFFFFFFF ^ xorMask);
            return 1;
        }
        int originalOffset = dstOffset;
        int length = value.length();
        for (int i = 0; i < length; ++i) {
            char c2;
            int a;
            int c = value.charAt(i) + 2;
            if (c <= 127) {
                dst[dstOffset++] = (byte)(c ^ xorMask);
                continue;
            }
            if (c <= 12415) {
                c -= 128;
                if ((c -= ((a = c * 21845 >> 22) << 7) + (a << 6)) == 192) {
                    ++a;
                    c = 0;
                }
                dst[dstOffset++] = (byte)((0x80 | a) ^ xorMask);
                dst[dstOffset++] = (byte)(c + 32 ^ xorMask);
                continue;
            }
            if (c - 2 >= 55296 && c - 2 <= 56319 && i + 1 < length && (c2 = value.charAt(i + 1)) >= '\udc00' && c2 <= '\udfff') {
                c = ((c - 2 & 0x3FF) << 10 | c2 & 0x3FF) + 65538;
                ++i;
            }
            c -= 12416;
            if ((c -= ((a = (int)((long)c * 21845L >> 22)) << 7) + (a << 6)) == 192) {
                ++a;
                c = 0;
            }
            dst[dstOffset + 2] = (byte)(c + 32 ^ xorMask);
            if ((a -= ((c = a * 21845 >> 22) << 7) + (c << 6)) == 192) {
                ++c;
                a = 0;
            }
            dst[dstOffset++] = (byte)((0xC0 | c) ^ xorMask);
            dst[dstOffset++] = (byte)(a + 32 ^ xorMask);
            ++dstOffset;
        }
        dst[dstOffset++] = (byte)(1 ^ xorMask);
        return dstOffset - originalOffset;
    }

    public static int calculateEncodedStringLength(String value) {
        int encodedLen = 1;
        if (value != null) {
            int valueLength = value.length();
            for (int i = 0; i < valueLength; ++i) {
                char c2;
                char c = value.charAt(i);
                if (c <= '}') {
                    ++encodedLen;
                    continue;
                }
                if (c <= '\u307d') {
                    encodedLen += 2;
                    continue;
                }
                if (c >= '\ud800' && c <= '\udbff' && i + 1 < valueLength && (c2 = value.charAt(i + 1)) >= '\udc00' && c2 <= '\udfff') {
                    ++i;
                }
                encodedLen += 3;
            }
        }
        return encodedLen;
    }

    public static byte[] encodeSingleDesc(byte[] value) {
        return KeyEncoder.encodeSingleDesc(value, 0, 0);
    }

    public static byte[] encodeSingleDesc(byte[] value, int prefixPadding, int suffixPadding) {
        int length = value.length;
        if (prefixPadding <= 0 && suffixPadding <= 0 && length == 0) {
            return value;
        }
        byte[] dst = new byte[prefixPadding + length + suffixPadding];
        while (--length >= 0) {
            dst[prefixPadding + length] = ~value[length];
        }
        return dst;
    }

    public static byte[] encodeSingleNullableDesc(byte[] value) {
        return KeyEncoder.encodeSingleNullableDesc(value, 0, 0);
    }

    public static byte[] encodeSingleNullableDesc(byte[] value, int prefixPadding, int suffixPadding) {
        if (prefixPadding <= 0 && suffixPadding <= 0) {
            if (value == null) {
                return new byte[]{0};
            }
            int length = value.length;
            if (length == 0) {
                return new byte[]{127};
            }
            byte[] dst = new byte[1 + length];
            dst[0] = 127;
            while (--length >= 0) {
                dst[1 + length] = ~value[length];
            }
            return dst;
        }
        if (value == null) {
            byte[] dst = new byte[prefixPadding + 1 + suffixPadding];
            dst[prefixPadding] = 0;
            return dst;
        }
        int length = value.length;
        byte[] dst = new byte[prefixPadding + 1 + length + suffixPadding];
        dst[prefixPadding] = 127;
        while (--length >= 0) {
            dst[prefixPadding + 1 + length] = ~value[length];
        }
        return dst;
    }

    private static class CachedBigDecimal {
        static final ThreadLocal<CachedBigDecimal> cLocal = new ThreadLocal();
        final BigDecimal mValue;
        final byte[] mEncoded;
        final int mLength;

        CachedBigDecimal(BigDecimal value, byte[] encoded, int length) {
            this.mValue = value;
            this.mEncoded = encoded;
            this.mLength = length;
        }

        int copyTo(byte[] dst, int dstOffset) {
            int length = this.mLength;
            System.arraycopy(this.mEncoded, 0, dst, dstOffset, length);
            return length;
        }

        int copyDescTo(byte[] dst, int dstOffset) {
            byte[] encoded = this.mEncoded;
            int length = this.mLength;
            for (int i = 0; i < length; ++i) {
                dst[dstOffset++] = ~encoded[i];
            }
            return length;
        }
    }
}

