/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.raw;

import com.amazon.carbonado.CorruptEncodingException;
import com.amazon.carbonado.raw.DataDecoder;
import com.amazon.carbonado.raw.EncodingConstants;
import java.math.BigDecimal;
import java.math.BigInteger;

public class KeyDecoder {
    public static int decodeIntDesc(byte[] src, int srcOffset) throws CorruptEncodingException {
        return ~DataDecoder.decodeInt(src, srcOffset);
    }

    public static Integer decodeIntegerObjDesc(byte[] src, int srcOffset) throws CorruptEncodingException {
        try {
            byte b = src[srcOffset];
            if (b == -1 || b == 0) {
                return null;
            }
            return KeyDecoder.decodeIntDesc(src, srcOffset + 1);
        }
        catch (IndexOutOfBoundsException e) {
            throw new CorruptEncodingException(null, e);
        }
    }

    public static long decodeLongDesc(byte[] src, int srcOffset) throws CorruptEncodingException {
        return DataDecoder.decodeLong(src, srcOffset) ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static Long decodeLongObjDesc(byte[] src, int srcOffset) throws CorruptEncodingException {
        try {
            byte b = src[srcOffset];
            if (b == -1 || b == 0) {
                return null;
            }
            return KeyDecoder.decodeLongDesc(src, srcOffset + 1);
        }
        catch (IndexOutOfBoundsException e) {
            throw new CorruptEncodingException(null, e);
        }
    }

    public static byte decodeByteDesc(byte[] src, int srcOffset) throws CorruptEncodingException {
        try {
            return (byte)(src[srcOffset] ^ 0x7F);
        }
        catch (IndexOutOfBoundsException e) {
            throw new CorruptEncodingException(null, e);
        }
    }

    public static Byte decodeByteObjDesc(byte[] src, int srcOffset) throws CorruptEncodingException {
        try {
            byte b = src[srcOffset];
            if (b == -1 || b == 0) {
                return null;
            }
            return KeyDecoder.decodeByteDesc(src, srcOffset + 1);
        }
        catch (IndexOutOfBoundsException e) {
            throw new CorruptEncodingException(null, e);
        }
    }

    public static short decodeShortDesc(byte[] src, int srcOffset) throws CorruptEncodingException {
        try {
            return (short)((src[srcOffset] << 8 | src[srcOffset + 1] & 0xFF) ^ Short.MAX_VALUE);
        }
        catch (IndexOutOfBoundsException e) {
            throw new CorruptEncodingException(null, e);
        }
    }

    public static Short decodeShortObjDesc(byte[] src, int srcOffset) throws CorruptEncodingException {
        try {
            byte b = src[srcOffset];
            if (b == -1 || b == 0) {
                return null;
            }
            return KeyDecoder.decodeShortDesc(src, srcOffset + 1);
        }
        catch (IndexOutOfBoundsException e) {
            throw new CorruptEncodingException(null, e);
        }
    }

    public static char decodeCharDesc(byte[] src, int srcOffset) throws CorruptEncodingException {
        try {
            return (char)(~(src[srcOffset] << 8 | src[srcOffset + 1] & 0xFF));
        }
        catch (IndexOutOfBoundsException e) {
            throw new CorruptEncodingException(null, e);
        }
    }

    public static Character decodeCharacterObjDesc(byte[] src, int srcOffset) throws CorruptEncodingException {
        try {
            byte b = src[srcOffset];
            if (b == -1 || b == 0) {
                return null;
            }
            return Character.valueOf(KeyDecoder.decodeCharDesc(src, srcOffset + 1));
        }
        catch (IndexOutOfBoundsException e) {
            throw new CorruptEncodingException(null, e);
        }
    }

    public static boolean decodeBooleanDesc(byte[] src, int srcOffset) throws CorruptEncodingException {
        try {
            return src[srcOffset] == 127;
        }
        catch (IndexOutOfBoundsException e) {
            throw new CorruptEncodingException(null, e);
        }
    }

    public static Boolean decodeBooleanObjDesc(byte[] src, int srcOffset) throws CorruptEncodingException {
        try {
            switch (src[srcOffset]) {
                case -1: 
                case 0: {
                    return null;
                }
                case 127: {
                    return Boolean.TRUE;
                }
            }
            return Boolean.FALSE;
        }
        catch (IndexOutOfBoundsException e) {
            throw new CorruptEncodingException(null, e);
        }
    }

    public static float decodeFloatDesc(byte[] src, int srcOffset) throws CorruptEncodingException {
        int bits = DataDecoder.decodeFloatBits(src, srcOffset);
        if (bits >= 0) {
            bits ^= Integer.MAX_VALUE;
        }
        return Float.intBitsToFloat(bits);
    }

    public static Float decodeFloatObjDesc(byte[] src, int srcOffset) throws CorruptEncodingException {
        int bits = DataDecoder.decodeFloatBits(src, srcOffset);
        if (bits >= 0) {
            bits ^= Integer.MAX_VALUE;
        }
        return bits == Integer.MAX_VALUE ? null : Float.valueOf(Float.intBitsToFloat(bits));
    }

    public static double decodeDoubleDesc(byte[] src, int srcOffset) throws CorruptEncodingException {
        long bits = DataDecoder.decodeDoubleBits(src, srcOffset);
        if (bits >= 0L) {
            bits ^= Long.MAX_VALUE;
        }
        return Double.longBitsToDouble(bits);
    }

    public static Double decodeDoubleObjDesc(byte[] src, int srcOffset) throws CorruptEncodingException {
        long bits = DataDecoder.decodeDoubleBits(src, srcOffset);
        if (bits >= 0L) {
            bits ^= Long.MAX_VALUE;
        }
        return bits == Long.MAX_VALUE ? null : Double.valueOf(Double.longBitsToDouble(bits));
    }

    public static int decode(byte[] src, int srcOffset, BigInteger[] valueRef) throws CorruptEncodingException {
        byte[] bytes;
        int headerSize;
        int bytesLength;
        try {
            int header = src[srcOffset];
            if (header == -1 || header == 0) {
                valueRef[0] = null;
                return 1;
            }
            if ((header &= 0xFF) > 1 && header < 254) {
                bytesLength = header < 128 ? 128 - header : header - 127;
                headerSize = 1;
            } else {
                bytesLength = Math.abs(DataDecoder.decodeInt(src, srcOffset + 1));
                headerSize = 5;
            }
            bytes = new byte[bytesLength];
            System.arraycopy(src, srcOffset + headerSize, bytes, 0, bytesLength);
        }
        catch (IndexOutOfBoundsException e) {
            throw new CorruptEncodingException(null, e);
        }
        valueRef[0] = new BigInteger(bytes);
        return headerSize + bytesLength;
    }

    public static int decodeDesc(byte[] src, int srcOffset, BigInteger[] valueRef) throws CorruptEncodingException {
        byte[] bytes;
        int headerSize;
        int bytesLength;
        try {
            int header = src[srcOffset];
            if (header == -1 || header == 0) {
                valueRef[0] = null;
                return 1;
            }
            if ((header &= 0xFF) > 1 && header < 254) {
                bytesLength = header < 128 ? 128 - header : header - 127;
                headerSize = 1;
            } else {
                bytesLength = Math.abs(DataDecoder.decodeInt(src, srcOffset + 1));
                headerSize = 5;
            }
            bytes = new byte[bytesLength];
            srcOffset += headerSize;
            for (int i = 0; i < bytesLength; ++i) {
                bytes[i] = ~src[srcOffset + i];
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new CorruptEncodingException(null, e);
        }
        valueRef[0] = new BigInteger(bytes);
        return headerSize + bytesLength;
    }

    public static int decode(byte[] src, int srcOffset, BigDecimal[] valueRef) throws CorruptEncodingException {
        return KeyDecoder.decode(src, srcOffset, valueRef, 0);
    }

    public static int decodeDesc(byte[] src, int srcOffset, BigDecimal[] valueRef) throws CorruptEncodingException {
        return KeyDecoder.decode(src, srcOffset, valueRef, -1);
    }

    private static int decode(byte[] src, int srcOffset, BigDecimal[] valueRef, int xorMask) throws CorruptEncodingException {
        int scale;
        BigInteger unscaledValue;
        int originalOffset = srcOffset;
        try {
            int exponent;
            int digitAdjust;
            int header = (src[srcOffset] ^ xorMask) & 0xFF;
            switch (header) {
                case 0: 
                case 255: {
                    valueRef[0] = null;
                    return 1;
                }
                case 127: 
                case 128: {
                    valueRef[0] = BigDecimal.ZERO;
                    return 1;
                }
                case 1: 
                case 126: {
                    digitAdjust = 1011;
                    exponent = ~DataDecoder.decodeInt(src, srcOffset + 1) ^ xorMask;
                    srcOffset += 5;
                    break;
                }
                case 129: 
                case 254: {
                    digitAdjust = 12;
                    exponent = DataDecoder.decodeInt(src, srcOffset + 1) ^ xorMask;
                    srcOffset += 5;
                    break;
                }
                default: {
                    exponent = (src[srcOffset++] ^ xorMask) & 0xFF;
                    if (exponent >= 130) {
                        digitAdjust = 12;
                        exponent -= 192;
                        break;
                    }
                    digitAdjust = 1011;
                    exponent = 63 - exponent;
                }
            }
            unscaledValue = null;
            int precision = 0;
            int accum = 0;
            int bits = 0;
            BigInteger lastDigit = null;
            block13: while (true) {
                accum = accum << 8 | (src[srcOffset++] ^ xorMask) & 0xFF;
                if ((bits += 8) < 10) continue;
                int digit = accum >> bits - 10 & 0x3FF;
                switch (digit) {
                    case 0: 
                    case 1023: {
                        lastDigit = lastDigit.divide(EncodingConstants.ONE_HUNDRED);
                        unscaledValue = unscaledValue == null ? lastDigit : unscaledValue.multiply(BigInteger.TEN).add(lastDigit);
                        ++precision;
                        break block13;
                    }
                    case 1: 
                    case 1022: {
                        lastDigit = lastDigit.divide(BigInteger.TEN);
                        unscaledValue = unscaledValue == null ? lastDigit : unscaledValue.multiply(EncodingConstants.ONE_HUNDRED).add(lastDigit);
                        precision += 2;
                        break block13;
                    }
                    case 2: 
                    case 1021: {
                        unscaledValue = unscaledValue == null ? lastDigit : unscaledValue.multiply(EncodingConstants.ONE_THOUSAND).add(lastDigit);
                        precision += 3;
                        break block13;
                    }
                    default: {
                        if (unscaledValue == null) {
                            unscaledValue = lastDigit;
                            if (unscaledValue != null) {
                                precision += 3;
                            }
                        } else {
                            unscaledValue = unscaledValue.multiply(EncodingConstants.ONE_THOUSAND).add(lastDigit);
                            precision += 3;
                        }
                        bits -= 10;
                        lastDigit = BigInteger.valueOf(digit - digitAdjust);
                        continue block13;
                    }
                }
                break;
            }
            scale = precision - exponent;
        }
        catch (IndexOutOfBoundsException e) {
            throw new CorruptEncodingException(null, e);
        }
        valueRef[0] = new BigDecimal(unscaledValue, scale);
        return srcOffset - originalOffset;
    }

    public static int decode(byte[] src, int srcOffset, byte[][] valueRef) throws CorruptEncodingException {
        try {
            return KeyDecoder.decode(src, srcOffset, valueRef, 0);
        }
        catch (IndexOutOfBoundsException e) {
            throw new CorruptEncodingException(null, e);
        }
    }

    public static int decodeDesc(byte[] src, int srcOffset, byte[][] valueRef) throws CorruptEncodingException {
        try {
            return KeyDecoder.decode(src, srcOffset, valueRef, -1);
        }
        catch (IndexOutOfBoundsException e) {
            throw new CorruptEncodingException(null, e);
        }
    }

    private static int decode(byte[] src, int srcOffset, byte[][] valueRef, int xorMask) {
        int d;
        byte b;
        int srcEnd = srcOffset;
        while (-32 > (b = src[srcEnd++]) || b >= 32) {
        }
        if ((b == -1 || b == 0) && srcEnd - 1 <= srcOffset) {
            valueRef[0] = null;
            return 1;
        }
        if (srcEnd - srcOffset == 1) {
            valueRef[0] = EncodingConstants.EMPTY_BYTE_ARRAY;
            return 1;
        }
        int valueLength = (srcEnd - srcOffset - 1) * 120 >> 7;
        byte[] value = new byte[valueLength];
        int valueOffset = 0;
        int originalOffset = srcOffset;
        int accumBits = 0;
        int accum = 0;
        while (true) {
            int b2;
            d = (src[srcOffset++] ^ xorMask) & 0xFF;
            if (srcOffset == srcEnd || (b2 = (src[srcOffset++] ^ xorMask) & 0xFF) < 32 || b2 > 223) {
                d -= 32;
                break;
            }
            d -= 32;
            d = (d << 7) + (d << 6) + b2 - 32;
            accum = accum << 15 | d;
            if ((accumBits += 15) == 15) {
                value[valueOffset++] = (byte)(accum >> 7);
            } else {
                value[valueOffset++] = (byte)(accum >> accumBits - 8);
                value[valueOffset++] = (byte)(accum >> (accumBits -= 8) - 8);
            }
            accumBits -= 8;
        }
        d = (d << 7) + (d << 6) + 191;
        accum = accum << 15 | d;
        if ((accumBits += 15) >= 8 && valueOffset < valueLength) {
            value[valueOffset] = (byte)(accum >> accumBits - 8);
        }
        valueRef[0] = value;
        return srcOffset - originalOffset;
    }

    public static int decodeString(byte[] src, int srcOffset, String[] valueRef) throws CorruptEncodingException {
        try {
            return KeyDecoder.decodeString(src, srcOffset, valueRef, 0);
        }
        catch (IndexOutOfBoundsException e) {
            throw new CorruptEncodingException(null, e);
        }
    }

    public static int decodeStringDesc(byte[] src, int srcOffset, String[] valueRef) throws CorruptEncodingException {
        try {
            return KeyDecoder.decodeString(src, srcOffset, valueRef, -1);
        }
        catch (IndexOutOfBoundsException e) {
            throw new CorruptEncodingException(null, e);
        }
    }

    private static int decodeString(byte[] src, int srcOffset, String[] valueRef, int xorMask) throws CorruptEncodingException {
        byte b;
        int srcEnd = srcOffset;
        while (-2 > (b = src[srcEnd++]) || b >= 2) {
        }
        if ((b == -1 || b == 0) && srcEnd - 1 <= srcOffset) {
            valueRef[0] = null;
            return 1;
        }
        if (srcEnd - srcOffset == 1) {
            valueRef[0] = "";
            return 1;
        }
        char[] value = new char[srcEnd - srcOffset];
        int valueOffset = 0;
        int originalOffset = srcOffset;
        block6: while (srcOffset < srcEnd) {
            int c = (src[srcOffset++] ^ xorMask) & 0xFF;
            switch (c >> 5) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    value[valueOffset++] = (char)(c - 2);
                    continue block6;
                }
                case 4: 
                case 5: {
                    value[valueOffset++] = (char)(((c &= 0x3F) << 7) + (c << 6) + ((src[srcOffset++] ^ xorMask) & 0xFF) + 94);
                    continue block6;
                }
                case 6: {
                    c &= 0x1F;
                    c = (c << 7) + (c << 6) + ((src[srcOffset++] ^ xorMask) & 0xFF) - 32;
                    c = (c << 7) + (c << 6) + ((src[srcOffset++] ^ xorMask) & 0xFF) + 12382;
                    if (c >= 65536) {
                        value[valueOffset++] = (char)(0xD800 | (c -= 65536) >> 10 & 0x3FF);
                        value[valueOffset++] = (char)(0xDC00 | c & 0x3FF);
                        continue block6;
                    }
                    value[valueOffset++] = (char)c;
                    continue block6;
                }
            }
            throw new CorruptEncodingException("Corrupt encoded string data (source offset = " + (srcOffset - 1) + ')');
        }
        valueRef[0] = new String(value, 0, valueOffset - 1);
        return srcEnd - originalOffset;
    }

    public static byte[] decodeSingleDesc(byte[] src) throws CorruptEncodingException {
        return KeyDecoder.decodeSingleDesc(src, 0, 0);
    }

    public static byte[] decodeSingleDesc(byte[] src, int prefixPadding, int suffixPadding) throws CorruptEncodingException {
        try {
            int length = src.length - suffixPadding - prefixPadding;
            if (length == 0) {
                return EncodingConstants.EMPTY_BYTE_ARRAY;
            }
            byte[] dst = new byte[length];
            while (--length >= 0) {
                dst[length] = ~src[prefixPadding + length];
            }
            return dst;
        }
        catch (IndexOutOfBoundsException e) {
            throw new CorruptEncodingException(null, e);
        }
    }

    public static byte[] decodeSingleNullableDesc(byte[] src) throws CorruptEncodingException {
        return KeyDecoder.decodeSingleNullableDesc(src, 0, 0);
    }

    public static byte[] decodeSingleNullableDesc(byte[] src, int prefixPadding, int suffixPadding) throws CorruptEncodingException {
        try {
            byte b = src[prefixPadding];
            if (b == -1 || b == 0) {
                return null;
            }
            int length = src.length - suffixPadding - 1 - prefixPadding;
            if (length == 0) {
                return EncodingConstants.EMPTY_BYTE_ARRAY;
            }
            byte[] dst = new byte[length];
            while (--length >= 0) {
                dst[length] = ~src[1 + prefixPadding + length];
            }
            return dst;
        }
        catch (IndexOutOfBoundsException e) {
            throw new CorruptEncodingException(null, e);
        }
    }
}

