/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.raw;

import com.amazon.carbonado.CorruptEncodingException;
import com.amazon.carbonado.SupportException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterOutputStream;

public class GzipCompressor {
    private static final ThreadLocal<Deflater> cLocalDeflater = new ThreadLocal();
    private static final ThreadLocal<Inflater> cLocalInflater = new ThreadLocal();

    public static byte[] compress(byte[] value, int prefix) throws SupportException {
        Deflater compressor = cLocalDeflater.get();
        if (compressor == null) {
            compressor = new Deflater();
            cLocalDeflater.set(compressor);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream(value.length);
        try {
            bos.write(value, 0, prefix);
            DeflaterOutputStream dout = new DeflaterOutputStream((OutputStream)bos, compressor);
            dout.write(value, prefix, value.length - prefix);
            dout.close();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new SupportException(e);
        }
        finally {
            compressor.reset();
        }
    }

    public static byte[] decompress(byte[] value, int prefix) throws CorruptEncodingException {
        Inflater inflater = cLocalInflater.get();
        if (inflater == null) {
            inflater = new Inflater();
            cLocalInflater.set(inflater);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream(value.length * 2);
        try {
            bos.write(value, 0, prefix);
            InflaterOutputStream ios = new InflaterOutputStream(bos, inflater);
            ios.write(value, prefix, value.length - prefix);
            ios.close();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new CorruptEncodingException(e);
        }
        finally {
            inflater.reset();
        }
    }
}

