/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.raw;

import com.amazon.carbonado.CorruptEncodingException;
import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.FetchNoneException;
import com.amazon.carbonado.RepositoryException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.SupportException;
import com.amazon.carbonado.gen.CodeBuilderUtil;
import com.amazon.carbonado.gen.TriggerSupport;
import com.amazon.carbonado.info.Direction;
import com.amazon.carbonado.info.OrderedProperty;
import com.amazon.carbonado.info.StorableIndex;
import com.amazon.carbonado.info.StorableIntrospector;
import com.amazon.carbonado.info.StorableProperty;
import com.amazon.carbonado.layout.Layout;
import com.amazon.carbonado.raw.GenericEncodingStrategy;
import com.amazon.carbonado.raw.GenericInstanceFactory;
import com.amazon.carbonado.raw.GenericStorableCodecFactory;
import com.amazon.carbonado.raw.RawStorableGenerator;
import com.amazon.carbonado.raw.RawSupport;
import com.amazon.carbonado.raw.StorableCodec;
import com.amazon.carbonado.util.QuickConstructorGenerator;
import com.amazon.carbonado.util.SoftValuedCache;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Map;
import org.cojen.classfile.ClassFile;
import org.cojen.classfile.CodeAssembler;
import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.Label;
import org.cojen.classfile.LocalVariable;
import org.cojen.classfile.Location;
import org.cojen.classfile.MethodInfo;
import org.cojen.classfile.Modifiers;
import org.cojen.classfile.TypeDesc;
import org.cojen.util.ClassInjector;
import org.cojen.util.IntHashMap;
import org.cojen.util.KeyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericStorableCodec<S extends Storable>
implements StorableCodec<S> {
    private static final String BLANK_KEY_FIELD_NAME = "blankKey$";
    private static final SoftValuedCache cCache = SoftValuedCache.newCache(11);
    private static final SoftValuedCache cCodecSearchKeyFactories = SoftValuedCache.newCache(11);
    private static final SoftValuedCache cCodecDecoders = SoftValuedCache.newCache(11);
    private final Object mCodecKey;
    private final GenericStorableCodecFactory mFactory;
    private final Class<S> mType;
    private final Class<? extends S> mStorableClass;
    private final GenericEncodingStrategy<S> mEncodingStrategy;
    private final GenericInstanceFactory mInstanceFactory;
    private final SearchKeyFactory<S> mPrimaryKeyFactory;
    private final Layout mLayout;
    private final RawSupport<S> mSupport;
    private IntHashMap mDecoders;

    static synchronized <S extends Storable> GenericStorableCodec<S> getInstance(GenericStorableCodecFactory factory, GenericEncodingStrategy<S> encodingStrategy, boolean isMaster, Layout layout, RawSupport support) throws SupportException {
        LayoutKey layoutKey = layout == null ? null : new LayoutKey(layout);
        Object key = KeyFactory.createKey((Object[])new Object[]{encodingStrategy, isMaster, layoutKey});
        Class<S> storableImpl = (Class<S>)cCache.get(key);
        if (storableImpl == null) {
            storableImpl = GenericStorableCodec.generateStorable(encodingStrategy, isMaster, layout);
            cCache.put(key, storableImpl);
        }
        return new GenericStorableCodec<S>(key, factory, encodingStrategy.getType(), storableImpl, encodingStrategy, layout, support);
    }

    private static <S extends Storable> Class<? extends S> generateStorable(GenericEncodingStrategy<S> encodingStrategy, boolean isMaster, Layout layout) throws SupportException {
        Class<S> storableClass = encodingStrategy.getType();
        Class<S> abstractClass = RawStorableGenerator.getAbstractClass(storableClass, isMaster);
        int generation = layout == null ? -1 : layout.getGeneration();
        ClassInjector ci = ClassInjector.create((String)storableClass.getName(), (ClassLoader)abstractClass.getClassLoader());
        ClassFile cf = new ClassFile(ci.getClassName(), abstractClass);
        cf.markSynthetic();
        cf.setSourceFile(GenericStorableCodec.class.getName());
        cf.setTarget("1.5");
        TypeDesc storableType = TypeDesc.forClass(Storable.class);
        TypeDesc triggerSupportType = TypeDesc.forClass(TriggerSupport.class);
        TypeDesc rawSupportType = TypeDesc.forClass(RawSupport.class);
        TypeDesc byteArrayType = TypeDesc.forClass(byte[].class);
        TypeDesc[] byteArrayParam = new TypeDesc[]{byteArrayType};
        for (int i = 1; i <= 3; ++i) {
            TypeDesc[] params = new TypeDesc[i];
            params[0] = rawSupportType;
            if (i >= 2) {
                params[1] = byteArrayType;
                if (i == 3) {
                    params[2] = byteArrayType;
                }
            }
            MethodInfo mi = cf.addConstructor(Modifiers.PUBLIC, params);
            CodeBuilder b = new CodeBuilder(mi);
            b.loadThis();
            b.loadLocal(b.getParameter(0));
            if (i >= 2) {
                b.loadLocal(b.getParameter(1));
                if (i == 3) {
                    b.loadLocal(b.getParameter(2));
                }
            }
            b.invokeSuperConstructor(params);
            b.returnVoid();
        }
        CodeBuilderUtil.definePrepareMethod(cf, storableClass, rawSupportType);
        MethodInfo mi = cf.addMethod(Modifiers.PROTECTED, "encodeKey$", byteArrayType, null);
        CodeBuilder b = new CodeBuilder(mi);
        LocalVariable encodedVar = encodingStrategy.buildKeyEncoding((CodeAssembler)b, null, null, null, false, null, null);
        b.loadLocal(encodedVar);
        b.returnValue(byteArrayType);
        mi = cf.addMethod(Modifiers.PROTECTED, "encodeData$", byteArrayType, null);
        b = new CodeBuilder(mi);
        encodedVar = encodingStrategy.buildDataEncoding((CodeAssembler)b, null, null, null, false, generation);
        b.loadLocal(encodedVar);
        b.returnValue(byteArrayType);
        mi = cf.addMethod(Modifiers.PROTECTED, "decodeKey$", null, byteArrayParam);
        b = new CodeBuilder(mi);
        encodingStrategy.buildKeyDecoding((CodeAssembler)b, null, null, null, false, b.getParameter(0));
        b.returnVoid();
        mi = cf.addMethod(Modifiers.PROTECTED, "decodeData$", null, byteArrayParam);
        b = new CodeBuilder(mi);
        Label tryStartDecode = b.createLabel().setLocation();
        Label altGenerationHandler = b.createLabel();
        encodingStrategy.buildDataDecoding((CodeAssembler)b, null, null, null, false, generation, altGenerationHandler, b.getParameter(0));
        b.returnVoid();
        altGenerationHandler.setLocation();
        LocalVariable actualGeneration = b.createLocalVariable(null, TypeDesc.INT);
        b.storeLocal(actualGeneration);
        b.loadThis();
        b.loadField("support$", triggerSupportType);
        b.checkCast(rawSupportType);
        b.loadThis();
        b.loadLocal(actualGeneration);
        b.loadLocal(b.getParameter(0));
        b.invokeInterface(rawSupportType, "decode", null, new TypeDesc[]{storableType, TypeDesc.INT, byteArrayType});
        b.returnVoid();
        Label tryEndDecode = b.createLabel().setLocation();
        b.exceptionHandler((Location)tryStartDecode, (Location)tryEndDecode, CorruptEncodingException.class.getName());
        TypeDesc exType = TypeDesc.forClass(CorruptEncodingException.class);
        LocalVariable exVar = b.createLocalVariable(null, TypeDesc.OBJECT);
        b.storeLocal(exVar);
        b.loadLocal(exVar);
        b.loadThis();
        b.invokeVirtual(exType, "setStorableWithPrimaryKey", null, new TypeDesc[]{storableType});
        b.loadLocal(exVar);
        b.throwObject();
        return ci.defineClass(cf);
    }

    private GenericStorableCodec(Object codecKey, GenericStorableCodecFactory factory, Class<S> type, Class<? extends S> storableClass, GenericEncodingStrategy<S> encodingStrategy, Layout layout, RawSupport<S> support) {
        this.mCodecKey = codecKey;
        this.mFactory = factory;
        this.mType = type;
        this.mStorableClass = storableClass;
        this.mEncodingStrategy = encodingStrategy;
        this.mInstanceFactory = QuickConstructorGenerator.getInstance(storableClass, GenericInstanceFactory.class);
        this.mPrimaryKeyFactory = this.getSearchKeyFactory(encodingStrategy.gatherAllKeyProperties());
        this.mLayout = layout;
        this.mSupport = support;
    }

    @Override
    public final Class<S> getStorableType() {
        return this.mType;
    }

    @Override
    public S instantiate() {
        return (S)this.mInstanceFactory.instantiate(this.support());
    }

    @Override
    public S instantiate(byte[] key, byte[] value) throws FetchException {
        return (S)this.mInstanceFactory.instantiate(this.support(), key, value);
    }

    @Override
    public S instantiate(RawSupport<S> support) {
        return (S)this.mInstanceFactory.instantiate(support);
    }

    @Override
    public S instantiate(RawSupport<S> support, byte[] key, byte[] value) throws FetchException {
        try {
            return (S)this.mInstanceFactory.instantiate(support, key, value);
        }
        catch (CorruptEncodingException e) {
            try {
                e.setStorableWithPrimaryKey(this.mInstanceFactory.instantiate(support, key));
            }
            catch (FetchException e2) {
                // empty catch block
            }
            throw e;
        }
    }

    @Override
    public StorableIndex<S> getPrimaryKeyIndex() {
        return this.mEncodingStrategy.getPrimaryKeyIndex();
    }

    @Override
    public int getPrimaryKeyPrefixLength() {
        return this.mEncodingStrategy.getConstantKeyPrefixLength();
    }

    @Override
    public byte[] encodePrimaryKey(S storable) {
        return this.mPrimaryKeyFactory.encodeSearchKey(storable);
    }

    @Override
    public byte[] encodePrimaryKey(S storable, int rangeStart, int rangeEnd) {
        return this.mPrimaryKeyFactory.encodeSearchKey(storable, rangeStart, rangeEnd);
    }

    @Override
    public byte[] encodePrimaryKey(Object[] values) {
        return this.mPrimaryKeyFactory.encodeSearchKey(values);
    }

    @Override
    public byte[] encodePrimaryKey(Object[] values, int rangeStart, int rangeEnd) {
        return this.mPrimaryKeyFactory.encodeSearchKey(values, rangeStart, rangeEnd);
    }

    @Override
    public byte[] encodePrimaryKeyPrefix() {
        return this.mPrimaryKeyFactory.encodeSearchKeyPrefix();
    }

    @Override
    public RawSupport<S> getSupport() {
        return this.mSupport;
    }

    private RawSupport<S> support() {
        RawSupport<S> support = this.mSupport;
        if (support == null) {
            throw new IllegalStateException("No RawSupport");
        }
        return support;
    }

    public Class<? extends S> getStorableClass() {
        return this.mStorableClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchKeyFactory<S> getSearchKeyFactory(OrderedProperty<S>[] properties) {
        Object key = KeyFactory.createKey((Object[])new Object[]{this.mCodecKey, properties});
        SoftValuedCache softValuedCache = cCodecSearchKeyFactories;
        synchronized (softValuedCache) {
            SearchKeyFactory<S> factory = (SearchKeyFactory<S>)cCodecSearchKeyFactories.get(key);
            if (factory == null) {
                factory = this.generateSearchKeyFactory(properties);
                cCodecSearchKeyFactories.put(key, factory);
            }
            return factory;
        }
    }

    @Override
    public void decode(S dest, int generation, byte[] data) throws CorruptEncodingException {
        try {
            this.getDecoder(generation).decode(dest, data);
        }
        catch (CorruptEncodingException e) {
            throw e;
        }
        catch (RepositoryException e) {
            throw new CorruptEncodingException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Decoder<S> getDecoder(int generation) throws FetchNoneException, FetchException {
        try {
            Layout layout = this.mLayout;
            synchronized (layout) {
                Decoder<S> decoder;
                IntHashMap decoders = this.mDecoders;
                if (decoders == null) {
                    this.mDecoders = decoders = new IntHashMap();
                }
                if ((decoder = (Decoder<S>)decoders.get(generation)) == null) {
                    SoftValuedCache softValuedCache = cCodecDecoders;
                    synchronized (softValuedCache) {
                        Object key = KeyFactory.createKey((Object[])new Object[]{this.mCodecKey, generation});
                        decoder = (Decoder)cCodecDecoders.get(key);
                        if (decoder == null) {
                            decoder = this.generateDecoder(generation);
                            cCodecDecoders.put(key, decoder);
                        } else {
                            try {
                                this.mLayout.getGeneration(generation);
                            }
                            catch (FetchNoneException e) {
                                cCodecDecoders.remove(key);
                                throw e;
                            }
                        }
                    }
                    this.mDecoders.put(generation, decoder);
                }
                return decoder;
            }
        }
        catch (NullPointerException e) {
            if (this.mLayout == null) {
                throw new FetchNoneException("Layout evolution not supported");
            }
            throw e;
        }
    }

    private SearchKeyFactory<S> generateSearchKeyFactory(OrderedProperty<S>[] properties) {
        CodeBuilder b;
        MethodInfo mi;
        LocalVariable encodedVar;
        LocalVariable instanceVar;
        CodeBuilder b2;
        MethodInfo mi2;
        StringBuilder b3 = new StringBuilder();
        b3.append(this.mType.getName());
        b3.append('$');
        for (OrderedProperty<S> property : properties) {
            if (property.getDirection() == Direction.UNSPECIFIED) {
                property = property.direction(Direction.ASCENDING);
            }
            try {
                property.appendTo(b3);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        String prefix = b3.toString();
        ClassInjector ci = ClassInjector.create((String)prefix, (ClassLoader)this.mStorableClass.getClassLoader());
        ClassFile cf = new ClassFile(ci.getClassName());
        cf.addInterface(SearchKeyFactory.class);
        cf.markSynthetic();
        cf.setSourceFile(GenericStorableCodec.class.getName());
        cf.setTarget("1.5");
        cf.addDefaultConstructor();
        TypeDesc storableType = TypeDesc.forClass(Storable.class);
        TypeDesc byteArrayType = TypeDesc.forClass(byte[].class);
        TypeDesc objectArrayType = TypeDesc.forClass(Object[].class);
        TypeDesc instanceType = TypeDesc.forClass(this.mStorableClass);
        try {
            mi2 = cf.addMethod(Modifiers.PUBLIC, "encodeSearchKey", byteArrayType, new TypeDesc[]{storableType});
            b2 = new CodeBuilder(mi2);
            b2.loadLocal(b2.getParameter(0));
            b2.checkCast(instanceType);
            instanceVar = b2.createLocalVariable(null, instanceType);
            b2.storeLocal(instanceVar);
            encodedVar = this.mEncodingStrategy.buildKeyEncoding((CodeAssembler)b2, properties, instanceVar, null, false, null, null);
            b2.loadLocal(encodedVar);
            b2.returnValue(byteArrayType);
        }
        catch (SupportException e) {
            throw new UndeclaredThrowableException(e);
        }
        try {
            mi2 = cf.addMethod(Modifiers.PUBLIC, "encodeSearchKey", byteArrayType, new TypeDesc[]{storableType, TypeDesc.INT, TypeDesc.INT});
            b2 = new CodeBuilder(mi2);
            b2.loadLocal(b2.getParameter(0));
            b2.checkCast(instanceType);
            instanceVar = b2.createLocalVariable(null, instanceType);
            b2.storeLocal(instanceVar);
            encodedVar = this.mEncodingStrategy.buildKeyEncoding((CodeAssembler)b2, properties, instanceVar, null, false, b2.getParameter(1), b2.getParameter(2));
            b2.loadLocal(encodedVar);
            b2.returnValue(byteArrayType);
        }
        catch (SupportException e) {
            throw new UndeclaredThrowableException(e);
        }
        Class<S> adapterInstanceClass = this.getStorableClass().getSuperclass();
        try {
            mi = cf.addMethod(Modifiers.PUBLIC, "encodeSearchKey", byteArrayType, new TypeDesc[]{objectArrayType});
            b = new CodeBuilder(mi);
            encodedVar = this.mEncodingStrategy.buildKeyEncoding((CodeAssembler)b, properties, b.getParameter(0), adapterInstanceClass, false, null, null);
            b.loadLocal(encodedVar);
            b.returnValue(byteArrayType);
        }
        catch (SupportException e) {
            throw new UndeclaredThrowableException(e);
        }
        try {
            mi = cf.addMethod(Modifiers.PUBLIC, "encodeSearchKey", byteArrayType, new TypeDesc[]{objectArrayType, TypeDesc.INT, TypeDesc.INT});
            b = new CodeBuilder(mi);
            encodedVar = this.mEncodingStrategy.buildKeyEncoding((CodeAssembler)b, properties, b.getParameter(0), adapterInstanceClass, false, b.getParameter(1), b.getParameter(2));
            b.loadLocal(encodedVar);
            b.returnValue(byteArrayType);
        }
        catch (SupportException e) {
            throw new UndeclaredThrowableException(e);
        }
        try {
            mi = cf.addMethod(Modifiers.PUBLIC, "encodeSearchKeyPrefix", byteArrayType, null);
            b = new CodeBuilder(mi);
            if (this.mEncodingStrategy.getKeyPrefixPadding() == 0 && this.mEncodingStrategy.getKeySuffixPadding() == 0) {
                b.loadNull();
                b.returnValue(byteArrayType);
            } else {
                cf.addField(Modifiers.PRIVATE.toStatic(true).toFinal(true), BLANK_KEY_FIELD_NAME, byteArrayType);
                b.loadStaticField(BLANK_KEY_FIELD_NAME, byteArrayType);
                b.returnValue(byteArrayType);
                mi = cf.addInitializer();
                b = new CodeBuilder(mi);
                encodedVar = this.mEncodingStrategy.buildKeyEncoding((CodeAssembler)b, new OrderedProperty[0], null, null, false, null, null);
                b.loadLocal(encodedVar);
                b.storeStaticField(BLANK_KEY_FIELD_NAME, byteArrayType);
                b.returnVoid();
            }
        }
        catch (SupportException e) {
            throw new UndeclaredThrowableException(e);
        }
        Class clazz = ci.defineClass(cf);
        try {
            return (SearchKeyFactory)clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new UndeclaredThrowableException(e);
        }
        catch (IllegalAccessException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    private Decoder<S> generateDecoder(int generation) throws FetchException {
        GenericEncodingStrategy<? extends Storable> altStrategy;
        Class<? extends Storable> altStorable;
        try {
            Layout altLayout = this.mLayout.getGeneration(generation);
            altStorable = altLayout.reconstruct(this.mStorableClass.getClassLoader());
            altStrategy = this.mFactory.createStrategy(altStorable, null, altLayout.getOptions());
        }
        catch (RepositoryException e) {
            throw new CorruptEncodingException(e);
        }
        ClassInjector ci = ClassInjector.create((String)this.mType.getName(), (ClassLoader)this.mStorableClass.getClassLoader());
        ClassFile cf = new ClassFile(ci.getClassName());
        cf.addInterface(Decoder.class);
        cf.markSynthetic();
        cf.setSourceFile(GenericStorableCodec.class.getName());
        cf.setTarget("1.5");
        cf.addDefaultConstructor();
        TypeDesc storableType = TypeDesc.forClass(Storable.class);
        TypeDesc byteArrayType = TypeDesc.forClass(byte[].class);
        MethodInfo mi = cf.addMethod(Modifiers.PUBLIC, "decode", null, new TypeDesc[]{storableType, byteArrayType});
        CodeBuilder b = new CodeBuilder(mi);
        LocalVariable uncastDestVar = b.getParameter(0);
        b.loadLocal(uncastDestVar);
        LocalVariable destVar = b.createLocalVariable(null, TypeDesc.forClass(this.mStorableClass));
        b.checkCast(destVar.getType());
        b.storeLocal(destVar);
        LocalVariable dataVar = b.getParameter(1);
        try {
            altStrategy.buildDataDecoding((CodeAssembler)b, null, destVar, null, false, generation, null, dataVar);
        }
        catch (SupportException e) {
            throw new CorruptEncodingException(e);
        }
        Map<String, StorableProperty<S>> currentProps = StorableIntrospector.examine(this.mType).getAllProperties();
        Map<String, StorableProperty<? extends Storable>> altProps = StorableIntrospector.examine(altStorable).getAllProperties();
        for (StorableProperty<S> prop : currentProps.values()) {
            if (prop.isDerived() || prop.isJoin() || altProps.keySet().contains(prop.getName())) continue;
            b.loadLocal(destVar);
            TypeDesc propType = TypeDesc.forClass(prop.getType());
            switch (propType.getTypeCode()) {
                case 0: {
                    b.loadNull();
                    break;
                }
                case 11: {
                    b.loadConstant(0L);
                    break;
                }
                case 6: {
                    b.loadConstant(0.0f);
                    break;
                }
                case 7: {
                    b.loadConstant(0.0);
                    break;
                }
                default: {
                    b.loadConstant(0);
                }
            }
            b.storeField(destVar.getType(), prop.getName(), propType);
        }
        b.returnVoid();
        Class clazz = ci.defineClass(cf);
        try {
            return (Decoder)clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new UndeclaredThrowableException(e);
        }
        catch (IllegalAccessException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    private static class LayoutKey {
        private final Layout mLayout;

        LayoutKey(Layout layout) {
            this.mLayout = layout;
        }

        public int hashCode() {
            return this.mLayout.getStorableTypeName().hashCode() * 7 + this.mLayout.getGeneration();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof LayoutKey) {
                LayoutKey other = (LayoutKey)obj;
                try {
                    return this.mLayout.getStorableTypeName().equals(other.mLayout.getStorableTypeName()) && this.mLayout.getGeneration() == other.mLayout.getGeneration() && this.mLayout.equalLayouts(other.mLayout);
                }
                catch (FetchException e) {
                    return false;
                }
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Decoder<S extends Storable> {
        public void decode(S var1, byte[] var2) throws CorruptEncodingException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface SearchKeyFactory<S extends Storable> {
        public byte[] encodeSearchKey(S var1);

        public byte[] encodeSearchKey(S var1, int var2, int var3);

        public byte[] encodeSearchKey(Object[] var1);

        public byte[] encodeSearchKey(Object[] var1, int var2, int var3);

        public byte[] encodeSearchKeyPrefix();
    }
}

