/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.raw;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;

public class DataEncoder {
    public static void encode(int value, byte[] dst, int dstOffset) {
        dst[dstOffset] = (byte)((value ^= Integer.MIN_VALUE) >> 24);
        dst[dstOffset + 1] = (byte)(value >> 16);
        dst[dstOffset + 2] = (byte)(value >> 8);
        dst[dstOffset + 3] = (byte)value;
    }

    public static int encode(Integer value, byte[] dst, int dstOffset) {
        if (value == null) {
            dst[dstOffset] = -1;
            return 1;
        }
        dst[dstOffset] = -128;
        DataEncoder.encode((int)value, dst, dstOffset + 1);
        return 5;
    }

    public static void encode(long value, byte[] dst, int dstOffset) {
        int w = (int)(value >> 32) ^ Integer.MIN_VALUE;
        dst[dstOffset] = (byte)(w >> 24);
        dst[dstOffset + 1] = (byte)(w >> 16);
        dst[dstOffset + 2] = (byte)(w >> 8);
        dst[dstOffset + 3] = (byte)w;
        w = (int)value;
        dst[dstOffset + 4] = (byte)(w >> 24);
        dst[dstOffset + 5] = (byte)(w >> 16);
        dst[dstOffset + 6] = (byte)(w >> 8);
        dst[dstOffset + 7] = (byte)w;
    }

    public static int encode(Long value, byte[] dst, int dstOffset) {
        if (value == null) {
            dst[dstOffset] = -1;
            return 1;
        }
        dst[dstOffset] = -128;
        DataEncoder.encode((long)value, dst, dstOffset + 1);
        return 9;
    }

    public static void encode(byte value, byte[] dst, int dstOffset) {
        dst[dstOffset] = (byte)(value ^ 0x80);
    }

    public static int encode(Byte value, byte[] dst, int dstOffset) {
        if (value == null) {
            dst[dstOffset] = -1;
            return 1;
        }
        dst[dstOffset] = -128;
        dst[dstOffset + 1] = (byte)(value ^ 0x80);
        return 2;
    }

    public static void encode(short value, byte[] dst, int dstOffset) {
        value = (short)(value ^ 0x8000);
        dst[dstOffset] = (byte)(value >> 8);
        dst[dstOffset + 1] = (byte)value;
    }

    public static int encode(Short value, byte[] dst, int dstOffset) {
        if (value == null) {
            dst[dstOffset] = -1;
            return 1;
        }
        dst[dstOffset] = -128;
        DataEncoder.encode((short)value, dst, dstOffset + 1);
        return 3;
    }

    public static void encode(char value, byte[] dst, int dstOffset) {
        dst[dstOffset] = (byte)(value >> 8);
        dst[dstOffset + 1] = (byte)value;
    }

    public static int encode(Character value, byte[] dst, int dstOffset) {
        if (value == null) {
            dst[dstOffset] = -1;
            return 1;
        }
        dst[dstOffset] = -128;
        DataEncoder.encode(value.charValue(), dst, dstOffset + 1);
        return 3;
    }

    public static void encode(boolean value, byte[] dst, int dstOffset) {
        dst[dstOffset] = value ? -128 : 127;
    }

    public static void encode(Boolean value, byte[] dst, int dstOffset) {
        dst[dstOffset] = value == null ? -1 : (value != false ? -128 : 127);
    }

    public static void encode(float value, byte[] dst, int dstOffset) {
        int bits;
        dst[dstOffset] = (byte)((bits ^= (bits = Float.floatToIntBits(value)) < 0 ? -1 : Integer.MIN_VALUE) >> 24);
        dst[dstOffset + 1] = (byte)(bits >> 16);
        dst[dstOffset + 2] = (byte)(bits >> 8);
        dst[dstOffset + 3] = (byte)bits;
    }

    public static void encode(Float value, byte[] dst, int dstOffset) {
        if (value == null) {
            DataEncoder.encode(Integer.MAX_VALUE, dst, dstOffset);
        } else {
            DataEncoder.encode(value.floatValue(), dst, dstOffset);
        }
    }

    public static void encode(double value, byte[] dst, int dstOffset) {
        long bits;
        int w = (int)((bits ^= (bits = Double.doubleToLongBits(value)) < 0L ? -1L : Long.MIN_VALUE) >> 32);
        dst[dstOffset] = (byte)(w >> 24);
        dst[dstOffset + 1] = (byte)(w >> 16);
        dst[dstOffset + 2] = (byte)(w >> 8);
        dst[dstOffset + 3] = (byte)w;
        w = (int)bits;
        dst[dstOffset + 4] = (byte)(w >> 24);
        dst[dstOffset + 5] = (byte)(w >> 16);
        dst[dstOffset + 6] = (byte)(w >> 8);
        dst[dstOffset + 7] = (byte)w;
    }

    public static void encode(Double value, byte[] dst, int dstOffset) {
        if (value == null) {
            DataEncoder.encode(Long.MAX_VALUE, dst, dstOffset);
        } else {
            DataEncoder.encode((double)value, dst, dstOffset);
        }
    }

    public static int encode(BigInteger value, byte[] dst, int dstOffset) {
        if (value == null) {
            dst[dstOffset] = -1;
            return 1;
        }
        byte[] bytes = value.toByteArray();
        int amt = DataEncoder.encodeUnsignedVarInt(bytes.length, dst, dstOffset);
        System.arraycopy(bytes, 0, dst, dstOffset + amt, bytes.length);
        return amt + bytes.length;
    }

    public static int calculateEncodedLength(BigInteger value) {
        if (value == null) {
            return 1;
        }
        int byteCount = (value.bitLength() >> 3) + 1;
        return DataEncoder.unsignedVarIntLength(byteCount) + byteCount;
    }

    public static int encode(BigDecimal value, byte[] dst, int dstOffset) {
        if (value == null) {
            dst[dstOffset] = -1;
            return 1;
        }
        int amt = DataEncoder.encodeSignedVarInt(value.scale(), dst, dstOffset);
        return amt + DataEncoder.encode(value.unscaledValue(), dst, dstOffset + amt);
    }

    public static int calculateEncodedLength(BigDecimal value) {
        if (value == null) {
            return 1;
        }
        return DataEncoder.signedVarIntLength(value.scale()) + DataEncoder.calculateEncodedLength(value.unscaledValue());
    }

    public static int encode(byte[] value, byte[] dst, int dstOffset) {
        if (value == null) {
            dst[dstOffset] = -1;
            return 1;
        }
        return DataEncoder.encode(value, 0, value.length, dst, dstOffset);
    }

    public static int encode(byte[] value, int valueOffset, int valueLength, byte[] dst, int dstOffset) {
        if (value == null) {
            dst[dstOffset] = -1;
            return 1;
        }
        int amt = DataEncoder.encodeUnsignedVarInt(valueLength, dst, dstOffset);
        System.arraycopy(value, valueOffset, dst, dstOffset + amt, valueLength);
        return amt + valueLength;
    }

    public static int calculateEncodedLength(byte[] value) {
        return value == null ? 1 : DataEncoder.calculateEncodedLength(value, 0, value.length);
    }

    public static int calculateEncodedLength(byte[] value, int valueOffset, int valueLength) {
        return value == null ? 1 : DataEncoder.unsignedVarIntLength(valueLength) + valueLength;
    }

    public static int encode(String value, byte[] dst, int dstOffset) {
        if (value == null) {
            dst[dstOffset] = -1;
            return 1;
        }
        int originalOffset = dstOffset;
        int valueLength = value.length();
        dstOffset += DataEncoder.encodeUnsignedVarInt(valueLength, dst, dstOffset);
        for (int i = 0; i < valueLength; ++i) {
            char c2;
            int c = value.charAt(i);
            if (c <= 127) {
                dst[dstOffset++] = (byte)c;
                continue;
            }
            if (c <= 16383) {
                dst[dstOffset++] = (byte)(0x80 | c >> 8);
                dst[dstOffset++] = (byte)(c & 0xFF);
                continue;
            }
            if (c >= 55296 && c <= 56319 && i + 1 < valueLength && (c2 = value.charAt(i + 1)) >= '\udc00' && c2 <= '\udfff') {
                c = 65536 + ((c & 0x3FF) << 10 | c2 & 0x3FF);
                ++i;
            }
            dst[dstOffset++] = (byte)(0xC0 | c >> 16);
            dst[dstOffset++] = (byte)(c >> 8 & 0xFF);
            dst[dstOffset++] = (byte)(c & 0xFF);
        }
        return dstOffset - originalOffset;
    }

    public static int calculateEncodedStringLength(String value) {
        if (value == null) {
            return 1;
        }
        int valueLength = value.length();
        int encodedLen = DataEncoder.unsignedVarIntLength(valueLength);
        for (int i = 0; i < valueLength; ++i) {
            char c2;
            char c = value.charAt(i);
            if (c <= '\u007f') {
                ++encodedLen;
                continue;
            }
            if (c <= '\u3fff') {
                encodedLen += 2;
                continue;
            }
            if (c >= '\ud800' && c <= '\udbff' && i + 1 < valueLength && (c2 = value.charAt(i + 1)) >= '\udc00' && c2 <= '\udfff') {
                ++i;
            }
            encodedLen += 3;
        }
        return encodedLen;
    }

    private static int encodeUnsignedVarInt(int value, byte[] dst, int dstOffset) {
        if (value < 128) {
            dst[dstOffset] = (byte)value;
            return 1;
        }
        if (value < 16384) {
            dst[dstOffset++] = (byte)(value >> 8 | 0x80);
            dst[dstOffset] = (byte)value;
            return 2;
        }
        if (value < 0x200000) {
            dst[dstOffset++] = (byte)(value >> 16 | 0xC0);
            dst[dstOffset++] = (byte)(value >> 8);
            dst[dstOffset] = (byte)value;
            return 3;
        }
        if (value < 0x10000000) {
            dst[dstOffset++] = (byte)(value >> 24 | 0xE0);
            dst[dstOffset++] = (byte)(value >> 16);
            dst[dstOffset++] = (byte)(value >> 8);
            dst[dstOffset] = (byte)value;
            return 4;
        }
        dst[dstOffset++] = -16;
        dst[dstOffset++] = (byte)(value >> 24);
        dst[dstOffset++] = (byte)(value >> 16);
        dst[dstOffset++] = (byte)(value >> 8);
        dst[dstOffset] = (byte)value;
        return 5;
    }

    private static int unsignedVarIntLength(int value) {
        if (value < 128) {
            return 1;
        }
        if (value < 16384) {
            return 2;
        }
        if (value < 0x200000) {
            return 3;
        }
        if (value < 0x10000000) {
            return 4;
        }
        return 5;
    }

    private static int encodeSignedVarInt(int value, byte[] dst, int dstOffset) {
        int n = value = value < 0 ? ~value << 1 | 1 : value << 1;
        if (value < 0) {
            dst[dstOffset++] = -16;
            dst[dstOffset++] = (byte)(value >> 24);
            dst[dstOffset++] = (byte)(value >> 16);
            dst[dstOffset++] = (byte)(value >> 8);
            dst[dstOffset] = (byte)value;
            return 5;
        }
        return DataEncoder.encodeUnsignedVarInt(value, dst, dstOffset);
    }

    private static int signedVarIntLength(int value) {
        value = (value < 0 ? ~value : value) << 1;
        return value < 0 ? 5 : DataEncoder.unsignedVarIntLength(value);
    }

    public static int writeLength(int valueLength, OutputStream out) throws IOException {
        if (valueLength < 128) {
            out.write(valueLength);
            return 1;
        }
        if (valueLength < 16384) {
            out.write(valueLength >> 8 | 0x80);
            out.write(valueLength);
            return 2;
        }
        if (valueLength < 0x200000) {
            out.write(valueLength >> 16 | 0xC0);
            out.write(valueLength >> 8);
            out.write(valueLength);
            return 3;
        }
        if (valueLength < 0x10000000) {
            out.write(valueLength >> 24 | 0xE0);
            out.write(valueLength >> 16);
            out.write(valueLength >> 8);
            out.write(valueLength);
            return 4;
        }
        out.write(240);
        out.write(valueLength >> 24);
        out.write(valueLength >> 16);
        out.write(valueLength >> 8);
        out.write(valueLength);
        return 5;
    }

    public static byte[] encodeSingle(byte[] value, int prefixPadding, int suffixPadding) {
        if (prefixPadding <= 0 && suffixPadding <= 0) {
            return value;
        }
        int length = value.length;
        byte[] dst = new byte[prefixPadding + length + suffixPadding];
        System.arraycopy(value, 0, dst, prefixPadding, length);
        return dst;
    }

    public static byte[] encodeSingleNullable(byte[] value) {
        return DataEncoder.encodeSingleNullable(value, 0, 0);
    }

    public static byte[] encodeSingleNullable(byte[] value, int prefixPadding, int suffixPadding) {
        if (prefixPadding <= 0 && suffixPadding <= 0) {
            if (value == null) {
                return new byte[]{-1};
            }
            int length = value.length;
            if (length == 0) {
                return new byte[]{-128};
            }
            byte[] dst = new byte[1 + length];
            dst[0] = -128;
            System.arraycopy(value, 0, dst, 1, length);
            return dst;
        }
        if (value == null) {
            byte[] dst = new byte[prefixPadding + 1 + suffixPadding];
            dst[prefixPadding] = -1;
            return dst;
        }
        int length = value.length;
        byte[] dst = new byte[prefixPadding + 1 + length + suffixPadding];
        dst[prefixPadding] = -128;
        System.arraycopy(value, 0, dst, prefixPadding + 1, length);
        return dst;
    }
}

