/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.raw;

import com.amazon.carbonado.Storable;
import com.amazon.carbonado.SupportException;
import com.amazon.carbonado.info.StorableIndex;
import com.amazon.carbonado.layout.LayoutOptions;
import com.amazon.carbonado.raw.CompressedEncodingStrategy;
import com.amazon.carbonado.raw.CompressionType;
import com.amazon.carbonado.raw.GenericEncodingStrategy;
import com.amazon.carbonado.raw.GenericStorableCodecFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompressedStorableCodecFactory
extends GenericStorableCodecFactory {
    private final Map<String, CompressionType> mCompressionMap;

    public CompressedStorableCodecFactory(Map<String, CompressionType> compressionMap) {
        this.mCompressionMap = compressionMap == null || compressionMap.isEmpty() ? Collections.emptyMap() : new HashMap<String, CompressionType>(compressionMap);
    }

    @Override
    public LayoutOptions getLayoutOptions(Class<? extends Storable> type) {
        CompressionType compType = this.getCompressionType(type);
        if (compType == CompressionType.NONE) {
            return null;
        }
        LayoutOptions options = new LayoutOptions();
        options.setCompressionType(compType.toString());
        return options;
    }

    @Override
    protected <S extends Storable> GenericEncodingStrategy<S> createStrategy(Class<S> type, StorableIndex<S> pkIndex, LayoutOptions options) throws SupportException {
        CompressionType compType = options == null ? this.getCompressionType(type) : CompressionType.valueOf(options.getCompressionType());
        return new CompressedEncodingStrategy<S>(type, pkIndex, compType);
    }

    protected CompressionType getCompressionType(Class<? extends Storable> type) {
        CompressionType compType = this.mCompressionMap.get(type.getName());
        return compType == null ? CompressionType.NONE : compType;
    }
}

