/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.qe;

import com.amazon.carbonado.Cursor;
import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.IsolationLevel;
import com.amazon.carbonado.PersistException;
import com.amazon.carbonado.PersistMultipleException;
import com.amazon.carbonado.Query;
import com.amazon.carbonado.RepositoryException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.Transaction;
import com.amazon.carbonado.filter.Filter;
import com.amazon.carbonado.filter.FilterValues;
import com.amazon.carbonado.filter.OpenFilter;
import com.amazon.carbonado.filter.RelOp;
import com.amazon.carbonado.info.Direction;
import com.amazon.carbonado.info.OrderedProperty;
import com.amazon.carbonado.qe.AbstractQuery;
import com.amazon.carbonado.qe.EmptyQuery;
import com.amazon.carbonado.qe.OrderingList;
import com.amazon.carbonado.qe.QueryExecutor;
import com.amazon.carbonado.qe.QueryExecutorFactory;
import com.amazon.carbonado.qe.QueryFactory;
import com.amazon.carbonado.qe.QueryHint;
import com.amazon.carbonado.qe.QueryHints;
import com.amazon.carbonado.util.Appender;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StandardQuery<S extends Storable>
extends AbstractQuery<S>
implements Appender {
    private final Filter<S> mFilter;
    private final FilterValues<S> mValues;
    private final OrderingList<S> mOrdering;
    private final QueryHints mHints;
    private volatile QueryExecutor<S> mExecutor;

    protected StandardQuery(Filter<S> filter, FilterValues<S> values, OrderingList<S> ordering, QueryHints hints) {
        if (filter != null && filter.isOpen()) {
            filter = null;
        }
        if (values == null && filter != null) {
            values = filter.initialFilterValues();
        }
        this.mFilter = filter;
        this.mValues = values;
        if (ordering == null) {
            ordering = OrderingList.emptyList();
        }
        this.mOrdering = ordering;
        this.mHints = hints;
    }

    @Override
    public Class<S> getStorableType() {
        return this.queryFactory().getStorableType();
    }

    @Override
    public Filter<S> getFilter() {
        Filter<S> filter = this.mFilter;
        if (filter == null) {
            return Filter.getOpenFilter(this.getStorableType());
        }
        return filter;
    }

    @Override
    public FilterValues<S> getFilterValues() {
        return this.mValues;
    }

    @Override
    public int getBlankParameterCount() {
        return this.mValues == null ? 0 : this.mValues.getBlankParameterCount();
    }

    @Override
    public Query<S> with(int value) {
        return this.newInstance(this.requireValues().with(value));
    }

    @Override
    public Query<S> with(long value) {
        return this.newInstance(this.requireValues().with(value));
    }

    @Override
    public Query<S> with(float value) {
        return this.newInstance(this.requireValues().with(value));
    }

    @Override
    public Query<S> with(double value) {
        return this.newInstance(this.requireValues().with(value));
    }

    @Override
    public Query<S> with(boolean value) {
        return this.newInstance(this.requireValues().with(value));
    }

    @Override
    public Query<S> with(char value) {
        return this.newInstance(this.requireValues().with(value));
    }

    @Override
    public Query<S> with(byte value) {
        return this.newInstance(this.requireValues().with(value));
    }

    @Override
    public Query<S> with(short value) {
        return this.newInstance(this.requireValues().with(value));
    }

    @Override
    public Query<S> with(Object value) {
        return this.newInstance(this.requireValues().with(value));
    }

    @Override
    public Query<S> withValues(Object ... values) {
        if (values == null || values.length == 0) {
            return this;
        }
        return this.newInstance(this.requireValues().withValues(values));
    }

    @Override
    public Query<S> and(Filter<S> filter) throws FetchException {
        FilterValues<S> newValues;
        Filter<S> newFilter;
        if (this.mFilter == null) {
            newFilter = filter;
            newValues = filter.initialFilterValues();
        } else {
            if (this.getBlankParameterCount() > 0) {
                throw new IllegalStateException("Blank parameters exist in query: " + this);
            }
            newFilter = this.mFilter.and(filter);
            newValues = newFilter.initialFilterValues();
            if (this.mValues != null) {
                newValues = newValues.withValues(this.mValues.getSuppliedValues());
            }
        }
        return this.createQuery(newFilter, newValues, this.mOrdering, this.mHints);
    }

    @Override
    public Query<S> or(Filter<S> filter) throws FetchException {
        if (this.mFilter == null) {
            throw new IllegalStateException("Query is already guaranteed to fetch everything");
        }
        if (this.getBlankParameterCount() > 0) {
            throw new IllegalStateException("Blank parameters exist in query: " + this);
        }
        Filter<S> newFilter = this.mFilter.or(filter);
        FilterValues<S> newValues = newFilter.initialFilterValues();
        if (this.mValues != null) {
            newValues = newValues.withValues(this.mValues.getSuppliedValues());
        }
        return this.createQuery(newFilter, newValues, this.mOrdering, this.mHints);
    }

    @Override
    public Query<S> not() throws FetchException {
        if (this.mFilter == null) {
            return new EmptyQuery<S>(this.queryFactory(), this.mOrdering);
        }
        Filter<S> newFilter = this.mFilter.not();
        FilterValues<S> newValues = newFilter.initialFilterValues();
        if (this.mValues != null) {
            newValues = newValues.withValues(this.mValues.getSuppliedValues());
        }
        return this.createQuery(newFilter, newValues, this.mOrdering, this.mHints);
    }

    @Override
    public Query<S> orderBy(String property) throws FetchException {
        return this.createQuery(this.mFilter, this.mValues, OrderingList.get(this.getStorableType(), property), this.mHints);
    }

    @Override
    public Query<S> orderBy(String ... properties) throws FetchException {
        return this.createQuery(this.mFilter, this.mValues, OrderingList.get(this.getStorableType(), properties), this.mHints);
    }

    @Override
    public <T extends S> Query<S> after(T start) throws FetchException {
        OrderingList<S> orderings;
        if (start == null || (orderings = this.mOrdering).size() == 0) {
            return this;
        }
        return this.buildAfter(start, orderings);
    }

    private <T extends S> Query<S> buildAfter(T start, OrderingList<S> orderings) throws FetchException {
        OpenFilter openFilter;
        Class<S> storableType = this.getStorableType();
        Filter orderFilter = Filter.getClosedFilter(storableType);
        Filter lastSubFilter = openFilter = Filter.getOpenFilter(storableType);
        Object[] values = new Object[orderings.size()];
        int i = 0;
        while (true) {
            Object property = orderings.get(i);
            RelOp operator = RelOp.GT;
            if (((OrderedProperty)property).getDirection() == Direction.DESCENDING) {
                operator = RelOp.LT;
            }
            String propertyName = ((OrderedProperty)property).getChainedProperty().toString();
            values[i] = start.getPropertyValue(propertyName);
            orderFilter = ((Filter)orderFilter).or(lastSubFilter.and(propertyName, operator));
            if (++i >= orderings.size()) break;
            Filter propFilter = openFilter.and(propertyName, RelOp.EQ).bind();
            lastSubFilter = ((Filter)lastSubFilter).and(propFilter);
        }
        Query<S> query = this.and(orderFilter);
        for (int i2 = 0; i2 < values.length; ++i2) {
            for (int j = 0; j <= i2; ++j) {
                query = query.with(values[j]);
            }
        }
        return query;
    }

    @Override
    public Cursor<S> fetch() throws FetchException {
        try {
            return this.executor().fetch(this.mValues);
        }
        catch (RepositoryException e) {
            throw e.toFetchException();
        }
    }

    @Override
    public Cursor<S> fetchSlice(long from, Long to) throws FetchException {
        if (!this.checkSliceArguments(from, to)) {
            return this.fetch();
        }
        try {
            QueryHints hints = QueryHints.emptyHints().with(QueryHint.CONSUME_SLICE);
            return this.executorFactory().executor(this.mFilter, this.mOrdering, hints).fetchSlice(this.mValues, from, to);
        }
        catch (RepositoryException e) {
            throw e.toFetchException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryDeleteOne() throws PersistException {
        Transaction txn = this.enterTransaction(IsolationLevel.READ_COMMITTED);
        try {
            boolean result;
            block13: {
                Cursor<S> cursor = this.fetch();
                try {
                    if (cursor.hasNext()) {
                        Storable obj = (Storable)cursor.next();
                        if (cursor.hasNext()) {
                            throw new PersistMultipleException(this.toString());
                        }
                        result = obj.tryDelete();
                        break block13;
                    }
                    boolean bl = false;
                    return bl;
                }
                finally {
                    cursor.close();
                }
            }
            if (txn != null) {
                txn.commit();
            }
            boolean bl = result;
            return bl;
        }
        catch (FetchException e) {
            throw e.toPersistException();
        }
        finally {
            if (txn != null) {
                txn.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAll() throws PersistException {
        Transaction txn = this.enterTransaction(IsolationLevel.READ_COMMITTED);
        try {
            Cursor<S> cursor = this.fetch();
            try {
                while (cursor.hasNext()) {
                    ((Storable)cursor.next()).tryDelete();
                }
            }
            finally {
                cursor.close();
            }
            if (txn != null) {
                txn.commit();
            }
        }
        catch (FetchException e) {
            throw e.toPersistException();
        }
        finally {
            if (txn != null) {
                txn.exit();
            }
        }
    }

    @Override
    public long count() throws FetchException {
        try {
            return this.executor().count(this.mValues);
        }
        catch (RepositoryException e) {
            throw e.toFetchException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists() throws FetchException {
        Cursor<S> cursor = this.fetchSlice(0L, 1L);
        try {
            boolean bl = cursor.skipNext(1) > 0;
            return bl;
        }
        finally {
            cursor.close();
        }
    }

    @Override
    public boolean printNative(Appendable app, int indentLevel) throws IOException {
        try {
            return this.executor().printNative(app, indentLevel, this.mValues);
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    @Override
    public boolean printPlan(Appendable app, int indentLevel) throws IOException {
        try {
            return this.executor().printPlan(app, indentLevel, this.mValues);
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    @Override
    public int hashCode() {
        int hash = this.queryFactory().hashCode();
        hash = hash * 31 + this.executorFactory().hashCode();
        if (this.mFilter != null) {
            hash = hash * 31 + this.mFilter.hashCode();
        }
        if (this.mValues != null) {
            hash = hash * 31 + this.mValues.hashCode();
        }
        hash = hash * 31 + this.mOrdering.hashCode();
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof StandardQuery) {
            StandardQuery other = (StandardQuery)obj;
            return this.queryFactory().equals(other.queryFactory()) && this.executorFactory().equals(other.executorFactory()) && (this.mFilter == null ? other.mFilter == null : this.mFilter.equals(other.mFilter)) && (this.mValues == null ? other.mValues == null : this.mValues.equals(other.mValues)) && this.mOrdering.equals(other.mOrdering);
        }
        return false;
    }

    @Override
    public void appendTo(Appendable app) throws IOException {
        app.append("Query {type=");
        app.append(this.getStorableType().getName());
        app.append(", filter=");
        Filter<S> filter = this.getFilter();
        if (filter.isOpen() || filter.isClosed()) {
            filter.appendTo(app);
        } else {
            app.append('\"');
            filter.appendTo(app, this.mValues);
            app.append('\"');
        }
        if (this.mOrdering != null && this.mOrdering.size() > 0) {
            app.append(", orderBy=[");
            for (int i = 0; i < this.mOrdering.size(); ++i) {
                if (i > 0) {
                    app.append(", ");
                }
                app.append(((OrderedProperty)this.mOrdering.get(i)).toString());
            }
            app.append(']');
        }
        app.append('}');
    }

    private FilterValues<S> requireValues() {
        FilterValues<S> values = this.mValues;
        if (values == null) {
            throw new IllegalStateException("Query doesn't have any parameters");
        }
        return values;
    }

    protected OrderingList<S> getOrdering() {
        return this.mOrdering;
    }

    protected QueryExecutor<S> executor() throws RepositoryException {
        QueryExecutor<S> executor = this.mExecutor;
        if (executor == null) {
            this.mExecutor = executor = this.executorFactory().executor(this.mFilter, this.mOrdering, null);
        }
        return executor;
    }

    protected void setExecutor() throws RepositoryException {
        this.executor();
    }

    protected void resetExecutor() throws RepositoryException {
        if (this.mExecutor != null) {
            this.mExecutor = this.executorFactory().executor(this.mFilter, this.mOrdering, null);
        }
    }

    protected void clearExecutor() {
        this.mExecutor = null;
    }

    protected abstract Transaction enterTransaction(IsolationLevel var1);

    protected abstract QueryFactory<S> queryFactory();

    protected abstract QueryExecutorFactory<S> executorFactory();

    protected abstract StandardQuery<S> newInstance(FilterValues<S> var1, OrderingList<S> var2, QueryHints var3);

    private StandardQuery<S> newInstance(FilterValues<S> values) {
        StandardQuery<S> query = this.newInstance(values, this.mOrdering, this.mHints);
        query.mExecutor = this.mExecutor;
        return query;
    }

    private Query<S> createQuery(Filter<S> filter, FilterValues<S> values, OrderingList<S> ordering, QueryHints hints) throws FetchException {
        return this.queryFactory().query(filter, values, ordering, hints);
    }
}

