/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.qe;

import com.amazon.carbonado.Cursor;
import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.cursor.ArraySortBuffer;
import com.amazon.carbonado.cursor.MergeSortBuffer;
import com.amazon.carbonado.cursor.SortBuffer;
import com.amazon.carbonado.cursor.SortedCursor;
import com.amazon.carbonado.filter.Filter;
import com.amazon.carbonado.filter.FilterValues;
import com.amazon.carbonado.qe.AbstractQueryExecutor;
import com.amazon.carbonado.qe.OrderingList;
import com.amazon.carbonado.qe.QueryExecutor;
import java.io.IOException;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortedQueryExecutor<S extends Storable>
extends AbstractQueryExecutor<S> {
    private final Support<S> mSupport;
    private final QueryExecutor<S> mExecutor;
    private final Comparator<S> mHandledComparator;
    private final Comparator<S> mFinisherComparator;
    private final OrderingList<S> mHandledOrdering;
    private final OrderingList<S> mRemainderOrdering;

    public SortedQueryExecutor(Support<S> support, QueryExecutor<S> executor, OrderingList<S> handledOrdering, OrderingList<S> remainderOrdering) {
        if (support == null) {
            support = this instanceof Support ? (ArraySortSupport)((Object)this) : new ArraySortSupport();
        }
        if (executor == null) {
            throw new IllegalArgumentException();
        }
        this.mSupport = support;
        this.mExecutor = executor;
        if (handledOrdering != null && handledOrdering.size() == 0) {
            handledOrdering = null;
        }
        if (remainderOrdering != null && remainderOrdering.size() == 0) {
            remainderOrdering = null;
        }
        if (remainderOrdering == null) {
            throw new IllegalArgumentException();
        }
        if (handledOrdering == null) {
            this.mHandledComparator = null;
            this.mHandledOrdering = OrderingList.emptyList();
        } else {
            this.mHandledComparator = SortedCursor.createComparator(handledOrdering);
            this.mHandledOrdering = handledOrdering;
        }
        this.mFinisherComparator = SortedCursor.createComparator(remainderOrdering);
        this.mRemainderOrdering = remainderOrdering;
    }

    @Override
    public Cursor<S> fetch(FilterValues<S> values) throws FetchException {
        Cursor<S> cursor = this.mExecutor.fetch(values);
        SortBuffer<S> buffer = this.mSupport.createSortBuffer();
        return new SortedCursor<S>(cursor, buffer, this.mHandledComparator, this.mFinisherComparator);
    }

    @Override
    public long count(FilterValues<S> values) throws FetchException {
        return this.mExecutor.count(values);
    }

    @Override
    public Filter<S> getFilter() {
        return this.mExecutor.getFilter();
    }

    @Override
    public OrderingList<S> getOrdering() {
        return this.mHandledOrdering.concat(this.mRemainderOrdering);
    }

    @Override
    public boolean printNative(Appendable app, int indentLevel, FilterValues<S> values) throws IOException {
        return this.mExecutor.printNative(app, indentLevel, values);
    }

    @Override
    public boolean printPlan(Appendable app, int indentLevel, FilterValues<S> values) throws IOException {
        this.indent(app, indentLevel);
        app.append("sort: ");
        if (this.mHandledOrdering.size() > 0) {
            app.append(this.mHandledOrdering.toString());
            app.append(", ");
        }
        app.append(this.mRemainderOrdering.toString());
        this.newline(app);
        this.mExecutor.printPlan(app, this.increaseIndent(indentLevel), values);
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MergeSortSupport<S extends Storable>
    implements Support<S> {
        @Override
        public SortBuffer<S> createSortBuffer() {
            return new MergeSortBuffer();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ArraySortSupport<S extends Storable>
    implements Support<S> {
        @Override
        public SortBuffer<S> createSortBuffer() {
            return new ArraySortBuffer();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Support<S extends Storable> {
        public SortBuffer<S> createSortBuffer();
    }
}

