/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.qe;

import com.amazon.carbonado.RepositoryException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.filter.Filter;
import com.amazon.carbonado.qe.OrderingList;
import com.amazon.carbonado.qe.QueryExecutor;
import com.amazon.carbonado.qe.QueryExecutorFactory;
import com.amazon.carbonado.qe.QueryHints;
import com.amazon.carbonado.util.SoftValuedCache;
import java.util.Map;
import org.cojen.util.WeakIdentityMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryExecutorCache<S extends Storable>
implements QueryExecutorFactory<S> {
    private final QueryExecutorFactory<S> mFactory;
    private final Map<Filter<S>, SoftValuedCache<Object, QueryExecutor<S>>> mFilterToExecutor;

    public QueryExecutorCache(QueryExecutorFactory<S> factory) {
        if (factory == null) {
            throw new IllegalArgumentException();
        }
        this.mFactory = factory;
        this.mFilterToExecutor = new WeakIdentityMap(7);
    }

    @Override
    public Class<S> getStorableType() {
        return this.mFactory.getStorableType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryExecutor<S> executor(Filter<S> filter, OrderingList<S> ordering, QueryHints hints) throws RepositoryException {
        QueryExecutor<Object> executor;
        SoftValuedCache<Object, QueryExecutor<Object>> cache;
        Map<Filter<S>, SoftValuedCache<Object, QueryExecutor<S>>> map = this.mFilterToExecutor;
        synchronized (map) {
            cache = this.mFilterToExecutor.get(filter);
            if (cache == null) {
                cache = SoftValuedCache.newCache(7);
                this.mFilterToExecutor.put(filter, cache);
            }
        }
        Object key = hints == null || hints.isEmpty() ? ordering : new WithHintsKey(ordering, hints);
        SoftValuedCache<Object, QueryExecutor<Object>> softValuedCache = cache;
        synchronized (softValuedCache) {
            executor = cache.get(key);
            if (executor == null) {
                executor = this.mFactory.executor(filter, ordering, hints);
                cache.put(key, executor);
            }
        }
        return executor;
    }

    private static class WithHintsKey {
        private final OrderingList mOrdering;
        private final QueryHints mHints;

        WithHintsKey(OrderingList ordering, QueryHints hints) {
            this.mOrdering = ordering;
            this.mHints = hints;
        }

        public int hashCode() {
            return this.mOrdering == null ? 0 : this.mOrdering.hashCode() * 31 + this.mHints.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof WithHintsKey) {
                WithHintsKey other = (WithHintsKey)obj;
                return (this.mOrdering == null ? other.mOrdering == null : this.mOrdering.equals(other.mOrdering)) && this.mHints.equals(other.mHints);
            }
            return false;
        }
    }
}

