/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.qe;

import com.amazon.carbonado.Storable;
import com.amazon.carbonado.filter.ExistsFilter;
import com.amazon.carbonado.filter.Filter;
import com.amazon.carbonado.filter.OrFilter;
import com.amazon.carbonado.filter.PropertyFilter;
import com.amazon.carbonado.filter.RelOp;
import com.amazon.carbonado.filter.Visitor;
import com.amazon.carbonado.util.SoftValuedCache;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PropertyFilterList<S extends Storable>
extends AbstractList<PropertyFilter<S>> {
    private static SoftValuedCache<Filter<?>, PropertyFilterList> cCache = SoftValuedCache.newCache(11);
    private final List<PropertyFilter<S>> mList;
    private final Map<PropertyFilter<S>, Integer> mPosMap;
    private final List<ExistsFilter<S>> mExistsList;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <S extends Storable> PropertyFilterList<S> get(Filter<S> filter) {
        List<ExistsFilter<Object>> existsList;
        Map<PropertyFilter<S>, Integer> posMap;
        List<PropertyFilter<S>> list;
        PropertyFilterList<S> plist;
        SoftValuedCache<Filter<?>, PropertyFilterList> softValuedCache = cCache;
        synchronized (softValuedCache) {
            plist = cCache.get(filter);
        }
        if (plist != null) {
            return plist;
        }
        if (filter == null) {
            list = Collections.emptyList();
            posMap = Collections.emptyMap();
            existsList = Collections.emptyList();
        } else if (filter instanceof PropertyFilter) {
            list = Collections.singletonList((PropertyFilter)filter);
            posMap = Collections.singletonMap((PropertyFilter)filter, 0);
            existsList = Collections.emptyList();
        } else {
            list = new ArrayList();
            existsList = new ArrayList();
            final List<PropertyFilter<S>> flist = list;
            final List<ExistsFilter<S>> fexistsList = existsList;
            filter.accept(new Visitor<S, Object, Object>(){

                @Override
                public Object visit(OrFilter<S> filter, Object param) {
                    throw new IllegalArgumentException("OrFilter not allowed");
                }

                @Override
                public Object visit(ExistsFilter<S> filter, Object param) {
                    fexistsList.add(filter);
                    return null;
                }

                @Override
                public Object visit(PropertyFilter<S> filter, Object param) {
                    flist.add(filter);
                    return null;
                }
            }, null);
            posMap = new HashMap<PropertyFilter<S>, Integer>();
            for (int i = 0; i < list.size(); ++i) {
                posMap.put(list.get(i), i);
            }
            Collections.sort(list, new PFComparator());
            ((ArrayList)list).trimToSize();
            list = Collections.unmodifiableList(list);
            existsList = Collections.unmodifiableList(existsList);
        }
        plist = new PropertyFilterList<S>(list, posMap, existsList);
        SoftValuedCache<Filter<?>, PropertyFilterList> softValuedCache2 = cCache;
        synchronized (softValuedCache2) {
            cCache.put(filter, plist);
        }
        return plist;
    }

    private PropertyFilterList(List<PropertyFilter<S>> list, Map<PropertyFilter<S>, Integer> posMap, List<ExistsFilter<S>> existsList) {
        this.mList = list;
        this.mPosMap = posMap;
        this.mExistsList = existsList;
    }

    public Integer getOriginalPosition(PropertyFilter<S> filter) {
        return this.mPosMap.get(filter);
    }

    @Override
    public int size() {
        return this.mList.size();
    }

    @Override
    public PropertyFilter<S> get(int index) {
        return this.mList.get(index);
    }

    public List<ExistsFilter<S>> getExistsFilters() {
        return this.mExistsList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PFComparator<S extends Storable>
    implements Comparator<PropertyFilter<S>>,
    Serializable {
        private static final long serialVersionUID = 2322537712763223517L;

        private PFComparator() {
        }

        @Override
        public int compare(PropertyFilter<S> a, PropertyFilter<S> b) {
            if (a.getOperator() != b.getOperator()) {
                if (a.getOperator() == RelOp.EQ) {
                    return -1;
                }
                if (a.getOperator() == RelOp.NE) {
                    return 1;
                }
                if (b.getOperator() == RelOp.EQ) {
                    return 1;
                }
                if (b.getOperator() == RelOp.NE) {
                    return -1;
                }
            }
            return 0;
        }
    }
}

