/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.qe;

import com.amazon.carbonado.Storable;
import com.amazon.carbonado.info.ChainedProperty;
import com.amazon.carbonado.info.OrderedProperty;
import com.amazon.carbonado.info.StorableIntrospector;
import com.amazon.carbonado.util.SoftValuedCache;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderingList<S extends Storable>
extends AbstractList<OrderedProperty<S>>
implements Serializable {
    private static final long serialVersionUID = 3692335128299485356L;
    private static final OrderingList EMPTY_LIST = new OrderingList();
    private static final SoftValuedCache<Class, OrderingList> cCache = SoftValuedCache.newCache(11);
    private final OrderingList<S> mParent;
    private final OrderedProperty<S> mProperty;
    private final int mSize;
    private Map<Object, OrderingList<S>> mNextNode;
    private OrderedProperty<S>[] mOrderings;
    private String[] mOrderingStrings;

    public static <S extends Storable> OrderingList<S> emptyList() {
        return EMPTY_LIST;
    }

    public static <S extends Storable> OrderingList<S> get(Class<S> type, String property) {
        OrderingList<S> list = OrderingList.emptyList();
        if (property != null) {
            list = list.concat(type, property);
        }
        return list;
    }

    public static <S extends Storable> OrderingList<S> get(Class<S> type, String ... orderings) {
        OrderingList<S> list = OrderingList.emptyList();
        if (orderings != null && orderings.length > 0) {
            for (String property : orderings) {
                list = list.concat(type, property);
            }
        }
        return list;
    }

    public static <S extends Storable> OrderingList<S> get(OrderedProperty<S> ... orderings) {
        OrderingList<S> list = OrderingList.emptyList();
        if (orderings != null && orderings.length > 0) {
            for (OrderedProperty<S> property : orderings) {
                list = list.concat(property);
            }
        }
        return list;
    }

    public static <S extends Storable> OrderingList<S> get(List<OrderedProperty<S>> orderings) {
        OrderingList<S> list = OrderingList.emptyList();
        if (orderings != null && orderings.size() > 0) {
            for (OrderedProperty<S> property : orderings) {
                list = list.concat(property);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <S extends Storable> OrderingList<S> getListHead(Class<S> type) {
        OrderingList<S> node;
        SoftValuedCache<Class, OrderingList> softValuedCache = cCache;
        synchronized (softValuedCache) {
            node = cCache.get(type);
            if (node == null) {
                node = new OrderingList<S>();
                cCache.put(type, node);
            }
        }
        return node;
    }

    private OrderingList() {
        this.mParent = null;
        this.mProperty = null;
        this.mSize = 0;
    }

    private OrderingList(OrderingList<S> parent, OrderedProperty<S> property) {
        if (property == null) {
            throw new IllegalArgumentException("Ordering property is null");
        }
        this.mParent = parent;
        this.mProperty = property;
        this.mSize = parent.mSize + 1;
    }

    @Override
    public int size() {
        return this.mSize;
    }

    @Override
    public OrderedProperty<S> get(int index) {
        return this.asArray()[index];
    }

    public OrderingList<S> concat(Class<S> type, String property) {
        OrderingList<S> newList = this;
        if (newList == EMPTY_LIST) {
            newList = OrderingList.getListHead(type);
        }
        return super.nextNode(type, property);
    }

    public OrderingList<S> concat(OrderedProperty<S> property) {
        OrderingList<S> newList = this;
        if (newList == EMPTY_LIST) {
            newList = OrderingList.getListHead(property.getChainedProperty().getPrimeProperty().getEnclosingType());
        }
        return newList.nextNode(property);
    }

    public OrderingList<S> concat(OrderingList<S> other) {
        if (this.size() == 0) {
            return other;
        }
        OrderingList<S> newList = this;
        if (other.size() > 0) {
            for (OrderedProperty orderedProperty : other) {
                newList = newList.concat(orderedProperty);
            }
        }
        return newList;
    }

    public OrderingList<S> reduce() {
        if (this.size() == 0) {
            return this;
        }
        HashSet seen = new HashSet();
        OrderingList<S> newList = OrderingList.emptyList();
        for (OrderedProperty property : this) {
            ChainedProperty chained = property.getChainedProperty();
            if (seen.contains(chained)) continue;
            newList = newList.concat(property);
            seen.add(chained);
        }
        return newList;
    }

    public OrderingList<S> reverseDirections() {
        if (this.size() == 0) {
            return this;
        }
        OrderingList reversedList = OrderingList.emptyList();
        for (int i = 0; i < this.size(); ++i) {
            reversedList = reversedList.concat(((OrderedProperty)this.get(i)).reverse());
        }
        return reversedList;
    }

    public OrderingList<S> replace(int index, OrderedProperty<S> property) {
        int size = this.size();
        if (index < 0 || index >= size) {
            throw new IndexOutOfBoundsException();
        }
        OrderingList<S> newList = OrderingList.emptyList();
        for (int i = 0; i < size; ++i) {
            newList = newList.concat((OrderedProperty<S>)(i == index ? property : this.get(i)));
        }
        return newList;
    }

    @Override
    public OrderingList<S> subList(int fromIndex, int toIndex) {
        if (fromIndex == 0 && toIndex >= 0 && toIndex <= this.mSize) {
            if (toIndex == 0) {
                return OrderingList.emptyList();
            }
            OrderingList<S> list = this;
            while (toIndex < list.mSize) {
                list = list.mParent;
            }
            return list;
        }
        return OrderingList.get(super.subList(fromIndex, toIndex));
    }

    OrderedProperty<S>[] asArray() {
        if (this.mOrderings == null) {
            OrderedProperty[] orderings = new OrderedProperty[this.mSize];
            OrderingList<S> node = this;
            int i = this.mSize;
            while (--i >= 0) {
                orderings[i] = node.mProperty;
                node = node.mParent;
            }
            this.mOrderings = orderings;
        }
        return this.mOrderings;
    }

    String[] asStringArray() {
        if (this.mOrderingStrings == null) {
            String[] orderings = new String[this.mSize];
            OrderingList<S> node = this;
            int i = this.mSize;
            while (--i >= 0) {
                orderings[i] = node.mProperty.toString();
                node = node.mParent;
            }
            this.mOrderingStrings = orderings;
        }
        return this.mOrderingStrings;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return super.equals(other);
    }

    private synchronized OrderingList<S> nextNode(Class<S> type, String property) {
        OrderingList<S> node;
        if (this.mNextNode == null) {
            this.mNextNode = new HashMap<Object, OrderingList<S>>();
            node = null;
        } else {
            node = this.mNextNode.get(property);
        }
        if (node == null) {
            OrderedProperty<S> op = OrderedProperty.parse(StorableIntrospector.examine(type), property);
            node = this.nextNode(op);
            this.mNextNode.put(property, node);
        }
        return node;
    }

    private synchronized OrderingList<S> nextNode(OrderedProperty<S> property) {
        OrderingList<S> node;
        if (this.mNextNode == null) {
            this.mNextNode = new HashMap<Object, OrderingList<S>>();
            node = null;
        } else {
            node = this.mNextNode.get(property);
        }
        if (node == null) {
            node = new OrderingList<S>(this, property);
            this.mNextNode.put(property, node);
        }
        return node;
    }

    private Object writeReplace() {
        return new Orderings(this.asArray());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Orderings
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private OrderedProperty[] mOrderings;

        public Orderings() {
        }

        Orderings(OrderedProperty<?>[] orderings) {
            this.mOrderings = orderings;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.mOrderings);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.mOrderings = (OrderedProperty[])in.readObject();
        }

        private Object readResolve() {
            return OrderingList.get(this.mOrderings);
        }
    }
}

