/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.qe;

import com.amazon.carbonado.Cursor;
import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.RepositoryException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.cursor.MultiTransformedCursor;
import com.amazon.carbonado.filter.Filter;
import com.amazon.carbonado.filter.FilterValues;
import com.amazon.carbonado.filter.RelOp;
import com.amazon.carbonado.gen.CodeBuilderUtil;
import com.amazon.carbonado.info.ChainedProperty;
import com.amazon.carbonado.info.OrderedProperty;
import com.amazon.carbonado.info.StorableIndex;
import com.amazon.carbonado.info.StorableInfo;
import com.amazon.carbonado.info.StorableIntrospector;
import com.amazon.carbonado.info.StorableProperty;
import com.amazon.carbonado.qe.AbstractQueryExecutor;
import com.amazon.carbonado.qe.CompositeScore;
import com.amazon.carbonado.qe.KeyQueryExecutor;
import com.amazon.carbonado.qe.OrderingList;
import com.amazon.carbonado.qe.QueryExecutor;
import com.amazon.carbonado.qe.QueryExecutorFactory;
import com.amazon.carbonado.qe.QueryHints;
import com.amazon.carbonado.qe.RepositoryAccess;
import com.amazon.carbonado.qe.SortedQueryExecutor;
import com.amazon.carbonado.qe.StorageAccess;
import com.amazon.carbonado.util.QuickConstructorGenerator;
import com.amazon.carbonado.util.SoftValuedCache;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.cojen.classfile.ClassFile;
import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.LocalVariable;
import org.cojen.classfile.MethodInfo;
import org.cojen.classfile.Modifiers;
import org.cojen.classfile.TypeDesc;
import org.cojen.util.ClassInjector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinedQueryExecutor<S extends Storable, T extends Storable>
extends AbstractQueryExecutor<T> {
    private static final String INNER_LOOP_EX_FIELD_NAME = "innerLoopExecutor";
    private static final String INNER_LOOP_FV_FIELD_NAME = "innerLoopFilterValues";
    private static final String ACTIVE_SOURCE_FIELD_NAME = "active";
    private static final SoftValuedCache<StorableProperty, Class> cJoinerCursorClassCache = SoftValuedCache.newCache(11);
    private final Filter<T> mTargetFilter;
    private final StorableProperty<T> mTargetToSourceProperty;
    private final QueryExecutor<S> mOuterLoopExecutor;
    private final FilterValues<S> mOuterLoopFilterValues;
    private final QueryExecutor<T> mInnerLoopExecutor;
    private final FilterValues<T> mInnerLoopFilterValues;
    private final Filter<T> mSourceFilterAsFromTarget;
    private final Filter<T> mCombinedFilter;
    private final OrderingList<T> mCombinedOrdering;
    private final Joiner.Factory<S, T> mJoinerFactory;

    public static <T extends Storable> QueryExecutor<T> build(RepositoryAccess repoAccess, ChainedProperty<T> targetToSourceProperty, Filter<T> targetFilter, OrderingList<T> targetOrdering, QueryHints hints) throws RepositoryException {
        AbstractQueryExecutor executor;
        OrderingList handledOrdering;
        int handledCount;
        List remainderOrdering;
        if (targetOrdering == null) {
            targetOrdering = OrderingList.emptyList();
        }
        if (((OrderingList)(remainderOrdering = targetOrdering.subList(handledCount = JoinedQueryExecutor.commonOrderingCount(handledOrdering = (executor = JoinedQueryExecutor.buildJoin(repoAccess, targetToSourceProperty, targetFilter, targetOrdering, hints)).getOrdering(), targetOrdering), targetOrdering.size()))).size() > 0) {
            StorageAccess<T> support = repoAccess.storageAccessFor(targetToSourceProperty.getPrimeProperty().getEnclosingType());
            executor = new SortedQueryExecutor<T>(support, executor, handledOrdering, remainderOrdering);
        }
        return executor;
    }

    private static <T extends Storable> JoinedQueryExecutor<?, T> buildJoin(RepositoryAccess repoAccess, ChainedProperty<T> targetToSourceProperty, Filter<T> targetFilter, OrderingList<T> targetOrdering, QueryHints hints) throws RepositoryException {
        QueryExecutor<Object> outerLoopExecutor;
        Filter<?> tailFilter;
        StorableProperty<T> primeTarget = targetToSourceProperty.getPrimeProperty();
        if (targetFilter == null) {
            tailFilter = null;
        } else {
            Filter.NotJoined nj = targetFilter.notJoinedFrom(ChainedProperty.get(primeTarget));
            tailFilter = nj.getNotJoinedFilter();
            targetFilter = nj.getRemainderFilter();
        }
        OrderingList outerLoopOrdering = JoinedQueryExecutor.mostOrdering(primeTarget, targetOrdering);
        if (targetToSourceProperty.getChainCount() > 0) {
            ChainedProperty<?> tailProperty = targetToSourceProperty.tail();
            outerLoopExecutor = JoinedQueryExecutor.buildJoin(repoAccess, tailProperty, tailFilter, outerLoopOrdering, hints);
        } else {
            Class<?> sourceType = targetToSourceProperty.getType();
            if (!Storable.class.isAssignableFrom(sourceType)) {
                throw new IllegalArgumentException("Property type is not a Storable: " + targetToSourceProperty);
            }
            StorageAccess<?> sourceAccess = repoAccess.storageAccessFor(sourceType);
            OrderingList<?> expectedOrdering = JoinedQueryExecutor.expectedOrdering(sourceAccess, tailFilter, outerLoopOrdering);
            QueryExecutorFactory<?> outerLoopExecutorFactory = sourceAccess.getQueryExecutorFactory();
            outerLoopExecutor = outerLoopExecutorFactory.executor(tailFilter, expectedOrdering, hints);
        }
        if (targetOrdering.size() > 0) {
            int handledCount = JoinedQueryExecutor.commonOrderingCount(outerLoopExecutor.getOrdering(), outerLoopOrdering);
            targetOrdering = targetOrdering.subList(handledCount, targetOrdering.size());
        }
        Class<T> targetType = primeTarget.getEnclosingType();
        StorageAccess<T> targetAccess = repoAccess.storageAccessFor(targetType);
        QueryExecutorFactory<T> innerLoopExecutorFactory = targetAccess.getQueryExecutorFactory();
        return new JoinedQueryExecutor(outerLoopExecutor, innerLoopExecutorFactory, primeTarget, targetFilter, targetOrdering, targetAccess);
    }

    private static synchronized <S, T extends Storable> Joiner.Factory<S, T> getJoinerFactory(StorableProperty<T> targetToSourceProperty) {
        Class<Cursor<T>> clazz = cJoinerCursorClassCache.get(targetToSourceProperty);
        if (clazz == null) {
            clazz = JoinedQueryExecutor.generateJoinerCursor(targetToSourceProperty);
            cJoinerCursorClassCache.put(targetToSourceProperty, clazz);
        }
        return QuickConstructorGenerator.getInstance(clazz, Joiner.Factory.class);
    }

    private static <T extends Storable> Class<Cursor<T>> generateJoinerCursor(StorableProperty<T> targetToSourceProperty) {
        boolean canSetSourceReference;
        Class<?> sourceType = targetToSourceProperty.getType();
        Class<T> targetType = targetToSourceProperty.getEnclosingType();
        String name = targetType.getName();
        int index = name.lastIndexOf(46);
        String packageName = index >= 0 ? name.substring(0, index) : "";
        ClassLoader loader = targetType.getClassLoader();
        ClassInjector ci = ClassInjector.create((String)(packageName + ".JoinedCursor"), (ClassLoader)loader);
        ClassFile cf = new ClassFile(ci.getClassName(), MultiTransformedCursor.class);
        cf.markSynthetic();
        cf.setSourceFile(JoinedQueryExecutor.class.getName());
        cf.setTarget("1.5");
        TypeDesc cursorType = TypeDesc.forClass(Cursor.class);
        TypeDesc queryExecutorType = TypeDesc.forClass(QueryExecutor.class);
        TypeDesc filterValuesType = TypeDesc.forClass(FilterValues.class);
        cf.addField(Modifiers.PRIVATE.toFinal(true), INNER_LOOP_EX_FIELD_NAME, queryExecutorType);
        cf.addField(Modifiers.PRIVATE.toFinal(true), INNER_LOOP_FV_FIELD_NAME, filterValuesType);
        boolean bl = canSetSourceReference = targetToSourceProperty.getWriteMethod() != null;
        if (canSetSourceReference) {
            cf.addField(Modifiers.PRIVATE, ACTIVE_SOURCE_FIELD_NAME, TypeDesc.forClass(sourceType));
        }
        TypeDesc[] params = new TypeDesc[]{cursorType, queryExecutorType, filterValuesType};
        MethodInfo mi = cf.addConstructor(Modifiers.PUBLIC, params);
        CodeBuilder b = new CodeBuilder(mi);
        b.loadThis();
        b.loadLocal(b.getParameter(0));
        b.invokeSuperConstructor(new TypeDesc[]{cursorType});
        b.loadThis();
        b.loadLocal(b.getParameter(1));
        b.storeField(INNER_LOOP_EX_FIELD_NAME, queryExecutorType);
        b.loadThis();
        b.loadLocal(b.getParameter(2));
        b.storeField(INNER_LOOP_FV_FIELD_NAME, filterValuesType);
        b.returnVoid();
        MethodInfo mi2 = cf.addMethod(Modifiers.PROTECTED, "transform", cursorType, new TypeDesc[]{TypeDesc.OBJECT});
        mi2.addException(TypeDesc.forClass(FetchException.class));
        CodeBuilder b2 = new CodeBuilder(mi2);
        LocalVariable sourceVar = b2.createLocalVariable(null, TypeDesc.forClass(sourceType));
        b2.loadLocal(b2.getParameter(0));
        b2.checkCast(TypeDesc.forClass(sourceType));
        b2.storeLocal(sourceVar);
        if (canSetSourceReference) {
            b2.loadThis();
            b2.loadLocal(sourceVar);
            b2.storeField(ACTIVE_SOURCE_FIELD_NAME, TypeDesc.forClass(sourceType));
        }
        b2.loadThis();
        b2.loadField(INNER_LOOP_EX_FIELD_NAME, queryExecutorType);
        b2.loadThis();
        b2.loadField(INNER_LOOP_FV_FIELD_NAME, filterValuesType);
        int propCount = targetToSourceProperty.getJoinElementCount();
        for (int i = 0; i < propCount; ++i) {
            StorableProperty<?> external = targetToSourceProperty.getExternalJoinElement(i);
            b2.loadLocal(sourceVar);
            b2.invoke(external.getReadMethod());
            TypeDesc bindType = CodeBuilderUtil.bindQueryParam(external.getType());
            CodeBuilderUtil.convertValue(b2, external.getType(), bindType.toClass());
            b2.invokeVirtual(filterValuesType, "with", filterValuesType, new TypeDesc[]{bindType});
        }
        b2.invokeInterface(queryExecutorType, "fetch", cursorType, new TypeDesc[]{filterValuesType});
        b2.returnValue(cursorType);
        if (canSetSourceReference) {
            mi2 = cf.addMethod(Modifiers.PUBLIC, "next", TypeDesc.OBJECT, null);
            mi2.addException(TypeDesc.forClass(FetchException.class));
            b2 = new CodeBuilder(mi2);
            b2.loadThis();
            b2.invokeSuper(TypeDesc.forClass(MultiTransformedCursor.class), "next", TypeDesc.OBJECT, null);
            b2.checkCast(TypeDesc.forClass(targetType));
            b2.dup();
            b2.loadThis();
            b2.loadField(ACTIVE_SOURCE_FIELD_NAME, TypeDesc.forClass(sourceType));
            b2.invoke(targetToSourceProperty.getWriteMethod());
            b2.returnValue(TypeDesc.OBJECT);
        }
        return ci.defineClass(cf);
    }

    private static <S extends Storable, T extends Storable> OrderingList<T> transformOrdering(Class<T> targetType, String targetToSourceProperty, QueryExecutor<S> sourceExecutor) {
        OrderingList<T> targetOrdering = OrderingList.emptyList();
        StorableInfo<T> targetInfo = StorableIntrospector.examine(targetType);
        for (OrderedProperty orderedProperty : sourceExecutor.getOrdering()) {
            String targetName = targetToSourceProperty + '.' + orderedProperty.getChainedProperty();
            OrderedProperty<T> targetProp = OrderedProperty.get(ChainedProperty.parse(targetInfo, targetName), orderedProperty.getDirection());
            targetOrdering = targetOrdering.concat(targetProp);
        }
        return targetOrdering;
    }

    private static <T extends Storable> OrderingList mostOrdering(StorableProperty<T> primeTarget, OrderingList<T> targetOrdering) {
        OrderedProperty targetProp;
        ChainedProperty chainedProp;
        OrderingList<?> handledOrdering = OrderingList.emptyList();
        Iterator i$ = targetOrdering.iterator();
        while (i$.hasNext() && (chainedProp = (targetProp = (OrderedProperty)i$.next()).getChainedProperty()).getPrimeProperty().equals(primeTarget)) {
            handledOrdering = handledOrdering.concat(OrderedProperty.get(chainedProp.tail(), targetProp.getDirection()));
        }
        return handledOrdering;
    }

    private static <T extends Storable> OrderingList<T> expectedOrdering(StorageAccess<T> access, Filter<T> filter, OrderingList<T> ordering) {
        List<Filter<T>> split = filter == null ? Filter.getOpenFilter(access.getStorableType()).disjunctiveNormalFormSplit() : filter.disjunctiveNormalFormSplit();
        Comparator<CompositeScore<?>> comparator = CompositeScore.fullComparator();
        CompositeScore<T> bestScore = null;
        for (StorableIndex<T> index : access.getAllIndexes()) {
            for (Filter<T> sub : split) {
                CompositeScore<T> candidateScore = CompositeScore.evaluate(index, sub, ordering);
                if (bestScore != null && comparator.compare(candidateScore, bestScore) >= 0) continue;
                bestScore = candidateScore;
            }
        }
        int handledCount = bestScore == null ? 0 : bestScore.getOrderingScore().getHandledCount();
        return ordering.subList(0, handledCount);
    }

    private static <T extends Storable> int commonOrderingCount(OrderingList<T> orderingA, OrderingList<T> orderingB) {
        int commonCount = Math.min(orderingA.size(), orderingB.size());
        for (int i = 0; i < commonCount; ++i) {
            if (((OrderedProperty)orderingA.get(i)).equals(orderingB.get(i))) continue;
            return i;
        }
        return commonCount;
    }

    private JoinedQueryExecutor(QueryExecutor<S> outerLoopExecutor, QueryExecutorFactory<T> innerLoopExecutorFactory, StorableProperty<T> targetToSourceProperty, Filter<T> targetFilter, OrderingList<T> targetOrdering, StorageAccess<T> targetAccess) throws RepositoryException {
        if (targetToSourceProperty == null || outerLoopExecutor == null) {
            throw new IllegalArgumentException("Null parameter");
        }
        Class<S> sourceType = outerLoopExecutor.getStorableType();
        if (targetToSourceProperty.getType() != sourceType) {
            throw new IllegalArgumentException("Property is not of type \"" + sourceType.getName() + "\": " + targetToSourceProperty);
        }
        if (!targetToSourceProperty.isJoin()) {
            throw new IllegalArgumentException("Property is not a join: " + targetToSourceProperty);
        }
        if (targetFilter != null && !targetFilter.isBound()) {
            throw new IllegalArgumentException("Target filter must be bound");
        }
        if (!outerLoopExecutor.getFilter().isBound()) {
            throw new IllegalArgumentException("Outer loop executor filter must be bound");
        }
        if (targetFilter.isOpen()) {
            targetFilter = null;
        }
        this.mTargetFilter = targetFilter;
        this.mTargetToSourceProperty = targetToSourceProperty;
        this.mOuterLoopExecutor = outerLoopExecutor;
        this.mOuterLoopFilterValues = outerLoopExecutor.getFilter().initialFilterValues();
        Class<T> targetType = targetToSourceProperty.getEnclosingType();
        Filter innerLoopExecutorFilter = Filter.getOpenFilter(targetType);
        if (targetFilter != null) {
            innerLoopExecutorFilter = innerLoopExecutorFilter.and(targetFilter);
        }
        int count = targetToSourceProperty.getJoinElementCount();
        for (int i = 0; i < count; ++i) {
            innerLoopExecutorFilter = innerLoopExecutorFilter.and(targetToSourceProperty.getInternalJoinElement(i).getName(), RelOp.EQ);
        }
        innerLoopExecutorFilter = innerLoopExecutorFilter.bind();
        this.mInnerLoopFilterValues = innerLoopExecutorFilter.initialFilterValues();
        if (targetOrdering != null) {
            targetOrdering = outerLoopExecutor instanceof KeyQueryExecutor ? JoinedQueryExecutor.expectedOrdering(targetAccess, innerLoopExecutorFilter, targetOrdering) : null;
        }
        this.mInnerLoopExecutor = innerLoopExecutorFactory.executor(innerLoopExecutorFilter, targetOrdering, null);
        Filter<T> filter = outerLoopExecutor.getFilter().asJoinedFrom(ChainedProperty.get(targetToSourceProperty));
        this.mSourceFilterAsFromTarget = filter;
        if (targetFilter != null) {
            filter = filter.and(targetFilter);
        }
        this.mCombinedFilter = filter;
        OrderingList<T> ordering = JoinedQueryExecutor.transformOrdering(targetType, targetToSourceProperty.getName(), outerLoopExecutor);
        if (targetOrdering != null) {
            ordering = ordering.concat(targetOrdering);
        }
        this.mCombinedOrdering = ordering;
        this.mJoinerFactory = JoinedQueryExecutor.getJoinerFactory(targetToSourceProperty);
    }

    @Override
    public Cursor<T> fetch(FilterValues<T> values) throws FetchException {
        FilterValues<T> innerLoopFilterValues = this.mInnerLoopFilterValues;
        if (this.mTargetFilter != null) {
            innerLoopFilterValues = innerLoopFilterValues.withValues(values.getValuesFor(this.mTargetFilter));
        }
        Cursor<S> outerLoopCursor = this.mOuterLoopExecutor.fetch(this.transferValues(values));
        return this.mJoinerFactory.newJoinedCursor(outerLoopCursor, this.mInnerLoopExecutor, innerLoopFilterValues);
    }

    @Override
    public Filter<T> getFilter() {
        return this.mCombinedFilter;
    }

    @Override
    public OrderingList<T> getOrdering() {
        return this.mCombinedOrdering;
    }

    @Override
    public boolean printPlan(Appendable app, int indentLevel, FilterValues<T> values) throws IOException {
        this.indent(app, indentLevel);
        app.append("join: ");
        app.append(this.mTargetToSourceProperty.getEnclosingType().getName());
        this.newline(app);
        this.indent(app, indentLevel);
        app.append("...inner loop: ");
        app.append(this.mTargetToSourceProperty.getName());
        this.newline(app);
        this.mInnerLoopExecutor.printPlan(app, this.increaseIndent(indentLevel), values);
        this.indent(app, indentLevel);
        app.append("...outer loop");
        this.newline(app);
        this.mOuterLoopExecutor.printPlan(app, this.increaseIndent(indentLevel), this.transferValues(values));
        return true;
    }

    private FilterValues<S> transferValues(FilterValues<T> values) {
        if (values == null) {
            return null;
        }
        return this.mOuterLoopFilterValues.withValues(values.getSuppliedValuesFor(this.mSourceFilterAsFromTarget));
    }

    private static interface Joiner {

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface Factory<S, T extends Storable> {
            public Cursor<T> newJoinedCursor(Cursor<S> var1, QueryExecutor<T> var2, FilterValues<T> var3);
        }
    }
}

