/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.qe;

import com.amazon.carbonado.Cursor;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.cursor.IteratorCursor;
import com.amazon.carbonado.filter.Filter;
import com.amazon.carbonado.filter.FilterValues;
import com.amazon.carbonado.qe.AbstractQueryExecutor;
import com.amazon.carbonado.qe.OrderingList;
import java.io.IOException;
import java.util.concurrent.locks.Lock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IterableQueryExecutor<S extends Storable>
extends AbstractQueryExecutor<S> {
    private final Class<S> mType;
    private final Iterable<S> mIterable;
    private final Lock mLock;

    public IterableQueryExecutor(Class<S> type, Iterable<S> iterable) {
        this(type, iterable, null);
    }

    public IterableQueryExecutor(Class<S> type, Iterable<S> iterable, Lock lock) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        this.mType = type;
        this.mIterable = iterable;
        this.mLock = lock;
    }

    @Override
    public Filter<S> getFilter() {
        return Filter.getOpenFilter(this.mType);
    }

    @Override
    public Cursor<S> fetch(FilterValues<S> values) {
        return new IteratorCursor<S>(this.mIterable, this.mLock);
    }

    @Override
    public OrderingList<S> getOrdering() {
        return OrderingList.emptyList();
    }

    @Override
    public boolean printPlan(Appendable app, int indentLevel, FilterValues<S> values) throws IOException {
        this.indent(app, indentLevel);
        app.append("collection iterator: ");
        app.append(this.mType.getName());
        this.newline(app);
        return true;
    }
}

