/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.qe;

import com.amazon.carbonado.Cursor;
import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.Query;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.filter.Filter;
import com.amazon.carbonado.filter.FilterValues;
import com.amazon.carbonado.filter.PropertyFilter;
import com.amazon.carbonado.filter.RelOp;
import com.amazon.carbonado.info.Direction;
import com.amazon.carbonado.info.StorableIndex;
import com.amazon.carbonado.qe.AbstractQueryExecutor;
import com.amazon.carbonado.qe.BoundaryType;
import com.amazon.carbonado.qe.CompositeScore;
import com.amazon.carbonado.qe.FilteringScore;
import com.amazon.carbonado.qe.OrderingList;
import com.amazon.carbonado.qe.OrderingScore;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexedQueryExecutor<S extends Storable>
extends AbstractQueryExecutor<S> {
    private final Support<S> mSupport;
    private final StorableIndex<S> mIndex;
    private final int mHandledCount;
    private final int mIdentityCount;
    private final Filter<S> mIdentityFilter;
    private final List<PropertyFilter<S>> mExclusiveRangeStartFilters;
    private final List<PropertyFilter<S>> mInclusiveRangeStartFilters;
    private final List<PropertyFilter<S>> mExclusiveRangeEndFilters;
    private final List<PropertyFilter<S>> mInclusiveRangeEndFilters;
    private final boolean mReverseOrder;
    private final boolean mReverseRange;
    private final Filter<S> mCoveringFilter;
    private final Query<?>[] mIndexEntryQueryCache;

    static int compareWithNullHigh(Object a, Object b) {
        return a == null ? (b == null ? 0 : -1) : (b == null ? 1 : ((Comparable)a).compareTo(b));
    }

    public IndexedQueryExecutor(Support<S> support, StorableIndex<S> index, CompositeScore<S> score) throws FetchException {
        if (support == null && this instanceof Support) {
            support = (Support)((Object)this);
        }
        if (support == null || index == null || score == null) {
            throw new IllegalArgumentException();
        }
        this.mSupport = support;
        this.mIndex = index;
        FilteringScore<S> fScore = score.getFilteringScore();
        OrderingScore<S> oScore = score.getOrderingScore();
        this.mHandledCount = oScore.getHandledCount();
        this.mIdentityCount = fScore.getIdentityCount();
        this.mIdentityFilter = fScore.getIdentityFilter();
        this.mExclusiveRangeStartFilters = fScore.getExclusiveRangeStartFilters();
        this.mInclusiveRangeStartFilters = fScore.getInclusiveRangeStartFilters();
        this.mExclusiveRangeEndFilters = fScore.getExclusiveRangeEndFilters();
        this.mInclusiveRangeEndFilters = fScore.getInclusiveRangeEndFilters();
        this.mReverseOrder = oScore.shouldReverseOrder();
        this.mReverseRange = fScore.shouldReverseRange();
        Query<?> indexEntryQuery = support.indexEntryQuery(index);
        if (indexEntryQuery == null) {
            this.mCoveringFilter = null;
            this.mIndexEntryQueryCache = null;
        } else {
            this.mCoveringFilter = fScore.getCoveringFilter();
            this.mIndexEntryQueryCache = new Query[9];
        }
    }

    @Override
    public Class<S> getStorableType() {
        return this.mIndex.getStorableType();
    }

    @Override
    public Cursor<S> fetch(FilterValues<S> values) throws FetchException {
        Query<?> indexEntryQuery;
        Object[] identityValues = null;
        Object rangeStartValue = null;
        Object rangeEndValue = null;
        BoundaryType rangeStartBoundary = BoundaryType.OPEN;
        BoundaryType rangeEndBoundary = BoundaryType.OPEN;
        if (values != null) {
            Object value;
            if (this.mIdentityFilter != null) {
                identityValues = values.getValuesFor(this.mIdentityFilter);
            }
            int i = this.mExclusiveRangeStartFilters.size();
            while (--i >= 0) {
                value = values.getValue(this.mExclusiveRangeStartFilters.get(i));
                if (rangeStartBoundary != BoundaryType.OPEN && IndexedQueryExecutor.compareWithNullHigh(value, rangeStartValue) <= 0) continue;
                rangeStartValue = value;
                rangeStartBoundary = BoundaryType.EXCLUSIVE;
            }
            i = this.mInclusiveRangeStartFilters.size();
            while (--i >= 0) {
                value = values.getValue(this.mInclusiveRangeStartFilters.get(i));
                if (rangeStartBoundary != BoundaryType.OPEN && IndexedQueryExecutor.compareWithNullHigh(value, rangeStartValue) <= 0) continue;
                rangeStartValue = value;
                rangeStartBoundary = BoundaryType.INCLUSIVE;
            }
            i = this.mExclusiveRangeEndFilters.size();
            while (--i >= 0) {
                value = values.getValue(this.mExclusiveRangeEndFilters.get(i));
                if (rangeEndBoundary != BoundaryType.OPEN && IndexedQueryExecutor.compareWithNullHigh(value, rangeEndValue) >= 0) continue;
                rangeEndValue = value;
                rangeEndBoundary = BoundaryType.EXCLUSIVE;
            }
            i = this.mInclusiveRangeEndFilters.size();
            while (--i >= 0) {
                value = values.getValue(this.mInclusiveRangeEndFilters.get(i));
                if (rangeEndBoundary != BoundaryType.OPEN && IndexedQueryExecutor.compareWithNullHigh(value, rangeEndValue) >= 0) continue;
                rangeEndValue = value;
                rangeEndBoundary = BoundaryType.INCLUSIVE;
            }
        }
        if ((indexEntryQuery = this.getIndexEntryQuery(rangeStartBoundary, rangeEndBoundary)) == null) {
            return this.mSupport.fetchSubset(this.mIndex, identityValues, rangeStartBoundary, rangeStartValue, rangeEndBoundary, rangeEndValue, this.mReverseRange, this.mReverseOrder);
        }
        indexEntryQuery = indexEntryQuery.withValues(identityValues);
        if (rangeStartBoundary != BoundaryType.OPEN) {
            indexEntryQuery = indexEntryQuery.with(rangeStartValue);
        }
        if (rangeEndBoundary != BoundaryType.OPEN) {
            indexEntryQuery = indexEntryQuery.with(rangeEndValue);
        }
        if (this.mCoveringFilter != null && values != null) {
            indexEntryQuery = indexEntryQuery.withValues(values.getValuesFor(this.mCoveringFilter));
        }
        return this.mSupport.fetchFromIndexEntryQuery(this.mIndex, indexEntryQuery);
    }

    public Filter<S> getCoveringFilter() {
        return this.mCoveringFilter;
    }

    @Override
    public Filter<S> getFilter() {
        Filter<S> filter = this.mIdentityFilter;
        for (PropertyFilter<S> p : this.mExclusiveRangeStartFilters) {
            filter = filter == null ? p : filter.and(p);
        }
        for (PropertyFilter<S> p : this.mInclusiveRangeStartFilters) {
            filter = filter == null ? p : filter.and(p);
        }
        for (PropertyFilter<S> p : this.mExclusiveRangeEndFilters) {
            filter = filter == null ? p : filter.and(p);
        }
        for (PropertyFilter<S> p : this.mInclusiveRangeEndFilters) {
            filter = filter == null ? p : filter.and(p);
        }
        if (this.mCoveringFilter != null) {
            Filter<S> filter2 = filter = filter == null ? this.mCoveringFilter : filter.and(this.mCoveringFilter);
        }
        if (filter == null) {
            return Filter.getOpenFilter(this.getStorableType());
        }
        return filter;
    }

    @Override
    public OrderingList<S> getOrdering() {
        List list;
        if (this.mHandledCount == 0) {
            list = OrderingList.emptyList();
        } else {
            list = OrderingList.get(this.mIndex.getOrderedProperties());
            if (this.mIdentityCount > 0) {
                list = ((OrderingList)list).subList(this.mIdentityCount, ((OrderingList)list).size());
            }
            if (this.mHandledCount < ((OrderingList)list).size()) {
                list = ((OrderingList)list).subList(0, this.mHandledCount);
            }
            if (this.mReverseOrder) {
                list = ((OrderingList)list).reverseDirections();
            }
        }
        return list;
    }

    @Override
    public boolean printPlan(Appendable app, int indentLevel, FilterValues<S> values) throws IOException {
        this.indent(app, indentLevel);
        if (this.mReverseOrder) {
            app.append("reverse ");
        }
        if (this.mIndex.isClustered()) {
            app.append("clustered ");
        }
        app.append("index scan: ");
        app.append(this.mIndex.getStorableType().getName());
        this.newline(app);
        this.indent(app, indentLevel);
        app.append("...index: ");
        this.mIndex.appendTo(app);
        this.newline(app);
        if (this.mIdentityFilter != null) {
            this.indent(app, indentLevel);
            app.append("...identity filter: ");
            this.mIdentityFilter.appendTo(app, values);
            this.newline(app);
        }
        if (this.mInclusiveRangeStartFilters.size() > 0 || this.mExclusiveRangeStartFilters.size() > 0 || this.mInclusiveRangeEndFilters.size() > 0 || this.mExclusiveRangeEndFilters.size() > 0) {
            this.indent(app, indentLevel);
            app.append("...range filter: ");
            int count = 0;
            for (PropertyFilter<S> p : this.mExclusiveRangeStartFilters) {
                if (count++ > 0) {
                    app.append(" & ");
                }
                p.appendTo(app, values);
            }
            for (PropertyFilter<S> p : this.mInclusiveRangeStartFilters) {
                if (count++ > 0) {
                    app.append(" & ");
                }
                p.appendTo(app, values);
            }
            for (PropertyFilter<S> p : this.mExclusiveRangeEndFilters) {
                if (count++ > 0) {
                    app.append(" & ");
                }
                p.appendTo(app, values);
            }
            for (PropertyFilter<S> p : this.mInclusiveRangeEndFilters) {
                if (count++ > 0) {
                    app.append(" & ");
                }
                p.appendTo(app, values);
            }
            this.newline(app);
        }
        if (this.mCoveringFilter != null) {
            this.indent(app, indentLevel);
            app.append("...covering filter: ");
            this.mCoveringFilter.appendTo(app, values);
            this.newline(app);
        }
        return true;
    }

    private Query<?> getIndexEntryQuery(BoundaryType rangeStartBoundary, BoundaryType rangeEndBoundary) throws FetchException {
        Query<?> indexEntryQuery;
        Query<?>[] indexEntryQueryCache = this.mIndexEntryQueryCache;
        if (indexEntryQueryCache == null) {
            return null;
        }
        int key = 0;
        if (rangeEndBoundary != BoundaryType.OPEN) {
            key += rangeEndBoundary == BoundaryType.INCLUSIVE ? 1 : 2;
        }
        if (rangeStartBoundary != BoundaryType.OPEN) {
            key += rangeStartBoundary == BoundaryType.INCLUSIVE ? 3 : 6;
        }
        if ((indexEntryQuery = indexEntryQueryCache[key]) == null) {
            RelOp op;
            int i;
            indexEntryQuery = this.mSupport.indexEntryQuery(this.mIndex);
            Filter<?> filter = indexEntryQuery.getFilter();
            for (i = 0; i < this.mIdentityCount; ++i) {
                filter = filter.and(this.mIndex.getProperty(i).getName(), RelOp.EQ);
            }
            if (rangeStartBoundary != BoundaryType.OPEN) {
                op = rangeStartBoundary == BoundaryType.INCLUSIVE ? RelOp.GE : RelOp.GT;
                filter = filter.and(this.mIndex.getProperty(i).getName(), op);
            }
            if (rangeEndBoundary != BoundaryType.OPEN) {
                op = rangeEndBoundary == BoundaryType.INCLUSIVE ? RelOp.LE : RelOp.LT;
                filter = filter.and(this.mIndex.getProperty(i).getName(), op);
            }
            if (this.mCoveringFilter != null) {
                filter = filter.and(this.mCoveringFilter.unbind().toString());
            }
            indexEntryQuery = indexEntryQuery.and(filter);
            if (this.mIdentityCount < this.mIndex.getPropertyCount()) {
                String[] orderProperties = new String[this.mIdentityCount + 1];
                for (i = 0; i < orderProperties.length; ++i) {
                    Direction dir = this.mIndex.getPropertyDirection(i);
                    if (dir == Direction.UNSPECIFIED) {
                        dir = Direction.ASCENDING;
                    }
                    if (this.mReverseOrder) {
                        dir = dir.reverse();
                    }
                    orderProperties[i] = dir.toCharacter() + this.mIndex.getProperty(i).getName();
                }
                indexEntryQuery = indexEntryQuery.orderBy(orderProperties);
            }
            this.mIndexEntryQueryCache[key] = indexEntryQuery;
        }
        return indexEntryQuery;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Support<S extends Storable> {
        public Query<?> indexEntryQuery(StorableIndex<S> var1) throws FetchException;

        public Cursor<S> fetchFromIndexEntryQuery(StorableIndex<S> var1, Query<?> var2) throws FetchException;

        public Cursor<S> fetchSubset(StorableIndex<S> var1, Object[] var2, BoundaryType var3, Object var4, BoundaryType var5, Object var6, boolean var7, boolean var8) throws FetchException;
    }
}

