/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.qe;

import com.amazon.carbonado.Cursor;
import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.PersistNoneException;
import com.amazon.carbonado.Query;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.cursor.EmptyCursor;
import com.amazon.carbonado.filter.Filter;
import com.amazon.carbonado.filter.FilterValues;
import com.amazon.carbonado.info.OrderedProperty;
import com.amazon.carbonado.qe.AbstractQuery;
import com.amazon.carbonado.qe.OrderingList;
import com.amazon.carbonado.qe.QueryFactory;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EmptyQuery<S extends Storable>
extends AbstractQuery<S> {
    private final QueryFactory<S> mFactory;
    private final OrderingList<S> mOrdering;

    public EmptyQuery(QueryFactory<S> factory, OrderingList<S> ordering) {
        if (factory == null) {
            throw new IllegalArgumentException();
        }
        this.mFactory = factory;
        if (ordering == null) {
            ordering = OrderingList.emptyList();
        }
        this.mOrdering = ordering;
    }

    public EmptyQuery(QueryFactory<S> factory, String ordering) {
        this(factory, OrderingList.get(factory.getStorableType(), ordering));
    }

    public EmptyQuery(QueryFactory<S> factory, String ... orderings) {
        this(factory, OrderingList.get(factory.getStorableType(), orderings));
    }

    EmptyQuery() {
        this.mFactory = null;
        this.mOrdering = OrderingList.emptyList();
    }

    @Override
    public Class<S> getStorableType() {
        return this.mFactory.getStorableType();
    }

    @Override
    public Filter<S> getFilter() {
        return Filter.getClosedFilter(this.getStorableType());
    }

    @Override
    public FilterValues<S> getFilterValues() {
        return null;
    }

    @Override
    public int getBlankParameterCount() {
        return 0;
    }

    @Override
    public Query<S> with(int value) {
        throw this.error();
    }

    @Override
    public Query<S> with(long value) {
        throw this.error();
    }

    @Override
    public Query<S> with(float value) {
        throw this.error();
    }

    @Override
    public Query<S> with(double value) {
        throw this.error();
    }

    @Override
    public Query<S> with(boolean value) {
        throw this.error();
    }

    @Override
    public Query<S> with(char value) {
        throw this.error();
    }

    @Override
    public Query<S> with(byte value) {
        throw this.error();
    }

    @Override
    public Query<S> with(short value) {
        throw this.error();
    }

    @Override
    public Query<S> with(Object value) {
        throw this.error();
    }

    @Override
    public Query<S> withValues(Object ... values) {
        if (values == null || values.length == 0) {
            return this;
        }
        throw this.error();
    }

    @Override
    public Query<S> and(Filter<S> filter) {
        throw new IllegalStateException("Query is already guaranteed to fetch nothing");
    }

    @Override
    public Query<S> or(Filter<S> filter) throws FetchException {
        return this.mFactory.query(filter, null, this.mOrdering, null);
    }

    @Override
    public Query<S> not() throws FetchException {
        return this.mFactory.query(null, null, this.mOrdering, null);
    }

    @Override
    public Query<S> orderBy(String property) throws FetchException {
        return new EmptyQuery<S>(this.mFactory, property);
    }

    @Override
    public Query<S> orderBy(String ... properties) throws FetchException {
        return new EmptyQuery<S>(this.mFactory, properties);
    }

    @Override
    public <T extends S> Query<S> after(T start) {
        return this;
    }

    @Override
    public Cursor<S> fetch() {
        return EmptyCursor.the();
    }

    @Override
    public Cursor<S> fetchSlice(long from, Long to) {
        this.checkSliceArguments(from, to);
        return EmptyCursor.the();
    }

    @Override
    public void deleteOne() throws PersistNoneException {
        throw new PersistNoneException();
    }

    @Override
    public boolean tryDeleteOne() {
        return false;
    }

    @Override
    public void deleteAll() {
    }

    @Override
    public long count() {
        return 0L;
    }

    @Override
    public boolean exists() {
        return false;
    }

    @Override
    public void appendTo(Appendable app) throws IOException {
        app.append("Query {type=");
        app.append(this.getStorableType().getName());
        app.append(", filter=");
        this.getFilter().appendTo(app);
        if (this.mOrdering != null && this.mOrdering.size() > 0) {
            app.append(", orderBy=[");
            for (int i = 0; i < this.mOrdering.size(); ++i) {
                if (i > 0) {
                    app.append(", ");
                }
                app.append(((OrderedProperty)this.mOrdering.get(i)).toString());
            }
            app.append(']');
        }
        app.append('}');
    }

    @Override
    public boolean printNative(Appendable app, int indentLevel) {
        return false;
    }

    @Override
    public boolean printPlan(Appendable app, int indentLevel) {
        return false;
    }

    @Override
    public int hashCode() {
        return this.mFactory.hashCode() * 31 + this.mOrdering.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof EmptyQuery) {
            EmptyQuery other = (EmptyQuery)obj;
            return this.mFactory.equals(other.mFactory) && this.mOrdering.equals(other.mOrdering);
        }
        return false;
    }

    private IllegalStateException error() {
        return new IllegalStateException("Query doesn't have any parameters");
    }
}

