/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.qe;

import com.amazon.carbonado.Cursor;
import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.Query;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.Storage;
import com.amazon.carbonado.filter.Filter;
import com.amazon.carbonado.filter.FilterValues;
import com.amazon.carbonado.qe.OrderingList;
import com.amazon.carbonado.qe.QueryExecutor;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatedQueryExecutor<S extends Storable>
implements QueryExecutor<S> {
    private final Filter<S> mFilter;
    private final OrderingList<S> mOrdering;
    private final Query<S> mQuery;

    private static final <T> T check(T object) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        return object;
    }

    public DelegatedQueryExecutor(Storage<S> rootStorage, QueryExecutor<S> executor) throws FetchException {
        executor = DelegatedQueryExecutor.check(executor);
        this(rootStorage, executor.getFilter(), executor.getOrdering());
    }

    public DelegatedQueryExecutor(Storage<S> rootStorage, Filter<S> filter, OrderingList<S> ordering) throws FetchException {
        DelegatedQueryExecutor.check(rootStorage);
        Query<S> query = filter == null ? rootStorage.query() : rootStorage.query(filter);
        if (ordering == null) {
            ordering = OrderingList.emptyList();
        } else if (ordering.size() > 0) {
            query = query.orderBy(ordering.asStringArray());
        }
        this.mFilter = filter;
        this.mOrdering = ordering;
        this.mQuery = query;
    }

    @Override
    public Class<S> getStorableType() {
        return this.mFilter.getStorableType();
    }

    @Override
    public Cursor<S> fetch(FilterValues<S> values) throws FetchException {
        return this.applyFilterValues(values).fetch();
    }

    @Override
    public Cursor<S> fetchSlice(FilterValues<S> values, long from, Long to) throws FetchException {
        return this.applyFilterValues(values).fetchSlice(from, to);
    }

    @Override
    public long count(FilterValues<S> values) throws FetchException {
        return this.applyFilterValues(values).count();
    }

    @Override
    public Filter<S> getFilter() {
        return this.mFilter;
    }

    @Override
    public OrderingList<S> getOrdering() {
        return this.mOrdering;
    }

    @Override
    public boolean printNative(Appendable app, int indentLevel, FilterValues<S> values) throws IOException {
        return this.applyFilterValues(values).printNative(app, indentLevel);
    }

    @Override
    public boolean printPlan(Appendable app, int indentLevel, FilterValues<S> values) throws IOException {
        Query<S> query;
        try {
            query = this.applyFilterValues(values);
        }
        catch (IllegalStateException e) {
            query = this.mQuery;
        }
        return query.printPlan(app, indentLevel);
    }

    private Query<S> applyFilterValues(FilterValues<S> values) {
        Query<S> query = this.mQuery;
        Filter<S> filter = query.getFilter();
        if (values != null && filter != null && query.getBlankParameterCount() != 0) {
            query = query.withValues(values.getSuppliedValuesFor(filter));
        }
        return query;
    }
}

