/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.lob;

import com.amazon.carbonado.PersistException;
import com.amazon.carbonado.lob.AbstractClob;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;

public class CharArrayClob
extends AbstractClob {
    private final int mInitialCapacity;
    private char[] mData;
    private int mLength;

    public CharArrayClob(int capacity) {
        if (capacity == 0) {
            throw new IllegalArgumentException();
        }
        this.mInitialCapacity = capacity;
        this.mData = new char[capacity];
    }

    public CharArrayClob(char[] data) {
        if (data.length == 0) {
            throw new IllegalArgumentException();
        }
        this.mLength = this.mInitialCapacity = data.length;
        this.mData = data;
    }

    public CharArrayClob(char[] data, int length) {
        if (data.length < length) {
            throw new IllegalArgumentException();
        }
        this.mInitialCapacity = data.length;
        this.mData = data;
        this.mLength = length;
    }

    public Reader openReader() {
        return new Input(this, 0L);
    }

    public Reader openReader(long pos) {
        if (pos < 0L) {
            throw new IllegalArgumentException("Position is negative: " + pos);
        }
        return new Input(this, pos);
    }

    public Reader openReader(long pos, int bufferSize) {
        return this.openReader(pos);
    }

    public synchronized long getLength() {
        return this.mLength;
    }

    public synchronized String asString() {
        return new String(this.mData, 0, this.mLength);
    }

    synchronized int read(long pos) {
        if (pos < 0L) {
            throw new IllegalArgumentException("Position is negative: " + pos);
        }
        if (pos > Integer.MAX_VALUE) {
            return -1;
        }
        int ipos = (int)pos;
        if (ipos >= this.mLength) {
            return -1;
        }
        return this.mData[ipos];
    }

    synchronized int read(long pos, char[] chars) {
        if (pos < 0L) {
            throw new IllegalArgumentException("Position is negative: " + pos);
        }
        if (chars == null) {
            throw new IllegalArgumentException("Character array is null");
        }
        if (pos > Integer.MAX_VALUE) {
            return -1;
        }
        int ipos = (int)pos;
        if (ipos > this.mLength) {
            return -1;
        }
        int length = chars.length;
        if (ipos + length > this.mLength) {
            length = this.mLength - ipos;
        }
        if (length > 0) {
            System.arraycopy(this.mData, ipos, chars, 0, length);
            return length;
        }
        return -1;
    }

    synchronized int read(long pos, char[] chars, int offset, int length) {
        if (pos < 0L) {
            throw new IllegalArgumentException("Position is negative: " + pos);
        }
        if (chars == null) {
            throw new IllegalArgumentException("Character array is null");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("Offset is negative: " + offset);
        }
        if (length < 0) {
            throw new IllegalArgumentException("Length is negative: " + length);
        }
        if (pos > Integer.MAX_VALUE) {
            return -1;
        }
        int ipos = (int)pos;
        if (ipos > this.mLength) {
            return -1;
        }
        if (ipos + length > this.mLength) {
            length = this.mLength - ipos;
        }
        if (length > 0) {
            try {
                System.arraycopy(this.mData, ipos, chars, offset, length);
            }
            catch (IndexOutOfBoundsException e) {
                if (offset >= chars.length && length > 0) {
                    throw new IllegalArgumentException("Offset is too large: " + offset);
                }
                throw e;
            }
            return length;
        }
        return -1;
    }

    public Writer openWriter() {
        return new Output(this, 0L);
    }

    public Writer openWriter(long pos) {
        if (pos < 0L) {
            throw new IllegalArgumentException("Position is negative: " + pos);
        }
        return new Output(this, pos);
    }

    public Writer openWriter(long pos, int bufferSize) {
        return this.openWriter(pos);
    }

    public synchronized void setLength(long length) throws PersistException {
        if (length < 0L) {
            throw new IllegalArgumentException("Length is negative: " + length);
        }
        if (length > Integer.MAX_VALUE) {
            throw new PersistException("Length too long: " + length);
        }
        int ilength = (int)length;
        if (ilength < this.mLength) {
            this.mLength = ilength;
            if (this.mData.length > this.mInitialCapacity) {
                this.mData = new char[this.mInitialCapacity];
            }
        } else if (ilength > this.mLength) {
            if (ilength <= this.mData.length) {
                Arrays.fill(this.mData, this.mLength, ilength, '\u0000');
                this.mLength = ilength;
            } else {
                int newLength = this.mData.length * 2;
                if (newLength < ilength) {
                    newLength = ilength;
                }
                char[] newData = new char[newLength];
                System.arraycopy(this.mData, 0, newData, 0, this.mLength);
            }
            this.mLength = ilength;
        }
    }

    synchronized void write(long pos, int b) throws IOException {
        if (pos < 0L) {
            throw new IllegalArgumentException("Position is negative: " + pos);
        }
        if (pos > Integer.MAX_VALUE) {
            throw new IOException("Position too high: " + pos);
        }
        int ipos = (int)pos;
        this.ensureLengthForWrite(ipos + 1);
        this.mData[ipos] = (char)b;
    }

    synchronized void write(long pos, char[] chars) throws IOException {
        if (pos < 0L) {
            throw new IllegalArgumentException("Position is negative: " + pos);
        }
        if (chars == null) {
            throw new IllegalArgumentException("Character array is null");
        }
        if (pos > Integer.MAX_VALUE) {
            throw new IOException("Position too high: " + pos);
        }
        if (pos + (long)chars.length > Integer.MAX_VALUE) {
            throw new IOException("Position plus length too high: " + (pos + (long)chars.length));
        }
        int ipos = (int)pos;
        this.ensureLengthForWrite(ipos + chars.length);
        System.arraycopy(chars, 0, this.mData, ipos, chars.length);
    }

    synchronized void write(long pos, char[] chars, int offset, int length) throws IOException {
        if (pos < 0L) {
            throw new IllegalArgumentException("Position is negative: " + pos);
        }
        if (chars == null) {
            throw new IllegalArgumentException("Character array is null");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("Offset is negative: " + offset);
        }
        if (length < 0) {
            throw new IllegalArgumentException("Length is negative: " + length);
        }
        if (pos > Integer.MAX_VALUE) {
            throw new IOException("Position too high: " + pos);
        }
        if (pos + (long)length > Integer.MAX_VALUE) {
            throw new IOException("Position plus length too high: " + (pos + (long)length));
        }
        int ipos = (int)pos;
        this.ensureLengthForWrite(ipos + length);
        System.arraycopy(chars, offset, this.mData, ipos, length);
    }

    private void ensureLengthForWrite(int ilength) {
        if (ilength > this.mLength) {
            if (ilength <= this.mData.length) {
                this.mLength = ilength;
            } else {
                int newLength = this.mData.length * 2;
                if (newLength < ilength) {
                    newLength = ilength;
                }
                char[] newData = new char[newLength];
                System.arraycopy(this.mData, 0, newData, 0, this.mLength);
                this.mData = newData;
            }
            this.mLength = ilength;
        }
    }

    public Object getLocator() {
        return null;
    }

    private static class Output
    extends Writer {
        private final CharArrayClob mClob;
        private long mPos;

        Output(CharArrayClob blob, long pos) {
            this.mClob = blob;
            this.mPos = pos;
        }

        public void write(int b) throws IOException {
            this.mClob.write(this.mPos, b);
            ++this.mPos;
        }

        public void write(char[] b) throws IOException {
            this.mClob.write(this.mPos, b);
            this.mPos += (long)b.length;
        }

        public void write(char[] b, int offset, int length) throws IOException {
            this.mClob.write(this.mPos, b, offset, length);
            this.mPos += (long)length;
        }

        public void flush() {
        }

        public void close() {
        }
    }

    private static class Input
    extends Reader {
        private final CharArrayClob mClob;
        private long mPos;
        private long mMarkPos;

        Input(CharArrayClob blob, long pos) {
            this.mClob = blob;
            this.mPos = pos;
            this.mMarkPos = pos;
        }

        public int read() {
            int b = this.mClob.read(this.mPos);
            if (b >= 0) {
                ++this.mPos;
            }
            return b;
        }

        public int read(char[] chars) {
            int length = this.mClob.read(this.mPos, chars);
            if (length > 0) {
                this.mPos += (long)length;
            }
            return length;
        }

        public int read(char[] chars, int offset, int length) {
            if ((length = this.mClob.read(this.mPos, chars, offset, length)) > 0) {
                this.mPos += (long)length;
            }
            return length;
        }

        public long skip(long n) {
            long length;
            if (n <= 0L) {
                return 0L;
            }
            long newPos = this.mPos + n;
            if (newPos < 0L) {
                newPos = Long.MAX_VALUE;
            }
            if (newPos > (length = this.mClob.getLength())) {
                newPos = length;
            }
            n = newPos - this.mPos;
            this.mPos = newPos;
            return n;
        }

        public boolean ready() {
            return this.mClob.getLength() - this.mPos > 0L;
        }

        public void mark(int readlimit) {
            this.mMarkPos = this.mPos;
        }

        public void reset() {
            this.mPos = this.mMarkPos;
        }

        public boolean markSupported() {
            return true;
        }

        public void close() {
        }
    }
}

