/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.layout;

import com.amazon.carbonado.Cursor;
import com.amazon.carbonado.FetchDeadlockException;
import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.FetchNoneException;
import com.amazon.carbonado.FetchTimeoutException;
import com.amazon.carbonado.IsolationLevel;
import com.amazon.carbonado.PersistDeadlockException;
import com.amazon.carbonado.PersistException;
import com.amazon.carbonado.PersistTimeoutException;
import com.amazon.carbonado.Repository;
import com.amazon.carbonado.RepositoryException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.Storage;
import com.amazon.carbonado.Transaction;
import com.amazon.carbonado.UniqueConstraintException;
import com.amazon.carbonado.capability.ResyncCapability;
import com.amazon.carbonado.info.StorableInfo;
import com.amazon.carbonado.info.StorableIntrospector;
import com.amazon.carbonado.info.StorableProperty;
import com.amazon.carbonado.info.StorablePropertyAdapter;
import com.amazon.carbonado.info.StorablePropertyAnnotation;
import com.amazon.carbonado.layout.Layout;
import com.amazon.carbonado.layout.LayoutCapability;
import com.amazon.carbonado.layout.LayoutOptions;
import com.amazon.carbonado.layout.StoredLayout;
import com.amazon.carbonado.layout.StoredLayoutProperty;
import com.amazon.carbonado.util.SoftValuedCache;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutFactory
implements LayoutCapability {
    private static final int[] HASH_MULTIPLIERS = new int[]{31, 63};
    final Repository mRepository;
    final Storage<StoredLayout> mLayoutStorage;
    final Storage<StoredLayoutProperty> mPropertyStorage;
    private SoftValuedCache<Class<? extends Storable>, Layout> mReconstructed;

    public LayoutFactory(Repository repo) throws RepositoryException {
        this.mRepository = repo;
        this.mLayoutStorage = repo.storageFor(StoredLayout.class);
        this.mPropertyStorage = repo.storageFor(StoredLayoutProperty.class);
    }

    @Override
    public Layout layoutFor(Class<? extends Storable> type) throws FetchException, PersistException {
        return this.layoutFor(type, null);
    }

    public Layout layoutFor(Class<? extends Storable> type, LayoutOptions options) throws FetchException, PersistException {
        return this.layoutFor(false, type, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Layout layoutFor(boolean readOnly, Class<? extends Storable> type, LayoutOptions options) throws FetchException, PersistException {
        Layout layout;
        if (options != null) {
            options.readOnly();
        }
        LayoutFactory layoutFactory = this;
        synchronized (layoutFactory) {
            if (this.mReconstructed != null && (layout = this.mReconstructed.get(type)) != null) {
                return layout;
            }
        }
        StorableInfo<? extends Storable> info = StorableIntrospector.examine(type);
        ResyncCapability resyncCap = null;
        boolean top = true;
        int retryCount = 3;
        block16: while (true) {
            try {
                Transaction txn = top ? this.mRepository.enterTopTransaction(IsolationLevel.READ_COMMITTED) : this.mRepository.enterTransaction(IsolationLevel.READ_COMMITTED);
                txn.setForUpdate(!readOnly);
                try {
                    Layout newLayout = null;
                    for (int i = 0; i < HASH_MULTIPLIERS.length; ++i) {
                        long layoutID = this.mixInHash(0L, info, options, HASH_MULTIPLIERS[i]);
                        newLayout = new Layout(this, info, options, layoutID);
                        StoredLayout storedLayout = this.mLayoutStorage.prepare();
                        storedLayout.setLayoutID(layoutID);
                        if (!storedLayout.tryLoad()) break;
                        Layout knownLayout = new Layout(this, storedLayout);
                        if (knownLayout.equalLayouts(newLayout)) {
                            layout = knownLayout;
                            break block16;
                        }
                        if (knownLayout.getAllProperties().size() == 0) break;
                        if (i < HASH_MULTIPLIERS.length - 1) continue;
                        throw new FetchException("Unable to generate unique layout identifier for " + type.getName());
                    }
                    assert (newLayout != null);
                    int generation = 0;
                    Cursor<StoredLayout> cursor = this.mLayoutStorage.query("storableTypeName = ?").with(info.getStorableType().getName()).orderBy("-generation").fetch();
                    try {
                        if (cursor.hasNext()) {
                            generation = cursor.next().getGeneration() + 1;
                        }
                    }
                    finally {
                        cursor.close();
                    }
                    newLayout.insert(readOnly, generation);
                    layout = newLayout;
                    txn.commit();
                }
                finally {
                    txn.exit();
                }
            }
            catch (UniqueConstraintException e) {
                retryCount = UniqueConstraintException.backoff(e, retryCount, 1000);
                resyncCap = this.mRepository.getCapability(ResyncCapability.class);
                continue;
            }
            catch (FetchException e) {
                if ((e instanceof FetchDeadlockException || e instanceof FetchTimeoutException) && top) {
                    top = false;
                    retryCount = FetchException.backoff(e, retryCount, 100);
                    continue;
                }
                throw e;
            }
            catch (PersistException e) {
                if ((e instanceof PersistDeadlockException || e instanceof PersistTimeoutException) && top) {
                    top = false;
                    retryCount = PersistException.backoff(e, retryCount, 100);
                    continue;
                }
                throw e;
            }
            break;
        }
        if (!readOnly && resyncCap != null) {
            try {
                resyncCap.resync(StoredLayoutProperty.class, 1.0, null, new Object[0]);
            }
            catch (RepositoryException e) {
                throw e.toPersistException();
            }
        }
        return layout;
    }

    @Override
    public Layout layoutFor(Class<? extends Storable> type, int generation) throws FetchException, FetchNoneException {
        StoredLayout storedLayout = this.mLayoutStorage.query("storableTypeName = ? & generation = ?").with(type.getName()).with(generation).loadOne();
        return new Layout(this, storedLayout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Layout readLayoutFrom(InputStream in) throws IOException, RepositoryException {
        Transaction txn = this.mRepository.enterTransaction();
        try {
            int op;
            StoredLayout storedLayout;
            block8: {
                txn.setForUpdate(true);
                storedLayout = this.mLayoutStorage.prepare();
                storedLayout.readFrom(in);
                try {
                    storedLayout.insert();
                }
                catch (UniqueConstraintException e) {
                    StoredLayout existing = this.mLayoutStorage.prepare();
                    storedLayout.copyPrimaryKeyProperties(existing);
                    if (existing.tryLoad() && existing.equalProperties(storedLayout)) break block8;
                    throw e;
                }
            }
            while ((op = in.read()) != 0) {
                StoredLayoutProperty storedProperty = this.mPropertyStorage.prepare();
                storedProperty.readFrom(in);
                try {
                    storedProperty.insert();
                }
                catch (UniqueConstraintException e) {
                    StoredLayoutProperty existing = this.mPropertyStorage.prepare();
                    storedProperty.copyPrimaryKeyProperties(existing);
                    existing.load();
                    if (existing.tryLoad() && existing.equalProperties(storedProperty)) continue;
                    throw e;
                }
            }
            txn.commit();
            Layout layout = new Layout(this, storedLayout);
            return layout;
        }
        finally {
            txn.exit();
        }
    }

    synchronized void registerReconstructed(Class<? extends Storable> reconstructed, Layout layout) {
        if (this.mReconstructed == null) {
            this.mReconstructed = SoftValuedCache.newCache(7);
        }
        this.mReconstructed.put(reconstructed, layout);
    }

    private long mixInHash(long hash, StorableInfo<?> info, LayoutOptions options, int multiplier) {
        hash = this.mixInHash(hash, info.getStorableType().getName(), multiplier);
        hash = this.mixInHash(hash, options, multiplier);
        for (StorableProperty<?> property : info.getAllProperties().values()) {
            if (property.isJoin()) continue;
            hash = this.mixInHash(hash, property, multiplier);
        }
        return hash;
    }

    private long mixInHash(long hash, StorableProperty<?> property, int multiplier) {
        hash = this.mixInHash(hash, property.getName(), multiplier);
        hash = this.mixInHash(hash, property.getType().getName(), multiplier);
        hash = hash * (long)multiplier + (long)(property.isNullable() ? 1 : 2);
        hash = hash * (long)multiplier + (long)(property.isPrimaryKeyMember() ? 1 : 2);
        hash = hash * (long)multiplier + 1L;
        if (property.getAdapter() != null) {
            ++hash;
            StorablePropertyAdapter adapter = property.getAdapter();
            StorablePropertyAnnotation annotation = adapter.getAnnotation();
            hash = this.mixInHash(hash, annotation.getAnnotationType().getName(), multiplier);
            Annotation ann = annotation.getAnnotation();
            if (ann != null) {
                hash = hash * (long)multiplier + (long)LayoutFactory.annHashCode(ann);
            }
        }
        return hash;
    }

    private long mixInHash(long hash, CharSequence value, int multiplier) {
        int i = value.length();
        while (--i >= 0) {
            hash = hash * (long)multiplier + (long)value.charAt(i);
        }
        return hash;
    }

    private long mixInHash(long hash, LayoutOptions options, int multiplier) {
        byte[] data;
        if (options != null && (data = options.encode()) != null) {
            for (byte b : data) {
                hash = hash * (long)multiplier + (long)(b & 0xFF);
            }
        }
        return hash;
    }

    private static int annHashCode(Annotation ann) {
        Method[] methods;
        int hash = 0;
        for (Method m : methods = ann.getClass().getDeclaredMethods()) {
            Object value;
            String name;
            if (m.getReturnType() == null || m.getReturnType() == Void.TYPE || m.getParameterTypes().length != 0 || (name = m.getName()).equals("hashCode") || name.equals("toString") || name.equals("annotationType")) continue;
            try {
                value = m.invoke((Object)ann, new Object[0]);
            }
            catch (InvocationTargetException e) {
                continue;
            }
            catch (IllegalAccessException e) {
                continue;
            }
            hash += 127 * name.hashCode() ^ LayoutFactory.annValueHashCode(value);
        }
        return hash;
    }

    private static int annValueHashCode(Object value) {
        Class<?> type = value.getClass();
        if (!type.isArray()) {
            if (value instanceof String || type.isPrimitive()) {
                return value.hashCode();
            }
            if (value instanceof Class) {
                return ((Class)value).getName().hashCode();
            }
            if (value instanceof Enum) {
                return ((Enum)value).name().hashCode();
            }
            if (value instanceof Annotation) {
                return LayoutFactory.annHashCode((Annotation)value);
            }
            return value.hashCode();
        }
        if (type == byte[].class) {
            return Arrays.hashCode((byte[])value);
        }
        if (type == char[].class) {
            return Arrays.hashCode((char[])value);
        }
        if (type == double[].class) {
            return Arrays.hashCode((double[])value);
        }
        if (type == float[].class) {
            return Arrays.hashCode((float[])value);
        }
        if (type == int[].class) {
            return Arrays.hashCode((int[])value);
        }
        if (type == long[].class) {
            return Arrays.hashCode((long[])value);
        }
        if (type == short[].class) {
            return Arrays.hashCode((short[])value);
        }
        if (type == boolean[].class) {
            return Arrays.hashCode((boolean[])value);
        }
        return Arrays.hashCode((Object[])value);
    }
}

