/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.info;

import com.amazon.carbonado.adapter.AdapterDefinition;
import com.amazon.carbonado.info.StorablePropertyAnnotation;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.cojen.util.BeanProperty;
import org.cojen.util.ThrowUnchecked;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StorablePropertyAdapter {
    private final Class mEnclosingType;
    private final String mPropertyName;
    private final StorablePropertyAnnotation mAnnotation;
    private final Class[] mStorageTypePreferences;
    private final Constructor mConstructor;
    private final Method[] mAdaptMethods;
    private transient Object mAdapterInstance;

    static Class getEnclosingType(BeanProperty property) {
        Method m = property.getReadMethod();
        if (m == null) {
            m = property.getWriteMethod();
        }
        return m.getDeclaringClass();
    }

    static Class findAdapterClass(Class<? extends Annotation> annotationType) {
        AdapterDefinition ad = annotationType.getAnnotation(AdapterDefinition.class);
        if (ad == null) {
            return null;
        }
        Class<?> adapterClass = ad.implementation();
        if (adapterClass == Void.TYPE) {
            Class<?>[] innerClasses;
            adapterClass = null;
            for (Class<?> c : innerClasses = annotationType.getClasses()) {
                if (!"Adapter".equals(c.getSimpleName())) continue;
                adapterClass = c;
                break;
            }
        }
        return adapterClass;
    }

    static Method[] findAdaptMethods(Class<?> propertyType, Class<?> adapterClass) {
        ArrayList<Method> adaptMethods = new ArrayList<Method>();
        for (Method adaptMethod : adapterClass.getMethods()) {
            Class<?> fromType;
            Class<?>[] paramTypes;
            Class<?> toType;
            if (!adaptMethod.getName().startsWith("adapt") || (toType = adaptMethod.getReturnType()) == Void.TYPE || (paramTypes = adaptMethod.getParameterTypes()).length != 1 || !(fromType = paramTypes[0]).isAssignableFrom(propertyType) && !propertyType.isAssignableFrom(toType)) continue;
            adaptMethods.add(adaptMethod);
        }
        return adaptMethods.toArray(new Method[adaptMethods.size()]);
    }

    public StorablePropertyAdapter(String propertyName, Class<?> propertyType, Class<? extends Annotation> adapterType) {
        this(null, propertyName, propertyType, null, adapterType);
    }

    StorablePropertyAdapter(BeanProperty property, StorablePropertyAnnotation annotation, AdapterDefinition ad, Constructor ctor, Method[] adaptMethods) {
        this.mEnclosingType = StorablePropertyAdapter.getEnclosingType(property);
        this.mPropertyName = property.getName();
        this.mAnnotation = annotation;
        this.mConstructor = ctor;
        this.mAdaptMethods = adaptMethods;
        Class[] storageTypePreferences = ad.storageTypePreferences();
        if (storageTypePreferences != null && storageTypePreferences.length == 0) {
            storageTypePreferences = null;
        }
        this.mStorageTypePreferences = storageTypePreferences;
    }

    StorablePropertyAdapter(BeanProperty property, StorablePropertyAnnotation annotation) {
        this(StorablePropertyAdapter.getEnclosingType(property), property.getName(), property.getType(), annotation, annotation.getAnnotationType());
    }

    private StorablePropertyAdapter(Class enclosingType, String propertyName, Class<?> propertyType, StorablePropertyAnnotation annotation, Class<? extends Annotation> adapterType) {
        this.mEnclosingType = enclosingType;
        this.mPropertyName = propertyName;
        this.mAnnotation = annotation;
        AdapterDefinition ad = adapterType.getAnnotation(AdapterDefinition.class);
        if (ad == null) {
            throw new IllegalArgumentException();
        }
        Class[] storageTypePreferences = ad.storageTypePreferences();
        if (storageTypePreferences != null && storageTypePreferences.length == 0) {
            storageTypePreferences = null;
        }
        this.mStorageTypePreferences = storageTypePreferences;
        Class adapterClass = StorablePropertyAdapter.findAdapterClass(adapterType);
        if (adapterClass == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.mConstructor = adapterClass.getConstructor(Class.class, String.class, adapterType);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
        this.mAdaptMethods = StorablePropertyAdapter.findAdaptMethods(propertyType, adapterClass);
        if (this.mAdaptMethods.length == 0) {
            throw new IllegalArgumentException();
        }
    }

    public StorablePropertyAnnotation getAnnotation() {
        return this.mAnnotation;
    }

    public Constructor getAdapterConstructor() {
        return this.mConstructor;
    }

    public Object getAdapterInstance() {
        if (this.mAdapterInstance == null) {
            try {
                this.mAdapterInstance = this.mConstructor.newInstance(this.mEnclosingType, this.mPropertyName, this.mAnnotation.getAnnotation());
            }
            catch (Exception e) {
                ThrowUnchecked.fireFirstDeclaredCause((Throwable)e, (Class[])new Class[0]);
            }
        }
        return this.mAdapterInstance;
    }

    public Class[] getStorageTypePreferences() {
        if (this.mStorageTypePreferences == null) {
            return new Class[0];
        }
        return (Class[])this.mStorageTypePreferences.clone();
    }

    public Method findAdaptMethod(Class from, Class to) {
        Method[] methods = this.mAdaptMethods;
        ArrayList<Method> candidates = new ArrayList<Method>(methods.length);
        int i = methods.length;
        while (--i >= 0) {
            Method method = methods[i];
            if (!to.isAssignableFrom(method.getReturnType()) || !method.getParameterTypes()[0].isAssignableFrom(from)) continue;
            candidates.add(method);
        }
        this.reduceCandidates(candidates, to);
        if (candidates.size() == 0) {
            return null;
        }
        return (Method)candidates.get(0);
    }

    public Method[] findAdaptMethodsFrom(Class from) {
        Method[] methods = this.mAdaptMethods;
        ArrayList<Method> candidates = new ArrayList<Method>(methods.length);
        int i = methods.length;
        while (--i >= 0) {
            Method method = methods[i];
            if (!method.getParameterTypes()[0].isAssignableFrom(from)) continue;
            candidates.add(method);
        }
        return candidates.toArray(new Method[candidates.size()]);
    }

    public Method[] findAdaptMethodsTo(Class to) {
        Method[] methods = this.mAdaptMethods;
        ArrayList<Method> candidates = new ArrayList<Method>(methods.length);
        int i = methods.length;
        while (--i >= 0) {
            Method method = methods[i];
            if (!to.isAssignableFrom(method.getReturnType())) continue;
            candidates.add(method);
        }
        this.reduceCandidates(candidates, to);
        return candidates.toArray(new Method[candidates.size()]);
    }

    public int getAdaptMethodCount() {
        return this.mAdaptMethods.length;
    }

    public Method getAdaptMethod(int index) throws IndexOutOfBoundsException {
        return this.mAdaptMethods[index];
    }

    public Method[] getAdaptMethods() {
        return (Method[])this.mAdaptMethods.clone();
    }

    private void reduceCandidates(List<Method> candidates, Class to) {
        if (candidates.size() <= 1) {
            return;
        }
        LinkedHashMap fromMap = new LinkedHashMap();
        for (Method method : candidates) {
            Class<?> from = method.getParameterTypes()[0];
            ArrayList<Method> matches = (ArrayList<Method>)fromMap.get(from);
            if (matches == null) {
                matches = new ArrayList<Method>();
                fromMap.put(from, matches);
            }
            matches.add(method);
        }
        candidates.clear();
        for (List matches : fromMap.values()) {
            Method best = null;
            int bestDistance = Integer.MAX_VALUE;
            for (Method method : matches) {
                int distance = StorablePropertyAdapter.distance(method.getReturnType(), to);
                if (best != null && distance >= bestDistance) continue;
                best = method;
                bestDistance = distance;
            }
            candidates.add(best);
        }
    }

    private static int distance(Class from, Class to) {
        int distance = 0;
        while (from != to) {
            if ((from = from.getSuperclass()) == null) {
                return Integer.MAX_VALUE;
            }
            ++distance;
        }
        return distance;
    }
}

