/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.gen;

import com.amazon.carbonado.ConstraintException;
import com.amazon.carbonado.IsolationLevel;
import com.amazon.carbonado.OptimisticLockException;
import com.amazon.carbonado.PersistException;
import com.amazon.carbonado.Repository;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.SupportException;
import com.amazon.carbonado.Transaction;
import com.amazon.carbonado.gen.CodeBuilderUtil;
import com.amazon.carbonado.gen.MasterFeature;
import com.amazon.carbonado.gen.MasterSupport;
import com.amazon.carbonado.gen.StorableGenerator;
import com.amazon.carbonado.gen.TriggerSupport;
import com.amazon.carbonado.info.StorableInfo;
import com.amazon.carbonado.info.StorableIntrospector;
import com.amazon.carbonado.info.StorableProperty;
import com.amazon.carbonado.sequence.SequenceValueProducer;
import com.amazon.carbonado.util.SoftValuedCache;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.cojen.classfile.ClassFile;
import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.Label;
import org.cojen.classfile.LocalVariable;
import org.cojen.classfile.Location;
import org.cojen.classfile.MethodInfo;
import org.cojen.classfile.Modifiers;
import org.cojen.classfile.TypeDesc;
import org.cojen.util.ClassInjector;
import org.cojen.util.KeyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MasterStorableGenerator<S extends Storable> {
    public static final String DO_TRY_LOAD_MASTER_METHOD_NAME = "doTryLoad$";
    public static final String DO_TRY_INSERT_MASTER_METHOD_NAME = "doTryInsert$master";
    public static final String DO_TRY_UPDATE_MASTER_METHOD_NAME = "doTryUpdate$master";
    public static final String DO_TRY_DELETE_MASTER_METHOD_NAME = "doTryDelete$master";
    private static final String APPEND_UNINIT_PROPERTY = "appendUninitializedPropertyName$";
    private static final String INSERT_OP = "Insert";
    private static final String UPDATE_OP = "Update";
    private static final String DELETE_OP = "Delete";
    private static SoftValuedCache<Object, Class<? extends Storable>> cCache = SoftValuedCache.newCache(11);
    private final EnumSet<MasterFeature> mFeatures;
    private final StorableInfo<S> mInfo;
    private final Map<String, ? extends StorableProperty<S>> mAllProperties;
    private final ClassInjector mClassInjector;
    private final ClassFile mClassFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <S extends Storable> Class<? extends S> getAbstractClass(Class<S> type, EnumSet<MasterFeature> features) throws SupportException, IllegalArgumentException {
        StorableInfo<S> info = StorableIntrospector.examine(type);
        features = features == null ? EnumSet.noneOf(MasterFeature.class) : ((EnumSet)features).clone();
        boolean anySequences = false;
        boolean doNormalize = false;
        if (((AbstractCollection)features).contains((Object)MasterFeature.INSERT_SEQUENCES) || ((AbstractCollection)features).contains((Object)MasterFeature.NORMALIZE)) {
            for (StorableProperty<S> property : info.getAllProperties().values()) {
                if (property.isDerived() || property.isJoin()) continue;
                if (!anySequences && property.getSequenceName() != null) {
                    anySequences = true;
                }
                if (!doNormalize && BigDecimal.class.isAssignableFrom(property.getType())) {
                    doNormalize = true;
                }
                if (!anySequences || !doNormalize) continue;
                break;
            }
            if (!anySequences) {
                ((AbstractCollection)features).remove((Object)MasterFeature.INSERT_SEQUENCES);
            }
            if (!doNormalize) {
                ((AbstractCollection)features).remove((Object)MasterFeature.NORMALIZE);
            }
        }
        if (info.getVersionProperty() == null) {
            ((AbstractCollection)features).remove((Object)MasterFeature.VERSIONING);
        }
        if (info.getPartitionKey() == null || info.getPartitionKey().getProperties().size() == 0) {
            ((AbstractCollection)features).remove((Object)MasterFeature.PARTITIONING);
        }
        if (((AbstractCollection)features).contains((Object)MasterFeature.VERSIONING)) {
            ((AbstractCollection)features).add(MasterFeature.UPDATE_FULL);
        }
        if (MasterStorableGenerator.alwaysHasTxn(INSERT_OP, (EnumSet<MasterFeature>)features)) {
            ((AbstractCollection)features).add(MasterFeature.INSERT_TXN);
        }
        if (MasterStorableGenerator.alwaysHasTxn(UPDATE_OP, (EnumSet<MasterFeature>)features)) {
            ((AbstractCollection)features).add(MasterFeature.UPDATE_TXN);
        }
        if (MasterStorableGenerator.alwaysHasTxn(DELETE_OP, (EnumSet<MasterFeature>)features)) {
            ((AbstractCollection)features).add(MasterFeature.DELETE_TXN);
        }
        if (MasterStorableGenerator.requiresTxnForUpdate(INSERT_OP, (EnumSet<MasterFeature>)features)) {
            ((AbstractCollection)features).add(MasterFeature.INSERT_TXN_FOR_UPDATE);
        }
        if (MasterStorableGenerator.requiresTxnForUpdate(UPDATE_OP, (EnumSet<MasterFeature>)features)) {
            ((AbstractCollection)features).add(MasterFeature.UPDATE_TXN_FOR_UPDATE);
        }
        if (MasterStorableGenerator.requiresTxnForUpdate(DELETE_OP, (EnumSet<MasterFeature>)features)) {
            ((AbstractCollection)features).add(MasterFeature.DELETE_TXN_FOR_UPDATE);
        }
        Object key = KeyFactory.createKey((Object[])new Object[]{type, features});
        SoftValuedCache<Object, Class<? extends Storable>> softValuedCache = cCache;
        synchronized (softValuedCache) {
            Class abstractClass = cCache.get(key);
            if (abstractClass != null) {
                return abstractClass;
            }
            abstractClass = super.generateAndInjectClass();
            cCache.put(key, abstractClass);
            return abstractClass;
        }
    }

    private MasterStorableGenerator(Class<S> storableType, EnumSet<MasterFeature> features) {
        this.mFeatures = features;
        this.mInfo = StorableIntrospector.examine(storableType);
        this.mAllProperties = this.mInfo.getAllProperties();
        Class<S> abstractClass = StorableGenerator.getAbstractClass(storableType);
        this.mClassInjector = ClassInjector.create((String)storableType.getName(), (ClassLoader)abstractClass.getClassLoader());
        this.mClassFile = new ClassFile(this.mClassInjector.getClassName(), abstractClass);
        this.mClassFile.setModifiers(this.mClassFile.getModifiers().toAbstract(true));
        this.mClassFile.markSynthetic();
        this.mClassFile.setSourceFile(MasterStorableGenerator.class.getName());
        this.mClassFile.setTarget("1.5");
    }

    private Class<? extends S> generateAndInjectClass() throws SupportException {
        this.generateClass();
        Class abstractClass = this.mClassInjector.defineClass(this.mClassFile);
        return abstractClass;
    }

    private void generateClass() throws SupportException {
        Label isInitialized;
        CodeBuilder b;
        TypeDesc storableType = TypeDesc.forClass(Storable.class);
        TypeDesc triggerSupportType = TypeDesc.forClass(TriggerSupport.class);
        TypeDesc masterSupportType = TypeDesc.forClass(MasterSupport.class);
        TypeDesc transactionType = TypeDesc.forClass(Transaction.class);
        TypeDesc optimisticLockType = TypeDesc.forClass(OptimisticLockException.class);
        TypeDesc persistExceptionType = TypeDesc.forClass(PersistException.class);
        TypeDesc[] params = new TypeDesc[]{masterSupportType};
        MethodInfo mi = this.mClassFile.addConstructor(Modifiers.PUBLIC, params);
        CodeBuilder b2 = new CodeBuilder(mi);
        b2.loadThis();
        b2.loadLocal(b2.getParameter(0));
        b2.invokeSuperConstructor(new TypeDesc[]{triggerSupportType});
        b2.returnVoid();
        MethodInfo mi2 = this.mClassFile.addMethod(Modifiers.PROTECTED.toAbstract(true), DO_TRY_INSERT_MASTER_METHOD_NAME, TypeDesc.BOOLEAN, null);
        mi2.addException(persistExceptionType);
        mi2 = this.mClassFile.addMethod(Modifiers.PROTECTED.toAbstract(true), DO_TRY_UPDATE_MASTER_METHOD_NAME, TypeDesc.BOOLEAN, null);
        mi2.addException(persistExceptionType);
        mi2 = this.mClassFile.addMethod(Modifiers.PROTECTED.toAbstract(true), DO_TRY_DELETE_MASTER_METHOD_NAME, TypeDesc.BOOLEAN, null);
        mi2.addException(persistExceptionType);
        if (this.mFeatures.contains((Object)MasterFeature.PARTITIONING)) {
            for (StorableProperty<S> property : this.mAllProperties.values()) {
                if (property.isDerived() || !property.isPartitionKeyMember()) continue;
                Method writeMethod = property.getWriteMethod();
                String writeName = property.getWriteMethodName();
                TypeDesc type = TypeDesc.forClass(property.getType());
                if (writeMethod == null) continue;
                MethodInfo mi3 = this.mClassFile.addMethod(writeMethod);
                CodeBuilder b3 = new CodeBuilder(mi3);
                String stateFieldName = "propertyState$" + (property.getNumber() >> 4);
                b3.loadThis();
                b3.loadField(stateFieldName, TypeDesc.INT);
                b3.loadConstant(3 << (property.getNumber() & 0xF) * 2);
                b3.math((byte)126);
                b3.loadConstant(1 << (property.getNumber() & 0xF) * 2);
                Label isMutable = b3.createLabel();
                b3.ifComparisonBranch((Location)isMutable, "!=");
                CodeBuilderUtil.throwException(b3, IllegalStateException.class, "Cannot alter partition key");
                isMutable.setLocation();
                b3.loadThis();
                b3.loadLocal(b3.getParameter(0));
                b3.invokeSuper(this.mClassFile.getSuperClassName(), writeName, null, new TypeDesc[]{type});
                b3.returnVoid();
            }
        }
        if (this.mFeatures.contains((Object)MasterFeature.PARTITIONING) || this.mFeatures.contains((Object)MasterFeature.INSERT_SEQUENCES)) {
            mi2 = this.mClassFile.addMethod(Modifiers.PROTECTED, "checkPkForInsert$", null, null);
            b = new CodeBuilder(mi2);
            if (this.mFeatures.contains((Object)MasterFeature.PARTITIONING)) {
                this.checkIfPartitionKeyPresent(b);
            }
            if (this.mFeatures.contains((Object)MasterFeature.INSERT_SEQUENCES)) {
                int ordinal = 0;
                for (StorableProperty<S> property : this.mAllProperties.values()) {
                    if (!property.isDerived() && property.getSequenceName() != null) {
                        Method method;
                        TypeDesc propertyType;
                        Label isInitialized2;
                        int shift;
                        String stateFieldName;
                        block38: {
                            stateFieldName = "propertyState$" + (ordinal >> 4);
                            b.loadThis();
                            b.loadField(stateFieldName, TypeDesc.INT);
                            shift = (ordinal & 0xF) * 2;
                            b.loadConstant(3 << shift);
                            b.math((byte)126);
                            isInitialized2 = b.createLabel();
                            b.ifZeroComparisonBranch((Location)isInitialized2, "!=");
                            b.loadThis();
                            TypeDesc seqValueProdType = TypeDesc.forClass(SequenceValueProducer.class);
                            b.loadThis();
                            b.loadField("support$", triggerSupportType);
                            b.checkCast(masterSupportType);
                            b.loadConstant(property.getSequenceName());
                            b.invokeInterface(masterSupportType, "getSequenceValueProducer", seqValueProdType, new TypeDesc[]{TypeDesc.STRING});
                            propertyType = TypeDesc.forClass(property.getType());
                            TypeDesc propertyObjType = propertyType.toObjectType();
                            try {
                                if (propertyObjType == TypeDesc.LONG.toObjectType()) {
                                    method = SequenceValueProducer.class.getMethod("nextLongValue", null);
                                    break block38;
                                }
                                if (propertyObjType == TypeDesc.INT.toObjectType()) {
                                    method = SequenceValueProducer.class.getMethod("nextIntValue", null);
                                    break block38;
                                }
                                if (propertyObjType == TypeDesc.STRING) {
                                    method = SequenceValueProducer.class.getMethod("nextDecimalValue", null);
                                    break block38;
                                }
                                throw new SupportException("Unable to support sequence of type \"" + TypeDesc.forClass(property.getType()).getFullName() + "\" for property: " + property.getName());
                            }
                            catch (NoSuchMethodException e) {
                                NoSuchMethodError err = new NoSuchMethodError();
                                err.initCause(e);
                                throw err;
                            }
                        }
                        b.invoke(method);
                        b.convert(TypeDesc.forClass(method.getReturnType()), propertyType);
                        b.storeField(property.getName(), propertyType);
                        b.loadThis();
                        b.loadThis();
                        b.loadField(stateFieldName, TypeDesc.INT);
                        b.loadConstant(3 << shift);
                        b.math((byte)-128);
                        b.storeField(stateFieldName, TypeDesc.INT);
                        isInitialized2.setLocation();
                    }
                    ++ordinal;
                }
            }
            b.loadThis();
            b.invokeSuper(this.mClassFile.getSuperClassName(), "checkPkForInsert$", null, null);
            b.returnVoid();
        }
        mi2 = this.mClassFile.addMethod(Modifiers.PROTECTED.toFinal(true), "doTryInsert$", TypeDesc.BOOLEAN, null);
        mi2.addException(persistExceptionType);
        b = new CodeBuilder(mi2);
        LocalVariable txnVar = b.createLocalVariable(null, transactionType);
        Label tryStart = this.addEnterTransaction(b, INSERT_OP, txnVar);
        LocalVariable wasVersionInitVar = null;
        if (this.mFeatures.contains((Object)MasterFeature.VERSIONING) && !this.mInfo.getVersionProperty().isDerived()) {
            b.loadThis();
            b.invokeVirtual("isVersionInitialized$", TypeDesc.BOOLEAN, null);
            wasVersionInitVar = b.createLocalVariable(null, TypeDesc.BOOLEAN);
            b.storeLocal(wasVersionInitVar);
            b.loadLocal(wasVersionInitVar);
            isInitialized = b.createLabel();
            b.ifZeroComparisonBranch((Location)isInitialized, "!=");
            this.addAdjustVersionProperty(b, null, 1);
            isInitialized.setLocation();
        }
        if (this.mFeatures.contains((Object)MasterFeature.INSERT_CHECK_REQUIRED)) {
            b.loadThis();
            b.invokeVirtual("isRequiredDataInitialized$", TypeDesc.BOOLEAN, null);
            isInitialized = b.createLabel();
            b.ifZeroComparisonBranch((Location)isInitialized, "!=");
            TypeDesc exType = TypeDesc.forClass(ConstraintException.class);
            b.newObject(exType);
            b.dup();
            LocalVariable countVar = b.createLocalVariable(null, TypeDesc.INT);
            b.loadConstant(0);
            b.storeLocal(countVar);
            TypeDesc sbType = TypeDesc.forClass(StringBuilder.class);
            b.newObject(sbType);
            b.dup();
            b.loadConstant("Not all required properties have been set: ");
            TypeDesc[] stringParam = new TypeDesc[]{TypeDesc.STRING};
            b.invokeConstructor(sbType, stringParam);
            LocalVariable sbVar = b.createLocalVariable(null, sbType);
            b.storeLocal(sbVar);
            int ordinal = -1;
            HashSet<Integer> stateAppendMethods = new HashSet<Integer>();
            TypeDesc[] appendParams = new TypeDesc[]{sbType, TypeDesc.INT, TypeDesc.INT, TypeDesc.STRING};
            for (StorableProperty<S> property : this.mAllProperties.values()) {
                ++ordinal;
                if (property.isDerived() || property.isIndependent() || property.isJoin() || property.isPrimaryKeyMember() || property.isNullable() || property.isAutomatic() || property.isVersion()) continue;
                int stateField = ordinal >> 4;
                String stateAppendMethodName = APPEND_UNINIT_PROPERTY + stateField;
                if (!stateAppendMethods.contains(stateField)) {
                    stateAppendMethods.add(stateField);
                    MethodInfo mi22 = this.mClassFile.addMethod(Modifiers.PRIVATE, stateAppendMethodName, TypeDesc.INT, appendParams);
                    CodeBuilder b22 = new CodeBuilder(mi22);
                    b22.loadLocal(b22.getParameter(0));
                    String stateFieldName = "propertyState$" + (ordinal >> 4);
                    b22.loadThis();
                    b22.loadField(stateFieldName, TypeDesc.INT);
                    b22.loadLocal(b22.getParameter(2));
                    b22.math((byte)126);
                    Label propIsInitialized = b22.createLabel();
                    b22.ifZeroComparisonBranch((Location)propIsInitialized, "!=");
                    b22.loadLocal(b22.getParameter(1));
                    Label noComma = b22.createLabel();
                    b22.ifZeroComparisonBranch((Location)noComma, "==");
                    b22.loadConstant(", ");
                    b22.invokeVirtual(sbType, "append", sbType, stringParam);
                    noComma.setLocation();
                    b22.loadLocal(b22.getParameter(3));
                    b22.invokeVirtual(sbType, "append", sbType, stringParam);
                    b22.integerIncrement(b22.getParameter(1), 1);
                    propIsInitialized.setLocation();
                    b22.loadLocal(b22.getParameter(1));
                    b22.returnValue(TypeDesc.INT);
                }
                b.loadThis();
                b.loadLocal(sbVar);
                b.loadLocal(countVar);
                b.loadConstant(3 << (ordinal & 0xF) * 2);
                b.loadConstant(property.getName());
                b.invokePrivate(stateAppendMethodName, TypeDesc.INT, appendParams);
                b.storeLocal(countVar);
            }
            b.loadLocal(sbVar);
            b.invokeVirtual(sbType, "toString", TypeDesc.STRING, null);
            b.invokeConstructor(exType, new TypeDesc[]{TypeDesc.STRING});
            b.throwObject();
            isInitialized.setLocation();
        }
        List<PropertyCopy> unnormalized = this.addNormalization(b, false);
        Label doTryStart = b.createLabel().setLocation();
        b.loadThis();
        b.invokeVirtual(DO_TRY_INSERT_MASTER_METHOD_NAME, TypeDesc.BOOLEAN, null);
        if (wasVersionInitVar != null) {
            b.dup();
            Label noRollback = b.createLabel();
            b.ifZeroComparisonBranch((Location)noRollback, "!=");
            b.loadLocal(wasVersionInitVar);
            b.ifZeroComparisonBranch((Location)noRollback, "!=");
            this.unsetVersionProperty(b);
            noRollback.setLocation();
        }
        this.addNormalizationRollback(b, doTryStart, unnormalized);
        if (tryStart == null) {
            b.returnValue(TypeDesc.BOOLEAN);
        } else {
            Label failed = b.createLabel();
            b.ifZeroComparisonBranch((Location)failed, "==");
            this.addCommitAndExitTransaction(b, INSERT_OP, txnVar);
            b.loadConstant(true);
            b.returnValue(TypeDesc.BOOLEAN);
            failed.setLocation();
            this.addExitTransaction(b, INSERT_OP, txnVar);
            b.loadConstant(false);
            b.returnValue(TypeDesc.BOOLEAN);
            this.addExitTransaction(b, INSERT_OP, txnVar, tryStart);
        }
        if (this.mFeatures.contains((Object)MasterFeature.PARTITIONING)) {
            mi2 = this.mClassFile.addMethod(Modifiers.PROTECTED, "checkPkForUpdate$", null, null);
            b = new CodeBuilder(mi2);
            this.checkIfPartitionKeyPresent(b);
            b.loadThis();
            b.invokeSuper(this.mClassFile.getSuperClassName(), "checkPkForUpdate$", null, null);
            b.returnVoid();
        }
        mi2 = this.mClassFile.addMethod(Modifiers.PROTECTED.toFinal(true), "doTryUpdate$", TypeDesc.BOOLEAN, null);
        mi2.addException(persistExceptionType);
        b = new CodeBuilder(mi2);
        if (!(this.mFeatures.contains((Object)MasterFeature.VERSIONING) || this.mFeatures.contains((Object)MasterFeature.NORMALIZE) || this.mFeatures.contains((Object)MasterFeature.UPDATE_FULL) || this.mFeatures.contains((Object)MasterFeature.UPDATE_TXN))) {
            b.loadThis();
            b.invokeVirtual(DO_TRY_UPDATE_MASTER_METHOD_NAME, TypeDesc.BOOLEAN, null);
            b.returnValue(TypeDesc.BOOLEAN);
        } else {
            Label doTryStart2;
            List<PropertyCopy> unnormalized2;
            txnVar = b.createLocalVariable(null, transactionType);
            LocalVariable savedVar = null;
            Label tryStart2 = this.addEnterTransaction(b, UPDATE_OP, txnVar);
            Label failed = b.createLabel();
            Label tryLoadStart = null;
            Label tryLoadEnd = null;
            if (!this.mFeatures.contains((Object)MasterFeature.UPDATE_FULL)) {
                unnormalized2 = this.addNormalization(b, true);
                doTryStart2 = b.createLabel().setLocation();
                b.loadThis();
                b.invokeVirtual(DO_TRY_UPDATE_MASTER_METHOD_NAME, TypeDesc.BOOLEAN, null);
                this.addNormalizationRollback(b, doTryStart2, unnormalized2);
                b.ifZeroComparisonBranch((Location)failed, "==");
            } else {
                b.loadThis();
                b.invokeVirtual("copy", storableType, null);
                b.checkCast(this.mClassFile.getType());
                savedVar = b.createLocalVariable(null, this.mClassFile.getType());
                b.storeLocal(savedVar);
                b.loadThis();
                b.loadField("support$", triggerSupportType);
                b.invokeInterface(triggerSupportType, "locallyDisableLoadTrigger", null, null);
                tryLoadStart = b.createLabel().setLocation();
                b.loadLocal(savedVar);
                b.invokeInterface(storableType, "tryLoad", TypeDesc.BOOLEAN, null);
                tryLoadEnd = b.createLabel().setLocation();
                b.loadThis();
                b.loadField("support$", triggerSupportType);
                b.invokeInterface(triggerSupportType, "locallyEnableLoadTrigger", null, null);
                b.ifZeroComparisonBranch((Location)failed, "==");
                if (this.mFeatures.contains((Object)MasterFeature.VERSIONING)) {
                    StorableProperty<S> versionProperty = this.mInfo.getVersionProperty();
                    TypeDesc versionType = TypeDesc.forClass(versionProperty.getType());
                    Label allowedVersion = b.createLabel();
                    if (!versionProperty.isDerived()) {
                        b.loadThis();
                        b.invoke(versionProperty.getReadMethod());
                        b.loadLocal(savedVar);
                        b.invoke(versionProperty.getReadMethod());
                        CodeBuilderUtil.addValuesEqualCall(b, versionType, true, allowedVersion, true);
                        b.newObject(optimisticLockType);
                        b.dup();
                        b.loadThis();
                        b.invoke(versionProperty.getReadMethod());
                        b.convert(versionType, TypeDesc.OBJECT);
                        b.loadLocal(savedVar);
                        b.invoke(versionProperty.getReadMethod());
                        b.convert(versionType, TypeDesc.OBJECT);
                        b.loadThis();
                        b.invokeConstructor(optimisticLockType, new TypeDesc[]{TypeDesc.OBJECT, TypeDesc.OBJECT, storableType});
                        b.throwObject();
                    } else {
                        b.loadThis();
                        b.invoke(versionProperty.getReadMethod());
                        LocalVariable newVersion = b.createLocalVariable(null, versionType);
                        b.storeLocal(newVersion);
                        b.loadLocal(savedVar);
                        b.invoke(versionProperty.getReadMethod());
                        LocalVariable savedVersion = b.createLocalVariable(null, versionType);
                        b.storeLocal(savedVersion);
                        this.branchIfNull(b, newVersion, allowedVersion);
                        this.branchIfNull(b, savedVersion, allowedVersion);
                        TypeDesc primVersionType = versionType.toPrimitiveType();
                        if (primVersionType != null) {
                            if (versionType != primVersionType) {
                                b.loadLocal(newVersion);
                                b.convert(versionType, primVersionType);
                                newVersion = b.createLocalVariable(null, primVersionType);
                                b.storeLocal(newVersion);
                                b.loadLocal(savedVersion);
                                b.convert(versionType, primVersionType);
                                savedVersion = b.createLocalVariable(null, primVersionType);
                                b.storeLocal(savedVersion);
                            }
                            this.branchIfNaN(b, newVersion, allowedVersion);
                            this.branchIfNaN(b, savedVersion, allowedVersion);
                            b.loadLocal(newVersion);
                            b.loadLocal(savedVersion);
                            b.ifComparisonBranch((Location)allowedVersion, ">", primVersionType);
                        } else if (Comparable.class.isAssignableFrom(versionProperty.getType())) {
                            b.loadLocal(newVersion);
                            b.loadLocal(savedVersion);
                            b.invokeInterface(TypeDesc.forClass(Comparable.class), "compareTo", TypeDesc.INT, new TypeDesc[]{TypeDesc.OBJECT});
                            b.ifZeroComparisonBranch((Location)allowedVersion, ">");
                        } else {
                            throw new SupportException("Derived version property must be Comparable: " + versionProperty);
                        }
                        b.newObject(optimisticLockType);
                        b.dup();
                        b.loadLocal(savedVar);
                        b.invoke(versionProperty.getReadMethod());
                        b.convert(versionType, TypeDesc.OBJECT);
                        b.loadThis();
                        b.loadThis();
                        b.invoke(versionProperty.getReadMethod());
                        b.convert(versionType, TypeDesc.OBJECT);
                        b.invokeConstructor(optimisticLockType, new TypeDesc[]{TypeDesc.OBJECT, storableType, TypeDesc.OBJECT});
                        b.throwObject();
                    }
                    allowedVersion.setLocation();
                }
                unnormalized2 = this.addNormalization(b, true);
                doTryStart2 = b.createLabel().setLocation();
                b.loadThis();
                b.loadLocal(savedVar);
                b.invokeVirtual("copyDirtyProperties", null, new TypeDesc[]{storableType});
                if (this.mFeatures.contains((Object)MasterFeature.VERSIONING) && !this.mInfo.getVersionProperty().isDerived()) {
                    this.addAdjustVersionProperty(b, savedVar, -1);
                }
                b.loadLocal(savedVar);
                b.invokeVirtual(DO_TRY_UPDATE_MASTER_METHOD_NAME, TypeDesc.BOOLEAN, null);
                this.addNormalizationRollback(b, doTryStart2, unnormalized2);
                b.ifZeroComparisonBranch((Location)failed, "==");
                b.loadLocal(savedVar);
                b.loadThis();
                b.invokeInterface(storableType, "copyUnequalProperties", null, new TypeDesc[]{storableType});
            }
            this.addCommitAndExitTransaction(b, UPDATE_OP, txnVar);
            b.loadConstant(true);
            b.returnValue(TypeDesc.BOOLEAN);
            failed.setLocation();
            this.addExitTransaction(b, UPDATE_OP, txnVar);
            b.loadConstant(false);
            b.returnValue(TypeDesc.BOOLEAN);
            if (tryLoadStart != null) {
                b.exceptionHandler((Location)tryLoadStart, (Location)tryLoadEnd, null);
                b.loadThis();
                b.loadField("support$", triggerSupportType);
                b.invokeInterface(triggerSupportType, "locallyEnableLoadTrigger", null, null);
                b.throwObject();
            }
            this.addExitTransaction(b, UPDATE_OP, txnVar, tryStart2);
        }
        if (this.mFeatures.contains((Object)MasterFeature.PARTITIONING)) {
            mi2 = this.mClassFile.addMethod(Modifiers.PROTECTED, "checkPkForDelete$", null, null);
            b = new CodeBuilder(mi2);
            this.checkIfPartitionKeyPresent(b);
            b.loadThis();
            b.invokeSuper(this.mClassFile.getSuperClassName(), "checkPkForDelete$", null, null);
            b.returnVoid();
        }
        mi2 = this.mClassFile.addMethod(Modifiers.PROTECTED.toFinal(true), "doTryDelete$", TypeDesc.BOOLEAN, null);
        mi2.addException(persistExceptionType);
        b = new CodeBuilder(mi2);
        txnVar = b.createLocalVariable(null, transactionType);
        tryStart = this.addEnterTransaction(b, DELETE_OP, txnVar);
        b.loadThis();
        b.invokeVirtual(DO_TRY_DELETE_MASTER_METHOD_NAME, TypeDesc.BOOLEAN, null);
        if (tryStart == null) {
            b.returnValue(TypeDesc.BOOLEAN);
        } else {
            Label failed = b.createLabel();
            b.ifZeroComparisonBranch((Location)failed, "==");
            this.addCommitAndExitTransaction(b, DELETE_OP, txnVar);
            b.loadConstant(true);
            b.returnValue(TypeDesc.BOOLEAN);
            failed.setLocation();
            this.addExitTransaction(b, DELETE_OP, txnVar);
            b.loadConstant(false);
            b.returnValue(TypeDesc.BOOLEAN);
            this.addExitTransaction(b, DELETE_OP, txnVar, tryStart);
        }
        if (this.mFeatures.contains((Object)MasterFeature.PARTITIONING)) {
            mi2 = this.mClassFile.addMethod(Modifiers.PROTECTED, "checkPkForLoad$", null, null);
            b = new CodeBuilder(mi2);
            this.checkIfPartitionKeyPresent(b);
            b.loadThis();
            b.invokeSuper(this.mClassFile.getSuperClassName(), "checkPkForLoad$", null, null);
            b.returnVoid();
        }
    }

    private void branchIfNull(CodeBuilder b, LocalVariable value, Label isNull) {
        if (!value.getType().isPrimitive()) {
            b.loadLocal(value);
            b.ifNullBranch((Location)isNull, true);
        }
    }

    private void branchIfNaN(CodeBuilder b, LocalVariable value, Label isNaN) {
        TypeDesc type = value.getType();
        if (type == TypeDesc.FLOAT || type == TypeDesc.DOUBLE) {
            b.loadLocal(value);
            if (type == TypeDesc.FLOAT) {
                b.invokeStatic(TypeDesc.FLOAT.toObjectType(), "isNaN", TypeDesc.BOOLEAN, new TypeDesc[]{TypeDesc.FLOAT});
                b.ifZeroComparisonBranch((Location)isNaN, "!=");
            } else {
                b.invokeStatic(TypeDesc.DOUBLE.toObjectType(), "isNaN", TypeDesc.BOOLEAN, new TypeDesc[]{TypeDesc.DOUBLE});
                b.ifZeroComparisonBranch((Location)isNaN, "!=");
            }
        }
    }

    private Label addEnterTransaction(CodeBuilder b, String opType, LocalVariable txnVar) {
        if (!this.alwaysHasTxn(opType)) {
            return null;
        }
        TypeDesc repositoryType = TypeDesc.forClass(Repository.class);
        TypeDesc transactionType = TypeDesc.forClass(Transaction.class);
        TypeDesc triggerSupportType = TypeDesc.forClass(TriggerSupport.class);
        TypeDesc masterSupportType = TypeDesc.forClass(MasterSupport.class);
        TypeDesc isolationLevelType = TypeDesc.forClass(IsolationLevel.class);
        b.loadThis();
        b.loadField("support$", triggerSupportType);
        b.invokeInterface(masterSupportType, "getRootRepository", repositoryType, null);
        if (this.requiresTxnForUpdate(opType)) {
            b.invokeInterface(repositoryType, "enterTransaction", transactionType, null);
            b.storeLocal(txnVar);
            b.loadLocal(txnVar);
            b.loadConstant(true);
            b.invokeInterface(transactionType, "setForUpdate", null, new TypeDesc[]{TypeDesc.BOOLEAN});
        } else {
            LocalVariable repoVar = b.createLocalVariable(null, repositoryType);
            b.storeLocal(repoVar);
            b.loadLocal(repoVar);
            b.invokeInterface(repositoryType, "getTransactionIsolationLevel", isolationLevelType, null);
            Label notInTxn = b.createLabel();
            b.ifNullBranch((Location)notInTxn, true);
            b.loadNull();
            Label storeTxn = b.createLabel();
            b.branch((Location)storeTxn);
            notInTxn.setLocation();
            b.loadLocal(repoVar);
            b.invokeInterface(repositoryType, "enterTransaction", transactionType, null);
            storeTxn.setLocation();
            b.storeLocal(txnVar);
        }
        return b.createLabel().setLocation();
    }

    private boolean alwaysHasTxn(String opType) {
        return MasterStorableGenerator.alwaysHasTxn(opType, this.mFeatures);
    }

    private static boolean alwaysHasTxn(String opType, EnumSet<MasterFeature> features) {
        if (opType == UPDATE_OP) {
            return features.contains((Object)MasterFeature.UPDATE_TXN) || features.contains((Object)MasterFeature.UPDATE_TXN_FOR_UPDATE) || features.contains((Object)MasterFeature.VERSIONING) || features.contains((Object)MasterFeature.UPDATE_FULL);
        }
        if (opType == INSERT_OP) {
            return features.contains((Object)MasterFeature.INSERT_TXN) || features.contains((Object)MasterFeature.INSERT_TXN_FOR_UPDATE);
        }
        if (opType == DELETE_OP) {
            return features.contains((Object)MasterFeature.DELETE_TXN) || features.contains((Object)MasterFeature.DELETE_TXN_FOR_UPDATE);
        }
        return false;
    }

    private boolean requiresTxnForUpdate(String opType) {
        return MasterStorableGenerator.requiresTxnForUpdate(opType, this.mFeatures);
    }

    private static boolean requiresTxnForUpdate(String opType, EnumSet<MasterFeature> features) {
        if (opType == UPDATE_OP) {
            return features.contains((Object)MasterFeature.UPDATE_TXN_FOR_UPDATE) || features.contains((Object)MasterFeature.VERSIONING) || features.contains((Object)MasterFeature.UPDATE_FULL);
        }
        if (opType == INSERT_OP) {
            return features.contains((Object)MasterFeature.INSERT_TXN_FOR_UPDATE);
        }
        if (opType == DELETE_OP) {
            return features.contains((Object)MasterFeature.DELETE_TXN_FOR_UPDATE);
        }
        return false;
    }

    private void addCommitAndExitTransaction(CodeBuilder b, String opType, LocalVariable txnVar) {
        if (!this.alwaysHasTxn(opType)) {
            return;
        }
        TypeDesc transactionType = TypeDesc.forClass(Transaction.class);
        Label noTxn = b.createLabel();
        if (!this.requiresTxnForUpdate(opType)) {
            b.loadLocal(txnVar);
            b.ifNullBranch((Location)noTxn, true);
        }
        b.loadLocal(txnVar);
        b.invokeInterface(transactionType, "commit", null, null);
        b.loadLocal(txnVar);
        b.invokeInterface(transactionType, "exit", null, null);
        noTxn.setLocation();
    }

    private void addExitTransaction(CodeBuilder b, String opType, LocalVariable txnVar) {
        if (!this.alwaysHasTxn(opType)) {
            return;
        }
        TypeDesc transactionType = TypeDesc.forClass(Transaction.class);
        Label noTxn = b.createLabel();
        if (!this.requiresTxnForUpdate(opType)) {
            b.loadLocal(txnVar);
            b.ifNullBranch((Location)noTxn, true);
        }
        b.loadLocal(txnVar);
        b.invokeInterface(transactionType, "exit", null, null);
        noTxn.setLocation();
    }

    private void addExitTransaction(CodeBuilder b, String opType, LocalVariable txnVar, Label tryStart) {
        if (tryStart == null) {
            this.addExitTransaction(b, opType, txnVar);
            return;
        }
        Label tryEnd = b.createLabel().setLocation();
        b.exceptionHandler((Location)tryStart, (Location)tryEnd, null);
        this.addExitTransaction(b, opType, txnVar);
        b.throwObject();
    }

    private void addAdjustVersionProperty(CodeBuilder b, LocalVariable storableVar, int value) throws SupportException {
        if (storableVar == null) {
            b.loadThis();
        } else {
            b.loadLocal(storableVar);
        }
        StorableProperty<S> versionProperty = this.mInfo.getVersionProperty();
        TypeDesc versionType = TypeDesc.forClass(versionProperty.getType());
        if (value >= 0) {
            CodeBuilderUtil.initialVersion(b, versionType, value);
        } else {
            b.dup();
            b.invoke(versionProperty.getReadMethod());
            CodeBuilderUtil.incrementVersion(b, versionType);
        }
        b.invoke(versionProperty.getWriteMethod());
    }

    private void unsetVersionProperty(CodeBuilder b) throws SupportException {
        StorableProperty<S> property = this.mInfo.getVersionProperty();
        String stateFieldName = "propertyState$" + (property.getNumber() >> 4);
        b.loadThis();
        b.loadThis();
        b.loadField(stateFieldName, TypeDesc.INT);
        int shift = (property.getNumber() & 0xF) * 2;
        b.loadConstant(~(3 << shift));
        b.math((byte)126);
        b.storeField(stateFieldName, TypeDesc.INT);
        TypeDesc type = TypeDesc.forClass(property.getType());
        b.loadThis();
        CodeBuilderUtil.blankValue(b, type);
        b.storeField(property.getName(), type);
    }

    private List<PropertyCopy> addNormalization(CodeBuilder b, boolean forUpdate) {
        ArrayList<PropertyCopy<S>> unnormalized = null;
        if (!this.mFeatures.contains((Object)MasterFeature.NORMALIZE)) {
            return unnormalized;
        }
        for (StorableProperty<S> property : this.mAllProperties.values()) {
            if (property.isDerived() || property.isJoin() || !BigDecimal.class.isAssignableFrom(property.getType())) continue;
            if (unnormalized == null) {
                unnormalized = new ArrayList<PropertyCopy<S>>();
            }
            PropertyCopy<S> copy = new PropertyCopy<S>(b, property);
            unnormalized.add(copy);
            copy.makeCopy(b);
            b.loadLocal(copy.copyVar);
            Label skipNormalize = b.createLabel();
            b.ifNullBranch((Location)skipNormalize, true);
            if (forUpdate) {
                String stateFieldName = "propertyState$" + (property.getNumber() >> 4);
                b.loadThis();
                b.loadField(stateFieldName, TypeDesc.INT);
                int shift = (property.getNumber() & 0xF) * 2;
                b.loadConstant(3 << shift);
                b.math((byte)126);
                b.loadConstant(3 << shift);
                b.ifComparisonBranch((Location)skipNormalize, "!=");
            }
            b.loadThis();
            TypeDesc propertyType = copy.copyVar.getType();
            b.loadStaticField(propertyType, "ZERO", propertyType);
            b.loadLocal(copy.copyVar);
            b.invokeVirtual(propertyType, "compareTo", TypeDesc.INT, new TypeDesc[]{propertyType});
            Label notZero = b.createLabel();
            b.ifZeroComparisonBranch((Location)notZero, "!=");
            b.loadStaticField(propertyType, "ZERO", propertyType);
            Label storeField = b.createLabel();
            b.branch((Location)storeField);
            notZero.setLocation();
            b.loadLocal(copy.copyVar);
            b.invokeVirtual(propertyType, "stripTrailingZeros", propertyType, null);
            storeField.setLocation();
            b.storeField(property.getName(), propertyType);
            skipNormalize.setLocation();
        }
        return unnormalized;
    }

    private void addNormalizationRollback(CodeBuilder b, Label doTryStart, List<PropertyCopy> unnormalized) {
        if (unnormalized == null) {
            return;
        }
        Label doTryEnd = b.createLabel().setLocation();
        b.dup();
        Label success = b.createLabel();
        b.ifZeroComparisonBranch((Location)success, "!=");
        for (int i = 0; i < 2; ++i) {
            if (i != 0) {
                b.exceptionHandler((Location)doTryStart, (Location)doTryEnd, null);
            }
            for (PropertyCopy copy : unnormalized) {
                copy.restore(b);
            }
            if (i == 0) {
                b.branch((Location)success);
                continue;
            }
            b.throwObject();
        }
        success.setLocation();
    }

    private void checkIfPartitionKeyPresent(CodeBuilder b) {
        b.loadThis();
        b.invokeVirtual("isPartitionKeyInitialized$", TypeDesc.BOOLEAN, null);
        Label ptnkInitialized = b.createLabel();
        b.ifZeroComparisonBranch((Location)ptnkInitialized, "!=");
        TypeDesc exType = TypeDesc.forClass(IllegalStateException.class);
        b.newObject(exType);
        b.dup();
        b.loadConstant("Partition key not fully specified");
        b.invokeConstructor(exType, new TypeDesc[]{TypeDesc.STRING});
        b.throwObject();
        ptnkInitialized.setLocation();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PropertyCopy<S extends Storable> {
        final StorableProperty<S> property;
        final LocalVariable copyVar;

        PropertyCopy(CodeBuilder b, StorableProperty<S> property) {
            this.property = property;
            this.copyVar = b.createLocalVariable(null, TypeDesc.forClass(property.getType()));
        }

        void makeCopy(CodeBuilder b) {
            b.loadThis();
            b.loadField(this.property.getName(), this.copyVar.getType());
            b.storeLocal(this.copyVar);
        }

        void restore(CodeBuilder b) {
            b.loadThis();
            b.loadLocal(this.copyVar);
            b.storeField(this.property.getName(), this.copyVar.getType());
        }
    }
}

