/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.filter;

import com.amazon.carbonado.Storable;
import com.amazon.carbonado.filter.Filter;
import com.amazon.carbonado.filter.FilterValues;
import com.amazon.carbonado.filter.RelOp;
import com.amazon.carbonado.filter.Visitor;
import com.amazon.carbonado.info.ChainedProperty;
import com.amazon.carbonado.info.StorableProperty;
import com.amazon.carbonado.util.Converter;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import org.cojen.classfile.TypeDesc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyFilter<S extends Storable>
extends Filter<S> {
    private static final long serialVersionUID = 1L;
    private static final int BOUND_CONSTANT = -1;
    private static final Converter cConverter = Converter.build(Hidden.Adapter.class);
    private final ChainedProperty<S> mProperty;
    private final RelOp mOp;
    private final int mBindID;
    private final Object mConstant;
    private volatile transient Class<?> mBoxedType;

    static <S extends Storable> PropertyFilter<S> getCanonical(ChainedProperty<S> property, RelOp op, int bindID) {
        return (PropertyFilter)cCanonical.put(new PropertyFilter<S>(property, op, bindID, null));
    }

    static <S extends Storable> PropertyFilter<S> getCanonical(ChainedProperty<S> property, RelOp op, Object constant) {
        return (PropertyFilter)cCanonical.put(new PropertyFilter<S>(property, op, -1, constant));
    }

    static <S extends Storable> PropertyFilter<S> getCanonical(PropertyFilter<S> filter, int bindID) {
        if (filter.mBindID == bindID) {
            return filter;
        }
        return (PropertyFilter)cCanonical.put(new PropertyFilter<S>(filter.getChainedProperty(), filter.getOperator(), bindID, filter.mConstant));
    }

    private PropertyFilter(ChainedProperty<S> property, RelOp op, int bindID, Object constant) {
        super(property == null ? null : property.getPrimeProperty().getEnclosingType());
        if (property == null || op == null) {
            throw new IllegalArgumentException();
        }
        if (property.isOuterJoin(property.getChainCount())) {
            throw new IllegalArgumentException("Last property in chain cannot be an outer join: " + property);
        }
        this.mProperty = property;
        this.mOp = op;
        this.mBindID = bindID;
        this.mConstant = constant;
    }

    @Override
    public PropertyFilter<S> not() {
        ChainedProperty<S> property = this.mProperty;
        if (property.getChainCount() > 0) {
            int chainCount = property.getChainCount();
            StorableProperty[] chain = new StorableProperty[chainCount];
            for (int i = 0; i < chainCount; ++i) {
                chain[i] = property.getChainedProperty(i);
            }
            boolean[] outerJoin = null;
            for (int i = 0; i < chainCount; ++i) {
                if (property.isOuterJoin(i)) continue;
                if (outerJoin == null) {
                    outerJoin = new boolean[chainCount + 1];
                }
                outerJoin[i] = true;
            }
            property = ChainedProperty.get(property.getPrimeProperty(), chain, outerJoin);
        }
        if (this.mBindID == -1) {
            return PropertyFilter.getCanonical(property, this.mOp.reverse(), this.mConstant);
        }
        return PropertyFilter.getCanonical(property, this.mOp.reverse(), this.mBindID);
    }

    @Override
    public List<Filter<S>> disjunctiveNormalFormSplit() {
        return Collections.singletonList(this);
    }

    @Override
    public List<Filter<S>> conjunctiveNormalFormSplit() {
        return Collections.singletonList(this);
    }

    @Override
    public <R, P> R accept(Visitor<S, R, P> visitor, P param) {
        return visitor.visit(this, param);
    }

    public ChainedProperty<S> getChainedProperty() {
        return this.mProperty;
    }

    public Class<?> getType() {
        return this.mProperty.getType();
    }

    public Class<?> getBoxedType() {
        if (this.mBoxedType == null) {
            this.mBoxedType = TypeDesc.forClass(this.getType()).toObjectType().toClass();
        }
        return this.mBoxedType;
    }

    public RelOp getOperator() {
        return this.mOp;
    }

    public int getBindID() {
        return this.mBindID;
    }

    @Override
    public PropertyFilter<S> bind() {
        return this.mBindID == 0 ? PropertyFilter.getCanonical(this, 1) : this;
    }

    @Override
    public PropertyFilter<S> unbind() {
        return this.mBindID == 0 ? this : PropertyFilter.getCanonical(this, 0);
    }

    @Override
    public boolean isBound() {
        return this.mBindID != 0;
    }

    @Override
    public <T extends Storable> PropertyFilter<T> asJoinedFromAny(ChainedProperty<T> joinProperty) {
        ChainedProperty<T> newProperty = joinProperty.append(this.getChainedProperty());
        if (this.isConstant()) {
            return PropertyFilter.getCanonical(newProperty, this.mOp, this.mConstant);
        }
        return PropertyFilter.getCanonical(newProperty, this.mOp, this.mBindID);
    }

    @Override
    Filter.NotJoined notJoinedFromCNF(ChainedProperty<S> joinProperty) {
        ChainedProperty<Object> notJoinedProp = this.getChainedProperty();
        ChainedProperty<Object> jp = joinProperty;
        while (notJoinedProp.getPrimeProperty().equals(jp.getPrimeProperty())) {
            notJoinedProp = notJoinedProp.tail();
            if (jp.getChainCount() == 0) {
                jp = null;
                break;
            }
            jp = jp.tail();
        }
        if (jp != null || notJoinedProp.equals(this.getChainedProperty())) {
            return super.notJoinedFromCNF(joinProperty);
        }
        PropertyFilter<Object> notJoinedFilter = this.isConstant() ? PropertyFilter.getCanonical(notJoinedProp, this.mOp, this.mConstant) : PropertyFilter.getCanonical(notJoinedProp, this.mOp, this.mBindID);
        return new Filter.NotJoined(notJoinedFilter, PropertyFilter.getOpenFilter(this.getStorableType()));
    }

    public PropertyFilter<S> constant(Object value) {
        if (this.mBindID == -1 && (this.mConstant == null ? value == null : this.mConstant.equals(value))) {
            return this;
        }
        return PropertyFilter.getCanonical(this.mProperty, this.mOp, this.adaptValue(value));
    }

    public Object constant() {
        return this.mConstant;
    }

    public boolean isConstant() {
        return this.mBindID == -1;
    }

    @Override
    void markBound() {
    }

    @Override
    Filter<S> buildDisjunctiveNormalForm() {
        return this;
    }

    @Override
    Filter<S> buildConjunctiveNormalForm() {
        return this;
    }

    @Override
    boolean isDisjunctiveNormalForm() {
        return true;
    }

    @Override
    boolean isConjunctiveNormalForm() {
        return true;
    }

    @Override
    boolean isReduced() {
        return true;
    }

    @Override
    void markReduced() {
    }

    Object adaptValue(int value) {
        return cConverter.convert(value, this.getType());
    }

    Object adaptValue(long value) {
        return cConverter.convert(value, this.getType());
    }

    Object adaptValue(float value) {
        return cConverter.convert(value, this.getType());
    }

    Object adaptValue(double value) {
        return cConverter.convert(value, this.getType());
    }

    Object adaptValue(boolean value) {
        return cConverter.convert(value, this.getType());
    }

    Object adaptValue(char value) {
        return cConverter.convert(value, this.getType());
    }

    Object adaptValue(byte value) {
        return cConverter.convert(value, this.getType());
    }

    Object adaptValue(short value) {
        return cConverter.convert(value, Object.class);
    }

    Object adaptValue(Object value) {
        return cConverter.convert(value, this.getType());
    }

    @Override
    int generateHashCode() {
        return this.mProperty.hashCode() * 31 + this.mOp.hashCode() + this.mBindID;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PropertyFilter) {
            PropertyFilter other = (PropertyFilter)obj;
            return this.getStorableType() == other.getStorableType() && this.mProperty.equals(other.mProperty) && this.mOp.equals((Object)other.mOp) && this.mBindID == other.mBindID && (this.mConstant == null ? other.mConstant == null : this.mConstant.equals(other.mConstant));
        }
        return false;
    }

    @Override
    public void appendTo(Appendable app, FilterValues<S> values) throws IOException {
        Object value;
        this.mProperty.appendTo(app);
        app.append(' ');
        app.append(this.mOp.toString());
        app.append(' ');
        if (values != null && ((value = values.getValue(this)) != null || values.isAssigned(this))) {
            app.append(String.valueOf(value));
            return;
        }
        if (this.mBindID == -1) {
            app.append(String.valueOf(this.mConstant));
        } else {
            app.append('?');
            if (this.mBindID > 1) {
                app.append('[').append(String.valueOf(this.mBindID)).append(']');
            }
        }
    }

    private static class Hidden {
        private Hidden() {
        }

        public static abstract class Adapter
        extends Converter {
            public String convertToString(char value) {
                return String.valueOf(value);
            }

            public CharSequence convertToCharSequence(char value) {
                return String.valueOf(value);
            }

            public String convertToString(StringBuffer value) {
                return value.toString();
            }

            public String convertToString(StringBuilder value) {
                return value.toString();
            }

            public BigInteger convertToBigInteger(long value) {
                return BigInteger.valueOf(value);
            }

            public BigDecimal convertToBigDecimal(long value) {
                if (value > -10L && value < 10L) {
                    return BigDecimal.valueOf(value);
                }
                return BigDecimal.valueOf(value).stripTrailingZeros();
            }

            public BigDecimal convertToBigDecimal(double value) {
                if (value == 0.0) {
                    return BigDecimal.ZERO;
                }
                return BigDecimal.valueOf(value).stripTrailingZeros();
            }

            public BigDecimal convertToBigDecimal(BigInteger value) {
                if (BigInteger.ZERO.equals(value)) {
                    return BigDecimal.ZERO;
                }
                return new BigDecimal(value, 0).stripTrailingZeros();
            }

            public BigDecimal convertToBigDecimal(BigDecimal value) {
                if (value.compareTo(BigDecimal.ZERO) == 0) {
                    return BigDecimal.ZERO;
                }
                return value.stripTrailingZeros();
            }
        }
    }
}

