/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.filter;

import com.amazon.carbonado.Storable;
import com.amazon.carbonado.filter.Binder;
import com.amazon.carbonado.filter.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BinaryOpFilter<S extends Storable>
extends Filter<S> {
    private static final byte REDUCED = 1;
    private static final byte DNF_KNOWN = 2;
    private static final byte DNF = 4;
    private static final byte CNF_KNOWN = 8;
    private static final byte CNF = 16;
    private static final byte BOUND = 32;
    final Filter<S> mLeft;
    final Filter<S> mRight;
    byte mState;

    BinaryOpFilter(Filter<S> left, Filter<S> right) {
        super(left == null ? null : left.getStorableType());
        if (left == null || right == null) {
            throw new IllegalArgumentException("Left or right filter is null");
        }
        if (left.getStorableType() != right.getStorableType()) {
            throw new IllegalArgumentException("Type mismatch");
        }
        this.mLeft = left;
        this.mRight = right;
        if (left.isBound() && right.isBound()) {
            this.markBound();
        }
    }

    public Filter<S> getLeftFilter() {
        return this.mLeft;
    }

    public Filter<S> getRightFilter() {
        return this.mRight;
    }

    @Override
    public Filter<S> bind() {
        if (this.isBound()) {
            return this;
        }
        return Binder.doBind(this);
    }

    @Override
    public synchronized boolean isBound() {
        return (this.mState & 0x20) != 0;
    }

    @Override
    synchronized void markBound() {
        this.mState = (byte)(this.mState | 0x20);
    }

    @Override
    final synchronized boolean isDisjunctiveNormalForm() {
        if ((this.mState & 2) != 0) {
            return (this.mState & 4) != 0;
        }
        if (this.checkIsDisjunctiveNormalForm()) {
            this.mState = (byte)(this.mState | 6);
            return true;
        }
        this.mState = (byte)(this.mState | 2);
        this.mState = (byte)(this.mState & 0xFFFFFFFB);
        return false;
    }

    abstract boolean checkIsDisjunctiveNormalForm();

    @Override
    final synchronized boolean isConjunctiveNormalForm() {
        if ((this.mState & 8) != 0) {
            return (this.mState & 0x10) != 0;
        }
        if (this.checkIsConjunctiveNormalForm()) {
            this.mState = (byte)(this.mState | 0x18);
            return true;
        }
        this.mState = (byte)(this.mState | 8);
        this.mState = (byte)(this.mState & 0xFFFFFFEF);
        return false;
    }

    abstract boolean checkIsConjunctiveNormalForm();

    @Override
    synchronized boolean isReduced() {
        return (this.mState & 1) != 0;
    }

    @Override
    synchronized void markReduced() {
        this.mState = (byte)(this.mState | 1);
    }
}

