/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.cursor;

import com.amazon.carbonado.Cursor;
import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.cursor.AbstractCursor;
import java.util.Comparator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymmetricDifferenceCursor<S>
extends AbstractCursor<S> {
    private final Cursor<S> mLeftCursor;
    private final Cursor<S> mRightCursor;
    private final Comparator<S> mOrder;
    private S mNextLeft;
    private S mNextRight;
    private int mCompareResult;

    public SymmetricDifferenceCursor(Cursor<S> left, Cursor<S> right, Comparator<S> order) {
        if (left == null || right == null || order == null) {
            throw new IllegalArgumentException();
        }
        this.mLeftCursor = left;
        this.mRightCursor = right;
        this.mOrder = order;
    }

    @Override
    public void close() throws FetchException {
        this.mLeftCursor.close();
        this.mRightCursor.close();
        this.mNextLeft = null;
        this.mNextRight = null;
    }

    @Override
    public boolean hasNext() throws FetchException {
        try {
            return this.compareNext() != 0;
        }
        catch (FetchException e) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    public int compareNext() throws FetchException {
        if (this.mCompareResult != 0) {
            return this.mCompareResult;
        }
        try {
            while (true) {
                if (this.mNextLeft == null && this.mLeftCursor.hasNext()) {
                    this.mNextLeft = this.mLeftCursor.next();
                }
                if (this.mNextRight == null && this.mRightCursor.hasNext()) {
                    this.mNextRight = this.mRightCursor.next();
                }
                if (this.mNextLeft == null) {
                    return this.mNextRight != null ? 1 : 0;
                }
                if (this.mNextRight == null) {
                    return -1;
                }
                this.mCompareResult = this.mOrder.compare(this.mNextLeft, this.mNextRight);
                if (this.mCompareResult != 0) break;
                this.mNextLeft = null;
                this.mNextRight = null;
            }
            return this.mCompareResult;
        }
        catch (NoSuchElementException e) {
            return 0;
        }
        catch (FetchException e) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    @Override
    public S next() throws FetchException {
        try {
            S next;
            int result = this.compareNext();
            if (result < 0) {
                next = this.mNextLeft;
                this.mNextLeft = null;
            } else if (result > 0) {
                next = this.mNextRight;
                this.mNextRight = null;
            } else {
                throw new NoSuchElementException();
            }
            this.mCompareResult = 0;
            return next;
        }
        catch (FetchException e) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }
}

